<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Mdl_Quote_Items extends Response_Model
{
    public $table = 'ip_supplier_order_items';
    public $primary_key = 'ip_supplier_order_items.item_id';
    public $date_created_field = 'item_date_added';

    public function default_select()
    {
        $this->db->select('ip_supplier_order_item_amounts.*, ip_supplier_order_items.*, item_tax_rates.tax_rate_percent AS item_tax_rate_percent, ip_products.product_sku AS product_sku');
    }

    public function default_order_by()
    {
        $this->db->order_by('ip_supplier_order_items.item_order');
    }

    public function default_join()
    {
        $this->db->join('ip_supplier_order_item_amounts', 'ip_supplier_order_item_amounts.item_id = ip_supplier_order_items.item_id', 'left');
        $this->db->join('ip_tax_rates AS item_tax_rates', 'item_tax_rates.tax_rate_id = ip_supplier_order_items.item_tax_rate_id', 'left');
        $this->db->join('ip_products AS ip_products', 'ip_products.product_sku = ip_supplier_order_items.item_description', 'left');
        //$this->db->join('ip_products AS ip_products', 'ip_products.product_name = ip_supplier_order_items.item_name', 'left');
    }

    public function validation_rules()
    {
        return array(
            'supplier_order_id' => array(
                'field' => 'supplier_order_id',
                'label' => lang('supplier_order'),
                'rules' => 'required'
            ),
            'item_name' => array(
                'field' => 'item_name',
                'label' => lang('item_name'),
                'rules' => 'required'
            ),
            'item_description' => array(
                'field' => 'item_description',
                'label' => lang('description')
            ),
            'item_quantity' => array(
                'field' => 'item_quantity',
                'label' => lang('quantity'),
                'rules' => 'required'
            ),
            'item_price' => array(
                'field' => 'item_price',
                'label' => lang('price'),
                'rules' => 'required'
            ),
            'item_tax_rate_id' => array(
                'field' => 'item_tax_rate_id',
                'label' => lang('item_tax_rate')
            )
        );
    }

    public function save($quote_id, $id = NULL, $db_array = NULL)
    {
        $id = parent::save($id, $db_array);

        $this->load->model('supplier/mdl_quote_item_amounts');
        $this->mdl_quote_item_amounts->calculate($id);

        $this->load->model('supplier/mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);

        return $id;
    }

    public function delete($item_id)
    {
        // Get the quote id so we can recalculate quote amounts
        $this->db->select('supplier_order_id');
        $this->db->where('item_id', $item_id);
        $quote_id = $this->db->get('ip_supplier_order_items')->row()->supplier_order_id;

        // Delete the item
        parent::delete($item_id);

        // Delete the item amounts
        $this->db->where('item_id', $item_id);
        $this->db->delete('ip_supplier_order_item_amounts');

        // Recalculate quote amounts
        $this->load->model('supplier/mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);
    }

}
