<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Supplier extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_quotes');
    }

    public function index()
    {
        // Display all quotes by default
        redirect('supplier/status/all');
    }

    public function status($status = 'all', $page = 0)
    {
        // Determine which group of quotes to load
        switch ($status) {
            case 'draft':
                $this->mdl_quotes->is_draft();
                break;
            /*case 'sent':
                $this->mdl_quotes->is_sent();
                break;*/
            case 'viewed':
                $this->mdl_quotes->is_viewed();
                break;
            case 'approved':
                $this->mdl_quotes->is_approved();
                break;
            /*case 'rejected':
                $this->mdl_quotes->is_rejected();
                break;*/
            case 'canceled':
                $this->mdl_quotes->is_canceled();
                break;
        }

        $this->mdl_quotes->paginate(site_url('supplier/status/' . $status), $page);
        $quotes = $this->mdl_quotes->result();

        $this->layout->set(
            array(
                'supplier_order' => $quotes,
                'status' => $status,
                'filter_display' => TRUE,
                'filter_placeholder' => lang('filter_supplier'),
                'filter_method' => 'filter_supplier',
                'supplier_order_statuses' => $this->mdl_quotes->statuses()
            )
        );

        $this->layout->buffer('content', 'supplier/index');
        $this->layout->render();
    }

    public function view($quote_id)
    {
        $this->load->model('mdl_quote_items');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('mdl_quote_tax_rates');
        $this->load->model('custom_fields/mdl_custom_fields');
        $this->load->model('custom_fields/mdl_quote_custom');
        $this->load->library('encrypt');

        //$quote_custom = $this->mdl_quote_custom->where('quote_id', $quote_id)->get();
        /*$quote_custom = $this->mdl_quote_custom->where('supplier_order_id', $quote_id)->get();

        if ($quote_custom->num_rows()) {
            $quote_custom = $quote_custom->row();

            unset($quote_custom->supplier_order_id, $quote_custom->supplier_order_custom_id);

            foreach ($quote_custom as $key => $val) {
                $this->mdl_quotes->set_form_value('custom[' . $key . ']', $val);
            }
        }*/

        $quote = $this->mdl_quotes->get_by_id($quote_id);

        if (!$quote) {
            show_404();
        }

        $this->layout->set(
            array(
                'supplier_order' => $quote,
                'items' => $this->mdl_quote_items->where('supplier_order_id', $quote_id)->get()->result(),
                'supplier_order_id' => $quote_id,
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
                'supplier_order_tax_rates' => $this->mdl_quote_tax_rates->where('supplier_order_id', $quote_id)->get()->result(),
                'custom_fields' => $this->mdl_custom_fields->by_table('ip_supplier_order_custom')->get()->result(),
                'custom_js_vars' => array(
                    'currency_symbol' => $this->mdl_settings->setting('currency_symbol'),
                    'currency_symbol_placement' => $this->mdl_settings->setting('currency_symbol_placement'),
                    'decimal_point' => $this->mdl_settings->setting('decimal_point')
                ),
                'supplier_order_statuses' => $this->mdl_quotes->statuses()
            )
        );

        $this->layout->buffer(
            array(
                array('modal_delete_quote', 'supplier/modal_delete_quote'),
                array('modal_add_quote_tax', 'supplier/modal_add_quote_tax'),
                array('content', 'supplier/view')
            )
        );

        $this->layout->render();
    }

    public function delete($quote_id)
    {
        // Delete the supplier_order
        $this->mdl_quotes->delete($quote_id);

        // Redirect to supplier_order index
        redirect('supplier/index');
    }

    public function delete_item($quote_id, $item_id)
    {
        // Delete supplier_order item
        $this->load->model('mdl_quote_items');
        $this->mdl_quote_items->delete($item_id);

        // Redirect to supplier_order view
        redirect('supplier/view/' . $quote_id);
    }

    public function generate_pdf($quote_id, $stream = TRUE, $supplier_order_template = NULL)
    {
        $this->load->helper('pdf');

        if ($this->mdl_settings->setting('mark_quotes_sent_pdf') == 1) {
            $this->mdl_quotes->mark_sent($quote_id);
        }

        //generate_quote_pdf($quote_id, $stream, $transport_template);
        generate_supplier_order_pdf($quote_id, $stream, $supplier_order_template);
    }

    public function delete_quote_tax($quote_id, $quote_tax_rate_id)
    {
        $this->load->model('mdl_quote_tax_rates');
        $this->mdl_quote_tax_rates->delete($quote_tax_rate_id);

        $this->load->model('mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);

        redirect('supplier/view/' . $quote_id);
    }

    public function recalculate_all_quotes()
    {
        $this->db->select('supplier_order_id');
        $quote_ids = $this->db->get('ip_supplier_order')->result();

        $this->load->model('mdl_quote_amounts');

        foreach ($quote_ids as $quote_id) {
            $this->mdl_quote_amounts->calculate($quote_id->supplier_order_id);
        }
    }

}
