<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->load->model('supplier/mdl_quote_items');
        $this->load->model('supplier/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');

        $quote_id = $this->input->post('supplier_order_id');

        $is_slash_create = substr($this->input->post('supplier_order_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('supplier_order_date_created'), 6, 9);
            $day_create = substr($this->input->post('supplier_order_date_created'), 0, 2);
            $month_create = substr($this->input->post('supplier_order_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('supplier_order_date_created');
        }

        $items = json_decode($this->input->post('items'));

        $plist = $this->db->query("SELECT * FROM ip_products WHERE inactive = 0 ORDER BY product_order")->result_array();

        $error = 0;

        foreach ($items as $item) {
            $exists = 0;
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_name." -- ".$item->item_description."', now() )");

            foreach($plist as $pl)
            {
                if($pl['product_sku'] == $item->item_description)
                {
                    $exists = 1;
                }

                //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$pl['product_sku']." ".$item->item_description."', now() )");
            }

            if($exists == 0)
            {
                //ERRO
                $this->load->helper('json_error');
                $response = array(
                    'success' => 0,
                    'validation_errors' => 'SKU_ERROR'
                );

                $error = 1;
            }

        }

        foreach ($items as $item) {
            //$note_k = " || ".$note_k.$item." ==>";
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_id." ".$item->item_description."', now() )");
            if($item->item_id == NULL)
            {
                foreach($item as $it)
                {
                    $string= "?? ".$string.$it;
                }
                $string = ' ' . $string;
                $ini = strpos($string, $quote_id);
                $ini += strlen($quote_id);
                $len = strpos($string, $item->item_quantity, $ini) - $ini;
                $note_k = substr($string, $ini, $len);

                $prod_info[] = $this->db->query("SELECT product_id FROM ip_products WHERE product_sku like '%".$note_k."%' limit 1;")->result_array();

                $pid = $prod_info[0][0]['product_id'];

                if($pid == NULL || $pdi == "")
                {
                    $pid = 0;
                }

                //$note_k = $note_k." ".$pid ;

                $date_add = date('Y-m-d');

                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                if($item->item_description != "" && $item->item_description != NULL)
                {
                    $updt_bl = $this->db->query( "INSERT INTO ip_supplier_order_items (item_id, supplier_order_id, item_tax_rate_id, item_date_added, item_name,
                                                                              item_description, item_quantity, item_price, item_discount_amount, item_warehouse_id, item_order) 
                                              VALUES
                                                                              (".$pid.", ".$this->input->post('supplier_order_id').", ".$item->item_tax_rate_id.", '".$date_add."', '".$item->item_name."',
                                                                              '".$item->item_description."', ".$item->item_quantity.", ".$item->item_price.", '".$item->item_discount_amount."', ".$item->item_warehouse_id.", ".$item->item_order.")" );
                }
            }
            else
            {
                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                if( is_numeric($item->item_pid) )
                {
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[2] ".$item->item_pid." ".$item->item_description."', now() )");
                    $prod_info[] = $this->db->query("SELECT * FROM ip_products WHERE product_id = ".$item->item_pid." AND online = 1 AND inactive = 0 limit 1;")->result_array();
                    $item->item_description = $prod_info[0][0]['product_sku'];
                }

                $prod_received[] = $this->db->query("SELECT * FROM ip_supplier_order_items WHERE supplier_order_id = ".$this->input->post('supplier_order_id')." AND item_id = ".$item->item_id)->result_array();

                $updt_bl = $this->db->query( "UPDATE ip_supplier_order_items SET 
                        item_name = '".$item->item_name."',
                        item_description = '".$item->item_description."',
                        item_order = ".$item->item_order.",
                        item_tax_rate_id = ".$item->item_tax_rate_id.",
                        item_warehouse_id = ".$item->item_warehouse_id.",
                        item_quantity = ".$item->item_quantity." 
                     WHERE supplier_order_id = ".$this->input->post('supplier_order_id')."
                     AND item_id = ".$item->item_id );

                //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[OSTT] ".$prod_received[0][0]['item_tax_rate_id']."', now() )");
                //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[CSTT] ".$item->item_tax_rate_id."', now() )");
                //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[SKU] ".$item->item_description."', now() )");

                //if($prod_received[0][0]['item_tax_rate_id'] == 0 && $item->item_tax_rate_id == 1)
                if( ( $prod_received[0][0]['item_tax_rate_id'] == 0 || $prod_received[0][0]['item_tax_rate_id'] == 2 ) && $item->item_tax_rate_id == 1)
                {
                    $prd_stk_o = $this->db->query("SELECT stock FROM ip_products WHERE product_sku = '".$item->item_description."'" )->result_array();

                    if($item->item_warehouse_id == 0)
                    {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[QTT] ".$item->item_quantity."', now() )");
                        $updt_bl = $this->db->query( "UPDATE ip_products SET 
                            stock = stock + ".$item->item_quantity."
                         WHERE product_sku = '".$item->item_description."'" );

                        $prd_stk_f = $this->db->query("SELECT stock, stock_sample FROM ip_products WHERE product_sku = '".$item->item_description."'" )->result_array();

                        $ref_msg = '
                        <html>
                        <head><title>Fornecedor - Entrada de Stock</title></head>
                        <body>
                          <p>Entrada de stock do Fornecedor '.$this->input->post('supplier_order_number').' </p><br />
                          <table border="1">
                            <tr>
                              <th>Ref.</th><th>Quantidade Acrescentada</th><th>Stock Original</th><th>Stock Final</th><th>Armazem</th>
                            </tr>
                            <tr>
                                <td>'.$item->item_description.'</td><td>'.$item->item_quantity.'</td><td>'.$prd_stk_o[0]['stock'].'</td><td>'.$prd_stk_f[0]['stock'].'</td><td>Leiria</td>
                            </tr>
                        </table> </body> </html>';

                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$item->item_description."', ".$item->item_quantity.", ".$prd_stk_o[0]['stock'].", ".$prd_stk_f[0]['stock'].", 
                                                  '".$this->input->post('supplier_order_number')."', 1, now() )" );
                    }
                    elseif($item->item_warehouse_id == 1)
                    {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[QTT] ".$item->item_quantity."', now() )");
                        $updt_bl = $this->db->query( "UPDATE ip_products SET 
                            stock_sample = stock_sample + ".$item->item_quantity."
                         WHERE product_sku = '".$item->item_description."'" );

                        $prd_stk_f = $this->db->query("SELECT stock, stock_sample FROM ip_products WHERE product_sku = '".$item->item_description."'" )->result_array();

                        $ref_msg = '
                        <html>
                        <head><title>Fornecedor - Entrada de Stock</title></head>
                        <body>
                          <p>Entrada de stock do Fornecedor '.$this->input->post('supplier_order_number').' </p><br />
                          <table border="1">
                            <tr>
                              <th>Ref.</th><th>Quantidade Acrescentada</th><th>Stock Original</th><th>Stock Final</th><th>Armazem</th>
                            </tr>
                            <tr>
                                <td>'.$item->item_description.'</td><td>'.$item->item_quantity.'</td><td>'.$prd_stk_o[0]['stock'].'</td><td>'.$prd_stk_f[0]['stock'].'</td><td>Amostras</td>
                            </tr>
                        </table> </body> </html>';

                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$item->item_description."', ".$item->item_quantity.", ".$prd_stk_o[0]['stock_sample'].", ".$prd_stk_f[0]['stock_sample'].", 
                                                  '".$this->input->post('supplier_order_number')."', 2, now() )" );
                    }

                    $to = 'bruno@rbdrinks.fr';

                    $subject = 'Fornecedor - Entrada de Stock';

                    $headers[] = 'MIME-Version: 1.0';
                    $headers[] = 'Content-type: text/html; charset=iso-8859-1';

                    // Additional headers
                    //$headers[] = 'To: Bruno Martins <bruno@rbdrinks.fr>, Bruno Rodrigues <brunomartins.1988@gmail.com>';
                    $headers[] = 'From: Backoffice RBDRINKS <noreply@rbdrinks.fr>';
                    //$headers[] = 'Bcc: bruno@rbdrinks.fr';

                    // Mail it
                    mail($to, $subject, $ref_msg, implode("\r\n", $headers));

                }
                unset($prod_received);
            }
        }

        $updt_bl = $this->db->query( "UPDATE ip_supplier_order SET
                        supplier_order_status_id = ".$this->input->post('supplier_order_status_id').",
                        tracking_inner_price = '".$this->input->post('tracking_inner_price')."',
                        notes = '".$this->input->post('notes')."'
                     WHERE supplier_order_id = ".$this->input->post('supplier_order_id') );

        $checked = 0;
        /*if($this->input->post('delivery') == 'true')
        {
            $checked = 1;
            $this->db->query("UPDATE ip_supplier_order SET supplier_order_delivery_id = '".$this->input->post('delivery_address')."' WHERE supplier_order_id = " . $this->input->post('supplier_order_id'));
        }
        else
        {
            $this->db->query("UPDATE ip_supplier_order SET supplier_order_delivery_id = 0 WHERE supplier_order_id = " . $this->input->post('supplier_order_id'));
        }

        //Delivery address
        //quote_delivery_id

        $this->db->query("UPDATE ip_supplier_order SET delivery = ".$checked." WHERE supplier_order_id = " . $this->input->post('supplier_order_id'));*/

        if( $this->input->post('supplier_order_status_id') == 4 )
        {
            $p_lst_stt = $this->db->query("SELECT * FROM ip_supplier_order_items WHERE supplier_order_id = ".$this->input->post('supplier_order_id'))->result_array();
            foreach($p_lst_stt as $pls)
            {
                if ( $pls['item_tax_rate_id'] != 2 )
                {
                    if ( $pls['item_tax_rate_id'] == 0 )
                    {
                        $updt_bl = $this->db->query( "UPDATE ip_supplier_order_items SET
                            item_tax_rate_id = 1
                         WHERE item_id = " . $pls['item_id'] . " 
                         AND supplier_order_id = ".$this->input->post('supplier_order_id') );

                        $prd_stk_o = $this->db->query("SELECT stock FROM ip_products WHERE product_sku = '".$pls['item_description']."'" )->result_array();

                        /*$updt_bl = $this->db->query( "UPDATE ip_products SET 
                            stock = stock + ".$pls['item_quantity']."
                         WHERE product_sku = '".$pls['item_description']."'" );*/
                        if ( $pls['item_warehouse_id'] == 0 )
                        {
                            $updt_bl = $this->db->query( "UPDATE ip_products SET 
                                stock = stock + ".$pls['item_quantity']."
                             WHERE product_sku = '".$pls['item_description']."'" );
                        }
                        elseif ( $pls['item_warehouse_id'] == 1 )
                        {
                            $updt_bl = $this->db->query( "UPDATE ip_products SET 
                                stock_sample = stock_sample + ".$pls['item_quantity']."
                             WHERE product_sku = '".$pls['item_description']."'" );
                        }

                        $prd_stk_f = $this->db->query("SELECT stock FROM ip_products WHERE product_sku = '".$pls['item_description']."'" )->result_array();

                        $ref_msg = '
                        <html>
                        <head><title>Fornecedor - Entrada de Stock</title></head>
                        <body>
                          <p>Entrada de stock do Fornecedor '.$this->input->post('supplier_order_number').' </p><br />
                          <table border="1">
                            <tr>
                              <th>Ref.</th><th>Quantidade Retirada</th><th>Stock Original</th><th>Stock Final</th><th>Armazem</th>
                            </tr>
                            <tr>
                                <td>'.$pls['item_description'].'</td><td>'.$pls['item_quantity'].'</td><td>'.$prd_stk_o[0]['stock'].'</td><td>'.$prd_stk_f[0]['stock'].'</td><td>'.$pls[0]['item_warehouse_id'].'</td>
                            </tr>
                        </table> </body> </html>';

                        $to = 'bruno@rbdrinks.fr';

                        $subject = 'Fornecedor - Entrada de Stock';

                        $headers[] = 'MIME-Version: 1.0';
                        $headers[] = 'Content-type: text/html; charset=iso-8859-1';

                        // Additional headers
                        //$headers[] = 'To: Bruno Martins <bruno@rbdrinks.fr>, Bruno Rodrigues <brunomartins.1988@gmail.com>';
                        $headers[] = 'From: Backoffice RBDRINKS <noreply@rbdrinks.fr>';
                        //$headers[] = 'Bcc: bruno@rbdrinks.fr';

                        // Mail it
                        mail($to, $subject, $ref_msg, implode("\r\n", $headers));

                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$pls['item_description']."', ".$pls['item_quantity'].", ".$prd_stk_o[0]['stock'].", ".$prd_stk_f[0]['stock'].", 
                                                  '".$this->input->post('supplier_order_number')."', 1, now() )" );
                    }
                    else
                    {
                        $updt_bl = $this->db->query( "UPDATE ip_supplier_order_items SET
                            item_tax_rate_id = 1
                         WHERE item_id = " . $pls['item_id'] . " 
                         AND supplier_order_id = ".$this->input->post('supplier_order_id') );
                    }
                }
            }
        }

        $response = array(
            'success' => 1,
            'supplier_order_id' => 168
        );

        echo json_encode($response);
    }

    public function save2()
    {
        $this->load->model('supplier/mdl_quote_items');
        $this->load->model('supplier/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');
        $this->load->library('encrypt');

        $quote_id = $this->input->post('supplier_order_id');

        $this->mdl_quotes->set_id($quote_id);
        //if ($this->mdl_quotes->run_validation('validation_rules_save_online_quote')) {
        $this->load->helper('json_error');
        $response = array(
            'success' => 0,
            'validation_errors' => json_errors()
        );
        $items = json_decode($this->input->post('items'));

        foreach ($items as $item) {
            if ($item->item_name) {
                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                $item_id = ($item->item_id) ?: NULL;

                $save_item_as_lookup = (isset($item->save_item_as_lookup)) ? $item->save_item_as_lookup : 0;

                unset($item->item_id, $item->save_item_as_lookup);

                $this->mdl_quote_items->save($quote_id, $item_id, $item);

                if ($save_item_as_lookup) {
                    $db_array = array(
                        'item_name' => $item->item_name,
                        'item_description' => $item->item_description,
                        'item_price' => $item->item_price
                    );

                    $this->mdl_item_lookups->save(NULL, $db_array);
                }
            }
        }

        //print "before db_array <br />";
        $is_slash_create = substr($this->input->post('supplier_order_date_created'), 2, 1);
        if($is_slash_create == "/")
        {//24-02-2016
            /*$year_create = substr($this->input->post('supplier_order_date_created'), 6, 9);
            $month_create = substr($this->input->post('supplier_order_date_created'), 0, 2);
            $day_create = substr($this->input->post('supplier_order_date_created'), 3, 4);
            $day_create = substr($day_create, 0, 2);*/
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('supplier_order_date_created'), 6, 9);
            $day_create = substr($this->input->post('supplier_order_date_created'), 0, 2);
            $month_create = substr($this->input->post('supplier_order_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('supplier_order_date_created');
        }
        $is_slash_expire = substr($this->input->post('supplier_order_date_expires'), 2, 1);
        if($is_slash_expire == "/")
        {
            $year_expire = substr($this->input->post('supplier_order_date_expires'), 6, 9);
            $month_expire = substr($this->input->post('supplier_order_date_expires'), 0, 2);
            $day_expire = substr($this->input->post('supplier_order_date_expires'), 3, 4);
            $day_expire = substr($day_expire, 0, 2);
            $date_expire = $year_expire."-".$month_expire."-".$day_expire;
        }
        elseif($is_slash_expire == "-")
        {
            $year_expire = substr($this->input->post('supplier_order_date_expires'), 6, 9);
            $day_expire = substr($this->input->post('supplier_order_date_expires'), 0, 2);
            $month_expire = substr($this->input->post('supplier_order_date_expires'), 3, 2);
            $day_expire = substr($day_expire, 0, 2);
            $date_expire = $year_expire."-".$month_expire."-".$day_expire;
        }
        else
        {
            $date_expire = $this->input->post('supplier_order_date_expires');
        }

        // @TODO Add checks / formatting for discounts!
        $db_array = array(
            'supplier_order_number' => $this->input->post('supplier_order_number'),
            'supplier_order_date_created' => $date_create,
            'supplier_order_date_expires' => $date_expire,
            'supplier_order_status_id' => $this->input->post('supplier_order_status_id'),
            'supplier_order_password' => $this->input->post('supplier_order_password'),
            'notes' => $this->input->post('notes'),
            'supplier_order_discount_amount' => $this->input->post('supplier_order_discount_amount'),
            'supplier_order_discount_percent' => $this->input->post('supplier_order_discount_percent')
        );

        //print "after db_array <br />";

        $this->mdl_quotes->save($quote_id, $db_array);

        //print "after mdl_quotes_save <br />";
        // Recalculate for discounts
        $this->load->model('supplier/mdl_quote_amounts');
        //print "after load model <br />";

        $this->mdl_quote_amounts->calculate($quote_id);

        //print "after mdl_quote_amounts calculate <br />";

        $response = array(
            'success' => 1,
            'supplier_order_id' => 168
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        if ($this->input->post('custom')) {
            $db_array = array();

            foreach ($this->input->post('custom') as $custom) {
                // I hate myself for this...
                $db_array[str_replace(']', '', str_replace('custom[', '', $custom['name']))] = $custom['value'];
            }

            $this->load->model('custom_fields/mdl_quote_custom');
            $this->mdl_quote_custom->save_custom($quote_id, $db_array);
        }

        //print "<br />";
        //print_r($response);


        echo json_encode($response);
    }

    public function save_quote_tax_rate()
    {
        $this->load->model('supplier/mdl_quote_tax_rates');

        if ($this->mdl_quote_tax_rates->run_validation()) {
            $this->mdl_quote_tax_rates->save($this->input->post('supplier_order_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_quote_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function create()
    {
        $this->load->model('supplier/mdl_quotes');

        /*$response = array(
            'success' => 2,
            'supplier_order_id' => 0
        );

        echo json_encode($response);*/

        //$t_max_id_num[] = $this->db->query("SELECT max(supplier_order_number) as supplier_order_number FROM ip_supplier_order")->result_array();
        $t_max_id_num[] = $this->db->query("SELECT supplier_order_number FROM ip_supplier_order ORDER BY supplier_order_id DESC LIMIT 1")->result_array();
        $num = $t_max_id_num[0][0]['supplier_order_number'];
        $num = substr($num, 2);
        $num = (int)$num;
        $num++;

        $cst_id[] = $this->db->query("SELECT supplier_id FROM ip_suppliers WHERE supplier_name = '".$this->input->post('doc_id')."' limit 1 ")->result_array();
        $nm_cst_id = $cst_id[0][0]['supplier_id'];

        $is_slash_create = substr($this->input->post('supplier_order_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('supplier_order_date_created'), 6, 9);
            $day_create = substr($this->input->post('supplier_order_date_created'), 0, 2);
            $month_create = substr($this->input->post('supplier_order_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('supplier_order_date_created');
        }

        //doc_id
        //supplier_order_date_created user_id
        $updt_bl = $this->db->query( "INSERT INTO ip_supplier_order (user_id, client_id, invoice_group_id, supplier_order_status_id, 
                                                                supplier_order_date_created, supplier_order_date_expires, 
                                                                supplier_order_number, owner) 
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', '".$date_create."', 
                                                  'CF".$num."', ".$this->input->post('user_id')." )" );

        $q_max_id[] = $this->db->query("SELECT max(supplier_order_id) as id FROM ip_supplier_order ")->result_array();
        //$quote_id = $t_max_id_num[0][0]['supplier_order_id'];

        $response = array(
            'success' => 1,
            'supplier_order_id' => $q_max_id[0][0]['id']
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        echo json_encode($response);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'supplier_order_id' => $this->input->post('supplier_order_id'),
            'clients' => $this->mdl_clients->get()->result(),
        );

        $this->layout->load_view('supplier/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('supplier/mdl_quotes');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $quote_id = $this->input->post('supplier_order_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('supplier_order_id', $quote_id);
            $this->db->update('ip_supplier_order', $db_array);

            $response = array(
                'success' => 1,
                'supplier_order_id' => $quote_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('supplier/mdl_quote_items');

        $item = $this->mdl_quote_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_quote()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'client_name' => $this->input->post('client_name'),
            //'clients' => $this->mdl_clients->get()->result(),
            //'clients' => $this->mdl_clients->where('client_active', 1)->get()->result(),
            //'clients' => $this->mdl_clients->where('is_valid', 1)->limit(10)->get()->result(),
        );

        $this->layout->load_view('supplier/modal_create_quote', $data);
    }

    public function modal_copy_quote()
    {
        $this->load->module('layout');

        $this->load->model('supplier/mdl_quotes');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'supplier_order_id' => $this->input->post('supplier_order_id'),
            'supplier_order' => $this->mdl_quotes->where('ip_supplier_order.supplier_order_id', $this->input->post('supplier_order_id'))->get()->row()
        );

        $this->layout->load_view('supplier/modal_copy_quote', $data);
    }

    public function copy_quote()
    {
        $this->load->model('supplier/mdl_quotes');
        $this->load->model('supplier/mdl_quote_items');
        $this->load->model('supplier/mdl_quote_tax_rates');

        if ($this->mdl_quotes->run_validation()) {
            $target_id = $this->mdl_quotes->save();
            $source_id = $this->input->post('supplier_order_id');

            $this->mdl_quotes->copy_quote($source_id, $target_id);

            $response = array(
                'success' => 1,
                'supplier_order_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_quote_to_invoice($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('supplier/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'supplier_order_id' => $quote_id,
            'supplier_order' => $this->mdl_quotes->where('ip_supplier_order.supplier_order_id', $quote_id)->get()->row()
        );

        $this->load->view('supplier/modal_quote_to_invoice', $data);
    }

    public function quote_to_invoice()
    {
        $this->load->model(
            array(
                'invoices/mdl_invoices',
                'invoices/mdl_items',
                'supplier/mdl_quotes',
                'supplier/mdl_quote_items',
                'invoices/mdl_invoice_tax_rates',
                'supplier/mdl_quote_tax_rates'
            )
        );
        /*$this->load->model(
            array(
                'quotes/mdl_quotes',
                'quotes/mdl_items',
                'supplier/mdl_quotes',
                'supplier/mdl_quote_items',
                'quotes/mdl_quote_tax_rates',
                'supplier/mdl_quote_tax_rates'
            )
        );*/

        if ($this->mdl_invoices->run_validation()) {
            // DO OWN CODE TO CONVERT EOL -> QUOTE
            $oq_res = $this->db->query("SELECT * FROM ip_supplier_order ioq
                LEFT JOIN ip_supplier_order_amounts ioqa ON ioqa.supplier_order_id = ioq.supplier_order_id
                LEFT JOIN ip_supplier_order_custom ioqc ON ioqc.supplier_order_id = ioq.supplier_order_id
                WHERE ioq.supplier_order_id = ".$this->input->post('supplier_order_id'))->result_array();

            $oqtax_res = $this->db->query("SELECT * FROM ip_supplier_order_tax_rates WHERE supplier_order_id = ".$this->input->post('supplier_order_id'))->result_array();

            $oqitems_res = $this->db->query("SELECT * FROM ip_supplier_order_items WHERE supplier_order_id = ".$this->input->post('supplier_order_id'))->result_array();

            foreach ($oqitems_res as $item) {
                $oqitems_qtt_res[] = $this->db->query("SELECT * FROM ip_supplier_order_item_amounts WHERE item_id = ".$item['item_id'] )->result_array();
            }

            $quo_exp_days = $this->db->query("SELECT * FROM ip_settings WHERE setting_key = 'quotes_expire_after'")->result_array();

            $q_max_id_num[] = $this->db->query("SELECT quote_number FROM ip_quotes order by quote_date_created desc limit 1 ")->result_array();
            $num = $q_max_id_num[0][0]['quote_number'];
            $num = substr($num, 1);
            $num = (int)$num;
            $num++;

            //GET EXPIRE QUOTE DATE TO CALCULATE NOW+EXPIRE TIMER
            /*$isrt_quo = $this->db->query("INSERT INTO ip_quotes (invoice_id, user_id, client_id, invoice_group_id, quote_status_id, quote_date_created,
            quote_date_modified, quote_date_expires, quote_number, quote_discount_amount, quote_discount_percent, quote_url_key,
            quote_password, notes) VALUES
             (0, ".$oq_res[0]['user_id'].", ".$oq_res[0]['client_id'].", ".$this->input->post('invoice_group_id').", 1, now(),
                now(), NOW() + INTERVAL ".$quo_exp_days[0]['setting_value']." DAY, 'D".$num."', ".$oq_res[0]['online_quote_discount_amount'].", ".$oq_res[0]['online_quote_discount_percent'].", '".$oq_res[0]['online_quote_url_key']."',
            '".$this->input->post('invoice_password')."', '".$oq_res[0]['notes']."' )");

            $q_max_id[] = $this->db->query("SELECT max(quote_id) as id FROM ip_quotes ")->result_array();

            if( !is_null($oq_res[0]['quote_custom_id']) && $oq_res[0]['quote_custom_id'] != "")
            {
                $isrt_quo_cstm = $this->db->query("INSERT INTO ip_quote_custom (quote_custom_id, quote_id) VALUES ( ".$oq_res[0]['online_quote_custom_id'].", ".$q_max_id[0][0]['id'].")");
            }
            if( !is_null($oq_res[0]['online_quote_amount_id']) && $oq_res[0]['online_quote_amount_id'] != "")
            {
                $isrt_quo_amnt = $this->db->query("INSERT INTO ip_quote_amounts (quote_id, quote_item_subtotal, quote_item_tax_total, quote_total) VALUES
                    ( ".$q_max_id[0][0]['id'].", '".$oq_res[0]['online_quote_item_subtotal']."', '".$oq_res[0]['online_quote_item_tax_total']."', '".$oq_res[0]['online_quote_total']."')");
            }

            foreach ($oqtax_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_tax_rates (quote_id, tax_rate_id, include_item_tax, quote_tax_rate_amount) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['tax_rate_id'].", ".$item['include_item_tax'].", ".$item['online_quote_tax_rate_amount']." )");
            }

            foreach ($oqitems_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_items (quote_id, item_tax_rate_id, item_date_added, item_name, item_description,
                        item_quantity, item_price, item_discount_amount, item_order) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['item_tax_rate_id'].", '".$item['item_date_added']."', '".$item['item_name']."', '".$item['item_description']."',
                        '".$item['item_quantity']."', '".$item['item_price']."', '".$item['item_discount_amount']."', ".$item['item_order']." )");

                $q_itm_max_id[] = $this->db->query("SELECT max(item_id) as id FROM ip_quote_items ")->result_array();

                foreach ($oqitems_qtt_res as $itm) {
                    if($itm[0]['item_id'] == $item['item_id'])
                    {
                        $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) VALUES
                        (".$itm[0]['item_id'].", ".$itm[0]['item_subtotal'].", '".$itm[0]['item_tax_total']."', '".$itm[0]['item_discount']."', '".$itm[0]['item_total']."')");
                    }
                }
            }*/

            $response = array(
                'success' => 1,
                'quote_id' => $q_max_id[0][0]['id']
            );

            echo json_encode($response);
            break;
            /*//$invoice_id = $this->mdl_invoices->create(NULL, FALSE);
            $invoice_id = $this->mdl_quotes->create(NULL);

            $this->db->where('online_quote_id', $this->input->post('online_quote_id'));
            $this->db->set('quote_id', $invoice_id);
            $this->db->update('ip_online_quotes');

            $quote_items = $this->mdl_quote_items->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_items as $quote_item) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'item_tax_rate_id' => $quote_item->item_tax_rate_id,
                    'item_name' => $quote_item->item_name,
                    'item_description' => $quote_item->item_description,
                    'item_quantity' => $quote_item->item_quantity,
                    'item_price' => $quote_item->item_price,
                    'item_order' => $quote_item->item_order
                );

                $this->mdl_items->save($invoice_id, NULL, $db_array);
            }

            $quote_tax_rates = $this->mdl_quote_tax_rates->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_tax_rates as $quote_tax_rate) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'tax_rate_id' => $quote_tax_rate->tax_rate_id,
                    'include_item_tax' => $quote_tax_rate->include_item_tax,
                    'invoice_tax_rate_amount' => $quote_tax_rate->quote_tax_rate_amount
                );

                $this->mdl_invoice_tax_rates->save($invoice_id, NULL, $db_array);
            }

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );*/
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

}
