<?php
$warehouse_list = $this->db->query("SELECT * FROM ip_warehouses WHERE inactive = 0 ORDER BY warehouse_order")->result_array();

if( !empty( $_POST['from_date'] ) || !empty( $_POST['to_date'] ) )
{
    $frm = date("Y-m-d", strtotime($_POST['from_date']));
    $to = date("Y-m-d", strtotime($_POST['to_date']));

    $frm = $frm." 00:00:00";
    $to = $to." 00:00:00";

    //echo $frm;
    //echo $to;
    //echo $_POST['supplier_order_status_id'];
    //echo $_POST['client_id'];

    if($_POST['type_of_movement_sku'] != "" AND $_POST['type_of_movement_sku'] != NULL)
    {
        //echo "WITH SKU SET";
        $myArray = explode(';', $_POST['type_of_movement_sku']);
        $qry = "SELECT * 
              FROM ip_stocks mvs
              JOIN ip_warehouses w ON mvs.warehouse_id = w.warehouse_id
              WHERE (mvs.ts >= '".$frm."' AND mvs.ts <= '".$to."' )";

        if($_POST['warehouse_id'] != NULL && $_POST['warehouse_id'] != 0 && $_POST['warehouse_id'] != '')
        {
            $qry.= " AND mvs.warehouse_id = " . $_POST['warehouse_id'];
        }

        if( $_POST['type_of_movement'] == 1 )
        {
            $qry.= " AND mvs.sign = '-'" ;
        }
        elseif ( $_POST['type_of_movement'] == 2 )
        {
            $qry.= " AND mvs.sign = '+'" ;
        }

        $qry.= " AND mvs.ref IN ( ";

        $cnt = 0;
        foreach($myArray as $my_Array){
            if($cnt > 0)
            {
                $qry.= ", ";
            }
            $qry.= "'".$my_Array."'";
            $cnt++;
        }

        $qry.= " ) ";

        $qry.= " ORDER BY mvs.ts DESC";

        //echo $qry;
    }
    else
    {
        //echo "NO SKU SET";
        $qry = "SELECT * 
              FROM ip_stocks mvs
              JOIN ip_warehouses w ON mvs.warehouse_id = w.warehouse_id
              WHERE (mvs.ts >= '".$frm."' AND mvs.ts <= '".$to."' )";

        if($_POST['warehouse_id'] != NULL && $_POST['warehouse_id'] != 0 && $_POST['warehouse_id'] != '')
        {
            $qry.= " AND mvs.warehouse_id = " . $_POST['warehouse_id'];
        }

        if( $_POST['type_of_movement'] == 1 )
        {
            $qry.= " AND mvs.sign = '-'" ;
        }
        elseif ( $_POST['type_of_movement'] == 2 )
        {
            $qry.= " AND mvs.sign = '+'" ;
        }

        $qry.= " ORDER BY mvs.ts DESC";
    }

    //print $qry;

    $dclst = $this->db->query($qry)->result_array();

    //print_r($dclst);
    //print $_SERVER['DOCUMENT_ROOT'];
    include $_SERVER['DOCUMENT_ROOT'].'/PHPExcel/Classes/PHPExcel.php';
    include $_SERVER['DOCUMENT_ROOT'].'/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

    $objPHPExcel = new PHPExcel();
    // Set properties
    $objPHPExcel->getProperties()->setCreator("Bruno Martins");
    $objPHPExcel->getProperties()->setLastModifiedBy("Bruno Martins");
    $objPHPExcel->getProperties()->setTitle("Movement Par Date");
    $objPHPExcel->getProperties()->setSubject("Movement Par Date");
    $objPHPExcel->getProperties()->setDescription("Movement Par Date");

    $i=0;
    // Add headers
    $objPHPExcel->setActiveSheetIndex(0);
    $objPHPExcel->getActiveSheet()->setTitle('ENTRADAS E SAIDAS DE STOCK');
    /*$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, 'RELANCES - MARÇO - 2018');
    $i++;*/

    $prvCstmr = '';
    $startCell = '';
    $endCell = '';
    $weekp = 0;

    $objPHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

    foreach ($dclst as $row)
    {
        $date = new DateTime($row['Date']);
        $week = $date->format("W");

        if($weekp != $week)
        {
            $weekp = $week;
            $i++;

            $monthNum  = $date->format("m");
            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F'); // March

            //$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, lang('month_'.$monthNum).' - '.lang('week').' '.$weekp  );
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, lang('month_'.$monthNum).' - '.lang('week_of').' '. $date->format('j') );

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A'.$i.':F'.$i);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':F'.$i)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => '919191'
                )
            ));
            $i++;
            $objPHPExcel->getActiveSheet()->getStyle('A'.$i)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, lang('sku') );
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, lang('type_of_movement'));
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, lang('stock_moved'));
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, lang('note'));
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, lang('warehouse'));
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, lang('created_date'));
            $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':F'.$i)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'ededed'
                )
            ));

            $prvCstmr = '';
        }

        $i++;
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, $row['ref']);
        if($row['sign'] == "+")
        {
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, 'Entrada de Stock');
        }
        else
        {
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, 'Saida de Stock');
        }

        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, $row['uni']);
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, $row['stock_note']);
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, $row['warehouse_name']);
        $year = substr($row['ts'], 0, 4);
        $month = substr($row['ts'], 5, 2);
        $day = substr($row['ts'], 8, 2);
        $hour = substr($row['ts'], 11, 2);
        $minute = substr($row['ts'], 14, 2);
        $second = substr($row['ts'], 17, 2);
        
        $dtp = $hour . ":" . $minute . ":" . $second . " " . $day . "-" . $month . "-" . $year;

        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, $dtp);

    }

    // Auto size columns for each worksheet
    $nCols = 5; //set the number of columns

    foreach (range(0, $nCols) as $col) {
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($col)->setAutoSize(true);
    }

    $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);

    $pth = __FILE__;
    $pth = str_replace('application/modules/reports/views', 'uploads', $pth);
    $objWriter->save(str_replace('.php', '.xlsx', $pth));

    //echo 'AFTER SUBMIT WITH VALUES';
}
else
{
    unset($dclst);
    //echo 'AFTER SUBMIT ANYWAY NO DATE';
}
?>

<div id="headerbar">
    <h1><?php echo lang('enter_exit_stock'); ?></h1>
</div>

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <!-- <form method="post" action="<?php echo site_url($this->uri->uri_string()); ?>"> -->
            <form action="type_movement" method="post">

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="from_date">
                            <?php echo lang('from_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="from_date" id="from_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['from_date']))
                                {
                                    echo "value=".$_POST['from_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="to_date">
                            <?php echo lang('to_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="to_date" id="to_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['to_date']))
                                {
                                    echo "value=".$_POST['to_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="type_of_movement_lbl" >
                            <?php echo lang('type_of_movement'); ?>
                        </label>

                        <select name="type_of_movement" id="type_of_movement" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <option value="1"><?php echo lang('stock_exit'); ?></option>
                            <option value="2"><?php echo lang('stock_entry'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="transport_transporter_lbl" >
                            <?php echo lang('warehouse'); ?>
                        </label>

                        <select name="warehouse_id" id="warehouse_id" class="form-control input-sm">
                            <option value="0" selected><?php echo lang('all'); ?></option>
                            <?php foreach ($warehouse_list  as $supl) {?>
                                <option value="<?php echo $supl['warehouse_id']; ?>"> <?php echo $supl['warehouse_name']; ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="sku_lbl" >
                            <?php echo lang('product_sku') . "(;)"; ?>
                        </label>

                        <input name="type_of_movement_sku" id="type_of_movement_sku" class="form-control input-sm">

                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="submit" class="btn btn-success" name="btn_submit" style="margin-top: 22px;"
                               value="<?php echo lang('run_report'); ?>">
                        <!-- <a href="production_by_supplier.xlsx">Lalala<img src="excel.png"></a> -->
                        <?php
                        if( isset($dclst) )
                        { ?>
                            <a href="/uploads/type_movement.xlsx"
                               style="display: inline-block;
                            color: #fff;
                            background-color: #5cb85c;
                            border-color: #4cae4c;
                            margin-bottom: 0;
                            margin-top: 22px;
                            font-weight: normal;
                            text-align: center;
                            vertical-align: middle;
                            touch-action: manipulation;
                            cursor: pointer;
                            background-image: none;
                            border: 1px solid transparent;
                            white-space: nowrap;
                            padding: 6px 12px;
                            font-size: 14px;
                            line-height: 1.428571429;
                            border-radius: 4px;"
                            >
                                <?php echo lang('download'); ?><i class="fas fa-file-excel"></i>
                            </a>
                        <?php } ?>
                    </div>
                </div>

            </form>

            <div>
                <?php
                if( isset($dclst) )
                {
                    ?>
                    <br />
                    <table class="table table-striped">
                        <thead>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('sku'); ?></th>
                            <th><?php echo lang('type_of_movement'); ?></th>
                            <th><?php echo lang('stock_moved'); ?></th>
                            <th><?php echo lang('note'); ?></th>
                            <th><?php echo lang('warehouse'); ?></th>
                            <th><?php echo lang('created_date'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach($dclst as $dcl)
                        {
                            echo '<tr>';
                            echo '<td>'.$dcl['ref'].'</td>';
                            if($dcl['sign'] == "+")
                            {
                                echo '<td>Entrada de Stock</td>';
                            }
                            else
                            {
                                echo '<td>Saida de Stock</td>';
                            }
                            echo '<td>'.$dcl['uni'].'</td>';
                            echo '<td>'.$dcl['stock_note'].'</td>';
                            echo '<td>'.$dcl['warehouse_name'].'</td>';
                            echo '<td>';
                            //echo $dcl['ts'];
                            $year = substr($dcl['ts'], 0, 4);
                            $month = substr($dcl['ts'], 5, 2);
                            $day = substr($dcl['ts'], 8, 2);
                            $hour = substr($dcl['ts'], 11, 2);
                            $minute = substr($dcl['ts'], 14, 2);
                            $second = substr($dcl['ts'], 17, 2);
                            
                            echo $hour . ":" . $minute . ":" . $second . " " . $day . "-" . $month . "-" . $year;
                            //echo $hour;

                            echo '</td>';
                            echo '</tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                    <?php
                }
                else
                {

                }
                ?>
            </div>

        </div>
    </div>
</div>