<?php
require_once('/home/drinksfr/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$transporter_list = $this->db->query("SELECT * FROM ip_transporters WHERE inactive = 0 ORDER BY order_list")->result_array();

if( !empty( $_POST['from_date'] ) || !empty( $_POST['to_date'] ) )
{
    $frm = date("Y-m-d", strtotime($_POST['from_date']));
    $to = date("Y-m-d", strtotime($_POST['to_date']));

    //echo $frm;
    //echo $to;
    //echo $_POST['supplier_order_status_id'];
    //echo $_POST['client_id'];
    //echo $_POST['tracking_code'];

    if($_POST['transport_sku'] != "" AND $_POST['transport_sku'] != NULL)
    {
        //echo "WITH SKU SET";
        $myArray = explode(';', $_POST['transport_sku']);
        $qry = "SELECT * 
              FROM ip_transport t 
              JOIN ip_transport_items ti ON ti.transport_id = t.transport_id
              JOIN ip_clients c ON c.client_id = t.client_id
              LEFT JOIN ip_transporters tp ON t.transporter = tp.transporter_id
              WHERE (t.transport_date_created >= '".$frm."' AND t.transport_date_created <= '".$to."' )";

        if($_POST['transport_status_id'] != NULL && $_POST['transport_status_id'] != 0 && $_POST['transport_status_id'] != '')
        {
            $qry.= " AND t.transport_status_id = " . $_POST['transport_status_id'];
        }
        if($_POST['tracking_code'] != NULL && $_POST['transport_status_id'] != 0 && $_POST['transport_status_id'] != '')
        {
            $qry.= " AND t.tracking_code != ''";
        }
        if($_POST['transporter_list'] != NULL && $_POST['transporter_list'] != 0 && $_POST['transporter_list'] != '')
        {
            $qry.= " AND t.transporter = " . $_POST['transporter_list'];
        }

        $qry.= " AND ti.item_description IN ( ";

        $cnt = 0;
        foreach($myArray as $my_Array){
            if($cnt > 0)
            {
                $qry.= ", ";
            }
            $qry.= "'".$my_Array."'";
            $cnt++;
        }

        $qry.= " ) ";

        $qry.= " GROUP BY t.transport_id ORDER BY t.transport_number ASC, t.transport_date_created ASC";

        //echo $qry;
    }
    else
    {
        //echo "NO SKU SET"; client_id
        $qry = "SELECT * 
              FROM ip_transport t 
              JOIN ip_clients c ON c.client_id = t.client_id
              LEFT JOIN ip_transporters tp ON t.transporter = tp.transporter_id
              WHERE (t.transport_date_created >= '".$frm."' AND t.transport_date_created <= '".$to."' )";

        if($_POST['transport_status_id'] != NULL && $_POST['transport_status_id'] != 0 && $_POST['transport_status_id'] != '')
        {
            $qry.= " AND t.transport_status_id = " . $_POST['transport_status_id'];
        }
        if($_POST['tracking_code'] == "on")
        {
            $qry.= " AND t.tracking_code != ''";
        }
        if($_POST['transporter_list'] != NULL && $_POST['transporter_list'] != 0 && $_POST['transporter_list'] != '')
        {
            $qry.= " AND t.transporter = " . $_POST['transporter_list'];
        }

        $qry.= " ORDER BY t.transport_number ASC, t.transport_date_created ASC";
    }

    //print $qry;

    $dclst = $this->db->query($qry)->result_array();

    //print_r($dclst);
    //print $_SERVER['DOCUMENT_ROOT'];
    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

    $sheet = $spreadsheet->getActiveSheet(); 

    $spreadsheet->getProperties()->setCreator('Bruno Martins')->setLastModifiedBy('Bruno Martins')->setTitle('Transport')->setSubject('Transport')->setDescription('Transport')->setKeywords('Transport Date Backoffice')->setCategory('Statistics');

    $i=0;
    // Add headers
    $spreadsheet->setActiveSheetIndex(0);
    $spreadsheet->getActiveSheet()->setTitle('BON LIVRAISON');

    $prvCstmr = '';
    $startCell = '';
    $endCell = '';
    $weekp = 0;
    $prc_ttl = 0;

    $styleArray = [
        'alignment' => [
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        ],
    ];

    foreach ($dclst as $row)
    {
        $date = new DateTime($row['Date']);
        $week = $date->format("W");

        $year = substr($row['transport_date_created'], 0, 4);
        $month = substr($row['transport_date_created'], 5, 2);
        $day = substr($row['transport_date_created'], 8, 2);

        $dtp =  $day . "-" . $month . "-" . $year;

        if($weekp != $week)
        {
            $weekp = $week;
            $i++;

            $monthNum  = $date->format("m");
            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F'); // March

            $sheet->setCellValue('A'.$i, lang('month_'.$monthNum).' - '.lang('week_of').' '. $date->format('j') );

            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':E'.$i)
                ->getFont()
                ->setBold(true);
            $spreadsheet->getActiveSheet()->mergeCells('A'.$i.':E'.$i);
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':E'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('919191');
            $spreadsheet->getActiveSheet()->getStyle('A'.$i.':G'.$i)->getAlignment()->setHorizontal('center');
            $spreadsheet->getActiveSheet()->getStyle('A'.$i.':G'.$i)->getAlignment()->setVertical('center');
            $i++;
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':E'.$i)
                ->getFont()
                ->setBold(true);
            $sheet->setCellValue('A'.$i, lang('transport') );
            $sheet->setCellValue('B'.$i, lang('transporter'));
            $sheet->setCellValue('C'.$i, lang('created_date'));
            $sheet->setCellValue('D'.$i, lang('status'));
            $sheet->setCellValue('E'.$i, lang('tracking_code'));
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':E'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('ededed');

           $prvCstmr = '';
        }

        $i++;
        $sheet->setCellValue('A'.$i, $row['transport_number']);
        $sheet->setCellValue('B'.$i, $row['transporter_name']);
        $sheet->setCellValue('C'.$i, $dtp);
        if( $row['transport_status_id'] == 1 )
        {
            $sheet->setCellValue('D'.$i, lang('draft'));
        } elseif( $row['transport_status_id'] == 4 )
        {
            $sheet->setCellValue('D'.$i, lang('approved_bl'));
        } elseif( $row['transport_status_id'] == 6 )
        {
            $sheet->setCellValue('D'.$i, lang('removed_sp'));
        }
        $sheet->setCellValue('E'.$i, $row['tracking_code']);

        $prc_ttl = $prc_ttl + $row['tracking_inner_price'];
    }

    // Auto size columns for each worksheet
    $nCols = 5; //set the number of columns

    foreach (range('A','E') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }

    $writer = new Xlsx($spreadsheet);
    $pth = __FILE__;
    $pth = str_replace('/home/drinksfr/backoffice.rbdrinks.fr/application/modules/reports/views', './uploads', $pth);
    $pth = str_replace('.php', '.xlsx', $pth);
    $writer->save($pth);

    //echo 'AFTER SUBMIT WITH VALUES';
}
else
{
    unset($dclst);
    //echo 'AFTER SUBMIT ANYWAY NO DATE';
}
?>

<?php $nw_dt = date("Y-m-d");?>

<div id="headerbar">
    <h1><?php echo lang('transport_list'); ?></h1>
</div>

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <!-- <form method="post" action="<?php echo site_url($this->uri->uri_string()); ?>"> -->
            <form action="transport_list" method="post">

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="from_date">
                            <?php echo lang('from_date'); ?>
                        </label>

                        <div class="input-group">
                            <input name="from_date" id="from_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['from_date']))
                                {
                                    echo "value=".$_POST['from_date'];
                                }
                                else
                                {
                                    echo "value=".date_from_mysql($nw_dt, TRUE);
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="to_date">
                            <?php echo lang('to_date'); ?>
                        </label>

                        <div class="input-group">
                            <input name="to_date" id="to_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['to_date']))
                                {
                                    echo "value=".$_POST['to_date'];
                                }
                                else
                                {
                                    echo "value=".date_from_mysql($nw_dt, TRUE);
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="transport_status_id">Statut</label>

                        <select name="transport_status_id" id="transport_status_id" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <option value="1"><?php echo lang('draft'); ?></option>
                            <option value="4"><?php echo lang('approved_bl'); ?></option>
                            <option value="6"><?php echo lang('removed_sp'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="transport_transporter_lbl" >
                            <?php echo lang('transporter'); ?>
                        </label>

                        <select name="transporter_list" id="transporter_list" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <?php foreach ($transporter_list  as $tpl) {?>

                                <option value="<?php echo $tpl['transporter_id']; ?>"
                                        <?php if ($tpl['transporter_id'] == $quote->transporter) { ?>selected="selected"<?php } ?>><?php echo $tpl['transporter_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="sku_lbl" >
                            <?php echo lang('product_sku') . "(;)"; ?>
                        </label>

                        <input name="transport_sku" id="transport_sku" class="form-control input-sm">

                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="checkbox"
                               style="margin-top: 30px;"
                               name="tracking_code" <?php if($_POST['tracking_code'] == 'on') echo "checked";?> ><?php echo lang('tracking_code'); ?><br>

                    </div>
                </div>

                <div class="col-xs-12 col-sm-2" style="float: right; margin-right: -50px; margin-top: -20px;">
                    <div class="form-group has-feedback">
                        <input type="submit" class="btn btn-success" name="btn_submit" style="margin-top: 22px;"
                               value="<?php echo lang('run_report'); ?>">
                        <!-- <a href="production_by_supplier.xlsx">Lalala<img src="excel.png"></a> -->
                        <?php
                        if( isset($dclst) )
                        { ?>
                            <a href="/uploads/transport_list.xlsx"
                               style="display: inline-block;
                            color: #fff;
                            background-color: #5cb85c;
                            border-color: #4cae4c;
                            margin-bottom: 0;
                            margin-top: 22px;
                            font-weight: normal;
                            text-align: center;
                            vertical-align: middle;
                            touch-action: manipulation;
                            cursor: pointer;
                            background-image: none;
                            border: 1px solid transparent;
                            white-space: nowrap;
                            padding: 6px 12px;
                            font-size: 14px;
                            line-height: 1.428571429;
                            border-radius: 4px;"
                            >
                                <?php echo lang('download'); ?><i class="fas fa-file-excel"></i>
                            </a>
                        <?php } ?>
                    </div>
                </div>

            </form>

            <div>
                <?php
                if( isset($dclst) )
                {
                    ?>
                    <br />
                    <table class="table table-striped">
                        <thead>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('transport'); ?></th>
                            <th><?php echo lang('personal_information'); ?></th>
                            <th><?php echo lang('transporter'); ?></th>
                            <th><?php echo lang('created_date'); ?></th>
                            <th><?php echo lang('tracking_code'); ?></th>
                            <th style="text-align:right;"><?php echo lang('price'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach($dclst as $dcl)
                        {
                            echo '<tr><td>'; ?>
                            <a href="<?php echo site_url('bon_livraison/view/' . $dcl['transport_id']); ?>"
                               title="<?php echo lang('edit'); ?>">
                                <?php echo $dcl['transport_number']; ?>
                            </a>
                            <?php 
                            echo '<td>'.$dcl['client_name'].'</td>';
                            echo '<td>'.$dcl['transporter_name'].'</td>';
                            $year = substr($dcl['transport_date_created'], 0, 4);
                            $month = substr($dcl['transport_date_created'], 5, 2);
                            $day = substr($dcl['transport_date_created'], 8, 2);

                            echo '<td>' . $day . "-" . $month . "-" . $year . '</td>';
                            //echo '<td>'.$dcl['transport_date_created'].'</td>';
                            echo '<td>'.$dcl['tracking_code'].'</td>';
                            echo '<td style="text-align:right;">'.$dcl['tracking_inner_price'].' €</td>';
                            echo '</tr>';
                        }

                        echo '<tr><td></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '</tr>';

                        echo '<tr><td><b>TOTAL</b></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '<td style="text-align:right;"><b>'.$prc_ttl.' €</b></td>';
                        echo '</tr>';
                        ?>
                        </tbody>
                    </table>
                    <?php
                }
                else
                {

                }
                ?>
            </div>

        </div>
    </div>
</div>