<?php
require_once('/home/drinksfr/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$supplier_list = $this->db->query("SELECT * FROM ip_suppliers WHERE supplier_active = 1 ORDER BY supplier_id")->result_array();

if( !empty( $_POST['from_date'] ) || !empty( $_POST['to_date'] ) )
{
    $frm = date("Y-m-d", strtotime($_POST['from_date']));
    $to = date("Y-m-d", strtotime($_POST['to_date']));

    //echo $frm;
    //echo $to;
    //echo $_POST['supplier_order_status_id'];
    //echo $_POST['client_id'];
    //echo $_POST['supplier_list_xpto'];

    if($_POST['supplier_order_sku'] != "" AND $_POST['supplier_order_sku'] != NULL)
    {
        //echo "WITH SKU SET";
        $myArray = explode(';', $_POST['supplier_order_sku']);
        $qry = "SELECT * 
              FROM ip_supplier_order s 
              JOIN ip_supplier_order_items si ON si.supplier_order_id = s.supplier_order_id
              JOIN ip_suppliers sp ON s.client_id = sp.supplier_id
              WHERE (s.supplier_order_date_created >= '".$frm."' AND s.supplier_order_date_created <= '".$to."' )";

        if($_POST['supplier_order_status_id'] != NULL && $_POST['supplier_order_status_id'] != 0 && $_POST['supplier_order_status_id'] != '')
        {
            $qry.= " AND s.supplier_order_status_id = " . $_POST['supplier_order_status_id'];
        }
        if($_POST['supplier_list_xpto'] != NULL && $_POST['supplier_list_xpto'] != 0 && $_POST['supplier_list_xpto'] != '')
        {
            $qry.= " AND s.client_id = " . $_POST['supplier_list_xpto'];
        }

        $qry.= " AND si.item_description IN ( ";

        $cnt = 0;
        foreach($myArray as $my_Array){
            if($cnt > 0)
            {
                $qry.= ", ";
            }
            $qry.= "'".$my_Array."'";
            $cnt++;
        }

        $qry.= " ) ";

        $qry.= " GROUP BY s.supplier_order_id ORDER BY s.supplier_order_date_created ASC";

        //echo $qry;
    }
    else
    {
        //echo "NO SKU SET"; client_id
        //echo $_POST['supplier_list_xpto'];
        $qry = "SELECT * 
              FROM ip_supplier_order s 
              JOIN ip_suppliers sp ON s.client_id = sp.supplier_id
              WHERE (s.supplier_order_date_created >= '".$frm."' AND s.supplier_order_date_created <= '".$to."' )";

        if($_POST['supplier_order_status_id'] != NULL && $_POST['supplier_order_status_id'] != 0 && $_POST['supplier_order_status_id'] != '')
        {
            $qry.= " AND s.supplier_order_status_id = " . $_POST['supplier_order_status_id'];
        }
        if($_POST['supplier_list_xpto'] != NULL && $_POST['supplier_list_xpto'] != 0 && $_POST['supplier_list_xpto'] != '')
        {
            $qry.= " AND s.client_id = " . $_POST['supplier_list_xpto'];
        }

        $qry.= " ORDER BY s.supplier_order_date_created ASC";
    }

    //print $qry;

    $dclst = $this->db->query($qry)->result_array();

    //print_r($dclst);
    //print $_SERVER['DOCUMENT_ROOT'];
    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

    $sheet = $spreadsheet->getActiveSheet(); 

    $spreadsheet->getProperties()->setCreator('Bruno Martins')->setLastModifiedBy('Bruno Martins')->setTitle('Commande Fournisser Par Date')->setSubject('Commande Fournisser Par Date')->setDescription('Commande Fournisser Par Date')->setKeywords('Commande Fournisser Date Backoffice')->setCategory('Statistics');

    $i=0;
    // Add headers
    $spreadsheet->setActiveSheetIndex(0);
    $spreadsheet->getActiveSheet()->setTitle('COMMANDE FOURNISSEUR');

    $prvCstmr = '';
    $startCell = '';
    $endCell = '';
    $weekp = 0;

    $styleArray = [
        'alignment' => [
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        ],
    ];

    foreach ($dclst as $row)
    {
        $date = new DateTime($row['Date']);
        $week = $date->format("W");

        if($weekp != $week)
        {
            $weekp = $week;
            $i++;

            $monthNum  = $date->format("m");
            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F'); // March

            $sheet->setCellValue('A'.$i, lang('month_'.$monthNum).' - '.lang('week_of').' '. $date->format('j') );

            $spreadsheet->getActiveSheet()->mergeCells('A'.$i.':D'.$i);
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':D'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('919191');
            $i++;
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':D'.$i)
                ->getFont()
                ->setBold(true);
            $sheet->setCellValue('A'.$i, lang('production') );
            $sheet->setCellValue('B'.$i, lang('supplier'));
            $sheet->setCellValue('C'.$i, lang('created_date'));
            $sheet->setCellValue('D'.$i, lang('status'));
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':D'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('ededed');

            $prvCstmr = '';
        }

        $i++;
        $sheet->setCellValue('A'.$i, $row['supplier_order_number']);
        $sheet->setCellValue('B'.$i, $row['supplier_name']);

        $year = substr($row['supplier_order_date_created'], 0, 4);
        $month = substr($row['supplier_order_date_created'], 5, 2);
        $day = substr($row['supplier_order_date_created'], 8, 2);
        
        $sheet->setCellValue('C'.$i, $day . "-" . $month . "-" . $year);
        if( $row['supplier_order_status_id'] == 1 )
        {
            $sheet->setCellValue('D'.$i, lang('draft'));
        } elseif( $row['supplier_order_status_id'] == 3 )
        {
            $sheet->setCellValue('D'.$i, lang('viewed_sp'));
        } elseif( $row['supplier_order_status_id'] == 4 )
        {
            $sheet->setCellValue('D'.$i, lang('approved_sp'));
        } elseif( $row['supplier_order_status_id'] == 6 )
        {
            $sheet->setCellValue('D'.$i, lang('removed_sp'));
        }
    }

    // Auto size columns for each worksheet
    $nCols = 5; //set the number of columns

    foreach (range('A','D') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);
    $pth = __FILE__;
    $pth = str_replace('/home/drinksfr/backoffice.rbdrinks.fr/application/modules/reports/views', './uploads', $pth);
    $pth = str_replace('.php', '.xlsx', $pth);
    $writer->save($pth);

    //echo 'AFTER SUBMIT WITH VALUES';
}
else
{
    unset($dclst);
    //echo 'AFTER SUBMIT ANYWAY NO DATE';
}
?>

<div id="headerbar">
    <h1><?php echo lang('supplier_report'); ?></h1>
</div>

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <!-- <form method="post" action="<?php echo site_url($this->uri->uri_string()); ?>"> -->
            <form action="supplier_report" method="post">

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="from_date">
                            <?php echo lang('from_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="from_date" id="from_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['from_date']))
                                {
                                    echo "value=".$_POST['from_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="to_date">
                            <?php echo lang('to_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="to_date" id="to_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['to_date']))
                                {
                                    echo "value=".$_POST['to_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="supplier_order_status_id">Statut</label>

                        <select name="supplier_order_status_id" id="supplier_order_status_id" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <option value="1"><?php echo lang('draft'); ?></option>
                            <option value="3"><?php echo lang('viewed_sp'); ?></option>
                            <option value="4"><?php echo lang('approved_sp'); ?></option>
                            <option value="6"><?php echo lang('removed_sp'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="transport_transporter_lbl" >
                            <?php echo lang('service_provider'); ?>
                        </label>

                        <select name="supplier_list_xpto" id="supplier_list_xpto" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <?php foreach ($supplier_list  as $supl) {?>

                                <option value="<?php echo $supl['supplier_id']; ?>"><?php echo $supl['supplier_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="sku_lbl" >
                            <?php echo lang('product_sku') . "(;)"; ?>
                        </label>

                        <input name="supplier_order_sku" id="supplier_order_sku" class="form-control input-sm">

                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="submit" class="btn btn-success" name="btn_submit" style="margin-top: 22px;"
                               value="<?php echo lang('run_report'); ?>">
                        <!-- <a href="production_by_supplier.xlsx">Lalala<img src="excel.png"></a> -->
                        <?php
                        if( isset($dclst) )
                        { ?>
                            <a href="/uploads/supplier_report.xlsx"
                               style="display: inline-block;
                            color: #fff;
                            background-color: #5cb85c;
                            border-color: #4cae4c;
                            margin-bottom: 0;
                            margin-top: 22px;
                            font-weight: normal;
                            text-align: center;
                            vertical-align: middle;
                            touch-action: manipulation;
                            cursor: pointer;
                            background-image: none;
                            border: 1px solid transparent;
                            white-space: nowrap;
                            padding: 6px 12px;
                            font-size: 14px;
                            line-height: 1.428571429;
                            border-radius: 4px;"
                            >
                                <?php echo lang('download'); ?><i class="fas fa-file-excel"></i>
                            </a>
                        <?php } ?>
                    </div>
                </div>

            </form>

            <div>
                <?php
                if( isset($dclst) )
                {
                    ?>
                    <br />
                    <table class="table table-striped">
                        <thead>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('supplier_order'); ?></th>
                            <th><?php echo lang('supplier'); ?></th>
                            <th><?php echo lang('created_date'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach($dclst as $dcl)
                        {
                            echo '<tr><td>'; ?>
                            <a href="<?php echo site_url('supplier/view/' . $dcl['supplier_order_id']); ?>"
                               title="<?php echo lang('edit'); ?>">
                                <?php echo $dcl['supplier_order_number']; ?>
                            </a>
                            <?php echo '<td>'.$dcl['supplier_name'].'</td>';
                            //echo '<td>'.$dcl['supplier_order_date_created'].'</td>';
                            echo '<td>';

                            $year = substr($dcl['supplier_order_date_created'], 0, 4);
                            $month = substr($dcl['supplier_order_date_created'], 5, 2);
                            $day = substr($dcl['supplier_order_date_created'], 8, 2);
                            //$hour = substr($dcl['ts'], 11, 2);
                            //$minute = substr($dcl['ts'], 14, 2);
                            //$second = substr($dcl['ts'], 17, 2);
                            
                            echo $day . "-" . $month . "-" . $year;

                            echo '</td>';
                            echo '</tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                    <?php
                }
                else
                {

                }
                ?>
            </div>

        </div>
    </div>
</div>