<?php
    unset($dclst);
    unset($rs);

    $qry = "SELECT product_sku, stock, stock_first_quarter, stock_second_quarter, stock_third_quarter, stock_forth_quarter
                FROM ip_products
                WHERE family_id IN (1, 2, 3)
                AND inactive = 0
                ORDER BY product_sku ASC;";
    //print $qry;

    $dclst = $this->db->query($qry)->result_array();

    //print_r($dclst);
    //print $_SERVER['DOCUMENT_ROOT'];
    $i = 0;

    foreach ($dclst as $row)
    {
        $qry = "SELECT SUM(item_quantity) AS StockOut
                FROM ip_production_items pi
                JOIN ip_production p ON p.production_id = pi.production_id
                WHERE pi.item_description = '".$row['product_sku']."'
                AND pi.item_date_added > '2019-03-31'
                AND p.production_status_id IN (2, 4)
                AND pi.item_warehouse_id = 1;";
        $dcout = $this->db->query($qry)->result_array();        

        $qry = "SELECT SUM(item_quantity) AS StockIn
                FROM ip_supplier_order_items soi
                JOIN ip_supplier_order so ON so.supplier_order_id = soi.supplier_order_id
                WHERE soi.item_description = '".$row['product_sku']."'
                AND soi.item_date_added > '2019-03-31'
                AND soi.item_tax_rate_id = 1
                AND item_warehouse_id = 0;";
        $dcin = $this->db->query($qry)->result_array();

        $rs[$i]['product_sku'] = $row['product_sku'];
        $rs[$i]['stock'] = $row['stock'];
        $rs[$i]['stock_first_quarter'] = $row['stock_first_quarter'];
        $rs[$i]['stock_second_quarter'] = $row['stock_second_quarter'];
        $rs[$i]['stock_third_quarter'] = $row['stock_third_quarter'];
        $rs[$i]['stock_forth_quarter'] = $row['stock_forth_quarter'];
        $rs[$i]['StockOut'] = $dcout[0]['StockOut'];
        $rs[$i]['StockIn'] = $dcin[0]['StockIn'];
        $i++;
    }

//print_r($rs);

?>

<!--<div id="headerbar">
    <h1><?php echo lang('enter_exit_stock'); ?></h1>
</div>-->

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo 'Rapport - Stocks'; ?>
                <?php //echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <!-- <form method="post" action="<?php echo site_url($this->uri->uri_string()); ?>"> -->

            <div>
                <?php
                if( isset($rs) )
                {
                    ?>
                    <style>
                        tr {
                            height: 25px;
                            font-size: 14px;
                        }
                        #header_tr {
                            height: 15px;
                        }
                        tr:hover {
                            background-color: #d3d3d3 !important;
                        }
                    </style>
                    <table class="table table-striped">
                        <thead>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('product_sku'); ?></th>
                            <th><?php echo lang('stock_first_semester'); ?></th>
                            <th><?php echo lang('stock_second_semester'); ?></th>
                            <th><?php echo lang('stock_third_semester'); ?></th>
                            <th><?php echo lang('stock_forth_semester'); ?></th>
                            <th><?php echo lang('stock_add'); ?></th>
                            <th><?php echo lang('stock_take'); ?></th>
                            <th><?php echo lang('current_stock'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach($rs as $dcl)
                        {
                            echo '<tr>';

                            echo '  <td><b>'.$dcl['product_sku'].'</b></td>';
                            echo '  <td>'.$dcl['stock_first_quarter'].'</td>';
                            echo '  <td>'.$dcl['stock_second_quarter'].'</td>';
                            echo '  <td>'.$dcl['stock_third_quarter'].'</td>';
                            echo '  <td>'.$dcl['stock_forth_quarter'].'</td>';
                            echo '  <td><b><span style="color: green;">'.$dcl['StockIn'].'</span></b></td>';
                            echo '  <td><b><span style="color: red;">'.$dcl['StockOut'].'</span></b></td>';
                            echo '  <td><b>'.$dcl['stock'].'</b></td>';
                            //echo '  <td>'.($dcl['stock_first_quarter'] + $dcl['StockIn'] - $dcl['StockOut']).'</td>';
                            //echo '  <td>Stock Inicial:'.$dcl['stock_first_quarter'].' + Entradas de Stock: '.$dcl['StockIn'].' - Saidas de Stock: '.$dcl['StockOut'].' = '.($dcl['stock_first_quarter'] + $dcl['StockIn'] - $dcl['StockOut']).'</td>';
                            
                            echo '</tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                    <?php
                }
                else
                {

                }
                ?>
            </div>

        </div>
    </div>
</div>