<?php
require_once('/home/drinksfr/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$production_supplier_list = $this->db->query("SELECT * FROM ip_production_suppliers WHERE production_supplier_active = 1 ORDER BY production_supplier_id")->result_array();

if( !empty( $_POST['from_date'] ) || !empty( $_POST['to_date'] ) )
{
    $frm = date("Y-m-d", strtotime($_POST['from_date']));
    $to = date("Y-m-d", strtotime($_POST['to_date']));

    //echo $frm;
    //echo $to;
    //echo $_POST['production_status_id'];
    //echo $_POST['production_supplier'];

    if($_POST['production_sku'] != "" AND $_POST['production_sku'] != NULL)
    {
        //echo "WITH SKU SET";
        $myArray = explode(';', $_POST['production_sku']);
        $qry = "SELECT * 
              FROM ip_production p 
              JOIN ip_production_items pi ON pi.production_id = p.production_id
              JOIN ip_clients c ON p.client_id = c.client_id
              WHERE (p.production_date_expires >= '".$frm."' AND p.production_date_expires <= '".$to."' )";

        if($_POST['production_status_id'] != NULL && $_POST['production_status_id'] != 0 && $_POST['production_status_id'] != '')
        {
            $qry.= " AND p.production_status_id = " . $_POST['production_status_id'];
        }
        if($_POST['production_supplier'] != NULL && $_POST['production_supplier'] != 0 && $_POST['production_supplier'] != '')
        {
            $qry.= " AND p.production_supplier = " . $_POST['production_supplier'];
        }

        $qry.= " AND pi.item_description IN ( ";

        $cnt = 0;
        foreach($myArray as $my_Array){
            if($cnt > 0)
            {
                $qry.= ", ";
            }
            $qry.= "'".$my_Array."'";
            $cnt++;
        }

        $qry.= " ) ";

        $qry.= " GROUP BY p.production_id ORDER BY p.production_date_expires ASC";

        //echo $qry;
    }
    else
    {
        //echo "NO SKU SET";
        $qry = "SELECT * 
              FROM ip_production p 
              JOIN ip_clients c ON p.client_id = c.client_id
              WHERE (p.production_date_expires >= '".$frm."' AND p.production_date_expires <= '".$to."' )";

        if($_POST['production_status_id'] != NULL && $_POST['production_status_id'] != 0 && $_POST['production_status_id'] != '')
        {
            $qry.= " AND p.production_status_id = " . $_POST['production_status_id'];
        }
        if($_POST['production_supplier'] != NULL && $_POST['production_supplier'] != 0 && $_POST['production_supplier'] != '')
        {
            $qry.= " AND p.production_supplier = " . $_POST['production_supplier'];
        }

        $qry.= " ORDER BY p.production_date_expires ASC";
    }

    //print $qry;

    $dclst = $this->db->query($qry)->result_array();

    //print_r($dclst);
    //print $_SERVER['DOCUMENT_ROOT'];
    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

    $sheet = $spreadsheet->getActiveSheet(); 

    $spreadsheet->getProperties()->setCreator('Bruno Martins')->setLastModifiedBy('Bruno Martins')->setTitle('Commande Par Date')->setSubject('Commande Par Date')->setDescription('Commande Par Date')->setKeywords('Commande Date Backoffice')->setCategory('Statistics');

    $i=0;
    // Add headers
    $spreadsheet->setActiveSheetIndex(0);
    $spreadsheet->getActiveSheet()->setTitle('COMMANDE');

    $prvCstmr = '';
    $startCell = '';
    $endCell = '';
    $weekp = 0;

    $styleArray = [
        'alignment' => [
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        ],
    ];

    $i++;
    $spreadsheet
        ->getActiveSheet()
        ->getStyle('A'.$i.':F'.$i)
        ->getFont()
        ->setBold(true);
    $sheet->setCellValue('A'.$i, lang('production') );
    $sheet->setCellValue('B'.$i, lang('client_name'));
    $sheet->setCellValue('C'.$i, lang('email'));
    $sheet->setCellValue('D'.$i, lang('supplier'));
    $sheet->setCellValue('E'.$i, lang('created_date'));
    $sheet->setCellValue('F'.$i, lang('status'));
    $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':F'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('919191');

    foreach ($dclst as $row)
    {
        $date = new DateTime($row['Date']);
        $week = $date->format("W");

        $i++;
        $sheet->setCellValue('A'.$i, $row['production_number']);
        $sheet->setCellValue('B'.$i, $row['client_name']);
        $sheet->setCellValue('C'.$i, $row['client_email']);
        if( $row['production_supplier'] != 0 && $row['production_supplier'] != '' && $row['production_supplier'] != NULL )
        {
            foreach ($production_supplier_list  as $psup2)
            {
                if ($psup2['production_supplier_id'] == $row['production_supplier'])
                {
                    $sheet->setCellValue('D'.$i, $psup2['production_supplier_name']);
                }
            }
        }

        $year = substr($row['production_date_expires'], 0, 4);
        $month = substr($row['production_date_expires'], 5, 2);
        $day = substr($row['production_date_expires'], 8, 2);

        $dtp =  $day . "-" . $month . "-" . $year;

        $sheet->setCellValue('E'.$i, $dtp);

        if($row['production_status_id'] == 1)
        {
            $sheet->setCellValue('F'.$i, lang('draft'));
        }
        elseif ($row['production_status_id'] == 2)
        {
            $sheet->setCellValue('F'.$i, lang('approved_pd'));
        }
        elseif ($row['production_status_id'] == 4)
        {
            $sheet->setCellValue('F'.$i, lang('finished_pd'));            
        }
        else
        {
            $sheet->setCellValue('F'.$i, lang('canceled'));
        }
    }

    // Auto size columns for each worksheet
    $nCols = 5; //set the number of columns

        foreach (range('A','F') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }

    $writer = new Xlsx($spreadsheet);
    $pth = __FILE__;
    $pth = str_replace('/home/drinksfr/backoffice.rbdrinks.fr/application/modules/reports/views', './uploads', $pth);
    $pth = str_replace('.php', '.xlsx', $pth);
    $writer->save($pth);

    //echo 'AFTER SUBMIT WITH VALUES';
}
else
{
    unset($dclst);
    //echo 'AFTER SUBMIT ANYWAY NO DATE';
}
?>

<div id="headerbar">
    <h1><?php echo lang('production_by_supplier'); ?></h1>
</div>

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <!-- <form method="post" action="<?php echo site_url($this->uri->uri_string()); ?>"> -->
            <form action="production_by_supplier" method="post">

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="from_date">
                            <?php echo lang('from_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="from_date" id="from_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['from_date']))
                                {
                                    echo "value=".$_POST['from_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="to_date">
                            <?php echo lang('to_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="to_date" id="to_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['to_date']))
                                {
                                    echo "value=".$_POST['to_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="production_status_id">Statut</label>

                        <select name="production_status_id" id="production_status_id" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <option value="1"><?php echo lang('draft'); ?></option>
                            <option value="2"><?php echo lang('approved_pd'); ?></option>
                            <option value="4"><?php echo lang('finished_pd'); ?></option>
                            <option value="5"><?php echo lang('canceled'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="transport_transporter_lbl" >
                            <?php echo lang('service_provider'); ?>
                        </label>

                        <select name="production_supplier" id="production_supplier" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <?php foreach ($production_supplier_list  as $psup) {?>

                                <option value="<?php echo $psup['production_supplier_id']; ?>"
                                        <?php if ($psup['production_supplier_id'] == $quote->production_supplier) { ?>selected="selected"<?php } ?>><?php echo $psup['production_supplier_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="sku_lbl" >
                            <?php echo lang('product_sku') . "(;)"; ?>
                        </label>

                        <input name="production_sku" id="production_sku" class="form-control input-sm">

                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="submit" class="btn btn-success" name="btn_submit" style="margin-top: 22px;"
                               value="<?php echo lang('run_report'); ?>">
                        <!-- <a href="production_by_supplier.xlsx">Lalala<img src="excel.png"></a> -->
                        <?php
                        if( isset($dclst) )
                        { ?>
                            <a href="/uploads/production_by_supplier.xlsx"
                               style="display: inline-block;
                            color: #fff;
                            background-color: #5cb85c;
                            border-color: #4cae4c;
                            margin-bottom: 0;
                            margin-top: 22px;
                            font-weight: normal;
                            text-align: center;
                            vertical-align: middle;
                            touch-action: manipulation;
                            cursor: pointer;
                            background-image: none;
                            border: 1px solid transparent;
                            white-space: nowrap;
                            padding: 6px 12px;
                            font-size: 14px;
                            line-height: 1.428571429;
                            border-radius: 4px;"
                            >
                                <?php echo lang('download'); ?><i class="fas fa-file-excel"></i>
                            </a>
                        <?php } ?>
                    </div>
                </div>

            </form>

            <div>
                <?php
                if( isset($dclst) )
                {
                    ?>
                    <br />
                    <table class="table table-striped">
                        <thead>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('production'); ?></th>
                            <th><?php echo lang('client_name'); ?></th>
                            <th><?php echo lang('email'); ?></th>
                            <th><?php echo lang('supplier'); ?></th>
                            <th><?php echo lang('created_date'); ?></th>
                            <th><?php echo lang('status'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach($dclst as $dcl)
                        {
                            echo '<tr><td>'; ?>
                            <a href="<?php echo site_url('production/view/' . $dcl['production_id']); ?>"
                               title="<?php echo lang('edit'); ?>">
                                <?php echo $dcl['production_number']; ?>
                            </a>
                            <?php
                            echo '</td><td>'.$dcl['client_name'].'</td>';
                            echo '<td>'.$dcl['client_email'].'</td>';
                            if($dcl['production_supplier'] != 0 && $dcl['production_supplier'] != '' && $dcl['production_supplier'] != NULL)
                            {
                                foreach ($production_supplier_list  as $psup2)
                                {
                                    if ($psup2['production_supplier_id'] == $dcl['production_supplier'])
                                    {
                                        echo '<td>'.$psup2['production_supplier_name'].'</td>';
                                    }
                                }
                            }
                            else
                            {
                                echo '<td></td>';
                            }
                            echo '<td>';

                            $year = substr($dcl['production_date_expires'], 0, 4);
                            $month = substr($dcl['production_date_expires'], 5, 2);
                            $day = substr($dcl['production_date_expires'], 8, 2);

                            echo $day . "-" . $month . "-" . $year;

                            echo '</td>';

                            if($dcl['production_status_id'] == 1)
                            {
                                echo '<td>'.lang('draft').'</td>';
                            }
                            elseif ($dcl['production_status_id'] == 2)
                            {
                                echo '<td>'.lang('approved_pd').'</td>';
                            }
                            elseif ($dcl['production_status_id'] == 4)
                            {
                                echo '<td>'.lang('finished_pd').'</td>';     
                            }
                            else
                            {
                                echo '<td>'.lang('canceled').'</td>';
                            }

                            echo '</tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                    <?php
                }
                else
                {

                }
                ?>
            </div>

        </div>
    </div>
</div>