<?php
require_once('/home/drinksfr/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if( !empty( $_POST['from_date'] ) || !empty( $_POST['to_date'] ) )
{
    $frm = date("Y-m-d", strtotime($_POST['from_date']));
    $to = date("Y-m-d", strtotime($_POST['to_date']));

    //echo $frm;
    //echo $to;

    if($_POST['invoice_status_id'] != NULL && $_POST['invoice_status_id'] != 0 && $_POST['invoice_status_id'] != '')
    {
        $qry.= " AND i.invoice_status_id = " . $_POST['invoice_status_id'];
    }

    if( $this->session->userdata('user_id') == 1 || $this->session->userdata('user_id') == 3 )
    {
        $dclst = $this->db->query("SELECT i.invoice_number AS Facture, ia.invoice_item_subtotal NetHT, i.invoice_date_created AS Date, c.client_name AS Societe, c.client_name_p1 AS NomPrenom, c.client_phone AS Telephone, c.client_email AS Email, c.client_city AS Ville, c.client_zip AS CodePostal, c.client_country AS Pays, i.invoice_status_id
                                FROM ip_invoices i
                                JOIN ip_invoice_amounts ia ON i.invoice_id = ia.invoice_id
                                JOIN ip_clients c ON i.client_id = c.client_id
                                WHERE (invoice_date_created >= '".$frm."' AND invoice_date_created <= '".$to."')
                                AND i.invoice_number like 'F%'
                                ".$qry."
                                ORDER BY i.invoice_date_created ASC, i.invoice_number ASC ")->result_array();
    }
    else
    {
        $dclst = $this->db->query("SELECT i.invoice_number AS Facture, ia.invoice_item_subtotal NetHT, i.invoice_date_created AS Date, c.client_name AS Societe, c.client_name_p1 AS NomPrenom, c.client_phone AS Telephone, c.client_email AS Email, c.client_city AS Ville, c.client_zip AS CodePostal, c.client_country AS Pays, i.invoice_status_id
                                FROM ip_invoices i
                                JOIN ip_invoice_amounts ia ON i.invoice_id = ia.invoice_id
                                JOIN ip_clients c ON i.client_id = c.client_id
                                WHERE (invoice_date_created >= '".$frm."' AND invoice_date_created <= '".$to."')
                                -- AND c.client_commercial = ".$this->session->userdata('user_id')."
                                AND c.client_commercial = ".$this->session->userdata('user_id')."
                                AND i.invoice_number like 'F%'
                                ".$qry."
                                ORDER BY i.invoice_date_created ASC, i.invoice_number ASC ")->result_array();
    }

    //print_r($dclst);
    //print $_SERVER['DOCUMENT_ROOT'];
    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

    $sheet = $spreadsheet->getActiveSheet(); 

    $spreadsheet->getProperties()->setCreator('Bruno Martins')->setLastModifiedBy('Bruno Martins')->setTitle('Facture Par Date')->setSubject('Facture Par Date')->setDescription('Facture Par Date')->setKeywords('Facture Date Backoffice')->setCategory('Statistics');

    $i=0;
    // Add headers
    $spreadsheet->setActiveSheetIndex(0);
    $spreadsheet->getActiveSheet()->setTitle('FACTURES');

    $prvCstmr = '';
    $startCell = '';
    $endCell = '';
    $weekp = 0;

    $styleArray = [
        'alignment' => [
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        ],
    ];

    foreach ($dclst as $row)
    {
        $date = new DateTime($row['Date']);
        $week = $date->format("W");

        if($weekp != $week)
        {
            $weekp = $week;
            $i++;

            $monthNum  = $date->format("m");
            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F'); // March

            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':L'.$i)
                ->getFont()
                ->setBold(true);

            $sheet->setCellValue('A'.$i, lang('month_'.$monthNum).' - '.lang('week_of').' '. $date->format('j') );

            $spreadsheet->getActiveSheet()->mergeCells('A'.$i.':L'.$i);
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':L'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('919191');
            $spreadsheet->getActiveSheet()->getStyle('A'.$i.':L'.$i)->getAlignment()->setHorizontal('center');
            $spreadsheet->getActiveSheet()->getStyle('A'.$i.':L'.$i)->getAlignment()->setVertical('center');
            $i++;
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':G'.$i)
                ->getFont()
                ->setBold(true);
            $sheet->setCellValue('A'.$i, lang('invoice') );
            $sheet->setCellValue('B'.$i, lang('subtotal_net_ht'));
            $sheet->setCellValue('C'.$i, lang('created_date'));
            $sheet->setCellValue('D'.$i, lang('client_name'));
            $sheet->setCellValue('E'.$i, lang('client_name_p1'));
            $sheet->setCellValue('F'.$i, lang('phone'));
            $sheet->setCellValue('G'.$i, lang('email'));
            $sheet->setCellValue('H'.$i, lang('city'));
            $sheet->setCellValue('I'.$i, lang('zip_code'));
            $sheet->setCellValue('J'.$i, lang('country'));
            $sheet->setCellValue('K'.$i, lang('status'));
            $sheet->setCellValue('L'.$i, lang('notes'));
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':L'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('ededed');

            $prvCstmr = '';
        }

        $i++;
        if($row['Email'] == $prvCstmr)
        {
            $endCell = $i;
            $sheet->setCellValue('A'.$i, $row['Facture']);
            $sheet->setCellValue('B'.$i, $row['NetHT'].' €');

            $year = substr($row['Date'], 0, 4);
            $month = substr($row['Date'], 5, 2);
            $day = substr($row['Date'], 8, 2);

            $sheet->setCellValue('C'.$i, $day . "-" . $month . "-" . $year);
        }
        else
        {
            if($startCell != $endCell)
            {
                $spreadsheet->getActiveSheet()->mergeCells('D'.$startCell.':D'.$endCell);
                $spreadsheet->getActiveSheet()->mergeCells('E'.$startCell.':E'.$endCell);
                $spreadsheet->getActiveSheet()->mergeCells('F'.$startCell.':F'.$endCell);
                $spreadsheet->getActiveSheet()->mergeCells('G'.$startCell.':G'.$endCell);
                $spreadsheet->getActiveSheet()->mergeCells('H'.$startCell.':H'.$endCell);
                $spreadsheet->getActiveSheet()->mergeCells('I'.$startCell.':I'.$endCell);
                $spreadsheet->getActiveSheet()->mergeCells('J'.$startCell.':J'.$endCell);
                if($row['invoice_status_id'] == 1)
                {
                    $sheet->setCellValue('K'.$i, lang('draft'));
                }
                elseif ($row['invoice_status_id'] == 2)
                {
                    $sheet->setCellValue('K'.$i, lang('sent_invoice'));
                }
                elseif ($row['invoice_status_id'] == 4)
                {
                    $sheet->setCellValue('K'.$i, lang('paid'));
                }
                else
                {
                    $sheet->setCellValue('K'.$i, lang('canceled'));
                }
                $spreadsheet->getActiveSheet()->getStyle('B'.$startCell.':J'.$endCell)->getAlignment()->setHorizontal('left');
                $spreadsheet->getActiveSheet()->getStyle('B'.$startCell.':J'.$endCell)->getAlignment()->setVertical('center');
                

            }
            $startCell = $i;
            $endCell = $i;
            $prvCstmr = $row['Email'];

            $sheet->setCellValue('A'.$i, $row['Facture']);
            $sheet->setCellValue('B'.$i, $row['NetHT'].' €');
            $year = substr($row['Date'], 0, 4);
            $month = substr($row['Date'], 5, 2);
            $day = substr($row['Date'], 8, 2);

            $sheet->setCellValue('C'.$i, $day . "-" . $month . "-" . $year);
            $sheet->setCellValue('D'.$i, $row['Societe']);
            $sheet->setCellValue('E'.$i, $row['NomPrenom']);
            $sheet->setCellValue('F'.$i, $row['Telephone']);
            $sheet->setCellValue('G'.$i, $row['Email']);
            $sheet->setCellValue('H'.$i, $row['Ville']);
            $sheet->setCellValue('I'.$i, $row['CodePostal']);
            $sheet->setCellValue('J'.$i, $row['Pays']);
            if($row['invoice_status_id'] == 1)
            {
                $sheet->setCellValue('K'.$i, lang('draft'));
            }
            elseif ($row['invoice_status_id'] == 2)
            {
                $sheet->setCellValue('K'.$i, lang('approved_pd'));
            }
            elseif ($row['invoice_status_id'] == 4)
            {
                $sheet->setCellValue('K'.$i, lang('finished_pd'));            
            }
            else
            {
                $sheet->setCellValue('K'.$i, lang('canceled'));
            }
        }
    }

    // Auto size columns for each worksheet
    foreach (range('A','L') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);
    $pth = __FILE__;
    $pth = str_replace('/home/drinksfr/backoffice.rbdrinks.fr/application/modules/reports/views', './uploads', $pth);
    $pth = str_replace('.php', '.xlsx', $pth);
    $writer->save($pth);

    //echo 'AFTER SUBMIT WITH VALUES';
}
else
{
    unset($dclst);
    //echo 'AFTER SUBMIT ANYWAY NO DATE';
}
?>

<div id="headerbar">
    <h1><?php echo lang('invoices_by_date_commercial'); ?></h1>
</div>

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <!-- <form method="post" action="<?php echo site_url($this->uri->uri_string()); ?>"> -->
            <form action="invoices_by_date_commercial" method="post">

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="from_date">
                            <?php echo lang('from_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="from_date" id="from_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['from_date']))
                                {
                                    echo "value=".$_POST['from_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="to_date">
                            <?php echo lang('to_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="to_date" id="to_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['to_date']))
                                {
                                    echo "value=".$_POST['to_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="invoice_status_id">Statut</label>

                        <select name="invoice_status_id" id="invoice_status_id" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <option value="1"><?php echo lang('draft'); ?></option>
                            <option value="2"><?php echo lang('sent_invoice'); ?></option>
                            <option value="4"><?php echo lang('paid'); ?></option>
                            <option value="6"><?php echo lang('canceled'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="submit" class="btn btn-success" name="btn_submit" style="margin-top: 22px;"
                               value="<?php echo lang('run_report'); ?>">
                        <!-- <a href="client_recall.xlsx">Lalala<img src="excel.png"></a> -->
                        <?php 
                        if( isset($dclst) )
                        { ?>
                            <a href="/uploads/invoices_by_date_commercial.xlsx"
                               style="display: inline-block;
                            color: #fff;
                            background-color: #5cb85c;
                            border-color: #4cae4c;
                            margin-bottom: 0;
                            margin-top: 22px;
                            font-weight: normal;
                            text-align: center;
                            vertical-align: middle;
                            touch-action: manipulation;
                            cursor: pointer;
                            background-image: none;
                            border: 1px solid transparent;
                            white-space: nowrap;
                            padding: 6px 12px;
                            font-size: 14px;
                            line-height: 1.428571429;
                            border-radius: 4px;"
                            >
                                <?php echo lang('download'); ?><i class="fas fa-file-excel"></i>
                            </a>
                        <?php } ?>
                    </div>
                </div>

            </form>

            <div>
                <?php
                if( isset($dclst) )
                {
                    ?>
                    <br />
                    <table class="table table-striped">
                        <thead>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('invoice'); ?></th>
                            <th><?php echo lang('subtotal_net_ht'); ?></th>
                            <th><?php echo lang('created_date'); ?></th>
                            <th><?php echo lang('client_name'); ?></th>
                            <th><?php echo lang('client_name_p1'); ?></th>
                            <th><?php echo lang('phone'); ?></th>
                            <th><?php echo lang('email'); ?></th>
                            <th><?php echo lang('city'); ?></th>
                            <th><?php echo lang('zip_code'); ?></th>
                            <th><?php echo lang('country'); ?></th>
                            <th><?php echo 'Manque'; ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach($dclst as $dcl)
                        {
                            echo '<tr>';
                            echo '<td>'.$dcl['Facture'].'</td>';
                            echo '<td>'.$dcl['NetHT'].' €</td>';
                            echo '<td>';

                            $year = substr($dcl['Date'], 0, 4);
                            $month = substr($dcl['Date'], 5, 2);
                            $day = substr($dcl['Date'], 8, 2);

                            echo $day . "-" . $month . "-" . $year;

                            echo '</td>';
                            //echo '<td>'.$dcl['Date'].'</td>';
                            echo '<td>'.$dcl['Societe'].'</td>';
                            echo '<td>'.$dcl['NomPrenom'].'</td>';
                            echo '<td>'.$dcl['Telephone'].'</td>';
                            echo '<td>'.$dcl['Email'].'</td>';
                            echo '<td>'.$dcl['Ville'].'</td>';
                            echo '<td>'.$dcl['CodePostal'].'</td>';
                            echo '<td>'.$dcl['Pays'].'</td>';

                            if($dcl['invoice_status_id'] == 1)
                            {
                                echo '<td>'.lang('draft').'</td>';
                            }
                            elseif ($dcl['invoice_status_id'] == 2)
                            {
                                echo '<td>'.lang('sent_invoice').'</td>';
                            }
                            elseif ($dcl['invoice_status_id'] == 4)
                            {
                                echo '<td>'.lang('paid').'</td>';     
                            }
                            else
                            {
                                echo '<td>'.lang('canceled').'</td>';
                            }

                            echo '</tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                    <?php
                }
                else
                {

                }
                ?>
            </div>

        </div>
    </div>
</div>