<?php
require_once('/home/drinksfr/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if( !empty( $_POST['from_date'] ) || !empty( $_POST['to_date'] ) )
{
    $frm = date("Y-m-d", strtotime($_POST['from_date']));
    $to = date("Y-m-d", strtotime($_POST['to_date']));

    //echo $frm;
    //echo $to;
    //echo $_POST['approved'];
    if($_POST['approved'] == 'on')
    {
        $aprvd = 1;
    }
    else
    {
        $aprvd = 0;
    }
    //echo $aprvd;

    if($_POST['paid_id'] == 0) //TODOS
    {
        $qry = "SELECT q.quote_number AS Devis, c.client_name AS Societe, c.client_email AS Email, c.client_phone AS Phone, qa.quote_item_subtotal NetHT, q.quote_date_created AS Date
                                FROM ip_quotes q
                                JOIN ip_quote_amounts qa ON q.quote_id = qa.quote_id
                                JOIN ip_clients c ON q.client_id = c.client_id
                                WHERE (quote_date_created >= '".$frm."' AND quote_date_created <= '".$to."')
                                AND ( c.client_commercial = ".$this->session->userdata('user_id')." OR q.user_id = ".$this->session->userdata('user_id').")";

        if($aprvd != NULL && $aprvd != 0 && $aprvd != '' && $aprvd != 'off')
        {
            $qry.= " AND q.quote_status_id = 4";
        }

        $qry.= " ORDER BY q.quote_number ASC";
    }
    elseif($_POST['paid_id'] == 1) //NAO FACTURADOS
    {
        $qry = "SELECT q.quote_number AS Devis, c.client_name AS Societe, c.client_email AS Email, c.client_phone AS Phone, qa.quote_item_subtotal NetHT, q.quote_date_created AS Date
                                FROM ip_quotes q
                                JOIN ip_quote_amounts qa ON q.quote_id = qa.quote_id
                                JOIN ip_clients c ON q.client_id = c.client_id
                                WHERE (quote_date_created >= '".$frm."' AND quote_date_created <= '".$to."')
                                AND ( c.client_commercial = ".$this->session->userdata('user_id')." OR q.user_id = ".$this->session->userdata('user_id').")
                                AND c.client_id NOT IN (
                                                        SELECT client_id 
                                                        FROM ip_invoices 
                                                        WHERE invoice_date_created >= '".$frm."' AND invoice_date_created <= '".$to."' 
                                                       )";

        if($aprvd != NULL && $aprvd != 0 && $aprvd != '' && $aprvd != 'off')
        {
            $qry.= " AND q.quote_status_id = 4";
        }

        $qry.= " ORDER BY q.quote_number ASC";
    }
    else //FACTURADOS
    {
        $qry = "SELECT q.quote_number AS Devis, c.client_name AS Societe, c.client_email AS Email, c.client_phone AS Phone, qa.quote_item_subtotal NetHT, q.quote_date_created AS Date
                                FROM ip_quotes q
                                JOIN ip_quote_amounts qa ON q.quote_id = qa.quote_id
                                JOIN ip_clients c ON q.client_id = c.client_id
                                WHERE (quote_date_created >= '".$frm."' AND quote_date_created <= '".$to."') 
                                AND ( c.client_commercial = ".$this->session->userdata('user_id')." OR q.user_id = ".$this->session->userdata('user_id').")
                                AND c.client_id IN (
                                                        SELECT client_id 
                                                        FROM ip_invoices 
                                                        WHERE invoice_date_created >= '".$frm."' AND invoice_date_created <= '".$to."' 
                                                       )";

        if($aprvd != NULL && $aprvd != 0 && $aprvd != '' && $aprvd != 'off')
        {
            $qry.= " AND q.quote_status_id = 4";
        }

        $qry.= " ORDER BY q.quote_number ASC";
    }

    //print $qry;
    $dclst = $this->db->query($qry)->result_array();

    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

    $sheet = $spreadsheet->getActiveSheet(); 

    $spreadsheet->getProperties()->setCreator('Bruno Martins')->setLastModifiedBy('Bruno Martins')->setTitle('Devis Par Date')->setSubject('Devis Par Date')->setDescription('Devis Par Date')->setKeywords('Devis Date Backoffice')->setCategory('Statistics');

    $i=0;
    // Add headers
    $spreadsheet->setActiveSheetIndex(0);
    $spreadsheet->getActiveSheet()->setTitle('DEVIS');

    $prvCstmr = '';
    $startCell = '';
    $endCell = '';
    $weekp = 0;

    $styleArray = [
        'alignment' => [
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        ],
    ];

    foreach ($dclst as $row)
    {
        $date = new DateTime($row['Date']);
        $week = $date->format("W");

        if($weekp != $week)
        {
            $weekp = $week;
            $i++;

            $monthNum  = $date->format("m");
            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F'); // March

            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':G'.$i)
                ->getFont()
                ->setBold(true);

            $sheet->setCellValue('A'.$i, lang('month_'.$monthNum).' - '.lang('week_of').' '. $date->format('j') );

            $spreadsheet->getActiveSheet()->mergeCells('A'.$i.':G'.$i);
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':G'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('919191');
            $spreadsheet->getActiveSheet()->getStyle('A'.$i.':G'.$i)->getAlignment()->setHorizontal('center');
            $spreadsheet->getActiveSheet()->getStyle('A'.$i.':G'.$i)->getAlignment()->setVertical('center');
            $i++;
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':G'.$i)
                ->getFont()
                ->setBold(true);
            $sheet->setCellValue('A'.$i, lang('quote') );
            $sheet->setCellValue('B'.$i, lang('client_name'));
            $sheet->setCellValue('C'.$i, lang('email'));
            $sheet->setCellValue('D'.$i, lang('subtotal_net_ht'));
            $sheet->setCellValue('E'.$i, lang('created_date'));
            $sheet->setCellValue('F'.$i, lang('notes'));
            $sheet->setCellValue('G'.$i, lang('phone'));
            $spreadsheet
                ->getActiveSheet()
                ->getStyle('A'.$i.':G'.$i)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('ededed');

            $prvCstmr = '';
        }

        $i++;
        if($row['Email'] == $prvCstmr)
        {
            $endCell = $i;
            $sheet->setCellValue('A'.$i, $row['Devis']);
            $sheet->setCellValue('D'.$i, $row['NetHT'].' €');

            $yearE = substr($row['Date'], 0, 4);
            $monthE = substr($row['Date'], 5, 2);
            $dayE = substr($row['Date'], 8, 2);

            $dateE = $dayE . "-" . $monthE . "-" . $yearE;

            $sheet->setCellValue('E'.$i, $dateE);
        }
        else
        {
            if($startCell != $endCell)
            {
                $spreadsheet->getActiveSheet()->mergeCells('B'.$startCell.':B'.$endCell);
                $spreadsheet->getActiveSheet()->getStyle('B'.$startCell.':B'.$endCell)->getAlignment()->setHorizontal('left');
                $spreadsheet->getActiveSheet()->getStyle('B'.$startCell.':B'.$endCell)->getAlignment()->setVertical('center');

                $spreadsheet->getActiveSheet()->mergeCells('C'.$startCell.':C'.$endCell);
                $spreadsheet->getActiveSheet()->getStyle('C'.$startCell.':C'.$endCell)->getAlignment()->setHorizontal('left');
                $spreadsheet->getActiveSheet()->getStyle('C'.$startCell.':C'.$endCell)->getAlignment()->setVertical('center');

                $spreadsheet->getActiveSheet()->mergeCells('G'.$startCell.':G'.$endCell);
                $spreadsheet->getActiveSheet()->getStyle('G'.$startCell.':G'.$endCell)->getAlignment()->setHorizontal('left');
                $spreadsheet->getActiveSheet()->getStyle('G'.$startCell.':G'.$endCell)->getAlignment()->setVertical('center');
            }
            $startCell = $i;
            $endCell = $i;
            $prvCstmr = $row['Email'];

            $sheet->setCellValue('A'.$i, $row['Devis']);
            $sheet->setCellValue('B'.$i, $row['Societe']);
            $sheet->setCellValue('C'.$i, $row['Email']);
            $sheet->setCellValue('D'.$i, $row['NetHT'].' €');
            $sheet->setCellValue('G'.$i, $row['Phone']);

            $yearE = substr($row['Date'], 0, 4);
            $monthE = substr($row['Date'], 5, 2);
            $dayE = substr($row['Date'], 8, 2);

            $dateE = $dayE . "-" . $monthE . "-" . $yearE;

            $sheet->setCellValue('E'.$i, $dateE);
        }

        // Auto size columns for each worksheet
        $nCols = 5; //set the number of columns

        foreach (range('A','G') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
    }

    $writer = new Xlsx($spreadsheet);
    $pth = __FILE__;
    $pth = str_replace('/home/drinksfr/backoffice.rbdrinks.fr/application/modules/reports/views', './uploads', $pth);
    $pth = str_replace('.php', '.xlsx', $pth);
    $writer->save($pth);

    //echo 'AFTER SUBMIT WITH VALUES';
}
else
{
    unset($dclst);
    //echo 'AFTER SUBMIT ANYWAY NO DATE';
}
?>

<div id="headerbar">
    <h1><?php echo lang('quotes_by_date_commercial'); ?></h1>
</div>

<div id="content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div id="report_options" class="panel panel-default">

        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-file-pdf-o fa-margin"></i>
                <?php echo lang('report_options'); ?>
            </h3>
        </div>

        <div class="panel-body">

            <form action="client_recall" method="post">

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="from_date">
                            <?php echo lang('from_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="from_date" id="from_date"
                                   class="form-control datepicker" autocomplete="off"
                                    <?php
                                    if(isset($_POST['from_date']))
                                    {
                                        echo "value=".$_POST['from_date'];
                                    }
                                    ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="to_date">
                            <?php echo lang('to_date_report'); ?>
                        </label>

                        <div class="input-group">
                            <input name="to_date" id="to_date"
                                   class="form-control datepicker" autocomplete="off"
                                <?php
                                if(isset($_POST['to_date']))
                                {
                                    echo "value=".$_POST['to_date'];
                                }
                                ?>
                            >
                            <span class="input-group-addon">
                                    <i class="fa fa-calendar fa-fw"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-2">
                    <div class="form-group has-feedback">
                        <label for="paid_id"><?php echo lang('invoiced'); ?></label>

                        <select name="paid_id" id="paid_id" class="form-control input-sm">
                            <option value="0"><?php echo lang('all'); ?></option>
                            <option value="1" <?php if ($_POST['paid_id'] == 1) { ?>selected="selected"<?php } ?> > <?php echo 'Non '.lang('invoiced'); ?></option>
                            <option value="2" <?php if ($_POST['paid_id'] == 2) { ?>selected="selected"<?php } ?> > <?php echo lang('invoiced'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="checkbox"
                               style="margin-top: 30px;"
                               name="approved" <?php if($_POST['approved'] == 'on') echo "checked";?> ><?php echo lang('approved_2'); ?><br>

                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group has-feedback">
                        <input type="submit" class="btn btn-success" name="btn_submit" style="margin-top: 22px;"
                               value="<?php echo lang('run_report'); ?>">
                        <!-- <a href="client_recall.xlsx">Lalala<img src="excel.png"></a> -->
                        <?php
                        if( isset($dclst) )
                        { ?>
                        <a href="/uploads/client_recall.xlsx"
                           style="display: inline-block;
                            color: #fff;
                            background-color: #5cb85c;
                            border-color: #4cae4c;
                            margin-bottom: 0;
                            margin-top: 22px;
                            font-weight: normal;
                            text-align: center;
                            vertical-align: middle;
                            touch-action: manipulation;
                            cursor: pointer;
                            background-image: none;
                            border: 1px solid transparent;
                            white-space: nowrap;
                            padding: 6px 12px;
                            font-size: 14px;
                            line-height: 1.428571429;
                            border-radius: 4px;"
                        >
                            <?php echo lang('download'); ?><i class="fas fa-file-excel"></i>
                        </a>
                        <?php } ?>
                    </div>
                </div>

            </form>

            <div>
                <?php
                    if( isset($dclst) )
                    {
                        ?>
                        <br />
                        <table class="table table-striped">
                            <thead>
                            <tr style="background-color: #ededed;">
                                <th><?php echo lang('quote'); ?></th>
                                <th><?php echo lang('client_name'); ?></th>
                                <th><?php echo lang('email'); ?></th>
                                <th><?php echo lang('subtotal_net_ht'); ?></th>
                                <th><?php echo lang('created_date'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach($dclst as $dcl)
                                {
                                    echo '<tr>';
                                    echo '<td>'.$dcl['Devis'].'</td>';
                                    echo '<td>'.$dcl['Societe'].'</td>';
                                    echo '<td>'.$dcl['Email'].'</td>';
                                    echo '<td>'.$dcl['NetHT'].' €</td>';
                                    echo '<td>';

                                    $year = substr($dcl['Date'], 0, 4);
                                    $month = substr($dcl['Date'], 5, 2);
                                    $day = substr($dcl['Date'], 8, 2);

                                    echo $day . "-" . $month . "-" . $year;

                                    echo '</td>';
                                    echo '</tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                        <?php
                    }
                    else
                    {

                    }
                ?>
            </div>

        </div>
    </div>
</div>