<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Reports extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_reports');
    }

    public function sales_by_client()
    {
        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->sales_by_client($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/sales_by_client', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('sales_by_client'), TRUE);
        }

        $this->layout->buffer('content', 'reports/sales_by_client_index')->render();
    }

    public function payment_history()
    {
        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->payment_history($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/payment_history', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('payment_history'), TRUE);
        }

        $this->layout->buffer('content', 'reports/payment_history_index')->render();
    }

    public function invoice_aging()
    {
        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->invoice_aging()
            );

            $html = $this->load->view('reports/invoice_aging', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('invoice_aging'), TRUE);
        }

        $this->layout->buffer('content', 'reports/invoice_aging_index')->render();
    }

    public function sales_by_year()
    {

        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->sales_by_year($this->input->post('from_date'), $this->input->post('to_date'), $this->input->post('minQuantity'), $this->input->post('maxQuantity'), $this->input->post('checkboxTax'))
            );

            $html = $this->load->view('reports/sales_by_year', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('sales_by_date'), TRUE);
        }

        $this->layout->buffer('content', 'reports/sales_by_year_index')->render();
    }

    public function quotes_by_year_commercial()
    {

        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->sales_by_year($this->input->post('from_date'), $this->input->post('to_date'), $this->input->post('minQuantity'), $this->input->post('maxQuantity'), $this->input->post('checkboxTax'))
            );

            $html = $this->load->view('reports/sales_by_year', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('sales_by_date'), TRUE);
        }

        $this->layout->buffer('content', 'reports/quotes_by_year_commercial_index')->render();
    }

    public function client_recall($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/client_recall')->render();
    }

    public function invoices_by_date_commercial($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/invoices_by_date_commercial')->render();
    }

    public function production_by_supplier($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/production_by_supplier')->render();
    }

    public function supplier_report($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/supplier_report')->render();
    }

    public function stock_movement($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/stock_movement')->render();
    }

    public function type_movement($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/type_movement')->render();
    }

    public function credit_note_list($page = 0)
    {
        if ($this->input->post('btn_submit')) {
            /*$data = array(
                'results' => $this->mdl_reports->quotes_by_year_commercial($this->input->post('from_date'), $this->input->post('to_date'))
            );

            $html = $this->load->view('reports/client_recall', $data, TRUE);

            $this->load->helper('mpdf');

            pdf_create($html, lang('client_recall'), TRUE);*/
        }

        $this->layout->buffer('content', 'reports/credit_note_list')->render();
    }

    public function invoice_by_country($page = 0)
    {
        $this->layout->buffer('content', 'reports/invoice_by_country')->render();
    }

    public function transport_list($page = 0)
    {
        $this->layout->buffer('content', 'reports/transport_list')->render();
    }
    
    public function monthly_resume($page = 0)
    {
        $this->layout->buffer('content', 'reports/monthly_resume')->render();
    }

    public function stock_check($page = 0)
    {
        $this->layout->buffer('content', 'reports/stock_check')->render();
    }

    public function customization_list($page = 0)
    {
        $this->layout->buffer('content', 'reports/customization_list')->render();
    }

    public function send_invoices($page = 0)
    {
        $this->layout->buffer('content', 'reports/send_invoices')->render();
    }

    public function daily_orders_out($page = 0)
    {
        $this->layout->buffer('content', 'reports/daily_orders_out')->render();
    }
}
