<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Mdl_Quote_Items extends Response_Model
{
    public $table = 'ip_purchase_order_items';
    public $primary_key = 'ip_purchase_order_items.item_id';
    public $date_created_field = 'item_date_added';

    public function default_select()
    {
        $this->db->select('ip_purchase_order_item_amounts.*, ip_purchase_order_items.*, item_tax_rates.tax_rate_percent AS item_tax_rate_percent, ip_products.product_sku AS product_sku');
    }

    public function default_order_by()
    {
        $this->db->order_by('ip_purchase_order_items.item_order');
    }

    public function default_join()
    {
        $this->db->join('ip_purchase_order_item_amounts', 'ip_purchase_order_item_amounts.item_id = ip_purchase_order_items.item_id', 'left');
        $this->db->join('ip_tax_rates AS item_tax_rates', 'item_tax_rates.tax_rate_id = ip_purchase_order_items.item_tax_rate_id', 'left');
        $this->db->join('ip_products AS ip_products', 'ip_products.product_sku = ip_purchase_order_items.item_description', 'left');
        //$this->db->join('ip_products AS ip_products', 'ip_products.product_name = ip_purchase_order_items.item_name', 'left');
    }

    public function validation_rules()
    {
        return array(
            'purchase_order_id' => array(
                'field' => 'purchase_order_id',
                'label' => lang('production'),
                'rules' => 'required'
            ),
            'item_name' => array(
                'field' => 'item_name',
                'label' => lang('item_name'),
                'rules' => 'required'
            ),
            'item_description' => array(
                'field' => 'item_description',
                'label' => lang('description')
            ),
            'item_quantity' => array(
                'field' => 'item_quantity',
                'label' => lang('quantity'),
                'rules' => 'required'
            ),
            'item_price' => array(
                'field' => 'item_price',
                'label' => lang('price'),
                'rules' => 'required'
            ),
            'item_tax_rate_id' => array(
                'field' => 'item_tax_rate_id',
                'label' => lang('item_tax_rate')
            )
        );
    }

    public function save($quote_id, $id = NULL, $db_array = NULL)
    {
        $isnew = 0;
        if($id == NULL || $id == '')
        {
            $isnew = 1;
        }

        $id = parent::save($id, $db_array);

        $this->load->model('purchases/mdl_quote_item_amounts');
        $this->mdl_quote_item_amounts->calculate($id);

        $this->load->model('purchases/mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);

        //INSERT INTO LOG TABLE HERE IF NEW PROD
        if($isnew == 1 )
        {
            $this->db->query("INSERT INTO ip_dc_log (dc_tp, dc_id, tp_mv, prd_id, usr_id, ts) VALUES (3, ".$quote_id.", 3, ".$id.", ".$this->session->userdata('user_id').", now() )");
        }

        return $id;
    }

    public function delete($item_id)
    {
        // Get the quote id so we can recalculate quote amounts
        $this->db->select('purchase_order_id');
        $this->db->where('item_id', $item_id);
        $quote_id = $this->db->get('ip_purchase_order_items')->row()->purchase_order_id;

        // Delete the item
        parent::delete($item_id);

        // Delete the item amounts
        $this->db->where('item_id', $item_id);
        $this->db->delete('ip_purchase_order_item_amounts');

        // Recalculate quote amounts
        $this->load->model('purchases/mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);

        $this->db->query("INSERT INTO ip_dc_log (dc_tp, dc_id, tp_mv, prd_id, usr_id, ts) VALUES (3, " . $quote_id . ", 4,  " . $item_id . ", " . $this->session->userdata('user_id') . ", now() )");
    }

}
