<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 *
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 *
 */

class Purchases extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_purchases');
    }

    public function index($page = 0)
    {
        // Display all quotes by default
        /*$this->layout->buffer('content', 'purchases/index');
        $this->layout->render();*/
        redirect('purchases/status/all');
    }

    public function status($status = 'all', $page = 0)
    {
        // Determine which group of quotes to load
        switch ($status) {
            case 'draft':
                $this->mdl_purchases->is_draft();
                break;
            case 'sent':
                $this->mdl_purchases->is_sent();
                break;
            /*case 'viewed':
                $this->mdl_purchases->is_viewed();
                break;*/
            case 'approved':
                $this->mdl_purchases->is_approved();
                break;
            case 'rejected':
                $this->mdl_purchases->is_rejected();
                break;
            /*case 'canceled':
                $this->mdl_purchases->is_canceled();
                break;*/
        }

        $this->mdl_purchases->paginate(site_url('purchases/status/' . $status), $page);
        $purchases = $this->mdl_purchases->result();

        $this->layout->set(
            array(
                'purchase' => $purchases,
                'status' => $status,
                'filter_display' => TRUE,
                'filter_placeholder' => lang('filter_purchase'),
                'filter_method' => 'filter_purchase',
                'purchase_statuses' => $this->mdl_purchases->statuses()
            )
        );

        $this->layout->buffer('content', 'purchases/index');
        $this->layout->render();
    }

    public function view($quote_id)
    {
        $this->load->model('mdl_quote_items');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('mdl_quote_tax_rates');
        $this->load->model('custom_fields/mdl_custom_fields');
        $this->load->model('custom_fields/mdl_quote_custom');
        $this->load->library('encrypt');

        //$quote_custom = $this->mdl_quote_custom->where('quote_id', $quote_id)->get();
        /*$quote_custom = $this->mdl_quote_custom->where('transport_id', $quote_id)->get();

        if ($quote_custom->num_rows()) {
            $quote_custom = $quote_custom->row();

            unset($quote_custom->transport_id, $quote_custom->transport_custom_id);

            foreach ($quote_custom as $key => $val) {
                $this->mdl_purchases->set_form_value('custom[' . $key . ']', $val);
            }
        }*/

        $quote = $this->mdl_purchases->get_by_id($quote_id);

        if (!$quote) {
            show_404();
        }

        $this->layout->set(
            array(
                'purchase' => $quote,
                'items' => $this->mdl_quote_items->where('purchase_order_id', $quote_id)->get()->result(),
                'purchase_order' => $quote_id,
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
                'purchase_tax_rates' => $this->mdl_quote_tax_rates->where('purchase_order_id', $quote_id)->get()->result(),
                'custom_fields' => $this->mdl_custom_fields->by_table('ip_purchase_order_custom')->get()->result(),
                'custom_js_vars' => array(
                    'currency_symbol' => $this->mdl_settings->setting('currency_symbol'),
                    'currency_symbol_placement' => $this->mdl_settings->setting('currency_symbol_placement'),
                    'decimal_point' => $this->mdl_settings->setting('decimal_point')
                ),
                'purchase_statuses' => $this->mdl_purchases->statuses()
            )
        );

        $this->layout->buffer(
            array(
                array('modal_delete_quote', 'purchases/modal_delete_quote'),
                array('modal_add_quote_tax', 'purchases/modal_add_quote_tax'),
                array('content', 'purchases/view')
            )
        );

        $this->layout->render();
    }

    public function delete($quote_id)
    {
        // Delete the transport
        $this->mdl_purchases->delete($quote_id);

        // Redirect to transport index
        redirect('purchases/index');
    }

    public function delete_item($quote_id, $item_id)
    {
        // Delete transport item
        $this->load->model('mdl_quote_items');
        $this->mdl_quote_items->delete($item_id);

        // Redirect to transport view
        redirect('purchases/view/' . $quote_id);
    }

    public function generate_pdf($quote_id, $stream = TRUE, $purchase_template = NULL)
    {
        $this->load->helper('pdf');

        if ($this->mdl_settings->setting('mark_quotes_sent_pdf') == 1) {
            $this->mdl_purchases->mark_sent($quote_id);
        }

        //generate_quote_pdf($quote_id, $stream, $transport_template);
        generate_purchase_pdf($quote_id, $stream, $purchase_template);
    }

    public function generate_pdf_services($quote_id, $stream = TRUE, $purchase_template = NULL)
    {
        $this->load->helper('pdf');

        if ($this->mdl_settings->setting('mark_quotes_sent_pdf') == 1) {
            $this->mdl_purchases->mark_sent($quote_id);
        }

        //generate_quote_pdf($quote_id, $stream, $transport_template);
        generate_production_pdf_services($quote_id, $stream, $purchase_template);
    }

    public function delete_quote_tax($quote_id, $quote_tax_rate_id)
    {
        $this->load->model('mdl_quote_tax_rates');
        $this->mdl_quote_tax_rates->delete($quote_tax_rate_id);

        $this->load->model('mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);

        redirect('purchases/view/' . $quote_id);
    }

    public function recalculate_all_quotes()
    {
        $this->db->select('purchase_order');
        $quote_ids = $this->db->get('ip_purchase_order')->result();

        $this->load->model('mdl_quote_amounts');

        foreach ($quote_ids as $quote_id) {
            $this->mdl_quote_amounts->calculate($quote_id->purchase_order_id);
        }
    }

}
