<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('1', now() )");

        $this->load->model('purchases/mdl_quote_items');
        $this->load->model('purchases/mdl_purchases');
        $this->load->model('item_lookups/mdl_item_lookups');

        $quote_id = $this->input->post('purchase_order_id');

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('2', now() )");

        //if ($this->mdl_purchases->run_validation('validation_rules_save_purchase'))
        /*if ($this->mdl_purchases->run_validation('validation_rules_save_production'))
        {*/
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3', now() )");

            $this->db->query("INSERT INTO ip_dc_log (dc_tp, dc_id, tp_mv, usr_id, ts) VALUES (3, ".$quote_id.", 2, ".$this->session->userdata('user_id').", now() )");

            $prd_stt = $this->db->query("SELECT purchase_order_status_id FROM ip_purchase_order WHERE purchase_order_id = ".$this->input->post('purchase_order_id') )->result_array();

            $is_slash_create = substr($this->input->post('purchase_order_date_created'), 2, 1);
            if($is_slash_create == "/")
            {
                $year_create = substr($this->input->post('purchase_order_date_created'), 6, 9);
                $day_create = substr($this->input->post('purchase_order_date_created'), 0, 2);
                $month_create = substr($this->input->post('purchase_order_date_created'), 3, 2);
                $date_create = $year_create . "-" . $month_create . "-" . $day_create;
            }
            elseif($is_slash_create == "-")
            {
                $year_create = substr($this->input->post('purchase_order_date_created'), 6, 9);
                $day_create = substr($this->input->post('purchase_order_date_created'), 0, 2);
                $month_create = substr($this->input->post('purchase_order_date_created'), 3, 2);
                $day_create = substr($day_create, 0, 2);
                $date_create = $year_create."-".$month_create."-".$day_create;
            }
            else
            {
                $date_create = $this->input->post('purchase_order_date_created');
            }

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('4', now() )");

            if($date_create != "" && $date_create != NULL)
            {
                $updt_bl_dt = $this->db->query( "UPDATE ip_purchase_order SET
                            purchase_order_date_created = '".$date_create."'
                         WHERE purchase_order_id = ".$this->input->post('purchase_order_id') );
            }

            $items = json_decode($this->input->post('items'));

            // Ir ler a outro lado os produtos. Tabela de produtos de fornecedores
            $plist = $this->db->query("SELECT * FROM ip_products_suppliers WHERE inactive = 0;")->result_array();

            $error = 0;

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('5', now() )");

            foreach ($items as $item) {
                // Validar se produto existe. Se nao existir, criar o produto.
                $exists = 0;
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_name." -- ".$item->item_description."', now() )");

                foreach($plist as $pl)
                {
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('For Each outside if', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('pl sku -- ".$pl['product_sku']." ', now() )");
                    if($pl['product_sku'] == $item->item_description) {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('For Each inside if', now() )");
                        // Se existir ignorar
                        // Se existir fetch ID se nao vier com o produto. Usar ID do produto no INSERT. Ja deve estar feito mas verificar.
                        $exists = 1;
                    }
                }

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('After For Each', now() )");

                if($exists == 0)
                {
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('Exists 0', now() )");
                    // Se nao existir criar novo produto na tabela de produtos de fornecedores. Nao gerar erro. Fetch ID para o INSERT. Ja deve estar feito mas verificar.
                    //$error = 1;
                    $this->db->query("INSERT INTO ip_products_suppliers (product_sku, product_name, product_description, product_price, tax_rate_id, inactive) VALUES ('".$item->item_description."', '".$item->item_name."', '".$item->item_name."', '".$item->item_price."', 1, 0)");
                }

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('Exists ".$exists."', now() )");

                if( isset($is_slash_item_line) && $is_slash_item_line != '' & $is_slash_item_line != NULL )
                {
                    $is_slash_item_line = substr($item->item_discount_amount, 2, 1);
                    if($is_slash_item_line == "/")
                    {
                        $year_line = substr($item->item_discount_amount, 6, 9);
                        $day_line = substr($item->item_discount_amount, 0, 2);
                        $month_line = substr($item->item_discount_amount, 3, 2);
                        $item->item_discount_amount = $year_line . "-" . $month_line . "-" . $day_line;
                    }
                    elseif($is_slash_item_line == "-")
                    {
                        $year_line = substr($item->item_discount_amount, 6, 9);
                        $day_line = substr($item->item_discount_amount, 0, 2);
                        $month_line = substr($item->item_discount_amount, 3, 2);
                        $item->item_discount_amount = $year_line."-".$month_line."-".$day_line;
                    }
                    else
                    {
                        $item->item_discount_amount = $item->item_discount_amount;
                    }
                }
                else
                {
                    $item->item_discount_amount = '';
                }

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('Item Discount Amount ".$item->item_discount_amount."', now() )");
            }

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('6', now() )");

            $string = "";

            $ttl_dc = 0;

            foreach ($items as $item) {
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_id." ".$item->item_description."', now() )");
                if($item->item_id == NULL)
                {
                    unset($itm_max);
                    unset($itm_id);
                    unset($ttl_ln);

                    foreach($item as $it)
                    {
                        $string= "?? ".$string." ".$it;
                    }

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('7', now() )");

                    $string = ' ' . $string;
                    $ini = strpos($string, $quote_id);
                    $ini += strlen($quote_id)+2;
                    //$len = strpos($string, $item->item_quantity, $ini ) - $ini;
                    $len = strpos($string, $item->item_name, $ini ) - $ini;
                    $note_k = substr($string, $ini, $len);

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('8', now() )");

                    $prod_info[] = $this->db->query("SELECT product_id FROM ip_products_suppliers WHERE product_sku like '%".trim($note_k)."%' limit 1;")->result_array();

                    $pid = $prod_info[0][0]['product_id'];

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] PID1 ".$pid."', now() )");

                    if($pid == NULL || $pid == "")
                    {
                        $pid = 0;
                    }

                    $date_add = date('Y-m-d');
                    $item->item_quantity = standardize_amount($item->item_quantity);

                    if($item->item_description != "" && $item->item_description != NULL)
                    {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] PID2 ".$pid."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] purchase_order ID ".$this->input->post('purchase_order_id')."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] DATE ADD ".$date_add."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM NAME ".$item->item_name."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM DESCRIPTION ".$item->item_description."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM QTT ".$item->item_quantity."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM PRICE ".$item->item_price."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM DSC AMNT ".$item->item_discount_amount."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM TAX RATE ID ".$item->item_tax_rate_id."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM ORDER".$item->item_order."', now() )");

                        $updt_bl = $this->db->query( "INSERT INTO ip_purchase_order_items (purchase_order_id, item_tax_rate_id, item_date_added, item_name,
                                                                                  item_description, item_quantity, item_price, item_discount_amount, item_order) 
                                                  VALUES
                                                                                  (".$this->input->post('purchase_order_id').", '".$item->item_tax_rate_id."', '".$date_add."', '".$item->item_name."',
                                                                                  '".$item->item_description."', ".$item->item_quantity.", '".$item->item_price."', '".$item->item_discount_amount."', ".$item->item_order.")" );

                        $itm_max[] = $this->db->query("SELECT max(item_id) AS item_id FROM ip_purchase_order_items")->result_array();
                        $itm_id = $itm_max[0][0]['item_id'];
                        $ttl_ln = $item->item_quantity * $item->item_price;

                        $isrt_itm_amnt = $this->db->query( "INSERT INTO ip_purchase_order_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) 
                                                            VALUES
                                                          (".$itm_id.", '".$ttl_ln."', '0.00', '0.00','".$ttl_ln."')" );

                        $ttl_dc = $ttl_dc + $ttl_ln;
                    }

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('9', now() )");
                }
                else
                {
                    $itm_id = 0;
                    $ttl_ln = 0;

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('10', now() )");

                    $item->item_quantity = standardize_amount($item->item_quantity);
                    //$item->item_price = standardize_amount($item->item_price);
                    //$item->item_discount_amount = standardize_amount($item->item_discount_amount);

                    if( is_numeric($item->item_pid) )
                    {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[2] ".$item->item_pid." ".$item->item_description."', now() )");
                        $prod_info[] = $this->db->query("SELECT * FROM ip_products WHERE product_id = ".$item->item_pid." AND online = 1 AND inactive = 0 limit 1;")->result_array();
                        $item->item_description = $prod_info[0][0]['product_sku'];
                    }

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] PID2 ".$pid."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] purchase_order ID ".$this->input->post('purchase_order_id')."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] DATE ADD ".$date_add."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM NAME ".$item->item_name."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM DESCRIPTION ".$item->item_description."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM QTT ".$item->item_quantity."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM PRICE ".$item->item_price."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM DSC AMNT ".$item->item_discount_amount."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM TAX RATE ID ".$item->item_tax_rate_id."', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM ORDER".$item->item_order."', now() )");

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('11', now() )");

                    $updt_bl = $this->db->query( "UPDATE ip_purchase_order_items SET 
                            item_name = '".$item->item_name."',
                            item_description = '".$item->item_description."',
                            item_order = ".$item->item_order.",
                            item_price = '".$item->item_price."',
                            item_discount_amount = '".$item->item_discount_amount."',
                            item_tax_rate_id = '".$item->item_tax_rate_id."',
                            item_quantity = ".$item->item_quantity."
                         WHERE purchase_order_id = ".$this->input->post('purchase_order_id')."
                         AND item_id = ".$item->item_id );

                    $itm_id = $item->item_id;
                    $ttl_ln = $item->item_quantity * $item->item_price;

                    $updt_itm_amnt = $this->db->query( "UPDATE ip_purchase_order_item_amounts SET 
                                                            item_subtotal = '".$ttl_ln."',
                                                            item_total = '".$ttl_ln."'
                                                        WHERE item_id = ".$itm_id.";");

                    $ttl_dc = $ttl_dc + $ttl_ln;
                }
            }

            $updt_amnt = $this->db->query( "UPDATE ip_purchase_order_amounts SET 
                                                purchase_order_item_subtotal = '".$ttl_dc."',
                                                purchase_order_total = '".$ttl_dc."'
                                            WHERE purchase_order_id = '".$this->input->post('purchase_order_id')."';");

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('12', now() )");

            $date_md = date('Y-m-d H:i:s');

            $q_prv_stt = $this->db->query("SELECT purchase_order_status_id, client_id FROM ip_purchase_order WHERE purchase_order_id = '".$this->input->post('purchase_order_id')."'")->result_array();

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[S] ".$q_prv_stt[0]['purchase_order_status_id']."', now() )");

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('13', now() )");

            if($q_prv_stt[0]['purchase_order_status_id'] != 4 && $q_prv_stt[0]['purchase_order_status_id'] != 5)
            {
                if($this->input->post('purchase_order_status_id') == 4 || $this->input->post('purchase_order_status_id') == 5)
                {
                }
            }

            $checked2 = 0;
            if ($this->input->post('no_bl_sent') == 'true') {
                $checked2 = 1;
            }

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('14', now() )");

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PCompany - ".$this->input->post('purchase_company')."', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PStatus - ".$this->input->post('purchase_order_status_id')."', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PDate - ".$date_md."', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PNotes - ".$this->input->post('notes')."', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PNotes2 - ".$this->input->post('notes2')."', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('POID - ".$this->input->post('purchase_order_id')."', now() )");

            $updt_bl = $this->db->query( "UPDATE ip_purchase_order SET
                        purchase_company = ".$this->input->post('purchase_company').",
                        purchase_order_status_id = ".$this->input->post('purchase_order_status_id').",
                        purchase_order_date_modified = '".$date_md."',
                        notes = '".$this->input->post('notes')."',
                        notes2 = '".$this->input->post('notes2')."'
                     WHERE purchase_order_id = ".$this->input->post('purchase_order_id') );

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('15', now() )");

            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('STT ORIGINAL: ".$prd_stt[0]['purchase_order_status_id']."', now() )" );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('STT NOVO: ".$this->input->post('purchase_order_status_id')."', now() )" );

            $checked = 0;

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('16', now() )");

            if ( $q_prv_stt[0]['purchase_order_status_id'] != $this->input->post('purchase_order_status_id') )
            {
                $this->db->query("INSERT INTO ip_dc_log (dc_tp, dc_id, tp_mv, stt_org, stt_dst, usr_id, ts) VALUES (3, " . $quote_id . ", 5, " . $q_prv_stt[0]['purchase_order_status_id'] . ", " . $this->input->post('purchase_order_status_id') . ", " . $this->session->userdata('user_id') . ", now() )");
            }

            $response = array(
                'success' => 1,
                'purchase_order_id' => 168
            );
        /*}
        else
        {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );

            //echo json_encode($response);
        }*/


        echo json_encode($response);
    }

    public function save2()
    {
        $this->load->model('purchases/mdl_quote_items');
        $this->load->model('purchases/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');
        $this->load->library('encrypt');

        $quote_id = $this->input->post('purchase_order_id');

        $this->mdl_quotes->set_id($quote_id);
        //if ($this->mdl_quotes->run_validation('validation_rules_save_online_quote')) {
        $this->load->helper('json_error');
        $response = array(
            'success' => 0,
            'validation_errors' => json_errors()
        );
        $items = json_decode($this->input->post('items'));

        foreach ($items as $item) {
            if ($item->item_name) {
                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                $item_id = ($item->item_id) ?: NULL;

                $save_item_as_lookup = (isset($item->save_item_as_lookup)) ? $item->save_item_as_lookup : 0;

                unset($item->item_id, $item->save_item_as_lookup);

                $this->mdl_quote_items->save($quote_id, $item_id, $item);

                if ($save_item_as_lookup) {
                    $db_array = array(
                        'item_name' => $item->item_name,
                        'item_description' => $item->item_description,
                        'item_price' => $item->item_price
                    );

                    $this->mdl_item_lookups->save(NULL, $db_array);
                }
            }
        }

        //print "before db_array <br />";
        $is_slash_create = substr($this->input->post('purchase_order_date_created'), 2, 1);
        if($is_slash_create == "/")
        {//24-02-2016
            /*$year_create = substr($this->input->post('purchase_order_date_created'), 6, 9);
            $month_create = substr($this->input->post('purchase_order_date_created'), 0, 2);
            $day_create = substr($this->input->post('purchase_order_date_created'), 3, 4);
            $day_create = substr($day_create, 0, 2);*/
            //$date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('purchase_order_date_created'), 6, 9);
            $day_create = substr($this->input->post('purchase_order_date_created'), 0, 2);
            $month_create = substr($this->input->post('purchase_order_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('purchase_order_date_created');
        }

        // @TODO Add checks / formatting for discounts!
        $db_array = array(
            'purchase_order_number' => $this->input->post('purchase_order_number'),
            'purchase_order_date_created' => $date_create,
            'purchase_order_date_expires' => $date_expire,
            'purchase_order_status_id' => $this->input->post('purchase_order_status_id'),
            'purchase_order_password' => $this->input->post('purchase_order_password'),
            'notes' => $this->input->post('notes'),
            'notes2' => $this->input->post('notes2'),
            'notes3' => $this->input->post('notes3'),
            'purchase_order_discount_amount' => $this->input->post('purchase_order_discount_amount'),
            'purchase_order_discount_percent' => $this->input->post('purchase_order_discount_percent')
        );

        //print "after db_array <br />";

        $this->mdl_quotes->save($quote_id, $db_array);

        //print "after mdl_quotes_save <br />";
        // Recalculate for discounts
        $this->load->model('purchases/mdl_quote_amounts');
        //print "after load model <br />";

        $this->mdl_quote_amounts->calculate($quote_id);

        //print "after mdl_quote_amounts calculate <br />";

        $response = array(
            'success' => 1,
            'purchase_order_id' => 168
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        if ($this->input->post('custom')) {
            $db_array = array();

            foreach ($this->input->post('custom') as $custom) {
                // I hate myself for this...
                $db_array[str_replace(']', '', str_replace('custom[', '', $custom['name']))] = $custom['value'];
            }

            $this->load->model('custom_fields/mdl_quote_custom');
            $this->mdl_quote_custom->save_custom($quote_id, $db_array);
        }

        //print "<br />";
        //print_r($response);


        echo json_encode($response);
    }

    public function save_quote_tax_rate()
    {
        $this->load->model('purchases/mdl_quote_tax_rates');

        if ($this->mdl_quote_tax_rates->run_validation()) {
            $this->mdl_quote_tax_rates->save($this->input->post('purchase_order_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_quote_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function create()
    {
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('1', now() )");
        $this->load->model('purchases/mdl_purchases');

        $t_max_id_num[] = $this->db->query("SELECT max(purchase_order_number) as purchase_order_number FROM ip_purchase_order")->result_array();
        $num = $t_max_id_num[0][0]['purchase_order_number'];
        $num = substr($num, 2);
        $num = (int)$num;
        $num++;

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('2', now() )");

        $cmp_pos = strpos($this->input->post('comp_id'), "-");
        $nm_cst_id = substr($this->input->post('comp_id'), 0, $cmp_pos-1);

        /*$is_slash_create = substr($this->input->post('purchase_order_order_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('purchase_order_order_date_created'), 6, 9);
            $day_create = substr($this->input->post('purchase_order_order_date_created'), 0, 2);
            $month_create = substr($this->input->post('purchase_order_order_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('purchase_order_order_date_created');
        }*/

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3', now() )");

        $date_add = date('Y-m-d');
        $date_create = date('Y-m-d');

        $note = '';

        $sup_pos = strpos($this->input->post('doc_id'), "-");
        $sup_id = substr($this->input->post('doc_id'), 0, $sup_pos-1);

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3 - Date Add " . $date_add . "', now() )");
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3 - Date Created " . $date_create . "', now() )");
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3 - NMCSTD " . $nm_cst_id . "', now() )");
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3 - Num " . $num . "', now() )");
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3 - UserId " . $this->input->post('user_id') . "', now() )");
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('3 - SupId " . $sup_id . "', now() )");

        $updt_bl = $this->db->query( "INSERT INTO ip_purchase_order (user_id, client_id, invoice_group_id, purchase_order_status_id, 
                                                                purchase_order_date_created, purchase_order_date_expires, 
                                                                purchase_order_number, owner, notes, purchase_company) 
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$sup_id.", 0, 1, 
                                                  '".$date_create."', '".$date_add."', 
                                                  'PO".$num."', ".$this->input->post('user_id').", '".$note."',".$nm_cst_id." )" );

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('4', now() )");

        $q_max_id[] = $this->db->query("SELECT max(purchase_order_id) as id FROM ip_purchase_order ")->result_array();

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('5', now() )");

        $this->db->query("INSERT INTO ip_dc_log (dc_tp, dc_id, tp_mv, clnt_org, usr_id, ts) VALUES (9, " . $q_max_id[0][0]['id'] . ", 1, ".$nm_cst_id.",  " . $this->session->userdata('user_id') . ", now() )");

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('6', now() )");

        $isrt_amnt = $this->db->query( "INSERT INTO ip_purchase_order_amounts (purchase_order_id, purchase_order_item_subtotal, purchase_order_item_tax_total, purchase_order_tax_total, purchase_order_total ) 
                                          VALUES
                                      (".$q_max_id[0][0]['id'].", '0.00', '0.00', '0.00', '0.00')" );

        $response = array(
            'success' => 1,
            'purchase_order_id' => $q_max_id[0][0]['id']
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        echo json_encode($response);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        //$this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'purchase_order_id' => $this->input->post('purchase_order_id'),
            'clients' => $this->mdl_clients->get()->result(),
        );

        $this->layout->load_view('purchases/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('purchases/mdl_quotes');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $quote_id = $this->input->post('purchase_order_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('purchase_order_id', $quote_id);
            $this->db->update('ip_purchase_order', $db_array);

            $response = array(
                'success' => 1,
                'purchase_order_id' => $quote_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('purchases/mdl_quote_items');

        $item = $this->mdl_quote_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_quote()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('purchase_suppliers/mdl_purchase_suppliers');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'client_name' => $this->input->post('purchase_supplier_name'),
            //'clients' => $this->mdl_clients->get()->result(),
            'clients' => $this->mdl_purchase_suppliers->where('purchase_supplier_active', 1)->get()->result(),
        );

        $this->layout->load_view('purchases/modal_create_quote', $data);
    }

    public function modal_copy_quote()
    {
        $this->load->module('layout');

        $this->load->model('purchases/mdl_quotes');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'purchase_order_id' => $this->input->post('purchase_order_id'),
            'purchase_order' => $this->mdl_quotes->where('ip_purchase_order.purchase_order_id', $this->input->post('purchase_order_id'))->get()->row()
        );

        $this->layout->load_view('purchases/modal_copy_quote', $data);
    }

    public function copy_quote()
    {
        $this->load->model('purchases/mdl_quotes');
        $this->load->model('purchases/mdl_quote_items');
        $this->load->model('purchases/mdl_quote_tax_rates');

        if ($this->mdl_quotes->run_validation()) {
            $target_id = $this->mdl_quotes->save();
            $source_id = $this->input->post('purchase_order_id');

            $this->mdl_quotes->copy_quote($source_id, $target_id);

            $response = array(
                'success' => 1,
                'purchase_order_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_quote_to_invoice($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('purchases/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'purchase_order_id' => $quote_id,
            'purchase_order' => $this->mdl_quotes->where('ip_purchase_order.purchase_order_id', $quote_id)->get()->row()
        );

        $this->load->view('purchases/modal_quote_to_invoice', $data);
    }

    public function quote_to_invoice()
    {
        $this->load->model(
            array(
                'invoices/mdl_invoices',
                'invoices/mdl_items',
                'purchases/mdl_quotes',
                'purchases/mdl_quote_items',
                'invoices/mdl_invoice_tax_rates',
                'purchases/mdl_quote_tax_rates'
            )
        );
        /*$this->load->model(
            array(
                'quotes/mdl_quotes',
                'quotes/mdl_items',
                'purchases/mdl_quotes',
                'purchases/mdl_quote_items',
                'quotes/mdl_quote_tax_rates',
                'purchases/mdl_quote_tax_rates'
            )
        );*/

        if ($this->mdl_invoices->run_validation()) {
            // DO OWN CODE TO CONVERT EOL -> QUOTE
            $oq_res = $this->db->query("SELECT * FROM ip_purchase_order ioq
                LEFT JOIN ip_purchase_order_amounts ioqa ON ioqa.purchase_order_id = ioq.purchase_order_id
                LEFT JOIN ip_purchase_order_custom ioqc ON ioqc.purchase_order_id = ioq.purchase_order_id
                WHERE ioq.purchase_order_id = ".$this->input->post('purchase_order_id'))->result_array();

            $oqtax_res = $this->db->query("SELECT * FROM ip_purchase_order_tax_rates WHERE purchase_order_id = ".$this->input->post('purchase_order_id'))->result_array();

            $oqitems_res = $this->db->query("SELECT * FROM ip_purchase_order_items WHERE purchase_order_id = ".$this->input->post('purchase_order_id'))->result_array();

            foreach ($oqitems_res as $item) {
                $oqitems_qtt_res[] = $this->db->query("SELECT * FROM ip_purchase_order_item_amounts WHERE item_id = ".$item['item_id'] )->result_array();
            }

            $quo_exp_days = $this->db->query("SELECT * FROM ip_settings WHERE setting_key = 'quotes_expire_after'")->result_array();

            $q_max_id_num[] = $this->db->query("SELECT quote_id, quote_number FROM ip_quotes order by quote_date_created desc limit 1 ")->result_array();
            $num = $q_max_id_num[0][0]['quote_number'];
            $num = substr($num, 1);
            $num = (int)$num;
            $num++;

            //GET EXPIRE QUOTE DATE TO CALCULATE NOW+EXPIRE TIMER
            /*$isrt_quo = $this->db->query("INSERT INTO ip_quotes (invoice_id, user_id, client_id, invoice_group_id, quote_status_id, quote_date_created,
            quote_date_modified, quote_date_expires, quote_number, quote_discount_amount, quote_discount_percent, quote_url_key,
            quote_password, notes) VALUES
             (0, ".$oq_res[0]['user_id'].", ".$oq_res[0]['client_id'].", ".$this->input->post('invoice_group_id').", 1, now(),
                now(), NOW() + INTERVAL ".$quo_exp_days[0]['setting_value']." DAY, 'D".$num."', ".$oq_res[0]['online_quote_discount_amount'].", ".$oq_res[0]['online_quote_discount_percent'].", '".$oq_res[0]['online_quote_url_key']."',
            '".$this->input->post('invoice_password')."', '".$oq_res[0]['notes']."' )");

            $q_max_id[] = $this->db->query("SELECT max(quote_id) as id FROM ip_quotes ")->result_array();

            if( !is_null($oq_res[0]['quote_custom_id']) && $oq_res[0]['quote_custom_id'] != "")
            {
                $isrt_quo_cstm = $this->db->query("INSERT INTO ip_quote_custom (quote_custom_id, quote_id) VALUES ( ".$oq_res[0]['online_quote_custom_id'].", ".$q_max_id[0][0]['id'].")");
            }
            if( !is_null($oq_res[0]['online_quote_amount_id']) && $oq_res[0]['online_quote_amount_id'] != "")
            {
                $isrt_quo_amnt = $this->db->query("INSERT INTO ip_quote_amounts (quote_id, quote_item_subtotal, quote_item_tax_total, quote_total) VALUES
                    ( ".$q_max_id[0][0]['id'].", '".$oq_res[0]['online_quote_item_subtotal']."', '".$oq_res[0]['online_quote_item_tax_total']."', '".$oq_res[0]['online_quote_total']."')");
            }

            foreach ($oqtax_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_tax_rates (quote_id, tax_rate_id, include_item_tax, quote_tax_rate_amount) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['tax_rate_id'].", ".$item['include_item_tax'].", ".$item['online_quote_tax_rate_amount']." )");
            }

            foreach ($oqitems_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_items (quote_id, item_tax_rate_id, item_date_added, item_name, item_description,
                        item_quantity, item_price, item_discount_amount, item_order) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['item_tax_rate_id'].", '".$item['item_date_added']."', '".$item['item_name']."', '".$item['item_description']."',
                        '".$item['item_quantity']."', '".$item['item_price']."', '".$item['item_discount_amount']."', ".$item['item_order']." )");

                $q_itm_max_id[] = $this->db->query("SELECT max(item_id) as id FROM ip_quote_items ")->result_array();

                foreach ($oqitems_qtt_res as $itm) {
                    if($itm[0]['item_id'] == $item['item_id'])
                    {
                        $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) VALUES
                        (".$itm[0]['item_id'].", ".$itm[0]['item_subtotal'].", '".$itm[0]['item_tax_total']."', '".$itm[0]['item_discount']."', '".$itm[0]['item_total']."')");
                    }
                }
            }*/

            $response = array(
                'success' => 1,
                'quote_id' => $q_max_id_num[0][0]['quote_id']
            );

            echo json_encode($response);
            //break;
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_production_to_transport($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('quotes/mdl_quotes');

        $purchase_order_id = substr($quote_id, strpos($quote_id, "_") + 1);
        $quote_id = substr($quote_id, 0, strpos($quote_id, "_") );

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'quote_id' => $quote_id,
            'purchase_order_id' => $purchase_order_id,
            'quote' => $this->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row()
        );

        $this->load->view('purchases/modal_production_to_transport', $data);
    }

    public function modal_print_notes($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('quotes/mdl_quotes');
        $this->load->model('purchases/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'quote_id' => $quote_id,
            'quote' => $this->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row()
        );

        $this->load->view('purchases/modal_print_notes', $data);
    }

    public function modal_print_notes_services($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('quotes/mdl_quotes');
        $this->load->model('purchases/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'quote_id' => $quote_id,
            'quote' => $this->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row()
        );

        $this->load->view('purchases/modal_print_notes_services', $data);
    }

    public function production_to_transport()
    {
        $this->load->model('bon_livraison/mdl_quotes');

        $q_num[] = $this->db->query("SELECT quote_number, client_id FROM ip_quotes WHERE quote_id = " . $this->input->post('quote_id'))->result_array();
        $quote_num = $q_num[0][0]['quote_number'];
        $nm_cst_id = $q_num[0][0]['client_id'];

        $t_max_id_num[] = $this->db->query("SELECT max(transport_number) as transport_number FROM ip_transport")->result_array();
        $num = $t_max_id_num[0][0]['transport_number'];
        $num = substr($num, 2);
        $num = (int)$num;
        $num++;

        $ps[] = $this->db->query("SELECT purchase_order_supplier FROM ip_purchase_order WHERE origin_quote = '" . $quote_num . "'")->result_array();
        $prd_spl = $ps[0][0]['purchase_order_supplier'];

        $year_create = '';
        $month_create = '';
        $day_create = '';

        $is_slash_create = substr($this->input->post('transport_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $day_create = substr($this->input->post('transport_date_created'), 0, 2);
            $month_create = substr($this->input->post('transport_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('transport_date_created');
        }

        $updt_bl = $this->db->query( "INSERT INTO ip_transport (user_id, client_id, invoice_group_id, transport_status_id, 
                                                                transport_date_created, transport_date_expires, 
                                                                transport_number, pack, box, transporter,
                                                                license_plate, tracking_code, weight, owner,
                                                                origin_quote, production_supplier) 
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', '".$date_create."', 
                                                  'BL".$num."', 0, 0, 0,
                                                  '', '', '', ".$this->input->post('user_id').",
                                                  '".$quote_num."', ".$prd_spl.")" );

        $q_max_id[] = $this->db->query("SELECT max(transport_id) as id FROM ip_transport ")->result_array();

        $quo_slct[] = $this->db->query("SELECT quote_id, notes, quote_transporter FROM ip_quotes WHERE quote_number = '".$quote_num."' limit 1 ")->result_array();
        $quo_id = $quo_slct[0][0]['quote_id'];
        $trnsp_id = $quo_slct[0][0]['quote_transporter'];

        $prd_lst = $this->db->query("SELECT * FROM ip_quote_items WHERE quote_id = ".$quo_id." ")->result_array();

        $date_add = date('Y-m-d');
        $tot_wgt = 0;
        $tot_hgt = 0;

        foreach ($prd_lst as $item)
        {
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('QTT BL: ".$item['item_quantity']."', now() )" );

            $isrt_bl_prd = $this->db->query( "INSERT INTO ip_transport_items (transport_id, item_tax_rate_id, 
                                              item_date_added, item_name, item_description, 
                                              item_quantity, item_price, item_discount_amount, item_order) 
                                          VALUES
                                              (".$q_max_id[0][0]['id'].", 0, 
                                              '".$date_add."', '".$item['item_name']."', '".$item['item_description']."',
                                              ".$item['item_quantity'].", '0.00', '0.00', ".$item['item_order']." )" );

            $wgt_sku[] = $this->db->query("SELECT wgt, stage, height FROM ip_products WHERE product_sku = '".$item['item_description']."' limit 1 ")->result_array();

            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('WGT1 [0][0] BL: ".$wgt_sku[0][0]['wgt']."', now() )" );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('STAGE1 [0][0] BL: ".$wgt_sku[0][0]['stage']."', now() )" );

            $tot_wgt = $tot_wgt + ( $wgt_sku[0][0]['wgt'] * $item['item_quantity'] );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTWGT BL: ".$tot_wgt."', now() )" );

            $tot_hgt = $tot_hgt + ( $wgt_sku[0][0]['height'] * ( ceil($item['item_quantity'] / $wgt_sku[0][0]['stage']) ) );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTHGT BL: ".$tot_hgt."', now() )" );
        }

        $tot_wgt = $tot_wgt / 1000;
        $tot_hgt = ceil($tot_hgt / 220);

        $quo_slct[0][0]['notes'] = str_replace("'", "´", $quo_slct[0][0]['notes']);

        $updt_bl = $this->db->query( "UPDATE ip_transport SET weight = ".$tot_wgt.", notes = '".$quo_slct[0][0]['notes']."', pack = ".$tot_hgt.", transporter = ".$trnsp_id." WHERE transport_id = ".$q_max_id[0][0]['id'] );

        $response = array(
            'success' => 1,
            'transport_id' => $q_max_id[0][0]['id']
        );

        echo json_encode($response);
    }

}
