<script type="text/javascript">
    $(function () {
        $('#save_client_note').click(function () {
            $.post("<?php echo site_url('purchase_suppliers/ajax/save_client_note'); ?>",
                {
                    purchase_supplier_id: $('#purchase_supplier_id').val(),
                    purchase_supplier_note: $('#purchase_supplier_note').val()
                }, function (data) {
                    var response = JSON.parse(data);
                    if (response.success == '1') {
                        // The validation was successful
                        $('.control-group').removeClass('error');
                        $('#purchase_supplier_note').val('');

                        $('#notes_list').load("<?php echo site_url('purchase_suppliers/ajax/load_client_notes'); ?>",
                            {
                                purchase_supplier_id: <?php echo $client->purchase_supplier_id; ?>
                            });
                    }
                    else {
                        // The validation was not successful
                        $('.control-group').removeClass('error');
                        for (var key in response.validation_errors) {
                            $('#' + key).parent().parent().addClass('error');
                        }
                    }
                });
        });

    });
</script>

<div id="headerbar">
    <div class="pull-left">
        <h1><?php echo $client->purchase_supplier_name; ?></h1>
    </div>
    <div class="pull-right btn-group">
        <a href="<?php echo site_url('purchase_suppliers/form/' . $client->purchase_supplier_id); ?>"
           class="btn btn-sm btn-default">
            <i class="fa fa-edit"></i> <?php echo lang('edit'); ?>
        </a>
        <!--<a class="btn btn-sm btn-danger"
           href="<?php echo site_url('purchase_suppliers/delete/' . $client->purchase_supplier_id); ?>"
           onclick="return confirm('<?php echo lang('delete_client_warning'); ?>');">
            <i class="fa fa-trash-o"></i> <?php echo lang('delete'); ?>
        </a>-->
    </div>

</div>

<ul id="settings-tabs" class="nav nav-tabs nav-tabs-noborder">
    <li class="active"><a data-toggle="tab" href="#clientDetails"><?php echo lang('details'); ?></a></li>
    <!--<li><a data-toggle="tab" href="#clientQuotes"><?php echo lang('hst_quotes'); ?></a></li>-->
</ul>

<div class="tabbable tabs-below">

    <div class="tab-content">

        <div id="clientDetails" class="tab-pane tab-info active">

            <?php $this->layout->load_view('layout/alerts'); ?>

            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-6 col-lg-8">
                    <h3><?php echo $client->purchase_supplier_name; ?></h3>

                    <p>
                        <?php echo ($client->purchase_supplier_address_1) ? $client->purchase_supplier_address_1 . '<br>' : ''; ?>
                        <?php echo ($client->purchase_supplier_address_2) ? $client->purchase_supplier_address_2 . '<br>' : ''; ?>
                        <?php echo ($client->purchase_supplier_city) ? $client->purchase_supplier_city : ''; ?>
                        <?php echo ($client->purchase_supplier_state) ? $client->purchase_supplier_state : ''; ?>
                        <?php echo ($client->purchase_supplier_zip) ? $client->purchase_supplier_zip : ''; ?>
                        <?php echo ($client->purchase_supplier_country) ? '<br>' . $client->purchase_supplier_country : ''; ?>
                    </p>
                </div>
                <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4" style="visibility: hidden; display: none;">
                    <table class="table table-condensed table-bordered">
                        <tr>
                            <td>
                                <b><?php echo lang('total_billed'); ?></b>
                            </td>
                            <td class="td-amount">
                                <?php echo format_currency($client->purchase_supplier_invoice_total); ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <b><?php echo lang('total_paid'); ?></b>
                            </td>
                            <td class="td-amount">
                                <?php echo format_currency($client->purchase_supplier_invoice_paid); ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <b><?php echo lang('total_balance'); ?></b>
                            </td>
                            <td class="td-amount">
                                <?php echo format_currency($client->purchase_supplier_invoice_balance); ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <hr/>

            <div class="row">
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('contact_information'); ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if (isset($client->purchase_supplier_gender) && $client->purchase_supplier_gender == 0) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('mr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->purchase_supplier_gender) && $client->purchase_supplier_gender == 1) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('ms'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->purchase_supplier_gender) && $client->purchase_supplier_gender == 2) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('msr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_name_p1) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo auto_link($client->purchase_supplier_name_p1, 'name'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_email) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo auto_link($client->purchase_supplier_email, 'email'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_phone) { ?>
                            <tr>
                                <td><?php echo lang('phone'); ?></td>
                                <td><?php echo $client->purchase_supplier_phone; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_mobile) { ?>
                            <tr>
                                <td><?php echo lang('mobile'); ?></td>
                                <td><?php echo $client->purchase_supplier_mobile; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_fax) { ?>
                            <tr>
                                <td><?php echo lang('fax'); ?></td>
                                <td><?php echo $client->purchase_supplier_fax; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_web) { ?>
                            <tr>
                                <td><?php echo lang('web'); ?></td>
                                <td><?php echo auto_link($client->purchase_supplier_web, 'url', TRUE); ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td><?php echo lang('segment_lbl'); ?></td>
                            <td>
                                <?php if ($client->purchase_supplier_segm == 0) echo lang('other_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 1) echo lang('com_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 2) echo lang('event_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 3) echo lang('rest_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 4) echo lang('bev_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 5) echo lang('collective_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 6) echo lang('reseller_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 7) echo lang('supplier_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 8) echo lang('camp_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 9) echo lang('treat_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 10) echo lang('assoc_segment'); ?>
                                <?php if ($client->purchase_supplier_segm == 11) echo lang('private_segment'); ?>

                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('tax_information'); ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->purchase_supplier_vat_id) { ?>
                            <tr>
                                <td><?php echo lang('vat_id'); ?></td>
                                <td><?php echo $client->purchase_supplier_vat_id; ?></td>
                            </tr>
                        <?php } ?>
                        <?php /*if ($client->client_tax_code) { ?>
                            <tr>
                                <td><?php echo lang('tax_code'); ?></td>
                                <td><?php echo $client->client_tax_code; ?></td>
                            </tr>
                        <?php }*/ ?>
                    </table>
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('contact_information')." 2"; ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if (isset($client->purchase_supplier_gender) && $client->purchase_supplier_gender == 0) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('mr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->purchase_supplier_gender) && $client->purchase_supplier_gender == 1) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('ms'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->purchase_supplier_gender) && $client->purchase_supplier_gender == 2) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('msr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_name_p1) { ?>
                            <tr>
                                <td><?php echo lang('name')." 2"; ?></td>
                                <td><?php echo $client->purchase_supplier_name_p1; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_email2) { ?>
                            <tr>
                                <td><?php echo lang('email')." 2"; ?></td>
                                <td><?php echo $client->purchase_supplier_email2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_phone2) { ?>
                            <tr>
                                <td><?php echo lang('phone')." 2"; ?></td>
                                <td><?php echo $client->purchase_supplier_phone2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->purchase_supplier_mobile_p2) { ?>
                            <tr>
                                <td><?php echo lang('mobile')." 2"; ?></td>
                                <td><?php echo $client->purchase_supplier_mobile_p2; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>

            </div>

            <div class="row" style="visibility: hidden; display: none;">
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('custom_fields'); ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php foreach ($custom_fields as $custom_field) { ?>
                            <tr>
                                <td><?php echo $custom_field->custom_field_label ?></td>
                                <td><?php echo $client->{$custom_field->custom_field_column}; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
            </div>

            <hr/>

            <div>
                <h4><?php echo lang('notes'); ?></h4>
                <br/>
                    <?php echo $client->notes; ?>
                <!-- <div id="notes_list">
                    <?php echo $partial_notes; ?>
                </div>
                <div class="panel panel-default panel-body">
                    <form class="row">
                        <div class="col-xs-12 col-md-10">
                            <input type="hidden" name="client_id" id="client_id"
                                   value="<?php echo $client->client_id; ?>">
                            <textarea id="client_note" class="form-control" rows="1"></textarea>
                        </div>
                        <div class="col-xs-12 col-md-2 text-center">
                            <input type="button" id="save_client_note" class="btn btn-default btn-block"
                                   value="<?php echo lang('add_notes'); ?>">
                        </div>
                    </form>
                </div> -->
            </div>

        </div>

        <!--<div id="clientQuotes" class="tab-pane table-content">
            <?php echo $quote_table; ?>
        </div>-->
    </div>

</div>