<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 *
 */

class Purchase_Suppliers extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_purchase_suppliers');
    }

    public function index()
    {
        // Display active clients by default
        redirect('purchase_suppliers/status/active');
    }

    public function status($status = 'active', $page = 0)
    {
        if (is_numeric(array_search($status, array('active', 'inactive')))) {
            $function = 'is_' . $status;
            $this->mdl_purchase_suppliers->$function();
        }

        $this->mdl_purchase_suppliers->with_total_balance()->paginate(site_url('purchase_suppliers/status/' . $status), $page);
        $clients = $this->mdl_purchase_suppliers->result();

        $this->layout->set(
            array(
                'records' => $clients,
                'filter_display' => TRUE,
                'filter_placeholder' => lang('filter_clients'),
                'filter_method' => 'filter_clients'
            )
        );

        $this->layout->buffer('content', 'purchase_suppliers/index');
        $this->layout->render();
    }

    public function form($id = NULL)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('clients');
        }

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('FORM INSERT-UPDATE CLIENT - IS UPDATE ".$this->input->post('is_update')."', now() )");

        if ($this->mdl_purchase_suppliers->run_validation()) {

            $_POST['client_name'] = str_replace("'", "´", $_POST['client_name']);

            if($_POST['client_active'] == 1)
            {
                if($_POST['client_name'] == '' || $_POST['client_email'] == '' || $_POST['client_phone'] == '' || $_POST['client_country'] == '' || $_POST['client_address_1'] == '' || $_POST['client_city'] == '' || $_POST['client_zip'] == '' || $_POST['client_name'] == NULL || $_POST['client_email'] == NULL || $_POST['client_phone'] == NULL || $_POST['client_country'] == NULL || $_POST['client_address_1'] == NULL || $_POST['client_city'] == NULL || $_POST['client_zip'] == NULL )
                {
                    $nm=$eml=$phn=$cntr=$adr=$cty=$zip=0;

                    if($_POST['client_name'] == '' || $_POST['client_name'] == NULL)
                    {
                        $nm = 1;
                    }
                    if($_POST['client_email'] == '' || $_POST['client_email'] == NULL)
                    {
                        $eml = 1;
                    }
                    if($_POST['client_phone'] == '' || $_POST['client_phone'] == NULL)
                    {
                        $phn = 1;
                    }
                    if($_POST['client_country'] == '' || $_POST['client_country'] == NULL)
                    {
                        $cntr = 1;
                    }
                    if($_POST['client_address_1'] == '' || $_POST['client_address_1'] == NULL)
                    {
                        $adr = 1;
                    }
                    if($_POST['client_city'] == '' || $_POST['client_city'] == NULL)
                    {
                        $cty = 1;
                    }
                    if($_POST['client_zip'] == '' || $_POST['client_zip'] == NULL)
                    {
                        $zip = 1;
                    }

                    $error = lang('mandatory_fields').($nm == 1 ? lang('personal_information').', ' : '').($eml == 1 ? lang('email_address').', ' : '').($phn == 1 ? lang('phone_abbr').', ' : '').($cntr == 1 ? lang('country').', ' : '').($adr == 1 ? lang('street_address').', ' : '').($cty == 1 ? lang('city').', ' : '').($zip == 1 ? lang('zip_code') : '').'.';

                    $this->session->set_flashdata('alert_error', $error);
                }
                else
                {
                    $id = $this->mdl_purchase_suppliers->save($id);

                    $this->load->model('custom_fields/mdl_client_custom');

                    $this->mdl_client_custom->save_custom($id, $this->input->post('custom'));

                    /* SPECIAL CUSTOMER FIELDS MANUALLY INSERT HERE */
                    //[client_name_p1] => Nome1 [client_name_p2] => Nome2 [client_email2] => Email2 [client_phone2] => Phone2 [client_mobile_p2] => Movel2
                    if($_POST['no_cee'] == '' || $_POST['no_cee'] == NULL)
                    {
                        $_POST['no_cee'] = 0;
                    }

                    redirect('purchase_suppliers/view/' . $id);
                }
            }
            else
            {
                $id = $this->mdl_purchase_suppliers->save($id);

                $this->load->model('custom_fields/mdl_client_custom');

                $this->mdl_client_custom->save_custom($id, $this->input->post('custom'));

                /* SPECIAL CUSTOMER FIELDS MANUALLY INSERT HERE */
                //[client_name_p1] => Nome1 [client_name_p2] => Nome2 [client_email2] => Email2 [client_phone2] => Phone2 [client_mobile_p2] => Movel2
                if($_POST['no_cee'] == '' || $_POST['no_cee'] == NULL)
                {
                    $_POST['no_cee'] = 0;
                }

                redirect('purchase_suppliers/view/' . $id);
            }
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_purchase_suppliers->prep_form($id)) {
                show_404();
            }

            $this->load->model('custom_fields/mdl_client_custom');
            $this->mdl_purchase_suppliers->set_form_value('is_update', true);

            $client_custom = $this->mdl_client_custom->where('client_id', $id)->get();

            if ($client_custom->num_rows()) {
                $client_custom = $client_custom->row();

                unset($client_custom->client_id, $client_custom->client_custom_id);

                foreach ($client_custom as $key => $val) {
                    $this->mdl_purchase_suppliers->set_form_value('custom[' . $key . ']', $val);
                }
            }
        } elseif ($this->input->post('btn_submit')) {
            if ($this->input->post('custom')) {
                foreach ($this->input->post('custom') as $key => $val) {
                    $this->mdl_purchase_suppliers->set_form_value('custom[' . $key . ']', $val);
                }
            }
        }

        $this->load->model('custom_fields/mdl_custom_fields');
        $this->load->helper('country');

        $this->layout->set('custom_fields', $this->mdl_custom_fields->by_table('ip_client_custom')->get()->result());
        $this->layout->set('countries', get_country_list(lang('cldr')));
        $this->layout->set('selected_country', $this->mdl_purchase_suppliers->form_value('client_country') ?:
            $this->mdl_settings->setting('default_country'));

        // Set validation rule based on is_update
        if ($this->input->post('is_update') == 0 && $this->input->post('client_name') != '') {
            $check = $this->db->get_where('ip_clients', array('client_name' => $this->input->post('client_name')))->result();
            if (!empty($check)) {
                $this->session->set_flashdata('alert_error', lang('client_already_exists'));
                redirect('purchase_suppliers/form');
            }

            $q_max_id[] = $this->db->query("SELECT max(client_id) as id FROM ip_clients ")->result_array();
        }

        $this->layout->buffer('content', 'purchase_suppliers/form');
        $this->layout->render();
    }

    public function view($client_id)
    {
        $this->load->model('purchase_suppliers/mdl_client_notes');

        //$client = $this->mdl_purchase_suppliers->with_total()->with_total_balance()->with_total_paid()->where('ip_purchase_supplier.purchase_supplier_id', $client_id)->get()->row();
        $client = $this->mdl_purchase_suppliers->where('ip_purchase_supplier.purchase_supplier_id', $client_id)->get()->row();

        if (!$client) {
            show_404();
        }

        $this->layout->set(
            array(
                'client' => $client,
                'client_notes' => $this->mdl_client_notes->where('client_id', $client_id)->get()->result(),
            )
        );

        $this->layout->buffer(
            array(
                array('content', 'purchase_suppliers/view')
            )
        );

        $this->layout->render();
    }

    public function delete($client_id)
    {
        $this->mdl_purchase_suppliers->delete($client_id);
        redirect('purchase_suppliers');
    }

}
