<script type="text/javascript">

    function stopRKey(evt) {
        //console.log("stopRK");
        var evt = (evt) ? evt : ((event) ? event : null);
        var node = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
        if ((evt.keyCode == 13) && (node.type=="text"))  {return false;}
        //keyCode27 added by BM
        if (evt.keyCode == 27)  {$('#modal-choose-items').modal('hide');return false;}
    }

    document.onkeypress = stopRKey;
    //Keydown added by BM
    document.onkeydown = stopRKey;
    document.onkeyup = stopRKey;

</script>
<script type="text/javascript">
    $(function () {
        // Display the create invoice modal
        $('#modal-choose-items').modal('show');

        //document.getElementById("filter_product").focus();
        document.getElementById("filter_product").focus(); //sets focus to element
        var val = document.getElementById("filter_product").value; //store the value of the element
        document.getElementById("filter_product").value = ''; //clear the value of the element
        document.getElementById("filter_product").value = val; //set that value back.

        // Creates the invoice
        $('.select-items-confirm').click(function () {
            var product_ids = [];

            $("input[name='product_ids[]']:checked").each(function () {
                product_ids.push(parseInt($(this).val()));
            });

            $.post("<?php echo site_url('products/ajax/process_product_selections'); ?>", {
                product_ids: product_ids
            }, function (data) {
                items = JSON.parse(data);

                for (var key in items) {
                    // Set default tax rate id if empty
                    if (!items[key].tax_rate_id) items[key].tax_rate_id = 0;

                    if ($('#item_table tbody:last input[name=item_name]').val() !== '') {
                        //$('#new_row').clone().appendTo('#item_table').removeAttr('id').addClass('item').show();
                        $('#new_row').clone().appendTo('#item_table').addClass('item').show();
                    }

                     var last_item_row = $('#item_table tbody:last');

                     console.log(items[key]);

                     last_item_row.find('input[name=item_description]').val(items[key].product_sku);
                     last_item_row.find('textarea[name=item_name]').val(items[key].product_name);
                     //last_item_row.find('input[name=item_name]').val(items[key].product_name);
                     last_item_row.find('textarea[name=item_description]').val(items[key].product_description);
                     last_item_row.find('input[name=item_price]').val(items[key].product_price);



                     last_item_row.find('input[name=item_quantity]').val('1');
                     last_item_row.find('select[name=item_tax_rate_id]').val(items[key].tax_rate_id);
                     last_item_row.find('input[name=item_product_id]').val(items[key].product_id);
                     last_item_row.find('input[name=item_discount_amount]').val('0.00');
                     last_item_row.find('span[name=subtotal]').text(items[key].product_price+' €');
                     last_item_row.find('span[name=item_discount_total]').text('0.00 €');
                     //last_item_row.find('span[name=item_discount_total]').text(items[key].product_price+' €');
                     if(items[key].tax_rate_id == 1)
                     {
                         last_item_row.find('span[name=item_tax_total]').text((Math.round((items[key].product_price * 0.2) * 100) / 100)+' €');
                     }
                     else
                     {
                         last_item_row.find('span[name=item_tax_total]').text('0.00 €');
                     }
                     last_item_row.find('span[name=item_total]').text(items[key].product_price+' €');
                    /*last_item_row.find('input[name=item_name]').val(items[key].product_name);
                     last_item_row.find('textarea[name=item_description]').val(items[key].product_description);
                     last_item_row.find('input[name=item_price]').val(items[key].product_price);
                     last_item_row.find('input[name=item_quantity]').val('1');
                     last_item_row.find('select[name=item_tax_rate_id]').val(items[key].tax_rate_id);
                     last_item_row.find('input[name=item_product_id]').val(items[key].product_id);*/

                    itemData[100] = {item_quantity:1, item_price:items[key].product_price, item_discount_amount:"0.00", item_description:items[key].product_sku};

                    tot = (document.getElementById("total_doc").innerHTML);

                    tot = tot.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
                    var n = tot.indexOf("&");
                    console.log(tot);
                    console.log(n);
                    if(n == -1)
                    {
                        n = tot.indexOf(" ");
                    }
                    tot = tot.substr(3, n);
                    console.log(tot);
                    tot = parseFloat(tot);
                    console.log(tot);

                    //document.getElementById("total_doc").innerHTML="<b>"+ tot +" €</b>";
                    if(items[key].tax_rate_id == 1)
                    {
                        last_item_row.find('span[name=item_tax_total]').text((Math.round((items[key].product_price * 0.2) * 100) / 100)+' €');
                        document.getElementById("total_doc").innerHTML="<b>"+(Math.round( ((items[key].product_price * 0.2) + parseFloat(items[key].product_price) + tot ) * 100) / 100).toString() +" €</b>";
                    }
                    else
                    {
                        document.getElementById("total_doc").innerHTML="<b>"+(Math.round( (parseFloat(items[key].product_price)+tot ) * 100) / 100).toString() +" €</b>";
                    }

                    $('#modal-choose-items').modal('hide');
                }
            });
        });

        // Toggle checkbox when click on row
        $('#products_table tr').click(function (event) {
            if (event.target.type !== 'checkbox') {
                $(':checkbox', this).trigger('click');
            }
        });

        // Filter on search button click
        $('#filter-button').click(function () {
            products_filter();
        });

        // Filter on family dropdown change
        $("#filter_family").change(function () {
            products_filter();
        });

        // Filter products
        function products_filter() {
            //console.log("Filter");
            var filter_family = $('#filter_family').val();
            var filter_product = $('#filter_product').val();
            var lookup_url = "<?php echo site_url('products/ajax/modal_product_lookups'); ?>/";
            lookup_url += Math.floor(Math.random() * 1000) + '/?';

            if (filter_family) {
                lookup_url += "&filter_family=" + filter_family;
            }

            if (filter_product) {
                lookup_url += "&filter_product=" + filter_product;
            }

            // refresh modal
            //$('#modal-choose-items').modal('hide');
            $('#modal-placeholder').load(lookup_url);
        }

        var timeout = null;

        function delayedSearch() {
            //console.log("Delay!!!");
            if (timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(function() {
                products_filter(); //this is your existing function
            }, 500);
        }


        var iBox = document.getElementById('filter_product');

        iBox.onkeyup = function(){
            //products_filter();
            delayedSearch();
        }
    });
</script>

<div id="modal-choose-items" class="modal col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2"
     role="dialog" aria-labelledby="modal-choose-items" aria-hidden="true">
    <form class="modal-content">
        <div class="modal-header">
            <a data-dismiss="modal" class="close"><i class="fa fa-close"></i></a>

            <h3><?php echo lang('check_stock'); ?></h3>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-xs-8">
                    <div class="form-inline">
                        <div class="form-group filter-form">
                            <!-- ToDo
					<select name="filter_family" id="filter_family" class="form-control">
						<option value=""><?php echo lang('any_family'); ?></option>
						<?php foreach ($families as $family) { ?>
						<option value="<?php echo $family->family_id; ?>"
							<?php if (isset($filter_family) && $family->family_id == $filter_family) {
                                echo ' selected="selected"';
                            } ?>><?php echo $family->family_name; ?></option>
						<?php } ?>
					</select>
					-->
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="filter_product" id="filter_product"
                                   placeholder="<?php echo lang('product_name'); ?>"
                                   value="<?php echo $filter_product ?>"
                                   onkeyup="delayedSearch();"
                                   onfocus="this.value = this.value;"
                            >
                            <!-- onChange="products_filter();" -->
                        </div>
                        <!-- <button type="button" id="filter-button"
                                class="btn btn-default"><i class="fa fa-search" aria-hidden="true"></i><?php //echo lang('search_product'); ?></button> -->
                    </div>
                </div>
                <div class="col-xs-4 text-right">
                    <div class="btn-group">
                        <button class="btn btn-danger" type="button" data-dismiss="modal">
                            <i class="fa fa-times"></i>
                            <?php echo lang('close'); ?>
                        </button>
                        <!-- <button class="select-items-confirm btn btn-success" type="button">
                            <i class="fa fa-check"></i>
                            <?php echo lang('submit'); ?>
                        </button> -->
                    </div>
                </div>
            </div>
            <br/>

            <div class="table-responsive">
                <table id="products_table" class="table table-bordered table-striped">
                    <tr>
                        <!-- <th>&nbsp;</th> -->
                        <th><?php echo lang('product_sku'); ?></th>
                        <!-- <th><?php echo lang('family_name'); ?></th> -->
                        <th><?php echo lang('product_name'); ?></th>
                        <?php /*<th><?php echo lang('product_description'); ?></th>*/?>
                        <th class="text-right"><?php //echo lang('product_price'); ?><?php echo lang('pack'); ?></th>
                        <th class="text-right"><?php echo lang('stock'); ?></th>
                    </tr>
                    <?php foreach ($products as $product) {
                        if ($product->inactive == 0) { ?>
                            <tr>
                                <!-- <td class="text-left">
                                <input type="checkbox" name="product_ids[]"
                                       value="<?php echo $product->product_id; ?>">
                            </td> -->
                                <td nowrap class="text-left">
                                    <b><?php echo $product->product_sku; ?></b>
                                </td>
                                <!-- <td>
                                <b><?php echo $product->family_name; ?></b>
                            </td> -->
                                <td>
                                    <b><?php echo $product->product_name; ?></b>
                                </td>
                                <?php /*<td>
                                <?php echo nl2br($product->product_description); ?>
                            </td>*/ ?>
                                <td class="text-right">
                                    <?php //echo format_currency($product->product_price); ?>
                                    <?php echo floor($product->stock / $product->uni); ?>
                                </td>
                                <td class="text-right">
                                    <?php //echo format_currency($product->product_price); ?>
                                    <?php echo($product->uni * (floor($product->stock / $product->uni))); ?>
                                </td>
                            </tr>
                        <?php }
                    }?>
                </table>
            </div>
        </div>

        <div class="modal-footer">
            <div class="btn-group">
                <!-- <button class="btn btn-danger" type="button" data-dismiss="modal">
                    <i class="fa fa-times"></i>
                    <?php echo lang('close'); ?>
                </button>
                <button class="select-items-confirm btn btn-success" type="button">
                    <i class="fa fa-check"></i>
                    <?php echo lang('submit'); ?>
                </button> -->
            </div>
        </div>

    </form>

</div>