<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Purchase_Products extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_purchase_products');
    }

    public function index($page = 0)
    {
        $this->mdl_purchase_products->paginate_products(site_url('purchase_products/index'), $page);
        $products = $this->mdl_purchase_products->result();

        $this->layout->set(
            array(
                'products' => $products,
                'filter_display' => FALSE,
                'filter_placeholder' => lang('filter_products'),
                'filter_method' => 'filter_products'
            )
        );

        $this->layout->set('products', $products);
        $this->layout->buffer('content', 'purchase_products/index');
        $this->layout->render();
    }

    public function form($id = NULL)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('purchase_products');
        }

        if ($this->mdl_purchase_products->run_validation()) {
            $this->mdl_purchase_products->save($id);
            redirect('purchase_products');
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_purchase_products->prep_form($id)) {
                show_404();
            }
        }

        $this->load->model('families/mdl_families');
        $this->load->model('tax_rates/mdl_tax_rates');

        $this->layout->set(
            array(
                'families' => $this->mdl_families->get()->result(),
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
            )
        );

        $this->layout->buffer('content', 'purchase_products/form');
        $this->layout->render();
    }

    public function delete($id)
    {
        $this->mdl_purchase_products->delete($id);
        redirect('purchase_products');
    }

}
