<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Products extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_products');
    }

    public function index($page = 0)
    {
        $this->mdl_products->paginate_products(site_url('products/index'), $page);
        $products = $this->mdl_products->result();

        $this->layout->set(
            array(
                'products' => $products,
                'filter_display' => FALSE,
                'filter_placeholder' => lang('filter_products'),
                'filter_method' => 'filter_products'
            )
        );

        $this->layout->set('products', $products);
        $this->layout->buffer('content', 'products/index');
        $this->layout->render();
    }

    public function stock($page = 0)
    {
        $this->mdl_products->paginate(site_url('products/stock'), $page);
        $products = $this->mdl_products->stock_product_list();

        $this->layout->set('products', $products);
        $this->layout->buffer('content', 'products/stock');
        $this->layout->render();
    }

    public function stock_off($page = 0)
    {
        $this->mdl_products->paginate(site_url('products/stock_off'), $page);
        $products = $this->mdl_products->stock_product_list();

        $this->layout->set('products', $products);
        $this->layout->buffer('content', 'products/stock_off');
        $this->layout->render();
    }

    public function stock_file($page = 0)
    {
        $this->layout->buffer('content', 'products/stock_file');
        $this->layout->render();
    }

    public function stock_factory($page = 0)
    {
        //$this->layout->set('products', $products);
        $this->layout->buffer('content', 'products/stock_factory');
        $this->layout->render();
    }

    public function form($id = NULL)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('products');
        }

        if ($this->mdl_products->run_validation()) {
            $this->mdl_products->save($id);
            redirect('products');
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_products->prep_form($id)) {
                show_404();
            }
        }

        $this->load->model('families/mdl_families');
        $this->load->model('tax_rates/mdl_tax_rates');

        $this->layout->set(
            array(
                'families' => $this->mdl_families->get()->result(),
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
            )
        );

        $this->layout->buffer('content', 'products/form');
        $this->layout->render();
    }

    public function delete($id)
    {
        $this->mdl_products->delete($id);
        redirect('products');
    }

}
