<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->load->model('production/mdl_quote_items');
        $this->load->model('production/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');

        $isrt_log = $this->db->query( "INSERT INTO drinksfr_office.idm_log (log, ts) VALUES ('ELSE DEU BOSTA', now() )" );

        $quote_id = $this->input->post('production_id');

        if ($this->mdl_quotes->run_validation('validation_rules_save_production'))
        {
            $prd_stt = $this->db->query("SELECT production_status_id FROM ip_production WHERE production_id = ".$this->input->post('production_id') )->result_array();

            $is_slash_create = substr($this->input->post('production_date_created'), 2, 1);
            if($is_slash_create == "/")
            {
                $date_create = $year_create."-".$month_create."-".$day_create;
            }
            elseif($is_slash_create == "-")
            {
                $year_create = substr($this->input->post('production_date_created'), 6, 9);
                $day_create = substr($this->input->post('production_date_created'), 0, 2);
                $month_create = substr($this->input->post('production_date_created'), 3, 2);
                $day_create = substr($day_create, 0, 2);
                $date_create = $year_create."-".$month_create."-".$day_create;
            }
            else
            {
                $date_create = $this->input->post('production_date_created');
            }

            if($date_create != "" && $date_create != NULL)
            {
                $updt_bl_dt = $this->db->query( "UPDATE ip_production SET
                            production_date_created = '".$date_create."'
                         WHERE production_id = ".$this->input->post('production_id') );
            }

            $items = json_decode($this->input->post('items'));

            $plist = $this->db->query("SELECT * FROM ip_products WHERE inactive = 0 ORDER BY product_order")->result_array();

            $error = 0;

            foreach ($items as $item) {
                $exists = 0;
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_name." -- ".$item->item_description."', now() )");

                foreach($plist as $pl)
                {
                    if($pl['product_sku'] == $item->item_description) {
                        $exists = 1;
                    }
                    //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$pl['product_sku']." ".$item->item_description."', now() )");
                }

                if($exists == 0)
                {
                    //ERRO
                    $this->load->helper('json_error');
                    $response = array(
                        'success' => 0,
                        'validation_errors' => 'SKU_ERROR'
                    );

                    $error = 1;
                }
            }

            foreach ($items as $item) {
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_id." ".$item->item_description."', now() )");
                if($item->item_id == NULL)
                {
                    foreach($item as $it)
                    {
                        $string= "?? ".$string." ".$it;
                    }
                    //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM ID NULL', now() )");
                    $string = ' ' . $string;
                    $ini = strpos($string, $quote_id);
                    $ini += strlen($quote_id)+2;
                    //$len = strpos($string, $item->item_quantity, $ini ) - $ini;
                    $len = strpos($string, $item->item_name, $ini ) - $ini;
                    $note_k = substr($string, $ini, $len);
                    $prod_info[] = $this->db->query("SELECT product_id FROM ip_products WHERE product_sku like '%".trim($note_k)."%' limit 1;")->result_array();

                    $pid = $prod_info[0][0]['product_id'];

                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] PID1 ".$pid."', now() )");

                    if($pid == NULL || $pid == "")
                    {
                        $pid = 0;
                    }

                    $date_add = date('Y-m-d');
                    $item->item_quantity = standardize_amount($item->item_quantity);

                    if($item->item_description != "" && $item->item_description != NULL)
                    {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] PID2 ".$pid."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] PRODUCTION ID ".$this->input->post('production_id')."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] DATE ADD ".$date_add."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM NAME ".$item->item_name."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM DESCRIPTION ".$item->item_description."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM QTT ".$item->item_quantity."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM PRICE ".$item->item_price."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM DSC AMNT ".$item->item_discount_amount."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM TAX RATE ID ".$item->item_tax_rate_id."', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ITEM ORDER".$item->item_order."', now() )");

                        $updt_bl = $this->db->query( "INSERT INTO ip_production_items (production_id, item_tax_rate_id, item_date_added, item_name,
                                                                                  item_description, item_quantity, item_price, item_discount_amount, item_order, item_warehouse_id) 
                                                  VALUES
                                                                                  (".$this->input->post('production_id').", '".$item->item_tax_rate_id."', '".$date_add."', '".$item->item_name."',
                                                                                  '".$item->item_description."', ".$item->item_quantity.", '".$item->item_price."', '".$item->item_discount_amount."', ".$item->item_order.", ".$item->item_warehouse_id.")" );
                    }
                }
                else
                {
                    $item->item_quantity = standardize_amount($item->item_quantity);
                    //$item->item_price = standardize_amount($item->item_price);
                    //$item->item_discount_amount = standardize_amount($item->item_discount_amount);

                    if( is_numeric($item->item_pid) )
                    {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[2] ".$item->item_pid." ".$item->item_description."', now() )");
                        $prod_info[] = $this->db->query("SELECT * FROM ip_products WHERE product_id = ".$item->item_pid." AND online = 1 AND inactive = 0 limit 1;")->result_array();
                        $item->item_description = $prod_info[0][0]['product_sku'];
                    }


                    $updt_bl = $this->db->query( "UPDATE ip_production_items SET 
                            item_name = '".$item->item_name."',
                            item_description = '".$item->item_description."',
                            item_order = ".$item->item_order.",
                            item_price = '".$item->item_price."',
                            item_discount_amount = '".$item->item_discount_amount."',
                            item_tax_rate_id = '".$item->item_tax_rate_id."',
                            item_quantity = ".$item->item_quantity.",
                            item_warehouse_id = ".$item->item_warehouse_id."
                         WHERE production_id = ".$this->input->post('production_id')."
                         AND item_id = ".$item->item_id );
                }
            }

            $date_md = date('Y-m-d H-i-s');

            $q_prv_stt = $this->db->query("SELECT production_status_id, client_id FROM ip_production WHERE production_id = '".$this->input->post('production_id')."'")->result_array();

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[S] ".$q_prv_stt[0]['production_status_id']."', now() )");

            if($q_prv_stt[0]['production_status_id'] != 4 && $q_prv_stt[0]['production_status_id'] != 5)
            {
                if($this->input->post('production_status_id') == 4 || $this->input->post('production_status_id') == 5)
                {
                    $c_res = $this->db->query("SELECT * FROM ip_clients WHERE client_id = ".$q_prv_stt[0]['client_id'])->result_array();

                    if($this->input->post('delivery') == 1 || $this->input->post('delivery') == TRUE)
                    {
                        if($this->input->post('delivery_address') == 1)
                        {
                            $quote_client_delivery_address = $c_res[0]['client_address_delivery_1'] . " " . $c_res[0]['client_address_delivery_2'];
                            $quote_client_delivery_local = $c_res[0]['client_delivery_zip'] . " " . $c_res[0]['client_delivery_city'] . " " . $c_res[0]['client_delivery_country'];
                            $quote_client_delivery_company = $c_res[0]['client_delivery_company'];
                            $quote_client_delivery_contact = $c_res[0]['client_delivery_contact'];
                            $quote_client_delivery_phone = $c_res[0]['client_delivery_phone'];
                        }
                        elseif($this->input->post('delivery_address') == 2)
                        {
                            $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_2'] . " " . $c_res[0]['client_address_delivery_2_2'];
                            $quote_client_delivery_local = $c_res[0]['client_delivery_zip2'] . " " . $c_res[0]['client_delivery_city2'] . " " . $c_res[0]['client_delivery_country2'];
                            $quote_client_delivery_company = $c_res[0]['client_delivery_company2'];
                            $quote_client_delivery_contact = $c_res[0]['client_delivery_contact2'];
                            $quote_client_delivery_phone = $c_res[0]['client_delivery_phone2'];
                        }
                        elseif($this->input->post('delivery_address') == 3)
                        {
                            $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_3'] . " " . $c_res[0]['client_address_delivery_2_3'];
                            $quote_client_delivery_local = $c_res[0]['client_delivery_zip3'] . " " . $c_res[0]['client_delivery_city3'] . " " . $c_res[0]['client_delivery_country3'];
                            $quote_client_delivery_company = $c_res[0]['client_delivery_company3'];
                            $quote_client_delivery_contact = $c_res[0]['client_delivery_contact3'];
                            $quote_client_delivery_phone = $c_res[0]['client_delivery_phone3'];
                        }
                        elseif($this->input->post('delivery_address') == 4)
                        {
                            $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_4'] . " " . $c_res[0]['client_address_delivery_2_4'];
                            $quote_client_delivery_local = $c_res[0]['client_delivery_zip4'] . " " . $c_res[0]['client_delivery_city4'] . " " . $c_res[0]['client_delivery_country4'];
                            $quote_client_delivery_company = $c_res[0]['client_delivery_company4'];
                            $quote_client_delivery_contact = $c_res[0]['client_delivery_contact4'];
                            $quote_client_delivery_phone = $c_res[0]['client_delivery_phone4'];
                        }
                        elseif($this->input->post('delivery_address') == 5)
                        {
                            $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_5'] . " " . $c_res[0]['client_address_delivery_2_5'];
                            $quote_client_delivery_local = $c_res[0]['client_delivery_zip5'] . " " . $c_res[0]['client_delivery_city5'] . " " . $c_res[0]['client_delivery_country5'];
                            $quote_client_delivery_company = $c_res[0]['client_delivery_company5'];
                            $quote_client_delivery_contact = $c_res[0]['client_delivery_contact5'];
                            $quote_client_delivery_phone = $c_res[0]['client_delivery_phone5'];
                        }
                        else
                        {
                            $quote_client_delivery_address = "";
                            $quote_client_delivery_local = "";
                            $quote_client_delivery_company = "";
                            $quote_client_delivery_contact = "";
                            $quote_client_delivery_phone = "";
                        }
                    }
                    else
                    {
                        $quote_client_delivery_address = "";
                        $quote_client_delivery_local = "";
                        $quote_client_delivery_company = "";
                        $quote_client_delivery_contact = "";
                        $quote_client_delivery_phone = "";
                    }

                    $c_res[0]['client_name'] = str_replace("'", "´", $c_res[0]['client_name']);
                    $c_res[0]['client_name_p1'] = str_replace("'", "´", $c_res[0]['client_name_p1']);
                    $c_res[0]['client_address_1'] = str_replace("'", "´", $c_res[0]['client_address_1']);
                    $c_res[0]['client_address_2'] = str_replace("'", "´", $c_res[0]['client_address_2']);
                    $c_res[0]['client_zip'] = str_replace("'", "´", $c_res[0]['client_zip']);
                    $c_res[0]['client_city'] = str_replace("'", "´", $c_res[0]['client_city']);
                    $c_res[0]['client_country'] = str_replace("'", "´", $c_res[0]['client_country']);
                    $c_res[0]['client_vat_id'] = str_replace("'", "´", $c_res[0]['client_vat_id']);
                    $c_res[0]['client_phone'] = str_replace("'", "´", $c_res[0]['client_phone']);
                    $c_res[0]['client_email'] = str_replace("'", "´", $c_res[0]['client_email']);
                    $quote_client_delivery_address = str_replace("'", "´", $quote_client_delivery_address);
                    $quote_client_delivery_local = str_replace("'", "´", $quote_client_delivery_local);
                    $quote_client_delivery_company = str_replace("'", "´", $quote_client_delivery_company);
                    $quote_client_delivery_contact = str_replace("'", "´", $quote_client_delivery_contact);
                    $quote_client_delivery_phone = str_replace("'", "´", $quote_client_delivery_phone);
                    
                    $c_res[0]['client_name'] = str_replace("'", "´", $c_res[0]['client_name']);
                    $c_res[0]['client_name_p1'] = str_replace("'", "´", $c_res[0]['client_name_p1']);
                    $c_res[0]['client_address_1'] = str_replace("'", "´", $c_res[0]['client_address_1']);
                    $c_res[0]['client_address_2'] = str_replace("'", "´", $c_res[0]['client_address_2']);
                    $c_res[0]['client_zip'] = str_replace("'", "´", $c_res[0]['client_zip']);
                    $c_res[0]['client_city'] = str_replace("'", "´", $c_res[0]['client_city']);
                    $c_res[0]['client_country'] = str_replace("'", "´", $c_res[0]['client_country']);
                    $c_res[0]['client_vat_id'] = str_replace("'", "´", $c_res[0]['client_vat_id']);
                    $c_res[0]['client_phone'] = str_replace("'", "´", $c_res[0]['client_phone']);
                    $c_res[0]['client_email'] = str_replace("'", "´", $c_res[0]['client_email']);
                    $c_res[0]['client_address_delivery_1'] = str_replace("'", "´", $c_res[0]['client_address_delivery_1']);
                    $c_res[0]['client_address_delivery_2'] = str_replace("'", "´", $c_res[0]['client_address_delivery_2']);
                    $c_res[0]['client_delivery_zip'] = str_replace("'", "´", $c_res[0]['client_delivery_zip']);
                    $c_res[0]['client_delivery_city'] = str_replace("'", "´", $c_res[0]['client_delivery_city']);
                    $c_res[0]['client_delivery_country'] = str_replace("'", "´", $c_res[0]['client_delivery_country']);
                    $c_res[0]['client_delivery_company'] = str_replace("'", "´", $c_res[0]['client_delivery_company']);
                    $c_res[0]['client_delivery_contact'] = str_replace("'", "´", $c_res[0]['client_delivery_contact']);
                    $c_res[0]['client_delivery_phone'] = str_replace("'", "´", $c_res[0]['client_delivery_phone']);

                    $updt_oquo_cstmr = $this->db->query("UPDATE ip_production SET
                                                    production_client_name = '".$c_res[0]['client_name']."',
                                                    production_client_name_p1 = '".$c_res[0]['client_name_p1']."',
                                                    production_client_address_1 = '".$c_res[0]['client_address_1']."',
                                                    production_client_address_2 = '".$c_res[0]['client_address_2']."',
                                                    production_client_zip = '".$c_res[0]['client_zip']."',
                                                    production_client_city = '".$c_res[0]['client_city']."',
                                                    production_client_country = '".$c_res[0]['client_country']."',
                                                    production_client_vat_id = '".$c_res[0]['client_vat_id']."',
                                                    production_client_phone = '".$c_res[0]['client_phone']."',
                                                    production_client_email = '".$c_res[0]['client_email']."',
                                                    production_client_delivery_address = '" . $quote_client_delivery_address . "',
                                                    production_client_delivery_local = '" . $quote_client_delivery_local . "',
                                                    production_client_delivery_company = '" . $quote_client_delivery_company . "',
                                                    production_client_delivery_contact = '" . $quote_client_delivery_contact . "',
                                                    production_client_delivery_phone = '" . $quote_client_delivery_phone . "'
                                                WHERE production_id = ".$this->input->post('production_id'));
                }
            }

            $checked2 = 0;
            $checked3 = 0;
            if ($this->input->post('no_bl_sent') == 'true') {
                $checked2 = 1;
            }
            if ($this->input->post('photolit_done') == 'true') {
                $checked3 = 1;
            }

            if($this->input->post('week') != "" && $this->input->post('week') != NULL)
            {
                $updt_bl = $this->db->query( "UPDATE ip_production SET
                            production_supplier = ".$this->input->post('production_supplier').",
                            production_status_id = ".$this->input->post('production_status_id').", 
                            week = '".$this->input->post('week')."',
                            production_date_modified = '".$date_md."',
                            notes = '".$this->input->post('notes')."',
                            notes2 = '".$this->input->post('notes2')."',
                            notes3 = '".$this->input->post('notes3')."',
                            no_bl_sent = ".$checked2.",
                            photolit_done = ".$checked3."
                         WHERE production_id = ".$this->input->post('production_id') );
            }
            else
            {
                $updt_bl = $this->db->query( "UPDATE ip_production SET
                            production_supplier = ".$this->input->post('production_supplier').",
                            production_status_id = ".$this->input->post('production_status_id').",
                            week = '',
                            production_date_modified = '".$date_md."',
                            notes = '".$this->input->post('notes')."',
                            notes2 = '".$this->input->post('notes2')."',
                            notes3 = '".$this->input->post('notes3')."',
                            no_bl_sent = ".$checked2.",
                            photolit_done = ".$checked3."
                         WHERE production_id = ".$this->input->post('production_id') );
            }

            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('STT ORIGINAL: ".$prd_stt[0]['production_status_id']."', now() )" );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('STT NOVO: ".$this->input->post('production_status_id')."', now() )" );

            if( ($prd_stt[0]['production_status_id'] == 1 || $prd_stt[0]['production_status_id'] == 5 ) && $this->input->post('production_status_id') > 1 && $this->input->post('production_status_id') != 5)
            {
                $prd_lst_stk = $this->db->query("SELECT * FROM ip_production_items WHERE production_id = ".$this->input->post('production_id')." ")->result_array();

                $ref_msg = '
				<html>
				<head><title>Commande - Saida de Stock</title></head>
				<body>
				  <p>Saida de stock da Commande '.$this->input->post('production_number').' </p><br />
				  <table border="1">
				    <tr>
				      <th>Ref.</th><th>Stock Original</th><th>Quantidade Retirada</th><th>Stock Final</th><th>Armazem</th>
				    </tr>';

                foreach ($prd_lst_stk as $itms)
                {
                	$prd_stk_o = $this->db->query("SELECT stock, stock_sample FROM ip_products WHERE product_sku = '".$itms['item_description']."'" )->result_array();

                    $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('PRD SKU + QTT CMND: ".$itms['item_description']." - ".$itms['item_quantity']."', now() )" );

                    if($itms['item_warehouse_id'] == 1)
                    {
                        $rm_stk = $this->db->query( "UPDATE ip_products SET stock = stock - ".$itms['item_quantity']." WHERE product_sku = '".$itms['item_description']."'" );
                        $prd_stk_f = $this->db->query("SELECT stock FROM ip_products WHERE product_sku = '".$itms['item_description']."'" )->result_array();
                        $ref_msg.= '<tr>
      						<td>'.$itms['item_description'].'</td><td>'.$prd_stk_o[0]['stock'].'</td><td>'.$itms['item_quantity'].'</td><td>'.$prd_stk_f[0]['stock'].'</td><td>Leiria</td>
    					</tr>';
                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$itms['item_description']."', ".$itms['item_quantity'].", ".$prd_stk_o[0]['stock'].", ".$prd_stk_f[0]['stock'].", 
                                                  '".$this->input->post('production_number')."', 1, now() )" );
                    }
                    elseif($itms['item_warehouse_id'] == 2)
                    {
                        $rm_stk = $this->db->query( "UPDATE ip_products SET stock_sample = stock_sample - ".$itms['item_quantity']." WHERE product_sku = '".$itms['item_description']."'" );
                        $prd_stk_f = $this->db->query("SELECT stock_sample FROM ip_products WHERE product_sku = '".$itms['item_description']."'" )->result_array();
                        $ref_msg.= '<tr>
      						<td>'.$itms['item_description'].'</td><td>'.$prd_stk_o[0]['stock_sample'].'</td><td>'.$itms['item_quantity'].'</td><td>'.$prd_stk_f[0]['stock_sample'].'</td><td>Echantillon</td>
    					</tr>';
                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$itms['item_description']."', ".$itms['item_quantity'].", ".$prd_stk_o[0]['stock_sample'].", ".$prd_stk_f[0]['stock_sample'].", 
                                                  '".$this->input->post('production_number')."', 2, now() )" );
                    }
                }

                $ref_msg.= '</table> </body> </html>';
                $to = 'bruno@rbdrinks.fr';

				$subject = 'Commande - Saida de Stock';

				$headers[] = 'MIME-Version: 1.0';
				$headers[] = 'Content-type: text/html; charset=iso-8859-1';

				// Additional headers
				//$headers[] = 'To: Bruno Martins <bruno@rbdrinks.fr>, Bruno Rodrigues <brunomartins.1988@gmail.com>';
				$headers[] = 'From: Backoffice RBDRINKS <noreply@rbdrinks.fr>';
				//$headers[] = 'Bcc: bruno@rbdrinks.fr';

				// Mail it
				mail($to, $subject, $ref_msg, implode("\r\n", $headers));
            }
            elseif($prd_stt[0]['production_status_id'] != 1 && $prd_stt[0]['production_status_id'] != 5 && $this->input->post('production_status_id') == 5)
            {
                $prd_lst_stk = $this->db->query("SELECT * FROM ip_production_items WHERE production_id = ".$this->input->post('production_id')." ")->result_array();

                $ref_msg = '
				<html>
				<head><title>Commande - Saida de Stock</title></head>
				<body>
				  <p>Entrada de stock da Commande '.$this->input->post('production_number').' </p><br />
				  <table border="1">
				    <tr>
				      <th>Ref.</th><th>Stock Original</th><th>Quantidade Reposta</th><th>Stock Final</th><th>Armazem</th>
				    </tr>';

                foreach ($prd_lst_stk as $itms)
                {
                	$prd_stk_o = $this->db->query("SELECT stock, stock_sample FROM ip_products WHERE product_sku = '".$itms['item_description']."'" )->result_array();

                    $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('PRD SKU + QTT CMND: ".$itms['item_description']." - ".$itms['item_quantity']."', now() )" );

                    if($itms['item_warehouse_id'] == 1)
                    {
                        $rm_stk = $this->db->query( "UPDATE ip_products SET stock = stock + ".$itms['item_quantity']." WHERE product_sku = '".$itms['item_description']."'" );
                        $prd_stk_f = $this->db->query("SELECT stock FROM ip_products WHERE product_sku = '".$itms['item_description']."'" )->result_array();
                        $ref_msg.= '<tr>
      						<td>'.$itms['item_description'].'</td><td>'.$prd_stk_o[0]['stock'].'</td><td>'.$itms['item_quantity'].'</td><td>'.$prd_stk_f[0]['stock'].'</td><td>Leiria</td>
    					</tr>';
                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$itms['item_description']."', ".$itms['item_quantity'].", ".$prd_stk_o[0]['stock'].", ".$prd_stk_f[0]['stock'].", 
                                                  '".$this->input->post('production_number')."', 1, now() )" );
                    }
                    elseif($itms['item_warehouse_id'] == 2)
                    {
                        $rm_stk = $this->db->query( "UPDATE ip_products SET stock_sample = stock_sample + ".$itms['item_quantity']." WHERE product_sku = '".$itms['item_description']."'" );
                        $prd_stk_f = $this->db->query("SELECT stock_sample FROM ip_products WHERE product_sku = '".$itms['item_description']."'" )->result_array();
                        $ref_msg.= '<tr>
      						<td>'.$itms['item_description'].'</td><td>'.$prd_stk_o[0]['stock_sample'].'</td><td>'.$itms['item_quantity'].'</td><td>'.$prd_stk_f[0]['stock_sample'].'</td><td>Echantillon</td>
    					</tr>';
                        $updt_mv = $this->db->query( "INSERT INTO ip_mv_stk (product_sku, product_qtt, stock_prv, stock_aftr, 
                                                  dc_org, warehouse_id, ts)  
                                              VALUES
                                                  ('".$itms['item_description']."', ".$itms['item_quantity'].", ".$prd_stk_o[0]['stock_sample'].", ".$prd_stk_f[0]['stock_sample'].", 
                                                  '".$this->input->post('production_number')."', 2, now() )" );
                    }
                }
                $ref_msg.= '</table> </body> </html>';
                $to = 'bruno@rbdrinks.fr';

				$subject = 'Commande - Entrada de Stock';

				$headers[] = 'MIME-Version: 1.0';
				$headers[] = 'Content-type: text/html; charset=iso-8859-1';

				// Additional headers
				//$headers[] = 'To: Bruno Martins <bruno@rbdrinks.fr>, Bruno Rodrigues <brunomartins.1988@gmail.com>';
				$headers[] = 'From: Backoffice RBDRINKS <noreply@rbdrinks.fr>';
				//$headers[] = 'Bcc: bruno@rbdrinks.fr';

				// Mail it
				mail($to, $subject, $ref_msg, implode("\r\n", $headers));
            }

            $checked = 0;

            $response = array(
                'success' => 1,
                'production_id' => 168
            );
        }
        else
        {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );

            //echo json_encode($response);
        }


        echo json_encode($response);
    }

    public function save2()
    {
        $this->load->model('production/mdl_quote_items');
        $this->load->model('production/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');
        $this->load->library('encrypt');

        $quote_id = $this->input->post('production_id');

        $this->mdl_quotes->set_id($quote_id);
        //if ($this->mdl_quotes->run_validation('validation_rules_save_online_quote')) {
        $this->load->helper('json_error');
        $response = array(
            'success' => 0,
            'validation_errors' => json_errors()
        );
        $items = json_decode($this->input->post('items'));

        foreach ($items as $item) {
            if ($item->item_name) {
                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                $item_id = ($item->item_id) ?: NULL;

                $save_item_as_lookup = (isset($item->save_item_as_lookup)) ? $item->save_item_as_lookup : 0;

                unset($item->item_id, $item->save_item_as_lookup);

                $this->mdl_quote_items->save($quote_id, $item_id, $item);

                if ($save_item_as_lookup) {
                    $db_array = array(
                        'item_name' => $item->item_name,
                        'item_description' => $item->item_description,
                        'item_price' => $item->item_price
                    );

                    $this->mdl_item_lookups->save(NULL, $db_array);
                }
            }
        }

        //print "before db_array <br />";
        $is_slash_create = substr($this->input->post('production_date_created'), 2, 1);
        if($is_slash_create == "/")
        {//24-02-2016
            /*$year_create = substr($this->input->post('production_date_created'), 6, 9);
            $month_create = substr($this->input->post('production_date_created'), 0, 2);
            $day_create = substr($this->input->post('production_date_created'), 3, 4);
            $day_create = substr($day_create, 0, 2);*/
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('production_date_created'), 6, 9);
            $day_create = substr($this->input->post('production_date_created'), 0, 2);
            $month_create = substr($this->input->post('production_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('production_date_created');
        }
        $is_slash_expire = substr($this->input->post('production_date_expires'), 2, 1);
        if($is_slash_expire == "/")
        {
            $year_expire = substr($this->input->post('production_date_expires'), 6, 9);
            $month_expire = substr($this->input->post('production_date_expires'), 0, 2);
            $day_expire = substr($this->input->post('production_date_expires'), 3, 4);
            $day_expire = substr($day_expire, 0, 2);
            $date_expire = $year_expire."-".$month_expire."-".$day_expire;
        }
        elseif($is_slash_expire == "-")
        {
            $year_expire = substr($this->input->post('production_date_expires'), 6, 9);
            $day_expire = substr($this->input->post('production_date_expires'), 0, 2);
            $month_expire = substr($this->input->post('production_date_expires'), 3, 2);
            $day_expire = substr($day_expire, 0, 2);
            $date_expire = $year_expire."-".$month_expire."-".$day_expire;
        }
        else
        {
            $date_expire = $this->input->post('production_date_expires');
        }

        // @TODO Add checks / formatting for discounts!
        $db_array = array(
            'production_number' => $this->input->post('production_number'),
            //'production_date_created' => $this->input->post('production_date_created'),
            //'production_date_expires' => $this->input->post('production_date_expires'),
            //'production_date_created' => date_to_mysql($this->input->post('production_date_created')),
            //'production_date_expires' => date_to_mysql($this->input->post('production_date_expires')),
            'production_date_created' => $date_create,
            'production_date_expires' => $date_expire,
            'production_status_id' => $this->input->post('production_status_id'),
            'production_password' => $this->input->post('production_password'),
            'notes' => $this->input->post('notes'),
            'notes2' => $this->input->post('notes2'),
            'notes3' => $this->input->post('notes3'),
            'production_discount_amount' => $this->input->post('production_discount_amount'),
            'production_discount_percent' => $this->input->post('production_discount_percent')
        );

        //print "after db_array <br />";

        $this->mdl_quotes->save($quote_id, $db_array);

        //print "after mdl_quotes_save <br />";
        // Recalculate for discounts
        $this->load->model('production/mdl_quote_amounts');
        //print "after load model <br />";

        $this->mdl_quote_amounts->calculate($quote_id);

        //print "after mdl_quote_amounts calculate <br />";

        $response = array(
            'success' => 1,
            'production_id' => 168
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        if ($this->input->post('custom')) {
            $db_array = array();

            foreach ($this->input->post('custom') as $custom) {
                // I hate myself for this...
                $db_array[str_replace(']', '', str_replace('custom[', '', $custom['name']))] = $custom['value'];
            }

            $this->load->model('custom_fields/mdl_quote_custom');
            $this->mdl_quote_custom->save_custom($quote_id, $db_array);
        }

        //print "<br />";
        //print_r($response);


        echo json_encode($response);
    }

    public function save_quote_tax_rate()
    {
        $this->load->model('production/mdl_quote_tax_rates');

        if ($this->mdl_quote_tax_rates->run_validation()) {
            $this->mdl_quote_tax_rates->save($this->input->post('production_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_quote_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function create()
    {
        $this->load->model('production/mdl_quotes');

        /*$response = array(
            'success' => 2,
            'production_id' => 0
        );

        echo json_encode($response);*/
        //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('CREATING COMMANDE MANUAL', now() )" );

        $t_max_id_num[] = $this->db->query("SELECT production_number FROM ip_production ORDER BY production_id DESC LIMIT 1")->result_array();
        $num = $t_max_id_num[0][0]['production_number'];
        $num = substr($num, 3);
        $num = (int)$num;
        $num++;

        /*$cst_id[] = $this->db->query("SELECT client_id FROM ip_clients WHERE client_name = '".$this->input->post('client_name')."' limit 1 ")->result_array();
        $nm_cst_id = $cst_id[0][0]['client_id'];*/
        if($this->input->post('client_id') == 0 || $this->input->post('client_id') == NULL )
        {
            $cst_id[] = $this->db->query("SELECT client_id FROM ip_clients WHERE client_name = '".$this->input->post('client_name')."' limit 1 ")->result_array();
            $nm_cst_id = $cst_id[0][0]['client_id'];
        }
        else
        {
            $nm_cst_id = $this->input->post('client_id');    
        }

        $is_slash_create = substr($this->input->post('production_order_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('production_order_date_created'), 6, 9);
            $day_create = substr($this->input->post('production_order_date_created'), 0, 2);
            $month_create = substr($this->input->post('production_order_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('production_order_date_created');
        }

        $date_add = date('Y-m-d');

        if($this->input->post('doc_id') != "")
        {
            $note = 'Ordre Fabrication pour le Devis '.$this->input->post('doc_id');
        }
        else
        {
            $note = '';
        }

        //doc_id
        //production_date_created user_id
        if( $this->input->post('doc_id') == "" || $this->input->post('doc_id') == NULL)
        {
            $dc_id = '';
        }
        else
        {
            //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('CREATING COMMANDE MANUAL', now() )" );
            $dc_id = $this->input->post('doc_id');
        }

        //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('DC id: '".$dc_id."' ', now() )" );

        $updt_bl = $this->db->query( "INSERT INTO ip_production (user_id, client_id, invoice_group_id, production_status_id, 
                                                                production_date_created, production_date_expires, production_date_modified, 
                                                                production_number, owner, origin_quote, notes) 
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', '".$date_add."', now(),
                                                  'COM".$num."', ".$this->input->post('user_id').", '".$dc_id."', '".$note."' )" );

        $q_max_id[] = $this->db->query("SELECT max(production_id) as id FROM ip_production ")->result_array();

        if($this->input->post('doc_id') != "" && $this->input->post('doc_id') != NULL)
        {
            $quo_slct[] = $this->db->query("SELECT quote_id, quote_delivery_id, notes, quote_date_delivery FROM ip_quotes WHERE quote_number = '".$this->input->post('doc_id')."' limit 1 ")->result_array();
            $quo_id = $quo_slct[0][0]['quote_id'];
            $quo__dlvr_id = $quo_slct[0][0]['quote_delivery_id'];

            if( ($quo_slct[0][0]['quote_date_delivery'] != '') AND ($quo_slct[0][0]['quote_date_delivery'] != NULL) AND ($quo_slct[0][0]['quote_date_delivery'] != '0000-00-00') )
            {
                $dtd =  date("d-m-Y", strtotime($quo_slct[0][0]['quote_date_delivery']) );
                $n3 = 'Livraison max le ' . $dtd;
            }
            else
            {
                $n3 = '';
            }

            $prd_lst = $this->db->query("SELECT * FROM ip_quote_items WHERE quote_id = ".$quo_id." ")->result_array();

            $date_add = date('Y-m-d');
            $tot_wgt = 0;

            $prd_lst_fmly = $this->db->query("SELECT product_sku FROM ip_products WHERE family_id = 4 ")->result_array();

            foreach ($prd_lst as $item)
            {
                $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('PRD SKU CMND: ".$item['item_description']."', now() )" );

                //if( !in_array($item['item_description'], $prd_lst_fmly[0][0]) )
                if( $item['item_description'] != 'TRANSPORT'    AND
                    $item['item_description'] != 'CC50'         AND
                    $item['item_description'] != 'CREA'         AND
                    $item['item_description'] != 'DIVERS'       AND
                    $item['item_description'] != 'OBS'          AND
                    $item['item_description'] != 'PROMO'        AND
                    $item['item_description'] != 'NOTE'         AND
                    $item['item_description'] != 'FT'           AND
                    $item['item_description'] != '1-couleur'    AND
                    $item['item_description'] != '2-couleurs'   AND
                    $item['item_description'] != '3-couleurs'   AND
                    $item['item_description'] != '4-couleurs' )
                {
                    $prd_un_wrh = $this->db->query("SELECT uni, default_warehouse FROM ip_products WHERE product_sku LIKE '".$item['item_description']."'; ")->result_array();
                    $p_un = $prd_un_wrh[0]['uni'];
                    $p_wrh = $prd_un_wrh[0]['default_warehouse'];

                    $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('QTT BL: ".$item['item_quantity']."', now() )" );

                    $wrh_id = 1;

                    if( $item['item_quantity'] < $p_un )
                    {
                        if( $p_wrh == 1 )
                        {
                            $wrh_id = 2;
                        }
                        else
                        {
                            $wrh_id = $p_wrh;
                        }
                    }
                    else
                    {
                        $wrh_id = $p_wrh;
                    }

                    /*$isrt_bl_prd = $this->db->query( "INSERT INTO ip_production_items (production_id, item_tax_rate_id, 
                                                  item_date_added, item_name, item_description, 
                                                  item_quantity, item_price, item_discount_amount, item_order) 
                                              VALUES
                                                  (".$q_max_id[0][0]['id'].", '".$item['item_tax_rate_id']."', 
                                                  '".$date_add."', '".$item['item_name']."', '".$item['item_description']."',
                                                  ".$item['item_quantity'].", '', '0', ".$item['item_order']." )" );*/
                    $isrt_bl_prd = $this->db->query( "INSERT INTO ip_production_items (production_id, item_tax_rate_id, 
                                                  item_date_added, item_name, item_description, 
                                                  item_quantity, item_price, item_discount_amount, item_order, item_warehouse_id) 
                                              VALUES
                                                  (".$q_max_id[0][0]['id'].", '".$item['item_bat_num']."', 
                                                  '".$date_add."', '".$item['item_name']."', '".$item['item_description']."',
                                                  ".$item['item_quantity'].", '".$item['item_logo']."', '".$item['item_color_num']."', ".$item['item_order'].", ".$wrh_id." )" );
                }

                $quo_slct[0][0]['notes'] = str_replace("'", "´", $quo_slct[0][0]['notes']);

                if($quo__dlvr_id > 0)
                {
                    $cst_dlvr[] = $this->db->query("SELECT client_delivery_company, client_delivery_contact, client_delivery_phone, client_address_delivery_1, client_address_delivery_2, client_delivery_zip, client_delivery_city, client_delivery_country FROM ip_clients WHERE client_id = ".$nm_cst_id." limit 1 ")->result_array();
                    
                    /*$updt_bl_nt = $this->db->query( "UPDATE ip_production SET
                            notes2 = '".$cst_dlvr[0][0]['client_delivery_company']." 
".$cst_dlvr[0][0]['client_delivery_contact']." 
".$cst_dlvr[0][0]['client_delivery_phone']."
".$cst_dlvr[0][0]['client_address_delivery_1']."
".$cst_dlvr[0][0]['client_address_delivery_2']."
".$cst_dlvr[0][0]['client_delivery_zip']."
".$cst_dlvr[0][0]['client_delivery_city']."
".$cst_dlvr[0][0]['client_delivery_country']."
".$quo_slct[0][0]['notes']."'
                         WHERE production_id = ".$q_max_id[0][0]['id'] );*/
                     $updt_bl_nt = $this->db->query( "UPDATE ip_production SET
                            notes3 = '".$n3." ".$quo_slct[0][0]['notes']."' 
                         WHERE production_id = ".$q_max_id[0][0]['id'] );
                }
                else
                {
                    $updt_bl_nt = $this->db->query( "UPDATE ip_production SET
                            notes3 = '".$n3." ".$quo_slct[0][0]['notes']."' 
                         WHERE production_id = ".$q_max_id[0][0]['id'] );
                }
            }

        }

        $response = array(
            'success' => 1,
            'production_id' => $q_max_id[0][0]['id']
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        echo json_encode($response);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'production_id' => $this->input->post('production_id'),
            'clients' => $this->mdl_clients->get()->result(),
        );

        $this->layout->load_view('production/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('production/mdl_quotes');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $quote_id = $this->input->post('production_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('production_id', $quote_id);
            $this->db->update('ip_production', $db_array);

            $response = array(
                'success' => 1,
                'production_id' => $quote_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('production/mdl_quote_items');

        $item = $this->mdl_quote_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_quote()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'client_name' => $this->input->post('client_name'),
            //'clients' => $this->mdl_clients->get()->result(),
            //'clients' => $this->mdl_clients->where('client_active', 1)->get()->result(),
            'clients' => $this->mdl_clients->where('is_valid', 1)->limit(1700)->get()->result(),
        );

        $this->layout->load_view('production/modal_create_quote', $data);
    }

    public function modal_copy_quote()
    {
        $this->load->module('layout');

        $this->load->model('production/mdl_quotes');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'production_id' => $this->input->post('production_id'),
            'production' => $this->mdl_quotes->where('ip_production.production_id', $this->input->post('production_id'))->get()->row()
        );

        $this->layout->load_view('production/modal_copy_quote', $data);
    }

    public function copy_quote()
    {
        $this->load->model('production/mdl_quotes');
        $this->load->model('production/mdl_quote_items');
        $this->load->model('production/mdl_quote_tax_rates');

        if ($this->mdl_quotes->run_validation()) {
            $target_id = $this->mdl_quotes->save();
            $source_id = $this->input->post('production_id');

            $this->mdl_quotes->copy_quote($source_id, $target_id);

            $response = array(
                'success' => 1,
                'production_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_quote_to_invoice($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('production/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'production_id' => $quote_id,
            'production' => $this->mdl_quotes->where('ip_production.production_id', $quote_id)->get()->row()
        );

        $this->load->view('production/modal_quote_to_invoice', $data);
    }

    public function quote_to_invoice()
    {
        $this->load->model(
            array(
                'invoices/mdl_invoices',
                'invoices/mdl_items',
                'production/mdl_quotes',
                'production/mdl_quote_items',
                'invoices/mdl_invoice_tax_rates',
                'production/mdl_quote_tax_rates'
            )
        );
        /*$this->load->model(
            array(
                'quotes/mdl_quotes',
                'quotes/mdl_items',
                'production/mdl_quotes',
                'production/mdl_quote_items',
                'quotes/mdl_quote_tax_rates',
                'production/mdl_quote_tax_rates'
            )
        );*/

        if ($this->mdl_invoices->run_validation()) {
            // DO OWN CODE TO CONVERT EOL -> QUOTE
            $oq_res = $this->db->query("SELECT * FROM ip_production ioq
                LEFT JOIN ip_production_amounts ioqa ON ioqa.production_id = ioq.production_id
                LEFT JOIN ip_production_custom ioqc ON ioqc.production_id = ioq.production_id
                WHERE ioq.production_id = ".$this->input->post('production_id'))->result_array();

            $oqtax_res = $this->db->query("SELECT * FROM ip_production_tax_rates WHERE production_id = ".$this->input->post('production_id'))->result_array();

            $oqitems_res = $this->db->query("SELECT * FROM ip_production_items WHERE production_id = ".$this->input->post('production_id'))->result_array();

            foreach ($oqitems_res as $item) {
                $oqitems_qtt_res[] = $this->db->query("SELECT * FROM ip_production_item_amounts WHERE item_id = ".$item['item_id'] )->result_array();
            }

            $quo_exp_days = $this->db->query("SELECT * FROM ip_settings WHERE setting_key = 'quotes_expire_after'")->result_array();

            $q_max_id_num[] = $this->db->query("SELECT quote_number FROM ip_quotes order by quote_date_created desc limit 1 ")->result_array();
            $num = $q_max_id_num[0][0]['quote_number'];
            $num = substr($num, 1);
            $num = (int)$num;
            $num++;

            //GET EXPIRE QUOTE DATE TO CALCULATE NOW+EXPIRE TIMER
            /*$isrt_quo = $this->db->query("INSERT INTO ip_quotes (invoice_id, user_id, client_id, invoice_group_id, quote_status_id, quote_date_created,
            quote_date_modified, quote_date_expires, quote_number, quote_discount_amount, quote_discount_percent, quote_url_key,
            quote_password, notes) VALUES
             (0, ".$oq_res[0]['user_id'].", ".$oq_res[0]['client_id'].", ".$this->input->post('invoice_group_id').", 1, now(),
                now(), NOW() + INTERVAL ".$quo_exp_days[0]['setting_value']." DAY, 'D".$num."', ".$oq_res[0]['online_quote_discount_amount'].", ".$oq_res[0]['online_quote_discount_percent'].", '".$oq_res[0]['online_quote_url_key']."',
            '".$this->input->post('invoice_password')."', '".$oq_res[0]['notes']."' )");

            $q_max_id[] = $this->db->query("SELECT max(quote_id) as id FROM ip_quotes ")->result_array();

            if( !is_null($oq_res[0]['quote_custom_id']) && $oq_res[0]['quote_custom_id'] != "")
            {
                $isrt_quo_cstm = $this->db->query("INSERT INTO ip_quote_custom (quote_custom_id, quote_id) VALUES ( ".$oq_res[0]['online_quote_custom_id'].", ".$q_max_id[0][0]['id'].")");
            }
            if( !is_null($oq_res[0]['online_quote_amount_id']) && $oq_res[0]['online_quote_amount_id'] != "")
            {
                $isrt_quo_amnt = $this->db->query("INSERT INTO ip_quote_amounts (quote_id, quote_item_subtotal, quote_item_tax_total, quote_total) VALUES
                    ( ".$q_max_id[0][0]['id'].", '".$oq_res[0]['online_quote_item_subtotal']."', '".$oq_res[0]['online_quote_item_tax_total']."', '".$oq_res[0]['online_quote_total']."')");
            }

            foreach ($oqtax_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_tax_rates (quote_id, tax_rate_id, include_item_tax, quote_tax_rate_amount) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['tax_rate_id'].", ".$item['include_item_tax'].", ".$item['online_quote_tax_rate_amount']." )");
            }

            foreach ($oqitems_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_items (quote_id, item_tax_rate_id, item_date_added, item_name, item_description,
                        item_quantity, item_price, item_discount_amount, item_order) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['item_tax_rate_id'].", '".$item['item_date_added']."', '".$item['item_name']."', '".$item['item_description']."',
                        '".$item['item_quantity']."', '".$item['item_price']."', '".$item['item_discount_amount']."', ".$item['item_order']." )");

                $q_itm_max_id[] = $this->db->query("SELECT max(item_id) as id FROM ip_quote_items ")->result_array();

                foreach ($oqitems_qtt_res as $itm) {
                    if($itm[0]['item_id'] == $item['item_id'])
                    {
                        $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) VALUES
                        (".$itm[0]['item_id'].", ".$itm[0]['item_subtotal'].", '".$itm[0]['item_tax_total']."', '".$itm[0]['item_discount']."', '".$itm[0]['item_total']."')");
                    }
                }
            }*/

            $response = array(
                'success' => 1,
                'quote_id' => $q_max_id[0][0]['id']
            );

            echo json_encode($response);
            break;
            /*//$invoice_id = $this->mdl_invoices->create(NULL, FALSE);
            $invoice_id = $this->mdl_quotes->create(NULL);

            $this->db->where('online_quote_id', $this->input->post('online_quote_id'));
            $this->db->set('quote_id', $invoice_id);
            $this->db->update('ip_online_quotes');

            $quote_items = $this->mdl_quote_items->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_items as $quote_item) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'item_tax_rate_id' => $quote_item->item_tax_rate_id,
                    'item_name' => $quote_item->item_name,
                    'item_description' => $quote_item->item_description,
                    'item_quantity' => $quote_item->item_quantity,
                    'item_price' => $quote_item->item_price,
                    'item_order' => $quote_item->item_order
                );

                $this->mdl_items->save($invoice_id, NULL, $db_array);
            }

            $quote_tax_rates = $this->mdl_quote_tax_rates->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_tax_rates as $quote_tax_rate) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'tax_rate_id' => $quote_tax_rate->tax_rate_id,
                    'include_item_tax' => $quote_tax_rate->include_item_tax,
                    'invoice_tax_rate_amount' => $quote_tax_rate->quote_tax_rate_amount
                );

                $this->mdl_invoice_tax_rates->save($invoice_id, NULL, $db_array);
            }

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );*/
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_production_to_transport($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('quotes/mdl_quotes');

        $production_id = substr($quote_id, strpos($quote_id, "_") + 1);
        $quote_id = substr($quote_id, 0, strpos($quote_id, "_") );

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'quote_id' => $quote_id,
            'production_id' => $production_id,
            'quote' => $this->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row()
        );

        $this->load->view('production/modal_production_to_transport', $data);
    }

    public function modal_production_to_transport_2($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('production/mdl_quotes');

        $production_id = substr($quote_id, strpos($quote_id, "_") + 1);
        $quote_id = substr($quote_id, 0, strpos($quote_id, "_") );

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'production_id' => $quote_id,
            'quote_id' => $production_id,
            'production' => $this->mdl_quotes->where('ip_production.production_id', $quote_id)->get()->row()
        );

        $this->load->view('production/modal_production_to_transport_2', $data);
    }

    public function modal_print_notes($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('quotes/mdl_quotes');
        $this->load->model('production/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'quote_id' => $quote_id,
            'quote' => $this->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row()
        );

        $this->load->view('production/modal_print_notes', $data);
    }

    public function modal_print_notes_services($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('quotes/mdl_quotes');
        $this->load->model('production/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'quote_id' => $quote_id,
            'quote' => $this->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row()
        );

        $this->load->view('production/modal_print_notes_services', $data);
    }

    public function production_to_transport()
    {
        $this->load->model('bon_livraison/mdl_quotes');

        $q_num[] = $this->db->query("SELECT quote_number, client_id, delivery, quote_delivery_id FROM ip_quotes WHERE quote_id = " . $this->input->post('quote_id'))->result_array();
        $quote_num = $q_num[0][0]['quote_number'];
        $nm_cst_id = $q_num[0][0]['client_id'];

        $t_max_id_num[] = $this->db->query("SELECT max(transport_number) as transport_number FROM ip_transport")->result_array();
        $num = $t_max_id_num[0][0]['transport_number'];
        $num = substr($num, 2);
        $num = (int)$num;
        $num++;

        $ps[] = $this->db->query("SELECT production_supplier, notes2, notes3 FROM ip_production WHERE origin_quote = '" . $quote_num . "'")->result_array();
        $prd_spl = $ps[0][0]['production_supplier'];
        $prd_n2 = $ps[0][0]['notes2'];
        $prd_n3 = $ps[0][0]['notes3'];

        $year_create = '';
        $month_create = '';
        $day_create = '';

        $is_slash_create = substr($this->input->post('transport_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $day_create = substr($this->input->post('transport_date_created'), 0, 2);
            $month_create = substr($this->input->post('transport_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('transport_date_created');
        }

        $updt_bl = $this->db->query( "INSERT INTO ip_transport (user_id, client_id, invoice_group_id, transport_status_id, 
                                                                transport_date_created, transport_date_expires, 
                                                                transport_number, pack, box, transporter,
                                                                license_plate, tracking_code, weight, owner,
                                                                origin_quote, production_supplier, delivery, quote_delivery_id)
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', '".$date_create."', 
                                                  'BL".$num."', 0, 0, 0,
                                                  '', '', '', ".$this->input->post('user_id').",
                                                  '".$quote_num."', ".$prd_spl.", ".$q_num[0][0]['delivery'].", ".$q_num[0][0]['quote_delivery_id'].")" );

        $q_max_id[] = $this->db->query("SELECT max(transport_id) as id FROM ip_transport ")->result_array();

        $quo_slct[] = $this->db->query("SELECT quote_id, notes, quote_transporter, box_qtt, is_box, ups_std_cst, ups_xprs_cst, dpd_cst, plt_cst FROM ip_quotes WHERE quote_number = '".$quote_num."' limit 1 ")->result_array();
        $quo_id = $quo_slct[0][0]['quote_id'];
        $trnsp_id = $quo_slct[0][0]['quote_transporter'];

        if( $quo_slct[0][0]['is_box'] == 0 )
        {
            $bx_qtt = 0;
            $plt_qtt = $quo_slct[0][0]['box_qtt'];
            $prc_cst = $quo_slct[0][0]['plt_cst'];
        }
        else
        {
            $bx_qtt = $quo_slct[0][0]['box_qtt'];
            $plt_qtt = 0;
            switch ($quo_slct[0][0]['quote_transporter']) {
                case 6:
                    $prc_cst = $quo_slct[0][0]['ups_std_cst'];
                    break;
                case 7:
                    $prc_cst = $quo_slct[0][0]['dpd_cst'];
                    break;
                case 12:
                    $prc_cst = $quo_slct[0][0]['ups_xprs_cst'];
                    break;
                default:
                    $prc_cst = 0;
                    break;
            }
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('BX QTT BL: ".$bx_qtt."', now() )" );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('PLT QTT BL: ".$plt_qtt."', now() )" );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('PRC BL: ".$prc_cst."', now() )" );
        }

        $c_slct[] = $this->db->query("SELECT production_id FROM ip_production WHERE origin_quote = '".$quote_num."' limit 1 ")->result_array();
        $c_id = $c_slct[0][0]['production_id'];

        //$prd_lst = $this->db->query("SELECT * FROM ip_quote_items WHERE quote_id = ".$quo_id." ")->result_array();
        $prd_lst = $this->db->query("SELECT * FROM ip_production_items WHERE production_id = ".$c_id." ")->result_array();

        $date_add = date('Y-m-d');
        $tot_wgt = 0;
        $tot_hgt = 0;

        foreach ($prd_lst as $item)
        {
            unset($wgt_sku);
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('QTT BL: ".$item['item_quantity']."', now() )" );

            $isrt_bl_prd = $this->db->query( "INSERT INTO ip_transport_items (transport_id, item_tax_rate_id, 
                                              item_date_added, item_name, item_description, 
                                              item_quantity, item_price, item_discount_amount, item_order,
                                              item_logo, item_color_num, item_bat_num)  
                                          VALUES
                                              (".$q_max_id[0][0]['id'].", 0, 
                                              '".$date_add."', '".$item['item_name']."', '".$item['item_description']."',
                                              ".$item['item_quantity'].", '0.00', '0.00', ".$item['item_order'].",
                                              '".$item['item_price']."', '".$item['item_discount_amount']."', '".$item['item_tax_rate_id']."' )" );

            $wgt_sku[] = $this->db->query("SELECT wgt, stage, height FROM ip_products WHERE product_sku = '".$item['item_description']."' limit 1 ")->result_array();

            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('WGT1 [0][0] BL: ".$wgt_sku[0][0]['wgt']."', now() )" );
            //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('STAGE1 [0][0] BL: ".$wgt_sku[0][0]['stage']."', now() )" );

            if($wgt_sku[0][0]['wgt'] != '0.00' && $wgt_sku[0][0]['wgt'] != 0 && $wgt_sku[0][0]['wgt'] != NULL && $wgt_sku[0][0]['wgt'] != "")
            {
                $tot_wgt = $tot_wgt + ( $wgt_sku[0][0]['wgt'] * $item['item_quantity'] );
            }

            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTWGT BL: ".$tot_wgt."', now() )" );

            /*$tot_hgt = $tot_hgt + ( $wgt_sku[0][0]['height'] * ( ceil($item['item_quantity'] / $wgt_sku[0][0]['stage']) ) );
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTHGT BL: ".$tot_hgt."', now() )" );*/
        }

        $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('AFTER FOREACH', now() )" );        

        $tot_wgt = number_format( ceil($tot_wgt / 1000), 2 );
        /*if( $tot_hgt != 0 AND $tot_hgt != NULL AND $tot_hgt != '')
        {
            $tot_hgt = ceil($tot_hgt / 220);
        }
        else
        {
            $tot_hgt = 0;
        }*/

        $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTWGT ROUND: ".$tot_wgt."', now() )" );

        $quo_slct[0][0]['notes'] = str_replace("'", "´", $quo_slct[0][0]['notes']);
        $prd_n2 = str_replace("'", "´", $prd_n2);
        $prd_n3 = str_replace("'", "´", $prd_n3);

        //$updt_bl = $this->db->query( "UPDATE ip_transport SET weight = ".$tot_wgt.", notes = '".$quo_slct[0][0]['notes']."', notes_logistic = '".$quo_slct[0][0]['notes2']."', pack = ".$tot_hgt.", transporter = ".$trnsp_id." WHERE transport_id = ".$q_max_id[0][0]['id'] );
        //$updt_bl = $this->db->query( "UPDATE ip_transport SET weight = '".$tot_wgt."', notes = '".$prd_n2."', notes_logistic = '".$prd_n3."', pack = ".$tot_hgt.", transporter = ".$trnsp_id." WHERE transport_id = ".$q_max_id[0][0]['id'] );
        $updt_bl = $this->db->query( "UPDATE ip_transport SET weight = '".$tot_wgt."', notes = '".$prd_n2."', notes_logistic = '".$prd_n3."', transporter = ".$trnsp_id.", pack = ".$plt_qtt.", box = ".$bx_qtt.", tracking_inner_price = '".$prc_cst."' WHERE transport_id = ".$q_max_id[0][0]['id'] );

        $response = array(
            'success' => 1,
            'transport_id' => $q_max_id[0][0]['id']
        );

        echo json_encode($response);
    }

    public function production_to_transport_2()
    {
        $this->load->model('bon_livraison/mdl_quotes');

        $q_num[] = $this->db->query("SELECT production_id, production_number, client_id, production_supplier, notes2, notes3 FROM ip_production WHERE production_id = " . $this->input->post('quote_id'))->result_array();
        $quote_num = $q_num[0][0]['production_number'];
        $nm_cst_id = $q_num[0][0]['client_id'];
        $prd_spl = $q_num[0][0]['production_supplier'];
        $quo_id = $q_num[0][0]['production_id'];
        $quo_slct[0][0]['notes'] = str_replace("'", "´", $q_num[0][0]['notes2']);
        $quo_slct[0][0]['notes2'] = str_replace("'", "´", $q_num[0][0]['notes3']);

        $t_max_id_num[] = $this->db->query("SELECT max(transport_number) as transport_number FROM ip_transport")->result_array();
        $num = $t_max_id_num[0][0]['transport_number'];
        $num = substr($num, 2);
        $num = (int)$num;
        $num++;
        

        $year_create = '';
        $month_create = '';
        $day_create = '';

        $is_slash_create = substr($this->input->post('transport_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $day_create = substr($this->input->post('transport_date_created'), 0, 2);
            $month_create = substr($this->input->post('transport_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('transport_date_created');
        }

        $updt_bl = $this->db->query( "INSERT INTO ip_transport (user_id, client_id, invoice_group_id, transport_status_id, 
                                                                transport_date_created, transport_date_expires, 
                                                                transport_number, pack, box, transporter,
                                                                license_plate, tracking_code, weight, owner,
                                                                origin_quote, production_supplier)
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', '".$date_create."', 
                                                  'BL".$num."', 0, 0, 0,
                                                  '', '', '', ".$this->input->post('user_id').",
                                                  '".$quote_num."', ".$prd_spl.")" );

        $q_max_id[] = $this->db->query("SELECT max(transport_id) as id FROM ip_transport ")->result_array();

        $trnsp_id = 6;

        $prd_lst = $this->db->query("SELECT * FROM ip_production_items WHERE production_id = ".$quo_id." ")->result_array();

        $date_add = date('Y-m-d');
        $tot_wgt = 0;
        $tot_hgt = 0;

        foreach ($prd_lst as $item)
        {
            unset($wgt_sku);
            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('QTT BL: ".$item['item_quantity']."', now() )" );

            $isrt_bl_prd = $this->db->query( "INSERT INTO ip_transport_items (transport_id, item_tax_rate_id, 
                                              item_date_added, item_name, item_description, 
                                              item_quantity, item_price, item_discount_amount, item_order) 
                                          VALUES
                                              (".$q_max_id[0][0]['id'].", 0, 
                                              '".$date_add."', '".$item['item_name']."', '".$item['item_description']."',
                                              ".$item['item_quantity'].", '0.00', '0.00', ".$item['item_order']." )" );

            $wgt_sku[] = $this->db->query("SELECT wgt, stage, height FROM ip_products WHERE product_sku = '".$item['item_description']."' limit 1 ")->result_array();

            $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('WGT1 [0][0] BL: ".$wgt_sku[0][0]['wgt']."', now() )" );
            //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('STAGE1 [0][0] BL: ".$wgt_sku[0][0]['stage']."', now() )" );

            if($wgt_sku[0][0]['wgt'] != '0.00' && $wgt_sku[0][0]['wgt'] != 0 && $wgt_sku[0][0]['wgt'] != NULL && $wgt_sku[0][0]['wgt'] != "")
            {
                $tot_wgt = $tot_wgt + ( $wgt_sku[0][0]['wgt'] * $item['item_quantity'] );
            }

            //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTWGT BL: ".$tot_wgt."', now() )" );

            //$tot_hgt = $tot_hgt + ( $wgt_sku[0][0]['height'] * ( ceil($item['item_quantity'] / $wgt_sku[0][0]['stage']) ) );
            //$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTHGT BL: ".$tot_hgt."', now() )" );
        }

        $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('AFTER FOREACH', now() )" );        

        $tot_wgt = number_format( ceil($tot_wgt / 1000), 2 );
        /*if( $tot_hgt != 0 AND $tot_hgt != NULL AND $tot_hgt != '')
        {
            $tot_hgt = ceil($tot_hgt / 220);
        }
        else
        {
            $tot_hgt = 0;
        }*/

        $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) VALUES ('TOTWGT ROUND: ".$tot_wgt."', now() )" );
 
        $quo_slct[0][0]['notes'] = str_replace("'", "´", $quo_slct[0][0]['notes']);
        $quo_slct[0][0]['notes2'] = str_replace("'", "´", $quo_slct[0][0]['notes2']);

        //$updt_bl = $this->db->query( "UPDATE ip_transport SET weight = ".$tot_wgt.", notes = '".$quo_slct[0][0]['notes']."', notes_logistic = '".$quo_slct[0][0]['notes2']."', pack = ".$tot_hgt.", transporter = ".$trnsp_id." WHERE transport_id = ".$q_max_id[0][0]['id'] );
        $updt_bl = $this->db->query( "UPDATE ip_transport SET weight = '".$tot_wgt."' WHERE transport_id = ".$q_max_id[0][0]['id'] );
        $updt_bl = $this->db->query( "UPDATE ip_transport SET transporter = ".$trnsp_id." WHERE transport_id = ".$q_max_id[0][0]['id'] );
        $updt_bl = $this->db->query( "UPDATE ip_transport SET notes = '".$quo_slct[0][0]['notes']."' WHERE transport_id = ".$q_max_id[0][0]['id'] );
        $updt_bl = $this->db->query( "UPDATE ip_transport SET notes_logistic = '".$quo_slct[0][0]['notes2']."' WHERE transport_id = ".$q_max_id[0][0]['id'] );

        $response = array(
            'success' => 1,
            'transport_id' => $q_max_id[0][0]['id']
        );

        echo json_encode($response);
    }

}
