<div class="table-responsive">
    <?php
    //print_r($this);
    $quotes = $this->view_data['online_quotes'];
    if($quotes == "" || is_null($quotes) )
    {
        $quotes = $this->_ci_cached_vars['online_quotes'];
    }?>
    <table class="table table-striped">

        <thead>
        <tr style="background-color: #ededed;">
            <th><?php echo lang('status'); ?></th>
            <th><?php echo lang('online_quote'); ?></th>
            <th><?php echo lang('created'); ?></th>
            <th><?php echo lang('due_date'); ?></th>
            <th><?php echo lang('personal_information'); ?></th>
            <th><?php echo lang('zip_code_city'); ?></th>
            <th><?php echo lang('comercial'); ?></th>
            <th style="text-align: right; padding-right: 25px;"><?php echo lang('amount_ht_net'); ?></th>
            <th><?php echo lang('options'); ?></th>
        </tr>
        </thead>

        <tbody>
        <?php foreach ($quotes as $quote) { ?>
            <tr>
                <td>
                    <?php if (strpos($_SERVER['REQUEST_URI'], 'online_quotes') !== false) { ?>
                        <span class="label <?php echo $online_quote_statuses[$quote->online_quote_status_id]['class']; ?>"><?php echo $online_quote_statuses[$quote->online_quote_status_id]['label']; ?></span>
                    <?php } else {
                        if($quote->online_quote_status_id == 1)
                        {
                            echo '<span class="label draft">A Traiter</span>';
                        }
                        elseif($quote->online_quote_status_id == 4)
                        {
                            echo '<span class="label approved">Traité</span>';
                        }
                        elseif($quote->online_quote_status_id == 5)
                        {
                            echo '<span class="label rejected">Annulé</span>';
                        }
                    } ?>
                </td>
                <td>
                    <a href="<?php echo site_url('online_quotes/view/' . $quote->online_quote_id); ?>"
                       title="<?php echo lang('edit'); ?>">
                        <?php echo $quote->online_quote_number; ?>
                    </a>
                </td>
                <td>
                    <?php echo date_from_mysql($quote->online_quote_date_created);//echo $quote->online_quote_date_created;//echo date_from_mysql($quote->online_quote_date_created); ?>
                </td>
                <td>
                    <?php echo date_from_mysql($quote->online_quote_date_expires);//$quote->online_quote_date_expires;//echo date_from_mysql($quote->online_quote_date_expires); ?>
                </td>
                <td>
                    <a href="<?php echo site_url('clients/view/' . $quote->client_id); ?>"
                       title="<?php echo lang('view_client'); ?>">
                        <?php echo $quote->client_name; ?>
                    </a>
                </td>
                <td>
                    <?php echo anchor('clients/view/' . $quote->client_id, $quote->client_zip.' - '.$quote->client_city.' - '.$quote->client_country); ?>
                </td>
                <td>
                        <?php
                            if($quote->user_id != 0 && $quote->user_id != 1)
                            {
                                $ownr = $this->db->query("SELECT user_name FROM ip_users WHERE user_id = ".$quote->user_id )->result_array();
                                echo $ownr[0]['user_name'];
                            }
                        ?>
                </td>
                <td style="text-align: right; padding-right: 25px;">
                    <?php //echo format_currency($quote->quote_total); ?>
                    <?php echo format_currency($quote->quote_item_subtotal); ?>
                </td>
                <td>
                    <div class="options btn-group">
                        <a class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown"
                           href="#">
                            <i class="fa fa-cog"></i> <?php echo lang('options'); ?>
                        </a>
                        <ul class="dropdown-menu">
                            <li>
                                <a href="<?php echo site_url('online_quotes/view/' . $quote->online_quote_id); ?>">
                                    <i class="fa fa-edit fa-margin"></i> <?php echo lang('edit'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo site_url('online_quotes/generate_pdf/' . $quote->online_quote_id); ?>"
                                   target="_blank">
                                    <i class="fa fa-file-pdf-o fa-margin"></i> <?php echo lang('download_pdf'); ?>
                                </a>
                            </li>
                            <li>
                                <?php /*<a href="<?php echo site_url('mailer/online_quote/' . $quote->online_quote_id); ?>">
                                    <i class="fa fa-send fa-margin"></i> <?php echo lang('send_email'); ?>
                                </a>*/?>
                                <?php
                                $subject = sprintf(lang('eol_email_subject'),
                                    $quote->online_quote_number
                                );
                                $body = sprintf(nl2br(lang('eol_email_body')),
                                    $quote->online_quote_number
                                );
                                $body = str_replace('<spc>', '%0D%0A', $body);
                                ?>
                                <a href="mailto:<?php echo $quote->client_email;?>?Subject=<?php echo $subject; ?>&Body=<?php echo $body; ?>">
                                    <i class="fa fa-send fa-margin"></i> <?php echo lang('send_email'); ?>
                                </a>
                            </li>
                            <!-- <li>
                                <a href="<?php echo site_url('online_quotes/delete/' . $quote->online_quote_id); ?>"
                                   onclick="return confirm('<?php echo lang('delete_quote_warning'); ?>');">
                                    <i class="fa fa-trash-o fa-margin"></i> <?php echo lang('delete'); ?>
                                </a>
                            </li> -->
                        </ul>
                    </div>
                </td>
            </tr>
        <?php } ?>
        </tbody>

    </table>
</div>