<script type="text/javascript">
    $(function () {
        // Display the create quote modal
        //console.log('clicked');
        $('#create-quote').modal('show');

        $('#create-quote').on('shown', function () {
            $("#client_name").focus();
        });

        $().ready(function () {
            $("[name='client_name']").select2({
                createSearchChoice: function (term, data) {
                    if ($(data).filter(function () {
                            return this.text.localeCompare(term) === 0;
                        }).length === 0) {
                        return {id: term, text: term};
                    }
                },
                multiple: false,
                allowClear: true,
                data: [
                    <?php
                    $i=0;
                    foreach ($clients as $client){
                        echo "{
                        id: '".str_replace("","",$client->client_name)."',
                        text: '".str_replace("","",$client->client_name)."'
                        }";
                        if (($i+1) != count($clients)) echo ',';
                        $i++;
                    }
                    ?>
                ]
            });
            $("#client_name").focus();
        });

        // Creates the quote
        $('#online_quote_create_confirm').click(function () {
            //console.log('clicked');
            // Posts the data to validate and create the quote;
            // will create the new client if necessary
            $.post("<?php echo site_url('online_quotes/ajax/create'); ?>", {
                    client_name: $('#client_name').val(),
                    online_quote_date_created: $('#quote_date_created').val(),
                    online_quote_password: $('#quote_password').val(),
                    user_id: '<?php echo $this->session->userdata('user_id'); ?>',
                    invoice_group_id: $('#invoice_group_id').val()
                },
                function (data) {
                    //console.log(data);
                    var response = JSON.parse(data);
                    if (response.success == '1') {
                        // The validation was successful and quote was created
                        window.location = "<?php echo site_url('online_quotes/view'); ?>/" + response.quote_id;
                    }
                    else {
                        // The validation was not successful
                        $('.control-group').removeClass('has-error');
                        for (var key in response.validation_errors) {
                            $('#' + key).parent().parent().addClass('has-error');
                        }
                    }
                });
            //console.log('clicked2');
        });
    });

</script>

<div id="create-quote" class="modal col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2"
     role="dialog" aria-labelledby="modal_create_quote" aria-hidden="true">
    <form class="modal-content">
        <div class="modal-header">
            <a data-dismiss="modal" class="close"><i class="fa fa-close"></i></a>

            <!-- <h3><?php //echo lang('create_online_quote'); ?></h3>-->
        </div>
        <div class="modal-body">

            <div class="form-group">
                <label for="client_name"><?php echo lang('client'); ?></label>
                <input type="text" name="client_name" id="client_name" class="form-control"
                       autofocus="autofocus"
                    <?php if ($client_name) echo 'value="' . html_escape($client_name) . '"'; ?>>
            </div>

            <div class="form-group has-feedback">
                <label for="quote_date_created">
                    <?php echo lang('online_quote_date'); ?>
                </label>

                <div class="input-group">
                    <input name="online_quote_date_created" id="online_quote_date_created"
                           class="form-control datepicker"
                           value="<?php echo date(date_format_setting()); ?>">
										<span class="input-group-addon">
												<i class="fa fa-calendar fa-fw"></i>
										</span>
                </div>
            </div>

            <div class="form-group">
                <label for="online_quote_password"><?php echo lang('online_quote_password'); ?></label>
                <input type="text" name="online_quote_password" id="online_quote_password" class="form-control"
                       value="<?php if ($this->mdl_settings->setting('quote_pre_password') == '') {
                           echo '';
                       } else {
                           echo $this->mdl_settings->setting('quote_pre_password');
                       } ?>" style="margin: 0 auto;" autocomplete="off">
            </div>

            <div class="form-group">
                <label for="invoice_group_id"><?php echo lang('invoice_group'); ?>: </label>

                <div class="controls">
                    <select name="invoice_group_id" id="invoice_group_id"
                            class="form-control">
                        <option value=""></option>
                        <?php foreach ($invoice_groups as $invoice_group) { ?>
                            <option value="<?php echo $invoice_group->invoice_group_id; ?>"
                                    <?php if ($this->mdl_settings->setting('default_quote_group') == $invoice_group->invoice_group_id) { ?>selected="selected"<?php } ?>><?php echo $invoice_group->invoice_group_name; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>

        </div>

        <div class="modal-footer">
            <div class="btn-group">
                <button class="btn btn-danger" type="button" data-dismiss="modal">
                    <i class="fa fa-times"></i> <?php echo lang('cancel'); ?>
                </button>
                    <i class="fa fa-check"></i> <?php echo lang('submit'); ?>
                <button class="btn btn-success ajax-loader" id="online_quote_create_confirm" type="button">
                </button>
            </div>
        </div>

    </form>

</div>
