<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



/*

 * InvoicePlane

 *

 * A free and open source web based invoicing system

 *

 * @package		InvoicePlane

 * @author		Kovah (www.kovah.de)

 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com

 * @license		https://invoiceplane.com/license.txt

 * @link		https://invoiceplane.com

 *

 */



class Mdl_Online_Dashboard extends CI_Model

{

    public function get_online_status_totals($period = '')

    {

        switch ($period) {

            case 'this-month':

                $results = $this->db->query("

                    SELECT online_quote_status_id,

                    SUM(online_quote_total) AS sum_total,

                    COUNT(*) AS num_total

                    FROM ip_online_quote_amounts

                    JOIN ip_online_quotes ON ip_online_quotes.online_quote_id = ip_online_quote_amounts.online_quote_id

                    AND MONTH(ip_online_quotes.online_quote_date_created) = MONTH(NOW())

                    AND YEAR(ip_online_quotes.online_quote_date_created) = YEAR(NOW())

                    GROUP BY ip_online_quotes.online_quote_status_id")->result_array();

                break;

            case 'last-month':

                $results = $this->db->query("

                    SELECT online_quote_status_id,

                    SUM(online_quote_total) AS sum_total,

                    COUNT(*) AS num_total

                    FROM ip_online_quote_amounts

                    JOIN ip_online_quotes ON ip_online_quotes.online_quote_id = ip_online_quote_amounts.online_quote_id

                    AND MONTH(ip_online_quotes.online_quote_date_created) = MONTH(NOW() - INTERVAL 1 MONTH)

                    AND YEAR(ip_online_quotes.online_quote_date_created) = YEAR(NOW())

                    GROUP BY ip_online_quotes.online_quote_status_id")->result_array();

                break;

            default:

            case 'this-quarter':

                $results = $this->db->query("

                    SELECT online_quote_status_id,

                    SUM(online_quote_total) AS sum_total,

                    COUNT(*) AS num_total

                    FROM ip_online_quote_amounts

                    JOIN ip_online_quotes ON ip_online_quotes.online_quote_id = ip_online_quote_amounts.online_quote_id

                    AND QUARTER(ip_online_quotes.online_quote_date_created) = QUARTER(NOW())

                    GROUP BY ip_online_quotes.online_quote_status_id")->result_array();

                break;

            case 'last-quarter':

                $results = $this->db->query("

                    SELECT online_quote_status_id,

                    SUM(online_quote_total) AS sum_total,

                    COUNT(*) AS num_total

                    FROM ip_online_quote_amounts

                    JOIN ip_online_quotes ON ip_online_quotes.online_quote_id = ip_online_quote_amounts.online_quote_id

                    AND QUARTER(ip_online_quotes.online_quote_date_created) = QUARTER(NOW() - INTERVAL 1 QUARTER)

                    GROUP BY ip_online_quotes.online_quote_status_id")->result_array();

                break;

            case 'this-year':

                $results = $this->db->query("

                    SELECT online_quote_status_id,

                    SUM(online_quote_total) AS sum_total,

                    COUNT(*) AS num_total

                    FROM ip_online_quote_amounts

                    JOIN ip_online_quotes ON ip_online_quotes.online_quote_id = ip_online_quote_amounts.online_quote_id

                    AND YEAR(ip_online_quotes.online_quote_date_created) = YEAR(NOW())

                    GROUP BY ip_online_quotes.online_quote_status_id")->result_array();

                break;

            case 'last-year':

                $results = $this->db->query("

                    SELECT online_quote_status_id,

                    SUM(online_quote_total) AS sum_total,

                    COUNT(*) AS num_total

                    FROM ip_online_quote_amounts

                    JOIN ip_online_quotes ON ip_online_quotes.online_quote_id = ip_online_quote_amounts.online_quote_id

                    AND YEAR(ip_online_quotes.online_quote_date_created) = YEAR(NOW() - INTERVAL 1 YEAR)

                    GROUP BY ip_online_quotes.online_quote_status_id")->result_array();

                break;

        }



        $return = array();



        foreach ($this->mdl_quotes->statuses() as $key => $status) {

            $return[$key] = array(

                'online_quote_status_id' => $key,

                'class' => $status['class'],

                'label' => $status['label'],

                'href' => 'online_'.$status['href'],

                'sum_total' => 0,

                'num_total' => 0

            );

        }



        foreach ($results as $result) {

            $return[$result['online_quote_status_id']] = array_merge($return[$result['online_quote_status_id']], $result);

        }



        return $return;

    }



    public function get_last_online($limit = 10)

    {

        $results = $this->db->query("SELECT SQL_CALC_FOUND_ROWS ip_online_quote_custom.*,

            ip_client_custom.*,

            ip_user_custom.*,

            ip_users.user_name,

			ip_users.user_company,

			ip_users.user_address_1,

			ip_users.user_address_2,

			ip_users.user_city,

			ip_users.user_state,

			ip_users.user_zip,

			ip_users.user_country,

			ip_users.user_phone,

			ip_users.user_fax,

			ip_users.user_mobile,

			ip_users.user_email,

			ip_users.user_web,

			ip_users.user_vat_id,

			ip_users.user_tax_code,

			ip_clients.*,

			ip_online_quote_amounts.online_quote_amount_id,

			IFNULL(ip_online_quote_amounts.online_quote_item_subtotal, '0.00') AS quote_item_subtotal,

			IFNULL(ip_online_quote_amounts.online_quote_item_tax_total, '0.00') AS quote_item_tax_total,

			IFNULL(ip_online_quote_amounts.online_quote_tax_total, '0.00') AS quote_tax_total,

			IFNULL(ip_online_quote_amounts.online_quote_total, '0.00') AS quote_total,

            ip_invoices.invoice_number,

			ip_online_quotes.*

			from ip_online_quotes

			join ip_clients on ip_clients.client_id = ip_online_quotes.client_id

            join ip_users on ip_users.user_id = ip_online_quotes.user_id

            left join ip_online_quote_amounts on ip_online_quote_amounts.online_quote_id = ip_online_quotes.online_quote_id

            left join ip_invoices on ip_invoices.invoice_id = ip_online_quotes.invoice_id

            left join ip_client_custom on ip_client_custom.client_id = ip_clients.client_id

            left join ip_user_custom on ip_user_custom.user_id = ip_users.user_id

            left join ip_online_quote_custom on ip_online_quote_custom.online_quote_id = ip_online_quotes.online_quote_id

            order by ip_online_quotes.online_quote_id DESC

            limit ".$limit."

			")->result_array();



        $return = array();



        foreach ($this->mdl_quotes->statuses() as $key => $status) {

            $return[$key] = array(

                'online_quote_status_id' => $key,

                'class' => $status['class'],

                'label' => $status['label'],

                'href' => 'online_'.$status['href'],

                'sum_total' => 0,

                'num_total' => 0

            );

        }



        $return = $results;

        /*foreach ($results as $result) {

            $return[$result['online_quote_status_id']] = array_merge($return[$result['online_quote_status_id']], $result);

        }*/



        return $return;

    }



    public function online_statuses()

    {

        return array(

            '1' => array(

                'label' => lang('draft'),

                'class' => 'draft',

                'href' => 'online_quotes/status/draft'

            ),

            /*'2' => array(

                'label' => lang('sent'),

                'class' => 'sent',

                'href' => 'online_quotes/status/sent'

            ),

            '3' => array(

                'label' => lang('viewed'),

                'class' => 'viewed',

                'href' => 'online_quotes/status/viewed'

            ),*/

            '4' => array(

                'label' => lang('approved'),

                'class' => 'approved',

                'href' => 'online_quotes/status/approved'

            ),

            '5' => array(

                'label' => lang('canceled'),

                'class' => 'rejected',

                'href' => 'online_quotes/status/rejected'

            )/*,

            '6' => array(

                'label' => lang('canceled'),

                'class' => 'canceled',

                'href' => 'online_quotes/status/canceled'

            )*/

        );

    }



}

