<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->load->model('online_quotes/mdl_quote_items');
        $this->load->model('online_quotes/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');
        $this->load->library('encrypt');

        $quote_id = $this->input->post('online_quote_id');

        //GET PREVIOUS STATE
        $oq_prv_stt = $this->db->query("SELECT online_quote_status_id, client_id FROM ip_online_quotes WHERE online_quote_number = '".$this->input->post('online_quote_number')."'")->result_array();

        $this->mdl_quotes->set_id($quote_id);
        //if ($this->mdl_quotes->run_validation('validation_rules_save_online_quote')) {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
            $items = json_decode($this->input->post('items'));

            foreach ($items as $item) {
                if ($item->item_name) {
                    $item->item_quantity = standardize_amount($item->item_quantity);
                    $item->item_price = standardize_amount($item->item_price);
                    $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                    $item_id = ($item->item_id) ?: NULL;

                    $save_item_as_lookup = (isset($item->save_item_as_lookup)) ? $item->save_item_as_lookup : 0;

                    unset($item->item_id, $item->save_item_as_lookup);

                    $this->mdl_quote_items->save($quote_id, $item_id, $item);

                    if ($save_item_as_lookup) {
                        $db_array = array(
                            'item_name' => $item->item_name,
                            'item_description' => $item->item_description,
                            'item_price' => $item->item_price
                        );

                        $this->mdl_item_lookups->save(NULL, $db_array);
                    }
                }
            }

            //print "before db_array <br />";
            $is_slash_create = substr($this->input->post('online_quote_date_created'), 2, 1);
            if($is_slash_create == "/")
            {//24-02-2016
                /*$year_create = substr($this->input->post('online_quote_date_created'), 6, 9);
                $month_create = substr($this->input->post('online_quote_date_created'), 0, 2);
                $day_create = substr($this->input->post('online_quote_date_created'), 3, 4);
                $day_create = substr($day_create, 0, 2);*/
                $date_create = $year_create."-".$month_create."-".$day_create;
            }
            elseif($is_slash_create == "-")
            {
                $year_create = substr($this->input->post('online_quote_date_created'), 6, 9);
                $day_create = substr($this->input->post('online_quote_date_created'), 0, 2);
                $month_create = substr($this->input->post('online_quote_date_created'), 3, 2);
                $day_create = substr($day_create, 0, 2);
                $date_create = $year_create."-".$month_create."-".$day_create;
            }
            else
            {
                $date_create = $this->input->post('online_quote_date_created');
            }
            $is_slash_expire = substr($this->input->post('online_quote_date_expires'), 2, 1);
            if($is_slash_expire == "/")
            {
                $year_expire = substr($this->input->post('online_quote_date_expires'), 6, 9);
                $month_expire = substr($this->input->post('online_quote_date_expires'), 0, 2);
                $day_expire = substr($this->input->post('online_quote_date_expires'), 3, 4);
                $day_expire = substr($day_expire, 0, 2);
                $date_expire = $year_expire."-".$month_expire."-".$day_expire;
            }
            elseif($is_slash_expire == "-")
            {
                $year_expire = substr($this->input->post('online_quote_date_expires'), 6, 9);
                $day_expire = substr($this->input->post('online_quote_date_expires'), 0, 2);
                $month_expire = substr($this->input->post('online_quote_date_expires'), 3, 2);
                $day_expire = substr($day_expire, 0, 2);
                $date_expire = $year_expire."-".$month_expire."-".$day_expire;
            }
            else
            {
                $date_expire = $this->input->post('online_quote_date_expires');
            }

            // @TODO Add checks / formatting for discounts!
            $db_array = array(
                'online_quote_number' => $this->input->post('online_quote_number'),
                //'online_quote_date_created' => $this->input->post('online_quote_date_created'),
                //'online_quote_date_expires' => $this->input->post('online_quote_date_expires'),
                //'online_quote_date_created' => date_to_mysql($this->input->post('online_quote_date_created')),
                //'online_quote_date_expires' => date_to_mysql($this->input->post('online_quote_date_expires')),
                'online_quote_date_created' => $date_create,
                'online_quote_date_expires' => $date_expire,
                'online_quote_status_id' => $this->input->post('online_quote_status_id'),
                'online_quote_password' => $this->input->post('online_quote_password'),
                'notes' => $this->input->post('notes'),
                'online_quote_discount_amount' => $this->input->post('online_quote_discount_amount'),
                'online_quote_discount_percent' => $this->input->post('online_quote_discount_percent')
            );

            if($oq_prv_stt[0]['online_quote_status_id'] != 4 && $oq_prv_stt[0]['online_quote_status_id'] != 5)
            {
                if($this->input->post('online_quote_status_id') == 4 || $this->input->post('online_quote_status_id') == 5)
                {
                    $c_res = $this->db->query("SELECT * FROM ip_clients WHERE client_id = ".$oq_prv_stt[0]['client_id'])->result_array();
                    
                    $c_res[0]['client_name'] = str_replace("'", "´", $c_res[0]['client_name']);
                    $c_res[0]['client_name_p1'] = str_replace("'", "´", $c_res[0]['client_name_p1']);
                    $c_res[0]['client_address_1'] = str_replace("'", "´", $c_res[0]['client_address_1']);
                    $c_res[0]['client_address_2'] = str_replace("'", "´", $c_res[0]['client_address_2']);
                    $c_res[0]['client_zip'] = str_replace("'", "´", $c_res[0]['client_zip']);
                    $c_res[0]['client_city'] = str_replace("'", "´", $c_res[0]['client_city']);
                    $c_res[0]['client_country'] = str_replace("'", "´", $c_res[0]['client_country']);
                    $c_res[0]['client_vat_id'] = str_replace("'", "´", $c_res[0]['client_vat_id']);
                    $c_res[0]['client_phone'] = str_replace("'", "´", $c_res[0]['client_phone']);
                    $c_res[0]['client_email'] = str_replace("'", "´", $c_res[0]['client_email']);
                    $c_res[0]['client_address_delivery_1'] = str_replace("'", "´", $c_res[0]['client_address_delivery_1']);
                    $c_res[0]['client_address_delivery_2'] = str_replace("'", "´", $c_res[0]['client_address_delivery_2']);
                    $c_res[0]['client_delivery_zip'] = str_replace("'", "´", $c_res[0]['client_delivery_zip']);
                    $c_res[0]['client_delivery_city'] = str_replace("'", "´", $c_res[0]['client_delivery_city']);
                    $c_res[0]['client_delivery_country'] = str_replace("'", "´", $c_res[0]['client_delivery_country']);
                    $c_res[0]['client_delivery_company'] = str_replace("'", "´", $c_res[0]['client_delivery_company']);
                    $c_res[0]['client_delivery_contact'] = str_replace("'", "´", $c_res[0]['client_delivery_contact']);
                    $c_res[0]['client_delivery_phone'] = str_replace("'", "´", $c_res[0]['client_delivery_phone']);

                    $updt_oquo_cstmr = $this->db->query("UPDATE ip_online_quotes SET
                                                    online_client_name = '".$c_res[0]['client_name']."',
                                                    online_client_name_p1 = '".$c_res[0]['client_name_p1']."',
                                                    online_client_address_1 = '".$c_res[0]['client_address_1']."',
                                                    online_client_address_2 = '".$c_res[0]['client_address_2']."',
                                                    online_client_zip = '".$c_res[0]['client_zip']."',
                                                    online_client_city = '".$c_res[0]['client_city']."',
                                                    online_client_country = '".$c_res[0]['client_country']."',
                                                    online_client_vat_id = '".$c_res[0]['client_vat_id']."',
                                                    online_client_phone = '".$c_res[0]['client_phone']."',
                                                    online_client_email = '".$c_res[0]['client_email']."',
                                                    online_client_delivery_address = '".$c_res[0]['client_address_delivery_1']." ".$c_res[0]['client_address_delivery_2']."',
                                                    online_client_delivery_local = '".$c_res[0]['client_delivery_zip']." ".$c_res[0]['client_delivery_city']." ".$c_res[0]['client_delivery_country']."',
                                                    online_client_delivery_company = '".$c_res[0]['client_delivery_company']."',
                                                    online_client_delivery_contact = '".$c_res[0]['client_delivery_contact']."',
                                                    online_client_delivery_phone = '".$c_res[0]['client_delivery_phone']."'
                                                WHERE online_quote_id = ".$this->input->post('online_quote_id'));
                }
            }

            //print "after db_array <br />";

            $this->mdl_quotes->save($quote_id, $db_array);

            //print "after mdl_quotes_save <br />";
            // Recalculate for discounts
            $this->load->model('online_quotes/mdl_quote_amounts');
            //print "after load model <br />";

            $this->mdl_quote_amounts->calculate($quote_id);

            //print "after mdl_quote_amounts calculate <br />";

            $response = array(
                'success' => 1
            );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        if ($this->input->post('custom')) {
            $db_array = array();

            foreach ($this->input->post('custom') as $custom) {
                // I hate myself for this...
                $db_array[str_replace(']', '', str_replace('custom[', '', $custom['name']))] = $custom['value'];
            }

            $this->load->model('custom_fields/mdl_quote_custom');
            $this->mdl_quote_custom->save_custom($quote_id, $db_array);
        }

        //print "<br />";
        //print_r($response);

        echo json_encode($response);
    }

    public function save_quote_tax_rate()
    {
        $this->load->model('online_quotes/mdl_quote_tax_rates');

        if ($this->mdl_quote_tax_rates->run_validation()) {
            $this->mdl_quote_tax_rates->save($this->input->post('online_quote_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_quote_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function create()
    {
        $this->load->model('online_quotes/mdl_quotes');

        /*$response = array(
            'success' => 2,
            'online_quote_id' => 0
        );

        echo json_encode($response);*/

        if ($this->mdl_quotes->run_validation()) {
            $quote_id = $this->mdl_quotes->create();

            $response = array(
                'success' => 1,
                'online_quote_id' => $quote_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'online_quote_id' => $this->input->post('online_quote_id'),
            'clients' => $this->mdl_clients->get()->result(),
        );

        $this->layout->load_view('online_quotes/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('online_quotes/mdl_quotes');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $quote_id = $this->input->post('online_quote_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('online_quote_id', $quote_id);
            $this->db->update('ip_online_quotes', $db_array);

            $response = array(
                'success' => 1,
                'online_quote_id' => $quote_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('online_quotes/mdl_quote_items');

        $item = $this->mdl_quote_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_quote()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'client_name' => $this->input->post('client_name'),
            'clients' => $this->mdl_clients->get()->result(),
        );

        $this->layout->load_view('online_quotes/modal_create_quote', $data);
    }

    public function modal_copy_quote()
    {
        $this->load->module('layout');

        $this->load->model('online_quotes/mdl_quotes');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'online_quote_id' => $this->input->post('online_quote_id'),
            'online_quote' => $this->mdl_quotes->where('ip_online_quotes.online_quote_id', $this->input->post('online_quote_id'))->get()->row()
        );

        $this->layout->load_view('online_quotes/modal_copy_quote', $data);
    }

    public function copy_quote()
    {
        $this->load->model('online_quotes/mdl_quotes');
        $this->load->model('online_quotes/mdl_quote_items');
        $this->load->model('online_quotes/mdl_quote_tax_rates');

        if ($this->mdl_quotes->run_validation()) {
            $target_id = $this->mdl_quotes->save();
            $source_id = $this->input->post('online_quote_id');

            $this->mdl_quotes->copy_quote($source_id, $target_id);

            $response = array(
                'success' => 1,
                'online_quote_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_quote_to_invoice($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('online_quotes/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'online_quote_id' => $quote_id,
            'online_quote' => $this->mdl_quotes->where('ip_online_quotes.online_quote_id', $quote_id)->get()->row()
        );

        $this->load->view('online_quotes/modal_quote_to_invoice', $data);
    }

    public function quote_to_invoice()
    {
        $this->load->model(
            array(
                'invoices/mdl_invoices',
                'invoices/mdl_items',
                'online_quotes/mdl_quotes',
                'online_quotes/mdl_quote_items',
                'invoices/mdl_invoice_tax_rates',
                'online_quotes/mdl_quote_tax_rates'
            )
        );
        /*$this->load->model(
            array(
                'quotes/mdl_quotes',
                'quotes/mdl_items',
                'online_quotes/mdl_quotes',
                'online_quotes/mdl_quote_items',
                'quotes/mdl_quote_tax_rates',
                'online_quotes/mdl_quote_tax_rates'
            )
        );*/

        if ($this->mdl_invoices->run_validation()) {
            // DO OWN CODE TO CONVERT EOL -> QUOTE
            $oq_res = $this->db->query("SELECT * FROM ip_online_quotes ioq
                LEFT JOIN ip_online_quote_amounts ioqa ON ioqa.online_quote_id = ioq.online_quote_id
                LEFT JOIN ip_online_quote_custom ioqc ON ioqc.online_quote_id = ioq.online_quote_id
                WHERE ioq.online_quote_id = ".$this->input->post('online_quote_id'))->result_array();

            $oqtax_res = $this->db->query("SELECT * FROM ip_online_quote_tax_rates WHERE online_quote_id = ".$this->input->post('online_quote_id'))->result_array();

            $oqitems_res = $this->db->query("SELECT * FROM ip_online_quote_items WHERE online_quote_id = ".$this->input->post('online_quote_id'))->result_array();

            foreach ($oqitems_res as $item) {
                $oqitems_qtt_res[] = $this->db->query("SELECT * FROM ip_online_quote_item_amounts WHERE item_id = ".$item['item_id'] )->result_array();
            }

            $quo_exp_days = $this->db->query("SELECT * FROM ip_settings WHERE setting_key = 'quotes_expire_after'")->result_array();

            $q_max_id_num[] = $this->db->query("SELECT quote_number FROM ip_quotes order by quote_id desc limit 1 ")->result_array();
            $num = $q_max_id_num[0][0]['quote_number'];
            $num = substr($num, 1);
            $num = (int)$num;
            $num++;

            //GET EXPIRE QUOTE DATE TO CALCULATE NOW+EXPIRE TIMER
            $isrt_quo = $this->db->query("INSERT INTO ip_quotes (invoice_id, user_id, client_id, invoice_group_id, quote_status_id, quote_date_created,
            quote_date_modified, quote_date_expires, quote_number, quote_discount_amount, quote_discount_percent, quote_url_key,
            quote_password, notes) VALUES
             (0, ".$this->session->userdata('user_id').", ".$oq_res[0]['client_id'].", ".$this->input->post('invoice_group_id').", 1, now(),
                now(), NOW() + INTERVAL ".$quo_exp_days[0]['setting_value']." DAY, 'D".$num."', ".$oq_res[0]['online_quote_discount_amount'].", ".$oq_res[0]['online_quote_discount_percent'].", '".$oq_res[0]['online_quote_url_key']."',
            '".$this->input->post('invoice_password')."', '".$oq_res[0]['notes']."' )");

            $q_max_id[] = $this->db->query("SELECT max(quote_id) as id FROM ip_quotes ")->result_array();

            if( !is_null($oq_res[0]['quote_custom_id']) && $oq_res[0]['quote_custom_id'] != "")
            {
                $isrt_quo_cstm = $this->db->query("INSERT INTO ip_quote_custom (quote_custom_id, quote_id) VALUES ( ".$oq_res[0]['online_quote_custom_id'].", ".$q_max_id[0][0]['id'].")");
            }
            if( !is_null($oq_res[0]['online_quote_amount_id']) && $oq_res[0]['online_quote_amount_id'] != "")
            {
                $isrt_quo_amnt = $this->db->query("INSERT INTO ip_quote_amounts (quote_id, quote_item_subtotal, quote_item_tax_total, quote_total) VALUES
                    ( ".$q_max_id[0][0]['id'].", '".$oq_res[0]['online_quote_item_subtotal']."', '".$oq_res[0]['online_quote_item_tax_total']."', '".$oq_res[0]['online_quote_total']."')");
            }

            foreach ($oqtax_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_tax_rates (quote_id, tax_rate_id, include_item_tax, quote_tax_rate_amount) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['tax_rate_id'].", ".$item['include_item_tax'].", ".$item['online_quote_tax_rate_amount']." )");
            }

            foreach ($oqitems_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_items (quote_id, item_tax_rate_id, item_date_added, item_name, item_description,
                        item_quantity, item_price, item_discount_amount, item_order) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['item_tax_rate_id'].", '".$item['item_date_added']."', '".$item['item_name']."', '".$item['item_description']."',
                        '".$item['item_quantity']."', '".$item['item_price']."', '".$item['item_discount_amount']."', ".$item['item_order']." )");

                $q_itm_max_id[] = $this->db->query("SELECT max(item_id) as id FROM ip_quote_items ")->result_array();

                foreach ($oqitems_qtt_res as $itm) {
                    if($itm[0]['item_id'] == $item['item_id'])
                    {
                        $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) VALUES
                        (".$itm[0]['item_id'].", ".$itm[0]['item_subtotal'].", '".$itm[0]['item_tax_total']."', '".$itm[0]['item_discount']."', '".$itm[0]['item_total']."')");
                    }
                }
            }


            $updt_oquo_owner = $this->db->query("UPDATE ip_online_quotes SET owner = ".$this->session->userdata('user_id')." WHERE online_quote_id = ".$this->input->post('online_quote_id'));
            $updt_oquo_stts = $this->db->query("UPDATE ip_online_quotes SET online_quote_status_id = 4 WHERE online_quote_id = ".$this->input->post('online_quote_id'));

            /*$response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );*/
            $response = array(
                'success' => 1,
                'quote_id' => $q_max_id[0][0]['id']
            );

            echo json_encode($response);
            break;
            /*//$invoice_id = $this->mdl_invoices->create(NULL, FALSE);
            $invoice_id = $this->mdl_quotes->create(NULL);

            $this->db->where('online_quote_id', $this->input->post('online_quote_id'));
            $this->db->set('quote_id', $invoice_id);
            $this->db->update('ip_online_quotes');

            $quote_items = $this->mdl_quote_items->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_items as $quote_item) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'item_tax_rate_id' => $quote_item->item_tax_rate_id,
                    'item_name' => $quote_item->item_name,
                    'item_description' => $quote_item->item_description,
                    'item_quantity' => $quote_item->item_quantity,
                    'item_price' => $quote_item->item_price,
                    'item_order' => $quote_item->item_order
                );

                $this->mdl_items->save($invoice_id, NULL, $db_array);
            }

            $quote_tax_rates = $this->mdl_quote_tax_rates->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_tax_rates as $quote_tax_rate) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'tax_rate_id' => $quote_tax_rate->tax_rate_id,
                    'include_item_tax' => $quote_tax_rate->include_item_tax,
                    'invoice_tax_rate_amount' => $quote_tax_rate->quote_tax_rate_amount
                );

                $this->mdl_invoice_tax_rates->save($invoice_id, NULL, $db_array);
            }

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );*/
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

}
