<!doctype html>

<!--[if lt IE 7]>
<html class="no-js ie6 oldie" lang="en"> <![endif]-->
<!--[if IE 7]>
<html class="no-js ie7 oldie" lang="en"> <![endif]-->
<!--[if IE 8]>
<html class="no-js ie8 oldie" lang="en"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang="en"> <!--<![endif]-->

<head>
    <title>
        <?php
        if ($this->mdl_settings->setting('custom_title') != '') {
            echo $this->mdl_settings->setting('custom_title');
        } else {
            echo 'RBDRINKS 2.0';
        } ?>
    </title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="robots" content="NOINDEX,NOFOLLOW">

    <link rel="icon" type="image/png" href="<?php echo base_url(); ?>assets/default/img/favicon.png">

    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/default/css/style.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/default/css/custom.css">

    <?php if ($this->mdl_settings->setting('monospace_amounts') == 1) { ?>
        <link rel="stylesheet" href="<?php echo base_url(); ?>assets/default/css/monospace.css">
    <?php } ?>

    <script src="<?php echo base_url(); ?>assets/default/js/libs/modernizr-2.8.3.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/default/js/libs/jquery-1.11.2.min.js"></script>

    <script src="<?php echo base_url(); ?>assets/default/js/libs/bootstrap-3.3.2.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/default/js/libs/jquery-ui-1.11.2.custom.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/default/js/libs/bootstrap-typeahead.js"></script>
    <script src="<?php echo base_url(); ?>assets/default/js/libs/select2.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/default/js/libs/dropzone.js"></script>

    <script type="text/javascript">
        Dropzone.autoDiscover = false;

        $(function () {
            $('.nav-tabs').tab();
            $('.tip').tooltip();

            $('body').on('focus', ".datepicker", function () {
                $(this).datepicker({
                    autoclose: true,
                    format: '<?php echo date_format_datepicker(); ?>',
                    language: '<?php echo lang('cldr'); ?>',
                    weekStart: '<?php echo $this->mdl_settings->setting('first_day_of_week'); ?>'
                });
            });

            $('.create-avoir').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('avoir/ajax/modal_create_avoir'); ?>");
            });

            $('.create-invoice').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('invoices/ajax/modal_create_invoice'); ?>");
            });

            $('.create-invoice-proform').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('invoices_proform/ajax/modal_create_invoice'); ?>");
            });

            $('.create-quote').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_create_quote'); ?>");
            });

            $('.online-create-quote').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('online_quotes/ajax/modal_create_quote'); ?>");
            });

            $('#btn_production_to_transport').click(function () {
                quote_id = $(this).data('quote-id');
                production_id = $(this).data('production-id');
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_production_to_transport'); ?>/" + quote_id);
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_production_to_transport'); ?>/" + quote_id + "_" + production_id);
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_production_to_transport'); ?>/" + quote_id + "_" + production_id);
            });

            $('#btn_production_to_transport_2').click(function () {
                quote_id = $(this).data('quote-id');
                production_id = $(this).data('production-id');
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_production_to_transport_2'); ?>/" + quote_id);
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_production_to_transport_2'); ?>/" + quote_id + "_" + production_id);
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_production_to_transport_2'); ?>/" + quote_id + "_" + production_id);
            });

            $('#btn_print_notes').click(function () {
                quote_id = $(this).data('quote-id');
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_print_notes'); ?>/" + quote_id);
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_print_notes'); ?>/" + quote_id);
            });

            $('#btn_print_notes_services').click(function () {
                quote_id = $(this).data('quote-id');
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_print_notes_services'); ?>/" + quote_id);
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_print_notes_services'); ?>/" + quote_id);
            });

            $('#btn_quote_to_invoice').click(function () {
                quote_id = $(this).data('quote-id');
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_quote_to_invoice'); ?>/" + quote_id);
            });

            $('#btn_quote_to_proform').click(function () {
                quote_id = $(this).data('quote-id');
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_quote_to_proform'); ?>/" + quote_id);
            });
            
            $('#btn_online_quote_to_invoice').click(function () {
                quote_id = $(this).data('quote-id');
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_oq_to_q'); ?>/" + quote_id);
            });
            $('#btn_online_quote_to_invoice_out').click(function () {
                quote_id = $(this).data('quote-id');
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_oq_to_q'); ?>/" + quote_id);
                console.log("HERE");
            });

            $('#btn_copy_invoice').click(function () {
                invoice_id = $(this).data('invoice-id');
                $('#modal-placeholder').load("<?php echo site_url('invoices/ajax/modal_copy_invoice'); ?>", {invoice_id: invoice_id});
            });

            $('#btn_create_credit').click(function () {
                invoice_id = $(this).data('invoice-id');
                $('#modal-placeholder').load("<?php echo site_url('invoices/ajax/modal_create_credit'); ?>", {invoice_id: invoice_id});
            });

            $('#btn_copy_quote').click(function () {
                quote_id = $(this).data('quote-id');
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_copy_quote'); ?>", {quote_id: quote_id});
            });

            $('.client-create-invoice').click(function () {
                console.log($(this).data('client-name'));
                console.log($(this).data('client-id'));
                $('#modal-placeholder').load("<?php echo site_url('invoices/ajax/modal_create_invoice'); ?>", {
                    client_name: $(this).data('client-name'),
                    client_id: $(this).data('client-id')
                });
            });
            $('.client-create-quote').click(function () {
                console.log($(this).data('client-name'));
                console.log($(this).data('client-id'));
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_create_quote'); ?>", {
                    client_name: $(this).data('client-name'),
                    client_id: $(this).data('client-id')
                });
            });

            $('.create-transport').click(function () {
                //$('#modal-placeholder').load("<?php echo site_url('bon_livraison/ajax/modal_create_quote'); ?>");
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_create_quote_transport'); ?>");
            });

            $('.create-production-order').click(function () {
                //$('#modal-placeholder').load("<?php echo site_url('production/ajax/modal_create_quote'); ?>");
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_create_production'); ?>");
            });

            $('.create-supplier-order').click(function () {
                //$('#modal-placeholder').load("<?php echo site_url('supplier/ajax/modal_create_quote'); ?>");
                $('#modal-placeholder').load("<?php echo site_url('quotes/ajax/modal_create_supplier_demand'); ?>");
            });

            $('.create-proform').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('invoices_proform/ajax/modal_create_invoice'); ?>");
            });

            $('.create-purchase-order').click(function () {
                $('#modal-placeholder').load("<?php echo site_url('purchases/ajax/modal_create_quote'); ?>");
            });

            $(document).on('click', '.invoice-add-payment', function () {
                invoice_id = $(this).data('invoice-id');
                invoice_balance = $(this).data('invoice-balance');
                invoice_payment_method = $(this).data('invoice-payment-method');
                $('#modal-placeholder').load("<?php echo site_url('payments/ajax/modal_add_payment'); ?>", {
                    invoice_id: invoice_id,
                    invoice_balance: invoice_balance,
                    invoice_payment_method: invoice_payment_method
                });
            });

        });

    </script>

</head>

<body class="<?php if ($this->mdl_settings->setting('disable_sidebar') == 1) {
    echo 'hidden-sidebar';
} ?>">

<noscript>
    <div class="alert alert-danger no-margin"><?php echo lang('please_enable_js'); ?></div>
</noscript>

<?php //echo $_SERVER['REQUEST_URI'];
$slct = 150;
$hms=$clts=$eols=$quos=$invs=$bls=$prds=$pays=$prods=$sups=$reps="";
$hm = strpos($_SERVER['REQUEST_URI'], 'dashboard');
if($hm != false) {
    $slct = 0;
    $hms = 'style="color:#FFF;"';
}
$cstm = strpos($_SERVER['REQUEST_URI'], 'clients');
if($cstm != false) {
    $slct = 1;
    $clts = 'style="color:#FFF;"';
}
$eol = strpos($_SERVER['REQUEST_URI'], 'online_quotes');
if($eol != false) {
    $slct = 2;
    $eols = 'style="color:#FFF;"';
}
$quo = strpos($_SERVER['REQUEST_URI'], 'quotes');
if($quo != false) {
    $slct = 3;
    if($quo == 1)
    {
        $quos = 'style="color:#FFF;"';
    }
}
$inv = strpos($_SERVER['REQUEST_URI'], 'invoices');
if($inv != false) {
    $slct = 4;
    $invs = 'style="color:#FFF;"';
}
$inv = strpos($_SERVER['REQUEST_URI'], 'invoices_proform');
if($inv != false) {
    $slct = 4;
    $invs = 'style="color:#FFF;"';
}
$bl = strpos($_SERVER['REQUEST_URI'], 'bon_livraison');
if($bl != false) {
    $slct = 5;
    $bls = 'style="color:#FFF;"';
}
$prd = strpos($_SERVER['REQUEST_URI'], 'products');
$prdp = strpos($_SERVER['REQUEST_URI'], 'purchase');
if($prd != false AND $prdp == false ) {
    $slct = 6;
    $prds = 'style="color:#FFF;"';
}
$pay = strpos($_SERVER['REQUEST_URI'], 'payments');
if($pay != false) {
    $slct = 7;
    $pays = 'style="color:#FFF;"';
}
$prod = strpos($_SERVER['REQUEST_URI'], 'production');
if($prod != false) {
    $slct = 8;
    $prods = 'style="color:#FFF;"';
}
$sup = strpos($_SERVER['REQUEST_URI'], 'supplier');
if($sup != false) {
    $slct = 9;
    $sups = 'style="color:#FFF;"';
}
$rep = strpos($_SERVER['REQUEST_URI'], 'reports');
if($rep != false) {
    $slct = 10;
    $reps = 'style="color:#FFF;"';
}

$rsPrm = $this->db->query("SELECT * FROM ip_users WHERE user_id = ".$this->session->userdata('user_id'))->result_array();
?>

<nav class="navbar navbar-inverse" role="navigation">
    <div class="container-fluid">
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#ip-navbar-collapse">
                <span class="sr-only">Toggle navigation</span>
                <?php echo lang('menu') ?> &nbsp; <i class="fa fa-bars"></i>
            </button>
        </div>

        <div class="collapse navbar-collapse" id="ip-navbar-collapse">
            <ul class="nav navbar-nav">
                <li>
                    <span style="line-height: 50px;">
                        <div style="height: 100%; display:inline-block;">
                            <?php if( $rsPrm[0]['view_home'] == 1 ) { ?>
                                <a href='http://backoffice.rbdrinks.lu/dashboard'><img height="35" width="35" src="<?php echo base_url(); ?>assets/default/img/menu_logo/logo.png"></a>
                            <?php } else { ?>
                                <img height="35" width="35" src="<?php echo base_url(); ?>assets/default/img/menu_logo/logo.png">
                            <?php } ?>
                        </div>
                    </span>
                </li>
                <?php if( $rsPrm[0]['view_home'] == 7 /*$rsPrm[0]['view_home'] == 1*/ ) { ?>
                    <li>
                        <?php echo anchor('dashboard', lang('dashboard'), 'class="hidden-sm"') ?>
                        <?php echo anchor('dashboard', '<i class="fa fa-dashboard"></i>', 'class="visible-sm-inline-block"') ?>
                    </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_clients'] == 1 || $rsPrm[0]['create_clients'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $clts;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                            class="hidden-sm"><?php echo lang('clients'); ?></span><i
                            class="visible-sm-inline fa fa-users"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_clients'] == 1 ) { ?>
                        <li><?php echo anchor('clients/form', lang('add_client')); ?></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_clients'] == 1 ) { ?>
                        <li><?php echo anchor('clients/index', lang('view_clients')); ?></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($rsPrm[0]['view_eol'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $eols;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                            class="hidden-sm"><?php echo lang('online_quote_mn'); ?></span><i
                            class="visible-sm-inline fa fa-file"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <!-- <li><a href="#" class="online-create-quote"><?php //echo lang('online_quote_create'); ?></a></li> -->
                        <li><?php echo anchor('online_quotes/index', lang('online_quote_view')); ?></li>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_quote'] == 1 || $rsPrm[0]['create_quote'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $quos;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                                class="hidden-sm"><?php echo lang('quotes'); ?></span><i
                                class="visible-sm-inline fa fa-file"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_quote'] == 1 ) { ?>
                        <li><a href="#" class="create-quote"><?php echo lang('create_quote'); ?></a></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_quote'] == 1 ) { ?>
                        <li><?php echo anchor('quotes/index', lang('view_quotes')); ?></li>
                        <?php } ?>
                        <li><?php echo anchor('clients/calculate_transports', 'Calculer Transports'); ?></li>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_invoice'] == 1 || $rsPrm[0]['create_invoice'] == 1  || $rsPrm[0]['create_proform'] == 1 || $rsPrm[0]['view_proform'] == 1 || $rsPrm[0]['view_avoir'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $invs;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                            class="hidden-sm"><?php echo lang('invoices'); ?></span><i
                            class="visible-sm-inline fa fa-file-text"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_invoice'] == 1 ) { ?>
                        <li><a href="#" class="create-invoice"><?php echo lang('create_invoice'); ?></a></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_invoice'] == 1 ) { ?>
                        <li><?php echo anchor('invoices/index', lang('view_invoices')); ?></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_avoir'] == 1 ) { ?>
                        <li><?php echo anchor('invoices/index_nc', lang('view_credit')); ?></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['create_proform'] == 1 ) { ?>
                        <li><a href="#" class="create-proform"><?php echo lang('create_invoice_proform'); ?></a></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_proform'] == 1 ) { ?>
                        <li><?php echo anchor('invoices_proform/index', lang('view_invoices_proform')); ?></li>
                        <?php } ?>
                        <?php /*<li><?php echo anchor('invoices/recurring/index', lang('view_recurring_invoices')); ?></li>*/?>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_payment'] == 1 || $rsPrm[0]['create_payment'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $pays;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                            class="hidden-sm"><?php echo lang('payments'); ?></span><i
                            class="visible-sm-inline fa fa-credit-card"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_payment'] == 1 ) { ?>
                        <li><?php echo anchor('payments/form', lang('enter_payment')); ?></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_payment'] == 1 ) { ?>
                        <li><?php echo anchor('payments/index', lang('view_payments')); ?></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_command'] == 1 || $rsPrm[0]['create_command'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $prods;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                                class="hidden-sm"><?php echo lang('production'); ?></span><i
                                class="visible-sm-inline fa fa-credit-card"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <!-- <li><?php echo anchor('production/form', lang('enter_production')); ?></li> -->
                        <?php if( $rsPrm[0]['create_command'] == 1 ) { ?>
                        <li><a href="#" class="create-production-order"><?php echo lang('enter_production'); ?></a></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_command'] == 1 ) { ?>
                        <li><?php echo anchor('production/index', lang('view_production')); ?></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_transport'] == 1 || $rsPrm[0]['create_transport'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $bls;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                                class="hidden-sm"><?php echo lang('transport'); ?></span><i
                                class="visible-sm-inline fa fa-file"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_transport'] == 1 ) { ?>
                        <li><a href="#" class="create-transport"><?php echo lang('create_transport'); ?></a></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_transport'] == 1 ) { ?>
                        <li><?php echo anchor('bon_livraison/index', lang('view_transport')); ?></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_supplier'] == 1 || $rsPrm[0]['create_supplier'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $sups;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                                class="hidden-sm"><?php echo lang('supplier'); ?></span><i
                                class="visible-sm-inline fa fa-credit-card"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_supplier'] == 1 ) { ?>
                        <li><a href="#" class="create-supplier-order"><?php echo lang('enter_supplier'); ?></a></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_supplier'] == 1 ) { ?>
                        <li><?php echo anchor('supplier/index', lang('view_supplier')); ?></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <li class="dropdown hidden">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                            class="hidden-sm"><?php echo lang('tasks'); ?></span><i
                            class="visible-sm-inline fa fa-check-square-o"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><?php echo anchor('tasks/form', lang('create_task')); ?></li>
                        <li><?php echo anchor('tasks/index', lang('show_tasks')); ?></li>
                        <li><?php echo anchor('projects/index', lang('projects')); ?></li>
                    </ul>
                </li>

                <?php /* if( $rsPrm[0]['create_products'] == 1 || $rsPrm[0]['enter_stock'] == 1 || $rsPrm[0]['remove_stock'] == 1 || $rsPrm[0]['view_family'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $prds;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                                class="hidden-sm"><?php echo lang('products'); ?></span><i
                                class="visible-sm-inline fa fa-database"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <?php if( $rsPrm[0]['create_products'] == 1 ) { ?>
                        <!-- <li><?php echo anchor('products/form', lang('create_product')); ?></li> -->
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_products'] == 1 ) { ?>
                        <!-- <li><?php echo anchor('products/index', lang('view_products')); ?></li> -->
                        <?php } ?>
                        <?php if( $rsPrm[0]['enter_stock'] == 1 ) { ?>
                        <li><?php echo anchor('products/stock', lang('stock_add')); ?></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['remove_stock'] == 1 ) { ?>
                        <li><?php echo anchor('products/stock_off', lang('stock_take')); ?></li>
                        <?php } ?>
                        <?php if( $rsPrm[0]['view_family'] == 1 ) { ?>
                        <!-- <li><?php echo anchor('families/index', lang('product_families')); ?></li> -->
                        <?php } ?>
                    </ul>
                </li>
                <?php } */ ?>

                <?php if( $rsPrm[0]['view_products'] == 1 ) { ?>
                <li>
                	<?php echo anchor('products/index', lang('view_products_online')); ?>
                    <!-- <?php echo anchor('products/stock_file', lang('stocks'), 'class="hidden-sm"') ?> -->
                    <?php echo anchor('products/stock_file', '<i class="fa fa-dashboard"></i>', 'class="visible-sm-inline-block"') ?>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_stock_doc'] == 1) { ?>
                <li>
                    <?php echo anchor('products/stock_factory', lang('factory'), 'class="hidden-sm"') ?>
                    <?php echo anchor('products/stock_factory', '<i class="fa fa-dashboard"></i>', 'class="visible-sm-inline-block"') ?>
                </li>
                <?php } ?>

                <?php if( $this->session->userdata('user_id') == 1 || $this->session->userdata('user_id') == 3 || $this->session->userdata('user_id') == 7  || $this->session->userdata('user_id') == 10 ) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $prch;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                                class="hidden-sm"><?php echo lang('purchase_central'); ?></span><i
                                class="visible-sm-inline fa fa-database"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="#" class="create-purchase-order"><?php echo lang('create_purchase_order'); ?></a></li>
                        <li><?php echo anchor('purchases/index', lang('view_purchase_order')); ?></li>
                        <li><?php echo anchor('purchase_products/index', lang('purchase_order_products')); ?></li>
                        <li><?php echo anchor('purchase_suppliers/form', lang('create_purchase_order_supplier')); ?></li>
                        <li><?php echo anchor('purchase_suppliers/index', lang('view_purchase_order_supplier')); ?></li>
                    </ul>
                </li>
                <?php } ?>

                <?php if( $rsPrm[0]['view_report'] == 1) { ?>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" <?php echo $reps;?>>
                        <i class="fa fa-caret-down"></i> &nbsp;<span
                            class="hidden-sm"><?php echo lang('reports'); ?></span><i
                            class="visible-sm-inline fa fa-bar-chart"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><?php echo anchor('reports/client_recall', lang('client_recall_menu')); ?></li>
                        <li><?php echo anchor('reports/invoices_by_date_commercial', lang('invoices_by_date')); ?></li>
                        <li><?php echo anchor('reports/credit_note_list', lang('credit_note_by_date')); ?></li>
                        <li><?php echo anchor('reports/invoice_by_country', lang('invoice_by_country')); ?></li>
                        <?php if($this->session->userdata('user_id') == 1) { ?> 
                            <li><?php echo anchor('#', '=-=-=-=-=-=-=-=-=-=-=-=-='); ?></li> 
                            <li><?php echo anchor('reports/invoice_aging', lang('invoice_aging')); ?></li>
                            <li><?php echo anchor('reports/payment_history', lang('payment_history')); ?></li>
                            <li><?php echo anchor('reports/sales_by_client', lang('sales_by_client')); ?></li>
                            <li><?php echo anchor('reports/sales_by_year', lang('sales_by_date')); ?></li>
                            <li><?php echo anchor('reports/production_by_supplier', lang('production_by_supplier')); ?></li>
                            <li><?php echo anchor('reports/supplier_report', lang('supplier_report')); ?></li>
                            <li><?php echo anchor('reports/transport_list', lang('transport_list')); ?></li>
                            <li><?php echo anchor('reports/customization_list', lang('printing_report')); ?></li>
                            <li><?php echo anchor('reports/monthly_resume', lang('monthly_commertial_report_menu')); ?></li>
                            <li><?php echo anchor('reports/daily_orders_out', lang('daily_commandes')); ?></li>
                            <li><?php echo anchor('reports/type_movement', 'OLD -> ' . lang('enter_exit_stock')); ?></li> 
                            <li><?php echo anchor('reports/stock_movement', 'OLD -> ' . lang('type_of_movement')); ?></li>
                            <li><?php echo anchor('reports/stock_check', 'OLD -> ' . lang('stock_control')); ?></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php } ?>

            </ul>

            <?php if (isset($filter_display) and $filter_display == TRUE) { ?>
                <?php $this->layout->load_view('filter/jquery_filter'); ?>
                <form class="navbar-form navbar-left" role="search" onsubmit="return false;">
                    <div class="form-group">
                        <input id="filter" type="text" class="search-query form-control input-sm" style="width: 250px;"
                               placeholder="<?php echo $filter_placeholder; ?>">
                        <i class="fa fa-search" aria-hidden="true" style="margin-left: -25px;"></i>
                    </div>
                </form>
            <?php } ?>
            <ul class="nav navbar-nav navbar-right">
                <?php if( $rsPrm[0]['view_notifications'] == 1 ) { ?>
                    <li>
                        <?php
                            if($this->session->userdata('user_id') != 1 && $this->session->userdata('user_id') != 3)
                            {
                                /*$results = $this->db->query("
                                    select count(quote_id) qid from ip_quotes where quote_status_id != 4 AND quote_status_id != 5 AND quote_status_id != 6 AND user_id = ".$this->session->userdata('user_id')." AND quote_date_expires between NOW() - INTERVAL 365 DAY and NOW() + INTERVAL 7 DAY
                                    UNION ALL
                                    select count(invoice_id) iid from ip_invoices where invoice_status_id != 4 AND invoice_status_id != 6 AND invoice_date_due between NOW() - INTERVAL 365 DAY and NOW() + INTERVAL 7 DAY;")->result_array();*/
                                $results = $this->db->query("
                                    select count(invoice_id) iid from ip_invoices where invoice_number LIKE 'F%' AND invoice_status_id != 4 AND invoice_status_id != 6 AND invoice_date_due between NOW() - INTERVAL 365 DAY and NOW() + INTERVAL 7 DAY;")->result_array();
                            }
                            else
                            {
                                /*$results = $this->db->query("
                                    select count(quote_id) qid from ip_quotes where quote_status_id != 4 AND quote_status_id != 5 AND quote_status_id != 6 AND quote_date_expires between NOW() - INTERVAL 365 DAY and NOW() + INTERVAL 7 DAY
                                    UNION ALL
                                    select count(invoice_id) iid from ip_invoices where invoice_status_id != 4 AND invoice_status_id != 6 AND invoice_date_due between NOW() - INTERVAL 365 DAY and NOW() + INTERVAL 7 DAY;")->result_array();*/
                                $results = $this->db->query("
                                    select count(invoice_id) iid from ip_invoices where invoice_number LIKE 'F%' AND invoice_status_id != 4 AND invoice_status_id != 6 AND invoice_date_due between NOW() - INTERVAL 365 DAY and NOW() + INTERVAL 7 DAY;")->result_array();
                            }
                        ?>
                        <span style="line-height: 50px;">
                            <div style="height: 100%; display:inline-block;">
                                <?php
                                //if( ($results[0]['qid']+$results[1]['qid']) > 0 )
                                if( ($results[0]['iid']) > 0 )
                                {
                                    //$ttl_msg = $results[0]['qid']+$results[1]['qid'];
                                    $ttl_msg = $results[0]['iid'];
                                    echo anchor('#message_board', '<span class="bell-alert">'.$ttl_msg.'</span><img id="bell_img" height="35" width="35" src="'.base_url().'assets/default/img/menu_logo/bell_full.png">');
                                }
                                else
                                {
                                    echo anchor('#message_board', '<img id="bell_img" height="35" width="35" src="'.base_url().'assets/default/img/menu_logo/bell.png">');
                                }?>
                            </div>
                        </span>
                        &nbsp;
                    </li>
                <?php } ?>
                <li>
                    <div style="height: 100%; display:inline-block; ">
                        <img id="avatar_img" height="35" width="35" style="border-radius: 100%" src="<?php echo base_url(); ?>assets/default/img/user_avatar/<?php echo $this->session->userdata('user_id');?>.png">
                    </div>
                    &nbsp;
                    <span style="color:#9d9d9d;line-height: 50px;">
                        <?php echo $this->session->userdata('user_name');?>
                    </span>

                </li>
                <!-- <li>
                    <a href="http://docs.invoiceplane.com/" target="_blank"
                       class="tip icon" data-original-title="<?php echo lang('documentation'); ?>"
                       data-placement="bottom">
                        <i class="fa fa-question-circle"></i>
                        <span class="visible-xs">&nbsp;<?php echo lang('documentation'); ?></span>
                    </a>
                </li> -->

                <?php if( $rsPrm[0]['view_config'] == 1 ) { ?>
                    <li class="dropdown">
                        <a href="#" class="tip icon dropdown-toggle" data-toggle="dropdown"
                           data-original-title="<?php echo lang('settings'); ?>"
                           data-placement="bottom">
                            <i class="fa fa-cogs"></i>
                            <span class="visible-xs">&nbsp;<?php echo lang('settings'); ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><?php echo anchor('custom_fields/index', lang('custom_fields')); ?></li>
                            <li><?php echo anchor('email_templates/index', lang('email_templates')); ?></li>
                            <li><?php echo anchor('invoice_groups/index', lang('invoice_groups')); ?></li>
                            <li><?php echo anchor('invoices/archive', lang('invoice_archive')); ?></li>
                            <!-- // temporarily disabled
                            <li><?php echo anchor('item_lookups/index', lang('item_lookups')); ?></li>
                            -->
                            <li><?php echo anchor('payment_methods/index', lang('payment_methods')); ?></li>
                            <li><?php echo anchor('tax_rates/index', lang('tax_rates')); ?></li>
                            <li><?php echo anchor('users/index', lang('user_accounts')); ?></li>
                            <li class="divider hidden-xs hidden-sm"></li>
                            <li><?php echo anchor('settings', lang('system_settings')); ?></li>
                            <li><?php echo anchor('import', lang('import_data')); ?></li>
                        </ul>
                    </li>
                <?php } ?>

                <li>
                    <a href="<?php echo site_url('sessions/logout'); ?>"
                       class="tip icon logout" data-placement="bottom"
                       data-original-title="<?php echo lang('logout'); ?>">
                        <i class="fa fa-power-off"></i>
                        <span class="visible-xs">&nbsp;<?php echo lang('logout'); ?></span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="sidebar hidden-xs <?php if ($this->mdl_settings->setting('disable_sidebar') == 1) {
    echo 'hidden';
} ?>">
    <ul>
        <li>
            <a href="<?php echo site_url('dashboard'); ?>">
                <i class="fa fa-dashboard"></i>
            </a>
        </li>
        <li>
            <a href="<?php echo site_url('clients/index'); ?>">
                <i class="fa fa-users"></i>
            </a>
        </li>
        <li>
            <a href="<?php echo site_url('quotes/index'); ?>">
                <i class="fa fa-file"></i>
            </a>
        </li>
        <li>
            <a href="<?php echo site_url('invoices/index'); ?>">
                <i class="fa fa-file-text"></i>
            </a>
        </li>
        <li>
            <a href="<?php echo site_url('payments/index'); ?>">
                <i class="fa fa-money"></i>
            </a>
        </li>
    </ul>
</div>

<div id="main-area">

    <div id="modal-placeholder"></div>

    <?php echo $content; ?>

</div>

<div id="fullpage-loader" style="display: none">
    <div class="loader-content">
        <i class="fa fa-cog fa-spin"></i>
        <div id="loader-error" style="display: none">
            <?php echo lang('loading_error'); ?><br/>
            <a href="https://wiki.invoiceplane.com/<?php echo lang('cldr'); ?>/1.0/general/faq"
               class="btn btn-primary btn-sm" target="_blank">
                <i class="fa fa-support"></i> <?php echo lang('loading_error_help'); ?>
            </a>
        </div>
    </div>
</div>

<script defer src="<?php echo base_url(); ?>assets/default/js/plugins.js"></script>
<script defer src="<?php echo base_url(); ?>assets/default/js/scripts.min.js"></script>
<script src="<?php echo base_url(); ?>assets/default/js/libs/bootstrap-datepicker.js"></script>
<?php if (lang('cldr') != 'en') { ?>
    <script
        src="<?php echo base_url(); ?>assets/default/js/locales/bootstrap-datepicker.<?php echo lang('cldr'); ?>.js"></script>
<?php } ?>

<!--[if lt IE 7 ]>
<script src="<?php echo base_url(); ?>assets/default/js/dd_belatedpng.js"></script>
<script
    type="text/javascript"> DD_belatedPNG.fix('img, .png_bg'); //fix any <img> or .png_bg background-images </script>
<![endif]-->

<!-- Prompt IE 6 users to install Chrome Frame. Remove this if you want to support IE 6.
     chromium.org/developers/how-tos/chrome-frame-getting-started -->
<!--[if lt IE 7 ]>
<script src="//ajax.googleapis.com/ajax/libs/chrome-frame/1.0.3/CFInstall.min.js"></script>
<script type="text/javascript">window.attachEvent('onload', function () {
    CFInstall.check({mode: 'overlay'})
})</script>
<![endif]-->
<!--<script>(function(d,t,u,s,e){e=d.getElementsByTagName(t)[0];s=d.createElement(t);s.src=u;s.async=1;e.parentNode.insertBefore(s,e);})(document,'script','//support.dev-rbdrinks.com/php/app.php?widget-init.js');</script>-->
</body>
</html>
