<script type="text/javascript">
    $(function () {
        // Display the create invoice modal
        $('#create-invoice-proform').modal('show');

        $('#create-invoice-proform').on('shown', function () {
            $("#client_name").focus();
        });

        $().ready(function () {
            $("[name='client_name']").select2({
                createSearchChoice: function (term, data) {
                    if ($(data).filter(function () {
                            return this.text.localeCompare(term) === 0;
                        }).length === 0) {
                        return {id: term, text: term};
                    }
                },
                multiple: false,
                allowClear: true,
                data: [
                    <?php
                    $i=0;
                    foreach ($clients as $client){
                        echo '{
                        id: "'.str_replace("","",$client->client_name).'",
                        text: "'.str_replace("","",$client->client_name).'"
                        }';
                        if (($i+1) != count($clients)) echo ',';
                        $i++;
                    }
                    ?>
                ]
            });
            $("#client_name").focus();
        });

        // Creates the invoice
        $('#invoice_proform_create_confirm').click(function () {
            console.log("Create");
            // Posts the data to validate and create the invoice;
            // will create the new client if necessar
            $.post("<?php echo site_url('invoices_proform/ajax/create'); ?>", {
                    /*client_name: '1848',
                    invoice_proform_date_created: '25-05-2017',
                    invoice_group_id: 0,
                    invoice_proform_password: '',
                    user_id: '1'*/
                    client_name: $('#client_name').val(),
                    invoice_proform_date_created: $('#invoice_date_created').val(),
                    invoice_group_id: $('#invoice_group_id').val(),
                    invoice_proform_time_created: '<?php echo date('H:i:s') ?>',
                    invoice_proform_password: $('#invoice_password').val(),
                    user_id: '<?php echo $this->session->userdata('user_id'); ?>',
                    payment_method: $('#payment_method_id').val()
                },
                function (data) {
                    var response = JSON.parse(data);
                    if (response.success == '1') {
                        // The validation was successful and invoice was created
                        window.location = "<?php echo site_url('invoices_proform/view'); ?>/" + response.invoice_proform_id;
                    }
                    else {
                        // The validation was not successful
                        $('.control-group').removeClass('has-error');
                        for (var key in response.validation_errors) {
                            $('#' + key).parent().parent().addClass('has-error');
                        }
                    }
                });
        });
    });

</script>

<div id="create-invoice-proform" class="modal col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2"
     role="dialog" aria-labelledby="modal_create_invoice" aria-hidden="true">
    <form class="modal-content">
        <div class="modal-header">
            <a data-dismiss="modal" class="close"><i class="fa fa-close"></i></a>

            <h3><?php echo lang('create_invoice_proform'); ?></h3>
        </div>
        <div class="modal-body">

            <input class="hidden" id="payment_method_id"
                   value="<?php echo $this->mdl_settings->setting('invoice_default_payment_method'); ?>">

            <div class="form-group">
                <label for="client_name"><?php echo lang('client'); ?></label><br />
                <input type="text" name="client_name" id="client_name" class="form-control" style="float: left; width: 95%; height: 30px;"
                       autofocus="autofocus"
                    <?php if ($client_name) echo 'value="' . html_escape($client_name) . '"'; ?>>
                <a href="clients/form">
                    <span style="background-color: #c594c5 !important;
                                border-radius: 4px;
                                display: inline-block; float: right;
                        height: 30px; width: 40px; text-align: center; font-size: 45px; line-height: 90px; background: rgba(0,0,0,0.2); border-right: 2px solid #fff;">
                            <img id="add_client" height="auto" width="27" src="<?php echo base_url(); ?>assets/default/img/menu_logo/create_customer.png"
                                 style="vertical-align: top; text-align: left; display:block; margin-left: 5px; margin-top: 1px;">
                    </span>
                </a>
                <br />
            </div>

            <div class="form-group has-feedback">
                <label><?php echo lang('invoice_date'); ?></label>

                <div class="input-group">
                    <input name="invoice_date_created" id="invoice_date_created"
                           class="form-control datepicker"
                           value="<?php echo date(date_format_setting()); ?>">
                <?php /*<span class="input-group-addon">
                    <i class="fa fa-calendar fa-fw"></i>
                </span>*/?>
                </div>
            </div>

            <!-- BM Hidden@request of admin -->
            <div class="form-group" style="display: none;">
                <label for="invoice_password"><?php echo lang('invoice_password'); ?></label>
                <input type="text" name="invoice_password" id="invoice_password" class="form-control"
                       value="<?php if ($this->mdl_settings->setting('invoice_pre_password') == '') {
                           echo '';
                       } else {
                           echo $this->mdl_settings->setting('invoice_pre_password');
                       } ?>" style="margin: 0 auto;" autocomplete="off">
            </div>

            <!-- BM Hidden@request of admin -->
            <div class="form-group" style="display: none;">
                <label><?php echo lang('invoice_group'); ?></label>

                <div class="controls">
                    <select name="invoice_group_id" id="invoice_group_id" class="form-control">
                        <option value=""></option>
                        <?php foreach ($invoice_groups as $invoice_group) { ?>
                            <option value="<?php echo $invoice_group->invoice_group_id; ?>"
                                    <?php if ($this->mdl_settings->setting('default_invoice_group') == $invoice_group->invoice_group_id) { ?>selected="selected"<?php } ?>><?php echo $invoice_group->invoice_group_name; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>

        </div>

        <div class="modal-footer">
            <div class="btn-group">
                <button class="btn btn-danger" type="button" data-dismiss="modal">
                    <i class="fa fa-times"></i> <?php echo lang('cancel'); ?>
                </button>
                <button class="btn btn-success ajax-loader" id="invoice_proform_create_confirm" type="button">
                    <i class="fa fa-check"></i> <?php echo lang('submit'); ?>
                </button>
            </div>
        </div>

    </form>

</div>
