<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->load->model('invoices_proform/mdl_items');
        $this->load->model('invoices_proform/mdl_invoices');
        $this->load->model('item_lookups/mdl_item_lookups');

        $invoice_id = $this->input->post('invoice_proform_id');

        $this->mdl_invoices->set_id($invoice_id);

        echo $invoice_id."IVID";

        //if ($this->mdl_invoices->run_validation('validation_rules_save_invoice')) {
        echo "Passou validacao";
        $items = json_decode($this->input->post('items'));

        $plist = $this->db->query("SELECT * FROM ip_products WHERE inactive = 0 ORDER BY product_order")->result_array();

        $error = 0;

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('INSIDE SAVE ', now() )");

        foreach ($items as $item) {
            $exists = 0;

            foreach($plist as $pl)
            {
                if($pl['product_sku'] == $item->item_description || $item->item_description == "")
                {
                    $exists = 1;
                }

                //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$pl['product_sku']." ".$item->item_description."', now() )");
            }

            if($exists == 0)
            {
                //ERRO
                $this->load->helper('json_error');
                $response = array(
                    'success' => 0,
                    'validation_errors' => 'SKU_ERROR'
                );

                $error = 1;
            }

        }

        //echo "<script> console.log('PHP: ',",$this->input->post('items'),");</script>";

        if($error == 0) {
            foreach ($items as $item) {
                echo "Entrou nos items";
                if ($item->item_name)
                {
                    if ($item->item_id == NULL) {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ERROR == 0 && Inside Items && Item Name && ID Null', now() )");
                        echo "Entrou no Null";
                        foreach ($item as $it) {
                            $string = "?? " . $string . $it;
                        }
                        $string = ' ' . $string;
                        $ini = strpos($string, $invoice_id);
                        $ini += strlen($invoice_id);
                        $len = strpos($string, $item->item_quantity, $ini) - $ini;
                        $note_k = substr($string, $ini, $len);

                        //echo $note_k."NoteK";
                        //echo $item->item_name."--name--";
                        echo $item->item_description . "--desc--";
                        //echo $item->item_sku."--sku--";

                        $prod_info[] = $this->db->query("SELECT product_id FROM ip_products WHERE product_sku like '%" . $item->item_description . "%' limit 1;")->result_array();

                        $pid = $prod_info[0][0]['product_id'];

                        if ($pid == NULL || $pdi == "") {
                            $pid = 0;
                        }

                        //$note_k = $note_k." ".$pid ;

                        $date_add = date('Y-m-d');

                        $item->item_quantity = standardize_amount($item->item_quantity);
                        echo $item->item_quantity . "--qtt--";
                        $item->item_price = standardize_amount($item->item_price);
                        echo $item->item_price . "--price--";
                        $item->item_discount_amount = standardize_amount($item->item_discount_amount);
                        echo $item->item_discount_amount . "--item_discount_amount--";

                        $updt_bl = $this->db->query("INSERT INTO ip_invoice_proform_items (item_id, invoice_proform_id, item_tax_rate_id, item_date_added, item_name,
                                                                              item_description, item_quantity, item_price, item_discount_amount, item_order) 
                                              VALUES
                                                                              (" . $pid . ", " . $invoice_id . ", " . $item->item_tax_rate_id . ", '" . $date_add . "', '" . $item->item_name . "',
                                                                              '" . $item->item_description . "', " . $item->item_quantity . ", " . $item->item_price . ", '" . $item->item_discount_amount . "', " . $item->item_order . ")");

                        $prd_nfo_itm[] = $this->db->query("SELECT max(item_id) AS item_id FROM ip_invoice_proform_items limit 1;")->result_array();

                        $itm_id = $prd_nfo_itm[0][0]['item_id'];

                        $itm_subttl = $item->item_quantity*$item->item_price;
                        $itm_dsc = $itm_subttl * ( $item->item_discount_amount / 100 ); //VER CONTAS
                        if($item->item_tax_rate_id == 0)
                        {
                            $itm_txttl = "0.00";
                        }
                        else
                        {
                            $itm_txttl = ( ( ( ($itm_subttl - $itm_dsc) * 0.2) * 100) / 100 );
                        }

                        $itm_ttl = $itm_subttl - $itm_dsc + $itm_txttl;

                        $updt_prf_itm_amt = $this->db->query("INSERT INTO ip_invoice_proform_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total)
                                                        VALUES
                                                        (".$itm_id.", ".$itm_subttl.", ".$itm_txttl.", ".$itm_dsc.", ".$itm_ttl.")");
                    } else {
                        echo "Entrou no Not Null";
                        echo $item->item_name . "--name--";
                        echo $item->item_sku . "--sku--";
                        echo $item->item_description . "--desc--";
                        $item->item_quantity = standardize_amount($item->item_quantity);
                        $item->item_price = standardize_amount($item->item_price);
                        $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                        $updt_bl = $this->db->query("UPDATE ip_invoice_proform_items SET 
                            item_name = '" . $item->item_name . "',
                            item_description = '" . $item->item_description . "',
                            item_order = " . $item->item_order . ",
                            item_price = " . $item->item_price . ",
                            item_discount_amount = " . $item->item_discount_amount . ",
                            item_tax_rate_id = " . $item->item_tax_rate_id . ",
                            item_quantity = " . $item->item_quantity . " 
                        WHERE invoice_proform_id = " . $invoice_id . "
                        AND item_id = " . $item->item_id);

                        $itm_subttl = $item->item_quantity*$item->item_price;
                        //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ERROR == 0 && Inside Items && Item Name && ID Not Null 3', now() )");
                        //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('REF ".$item->item_description." SUBTOTAL ".$itm_subttl." ', now() )");
                        $itm_dsc = $itm_subttl * ( $item->item_discount_amount / 100 ); //VER CONTAS
                        if($item->item_tax_rate_id == 0)
                        {
                            $itm_txttl = "0.00";
                        }
                        else
                        {
                            $itm_txttl = ( ( ( ($itm_subttl - $itm_dsc) * 0.2) * 100) / 100 );
                        }

                        $itm_ttl = $itm_subttl - $itm_dsc + $itm_txttl;

                        $updt_prf_itm_amt = $this->db->query("UPDATE ip_invoice_proform_item_amounts SET
                                                              item_subtotal = ".$itm_subttl.", 
                                                              item_tax_total = ".$itm_txttl.",
                                                              item_discount = ".$itm_dsc.",
                                                              item_total = ".$itm_ttl."
                                                          WHERE item_id = ".$item->item_id);
                    }

                    $sub_ttl_doc = $sub_ttl_doc + $itm_subttl - $itm_dsc;
                    $ttl_tx_doc = $ttl_tx_doc + $itm_txttl;
                    $ttl_dsc_doc = $ttl_dsc_doc + $itm_dsc;
                    $ttl_doc = $ttl_doc + $itm_ttl;
                }
            }

            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('SUBTOTAL ".$sub_ttl_doc." ', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('TAX DOC ".$ttl_tx_doc." ', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('DESC DOC ".$ttl_dsc_doc." ', now() )");
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('TOTAL DOC ".$ttl_doc." ', now() )");

            $invoice_status = $this->input->post('invoice_status_id');

            echo "Passou status";

            $db_array = array(
                'invoice_proform_number' => $this->input->post('invoice_proform_number'),
                'invoice_proform_terms' => $this->input->post('invoice_proform_terms'),
                'invoice_proform_date_created' => $this->input->post('invoice_proform_date_created'),
                'invoice_proform_date_due' => $this->input->post('invoice_proform_date_due'),
                'invoice_proform_password' => $this->input->post('invoice_proform_password'),
                'invoice_status_id' => $invoice_status,
                'payment_method' => $this->input->post('payment_method'),
                'invoice_proform_discount_amount' => $this->input->post('invoice_proform_discount_amount'),
                'invoice_proform_discount_percent' => $this->input->post('invoice_proform_discount_percent'),
            );

            echo "Passou DBArray";
            $readonly = 0;

            // check if status changed to sent, the feature is enabled and settings is set to sent
            if ($invoice_status == 2 && $this->config->item('disable_read_only') == FALSE && $this->mdl_settings->setting('read_only_toggle') == 'sent') {
                $db_array['is_read_only'] = 1;
                $readonly = 1;
            }

            // check if status changed to viewed, the feature is enabled and settings is set to viewed
            if ($invoice_status == 3 && $this->config->item('disable_read_only') == FALSE && $this->mdl_settings->setting('read_only_toggle') == 'viewed') {
                $db_array['is_read_only'] = 1;
                $readonly = 1;
            }

            // check if status changed to paid and the feature is enabled
            if ($invoice_status == 4 && $this->config->item('disable_read_only') == FALSE && $this->mdl_settings->setting('read_only_toggle') == 'paid') {
                $db_array['is_read_only'] = 1;
                $readonly = 1;
            }

            echo $this->session->userdata('user_id') . "USER";

            $updt_bl = $this->db->query("UPDATE ip_invoices_proform SET 
                            invoice_proform_discount_percent = '" . $this->input->post('invoice_proform_discount_percent') . "',
                            invoice_proform_discount_amount = '" . $this->input->post('invoice_proform_discount_amount') . "',
                            invoice_proform_date_modified = '" . date('Y-m-d H:i:s') . "',
                            invoice_status_id = " . $invoice_status . ",
                            is_read_only = " . $readonly . ",
                            user_id = " . $this->session->userdata('user_id') . "
                         WHERE invoice_proform_id = " . $invoice_id);

            echo "After Save";

            // Recalculate for discounts
            $this->load->model('invoices_proform/mdl_invoice_amounts');
            $this->mdl_invoice_amounts->calculate($invoice_id);
            $ttl_id[] = $this->db->query("SELECT count(invoice_proform_amount_id) as cnt FROM ip_invoice_proform_amounts WHERE invoice_proform_id = ".$invoice_id)->result_array();

            $amnt = $ttl_id[0][0]['cnt'];

            /*if($amnt == 0)
            {
                //INSERT
            }
            else
            {*/
                //UPDATE
                //$sub_ttl_doc = $ttl_doc + $itm_subttl;
                //$ttl_tx_doc = $ttl_doc + $itm_txttl;
                //$ttl_dsc_doc = $ttl_doc + $itm_dsc;
                //$ttl_doc = $ttl_doc + $itm_ttl;

                /*$updt_bl_amnt = $this->db->query( "UPDATE ip_invoice_proform_amounts SET
                                invoice_proform_total = ".$ttl_doc.",
                                invoice_proform_item_tax_total = ".$ttl_tx_doc.",
                                invoice_proform_item_subtotal = ".$sub_ttl_doc.",
                                invoice_proform_sign = 1
                             WHERE invoice_proform_id = ".$invoice_id );*/

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER AMNT INVOICE ID '.$invoice_id, now() )");
            //}

            echo "After Amounts";

            $response = array(
                'success' => 1
            );
            /*} else {
                $this->load->helper('json_error');
                $response = array(
                    'success' => 0,
                    'validation_errors' => json_errors()
                );
            }*/

        }
        //echo json_encode($response);
        echo 1;
    }

    public function save_invoice_tax_rate()
    {
        $this->load->model('invoices_proform/mdl_invoice_tax_rates');

        if ($this->mdl_invoice_tax_rates->run_validation()) {
            $this->mdl_invoice_tax_rates->save($this->input->post('invoice_proform_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_invoice_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function create()
    {
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM CREATE FUNCTION', now() )");
        $this->load->model('invoices_proform/mdl_invoices');
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('USER ID ".$this->input->post('user_id')."', now() )");

        $t_max_id_num[] = $this->db->query("SELECT max(invoice_proform_number) as invoice_proform_number FROM ip_invoices_proform")->result_array();
        $num = $t_max_id_num[0][0]['invoice_proform_number'];
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM NUMBER 1 - ".$num."', now() )");
        $num = substr($num, 3);
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM NUMBER 2 - ".$num."', now() )");
        $num = (int)$num;
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM NUMBER 3 - ".$num."', now() )");
        $num++;
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM NUMBER 4 - ".$num."', now() )");

        $cst_id[] = $this->db->query("SELECT client_id FROM ip_clients WHERE client_name = '".$this->input->post('client_name')."' limit 1 ")->result_array();
        $nm_cst_id = $cst_id[0][0]['client_id'];
        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM CLIENT NUMBER ".$nm_cst_id."', now() )");

        $is_slash_create = substr($this->input->post('invoice_proform_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('invoice_proform_date_created'), 6, 9);
            $day_create = substr($this->input->post('invoice_proform_date_created'), 0, 2);
            $month_create = substr($this->input->post('invoice_proform_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('invoice_proform_date_created');
        }

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('PROFORM DATE CREATED ".$date_create."', now() )");

        //proform_date_created user_id
        $updt_bl = $this->db->query( "INSERT INTO ip_invoices_proform (user_id, client_id, invoice_group_id, invoice_status_id, 
                                                                invoice_proform_date_created,  
                                                                invoice_proform_number, owner, invoice_proform_url_key) 
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', 
                                                  'FTP".$num."', ".$this->input->post('user_id').", now() )" );

        $q_max_id[] = $this->db->query("SELECT max(invoice_proform_id) as id FROM ip_invoices_proform ")->result_array();

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('MAX PROFORM ID ".$q_max_id[0][0]['id']."', now() )");

        $isrt_amnt = $this->db->query( "INSERT INTO ip_invoice_proform_amounts (invoice_proform_id, invoice_proform_sign, invoice_proform_item_subtotal, 
                                                                  invoice_proform_item_tax_total, invoice_proform_tax_total, invoice_proform_total, invoice_proform_paid, invoice_proform_balance) 
                                              VALUES
                                              (".$q_max_id[0][0]['id'].", 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00)" );

        $response = array(
            'success' => 1,
            'invoice_proform_id' => $q_max_id[0][0]['id']
            //'invoice_proform_id' => 15845
        );

        echo json_encode($response);

        /*if ($this->mdl_invoices->run_validation()) {
            $invoice_id = $this->mdl_invoices->create();

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);*/
    }

    public function create_recurring()
    {
        $this->load->model('invoices_proform/mdl_invoices_recurring');

        if ($this->mdl_invoices_recurring->run_validation()) {
            $this->mdl_invoices_recurring->save();

            $response = array(
                'success' => 1,
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('invoices_proform/mdl_items');

        $item = $this->mdl_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_invoice()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'client_name' => $this->input->post('client_name'),
            //'clients' => $this->mdl_clients->get()->result(),
            //'clients' => $this->mdl_clients->where('client_active', 1)->get()->result(),
            //'clients' => $this->mdl_clients->where('is_valid', 1)->get()->result(),
            'clients' => $this->mdl_clients->where('is_valid', 1)->limit(1550)->get()->result(),
        );

        $this->layout->load_view('invoices_proform/modal_create_invoice', $data);
    }

    public function modal_create_recurring()
    {
        $this->load->module('layout');

        $this->load->model('mdl_invoices_recurring');

        $data = array(
            'invoice_proform_id' => $this->input->post('invoice_proform_id'),
            'recur_frequencies' => $this->mdl_invoices_recurring->recur_frequencies
        );

        $this->layout->load_view('invoices_proform/modal_create_recurring', $data);
    }

    public function get_recur_start_date()
    {
        $invoice_date = $this->input->post('invoice_proform_date');
        $recur_frequency = $this->input->post('recur_frequency');

        echo increment_user_date($invoice_date, $recur_frequency);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'invoice_proform_id' => $this->input->post('invoice_proform_id'),
            //'clients' => $this->mdl_clients->get()->result(),
            'clients' => $this->mdl_clients->where('is_valid', 1)->get()->result(),
        );

        $this->layout->load_view('invoices_proform/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('invoices_proform/mdl_invoices');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $invoice_id = $this->input->post('invoice_proform_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('invoice_proform_id', $invoice_id);
            $this->db->update('ip_invoices_proform', $db_array);

            $response = array(
                'success' => 1,
                'invoice_proform_id' => $invoice_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_copy_invoice()
    {
        $this->load->module('layout');

        $this->load->model('invoices_proform/mdl_invoices');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'invoice_proform_id' => $this->input->post('invoice_proform_id'),
            'invoice_proform' => $this->mdl_invoices->where('ip_invoices_proform.invoice_proform_id', $this->input->post('invoice_proform_id'))->get()->row()
        );

        $this->layout->load_view('invoices_proform/modal_copy_invoice', $data);
    }

    public function copy_invoice()
    {
        $this->load->model('invoices_proform/mdl_invoices');
        $this->load->model('invoices_proform/mdl_items');
        $this->load->model('invoices_proform/mdl_invoice_tax_rates');

        if ($this->mdl_invoices->run_validation()) {
            $target_id = $this->mdl_invoices->save();
            $source_id = $this->input->post('invoice_proform_id');

            $this->mdl_invoices->copy_invoice($source_id, $target_id);

            $response = array(
                'success' => 1,
                'invoice_proform_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_create_credit()
    {
        $this->load->module('layout');

        $this->load->model('invoices_proform/mdl_invoices');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'invoice_proform_id' => $this->input->post('invoice_proform_id'),
            'invoice_proform' => $this->mdl_invoices->where('ip_invoices_proform.invoice_proform_id', $this->input->post('invoice_proform_id'))->get()->row()
        );

        $this->layout->load_view('invoices_proform/modal_create_credit', $data);
    }

    public function create_credit()
    {
        $this->load->model('invoices_proform/mdl_invoices');
        $this->load->model('invoices_proform/mdl_items');
        $this->load->model('invoices_proform/mdl_invoice_tax_rates');

        if ($this->mdl_invoices->run_validation()) {
            $target_id = $this->mdl_invoices->save();
            $source_id = $this->input->post('invoice_proform_id');

            $this->mdl_invoices->copy_credit_invoice($source_id, $target_id);

            // Set source invoice to read-only
            if ($this->config->item('disable_read_only') == FALSE) {
                $this->mdl_invoices->where('invoice_proform_id', $source_id);
                $this->mdl_invoices->update('ip_invoices_proform', array('is_read_only' => '1'));
            }

            // Set target invoice to credit invoice
            $this->mdl_invoices->where('invoice_proform_id', $target_id);
            $this->mdl_invoices->update('ip_invoices_proform', array('creditinvoice_parent_id' => $source_id));

            $this->mdl_invoices->where('invoice_proform_id', $target_id);
            $this->mdl_invoices->update('ip_invoice_proform_amounts', array('invoice_sign' => '-1'));

            $oq_res = $this->db->query("SELECT max(invoice_proform_number) as fn FROM ip_invoices_proform WHERE invoice_proform_number like 'AV%'")->result_array();
            $dtp = substr($oq_res[0]['fn'],0,2);
            $dnm = substr($oq_res[0]['fn'],2);
            $dnm = intval($dnm)+1;
            $cnote_nm = $dtp.$dnm;

            $this->mdl_invoices->where('invoice_proform_id', $target_id);
            $this->mdl_invoices->update('ip_invoices_proform', array('invoice_proform_number' => $cnote_nm));

            $response = array(
                'success' => 1,
                'invoice_proform_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

}
