<div class="table-responsive">
    <table class="table table-striped">

        <thead>
        <tr style="background-color: #ededed;">
            <th><?php echo lang('status'); ?></th>
            <th><?php echo lang('invoice'); ?></th>
            <th><?php echo lang('created'); ?></th>
            <th><?php echo lang('due_date'); ?></th>
            <th><?php echo lang('personal_information'); ?></th>
            <th><?php echo lang('zip_code_city'); ?></th>
            <th><?php echo lang('comercial'); ?></th>
            <th style="text-align: right;"><?php echo lang('subtotal_net_ht'); ?></th>
            <th style="text-align: right;"><?php echo lang('total_ttc'); ?></th>
            <th style="text-align: right;"><?php echo lang('owes'); ?></th>
            <th><?php echo lang('options'); ?></th>
        </tr>
        </thead>

        <tbody>
        <?php foreach ($invoices as $invoice) {
            //print_r($invoice);
            if ($invoice->invoice_sign == '-1') {
                if ($this->config->item('disable_read_only') == TRUE) {
                    $invoice->is_read_only = 0;
                }
                /*if($invoice->creditinvoice_parent_id != null && $invoice->creditinvoice_parent_id != '')*/
                if ($invoice->invoice_balance > 0) {
                    echo '<tr style="background-color:#f9e8e8">';
                } else {
                    echo '<tr>';
                }
                ?>
                <td>
                    <span class="label <?php echo $invoice_statuses[$invoice->invoice_status_id]['class']; ?>">
                        <?php echo $invoice_statuses[$invoice->invoice_status_id]['label'];
                        if ($invoice->invoice_sign == '-1') { ?>
                            &nbsp;<i class="fa"
                                     title="<?php echo lang('credit_invoice') ?>">- €</i>
                        <?php }
                        if ($invoice->is_read_only == 1) { ?>
                            &nbsp;<i class="fa fa-read-only"
                                     title="<?php echo lang('read_only') ?>"></i>
                        <?php }; ?>
                    </span>
                </td>

                <td>
                    <a href="<?php echo site_url('invoices/view/' . $invoice->invoice_id); ?>"
                       title="<?php echo lang('edit'); ?>">
                        <?php echo $invoice->invoice_number; ?>
                    </a>
                </td>

                <td>
                    <?php echo date_from_mysql($invoice->invoice_date_created); ?>
                </td>

                <td>
                    <span class="<?php if ($invoice->is_overdue) { ?>font-overdue<?php } ?>">
                        <?php echo date_from_mysql($invoice->invoice_date_due); ?>
                    </span>
                </td>

                <td>
                    <a href="<?php echo site_url('clients/view/' . $invoice->client_id); ?>"
                       title="<?php echo lang('view_client'); ?>">
                        <?php echo $invoice->client_name; ?>
                    </a>
                </td>

                <td>
                    <?php //echo anchor('clients/view/' . $invoice->client_id, $invoice->client_zip.' - '.$invoice->client_country); ?>
                    <?php echo anchor('clients/view/' . $invoice->client_id, $invoice->client_zip . ' - ' . $invoice->client_city . ' - ' . $invoice->client_country); ?>
                </td>

                <td>
                    <?php
                    /*if(strlen($invoice->user_name) > 8)
                    {
                    echo substr($invoice->user_name,0,7).'...';
                    }
                    else
                    {*/
                    echo $invoice->user_name;
                    /*}*/
                    ?>
                </td>

                <td class="amount <?php if ($invoice->invoice_sign == '-1') {
                    echo 'text-danger';
                }; ?>">
                    <?php //print_r($invoice); ?>
                    <?php //echo format_currency($invoice->invoice_total); ?>
                    <?php //echo format_currency($invoice->invoice_item_subtotal); ?>
                    <?php if ($invoice->invoice_discount_percent != "0.00") {
                        echo format_currency($invoice->invoice_item_subtotal - ($invoice->invoice_item_subtotal * ($invoice->invoice_discount_percent / 100)));
                    } elseif ($invoice->invoice_discount_amount != "0.00") {
                        echo format_currency($invoice->invoice_item_subtotal - $invoice->invoice_discount_amount);
                    } else {
                        echo format_currency($invoice->invoice_item_subtotal);
                    } ?>
                </td>
                <td class="amount <?php if ($invoice->invoice_sign == '-1') {
                    echo 'text-danger';
                }; ?>">
                    <?php //echo format_currency($invoice->invoice_total); ?>
                    <?php echo format_currency($invoice->invoice_total); ?>
                </td>

                <td class="amount">
                    <?php
                    if ($invoice->creditinvoice_parent_id != null && $invoice->creditinvoice_parent_id != '') {
                        ?>
                        <a href="<?php echo site_url('invoices/view/' . $invoice->creditinvoice_parent_id); ?>"
                           title="<?php echo lang('edit'); ?>">
                            <?php echo $invoice->creditinvoice_parent_id; ?>
                        </a>
                        <?php
                    } else {
                        ?>
                        <span class="<?php if ($invoice->invoice_balance > 0) { ?>font-overdue<?php } ?>">
                            <?php echo format_currency($invoice->invoice_balance); ?>
                        </span>
                    <?php } ?>
                    <?php //echo format_currency($invoice->invoice_balance); ?>
                </td>

                <td>
                    <div class="options btn-group">
                        <a class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" href="#">
                            <i class="fa fa-cog"></i> <?php echo lang('options'); ?>
                        </a>
                        <ul class="dropdown-menu">
                            <?php if ($invoice->is_read_only != 1) { ?>
                                <li>
                                    <a href="<?php echo site_url('invoices/view/' . $invoice->invoice_id); ?>">
                                        <i class="fa fa-edit fa-margin"></i> <?php echo lang('edit'); ?>
                                    </a>
                                </li>
                            <?php } ?>
                            <li>
                                <a href="<?php echo site_url('invoices/generate_pdf/' . $invoice->invoice_id); ?>"
                                   target="_blank">
                                    <i class="fa fa-file-pdf-o fa-margin"></i> <?php echo lang('download_pdf'); ?>
                                </a>
                            </li>
                            <li>
                                <?php /*<a href="<?php echo site_url('mailer/invoice/' . $invoice->invoice_id); ?>">
                                    <i class="fa fa-send fa-margin"></i> <?php echo lang('send_email'); ?>
                                </a>*/ ?>
                                <?php if ($invoice->creditinvoice_parent_id != null && $invoice->creditinvoice_parent_id != '') {
                                    $subject = sprintf(lang('avoir_email_subject'),
                                        $invoice->invoice_number
                                    );
                                    $body = sprintf(nl2br(lang('avoir_email_body')),
                                        $invoice->invoice_number
                                    );
                                    $body = str_replace('<spc>', '%0D%0A', $body);
                                } else {
                                    $subject = sprintf(lang('invoice_email_subject'),
                                        $invoice->invoice_number
                                    );
                                    $body = sprintf(nl2br(lang('invoice_email_body')),
                                        $invoice->invoice_number
                                    );
                                    $body = str_replace('<spc>', '%0D%0A', $body);
                                } ?>
                                <a href="mailto:<?php echo $invoice->client_email; ?>?Subject=<?php echo $subject; ?>&Body=<?php echo $body; ?>">
                                    <i class="fa fa-send fa-margin"></i> <?php echo lang('send_email'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#" class="invoice-add-payment"
                                   data-invoice-id="<?php echo $invoice->invoice_id; ?>"
                                   data-invoice-balance="<?php echo $invoice->invoice_balance; ?>"
                                   data-invoice-payment-method="<?php echo $invoice->payment_method; ?>">
                                    <i class="fa fa-money fa-margin"></i>
                                    <?php echo lang('enter_payment'); ?>
                                </a>
                            </li>
                            <?php if ($invoice->invoice_status_id == 1 || ($this->config->item('enable_invoice_deletion') === TRUE && $invoice->is_read_only != 1)) { ?>
                                <li>
                                    <a href="<?php echo site_url('invoices/delete/' . $invoice->invoice_id); ?>"
                                       onclick="return confirm('<?php echo lang('delete_invoice_warning'); ?>');">
                                        <i class="fa fa-trash-o fa-margin"></i> <?php echo lang('delete'); ?>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </td>
                </tr>
                <?php
            }
        } ?>
        </tbody>

    </table>
</div>