<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->load->model('invoices/mdl_items');
        $this->load->model('invoices/mdl_invoices');
        $this->load->model('item_lookups/mdl_item_lookups');

        $invoice_id = $this->input->post('invoice_id');

        $this->mdl_invoices->set_id($invoice_id);

        $i_prv_stt = $this->db->query("SELECT invoice_status_id, client_id FROM ip_invoices WHERE invoice_number = '".$this->input->post('invoice_number')."'")->result_array();

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('Pre Validation', now() )");

        //if ($this->mdl_invoices->run_validation('validation_rules_save_invoice')) {
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('Inside Validation', now() )");
            $items = json_decode($this->input->post('items'));

            $plist = $this->db->query("SELECT * FROM ip_products WHERE inactive = 0 ORDER BY product_order")->result_array();

            $error = 0;

            foreach ($items as $item) {
                $exists = 0;

                foreach ($plist as $pl) {
                    if ($pl['product_sku'] == $item->item_description || $item->item_description == "") {
                        $exists = 1;
                    }

                    //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$pl['product_sku']." ".$item->item_description."', now() )");
                }

                if ($exists == 0) {
                    //ERRO
                    $this->load->helper('json_error');
                    $response = array(
                        'success' => 0,
                        'validation_errors' => 'SKU_ERROR'
                    );

                    $error = 1;
                }

            }

            if ($error == 0) {
                $ord = 1;
                foreach ($items as $item) {
                    $flg = 0;
                    if ($item->item_name) {
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM NAME " . $item->item_name . "', now() )");
                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM DESCRIPTION " . $item->item_description . "', now() )");

                        $nameS = str_replace("[+Logo]", "", $item->item_name);
                        $nameS = str_replace("[Logo]", "", $item->item_name);
                        $nameS = str_replace("[ Logo]", "", $item->item_name);
                        $nameS = str_replace("Logo", "", $item->item_name);

                        //$rf = $this->db->query("SELECT product_sku FROM ip_products WHERE product_name like trim('%".$nameS."%') limit 1;");

                        //$rf= $this->db->query("SELECT product_sku FROM ip_products WHERE product_name like trim('%".$nameS."%') limit 1")->result_array();
                        $srcprd = $this->db->query("SELECT product_sku FROM ip_products WHERE product_name like trim('%" . $nameS . "%') limit 1")->result_array();

                        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM DESCRIPTION AFTER SELECT " . $srcprd[0]['product_sku'] . "', now() )");

                        if (($srcprd[0]['product_sku'] != $item->item_description) AND ($srcprd[0]['product_sku'] != null) AND ($srcprd[0]['product_sku'] != "")) {
                            $item->item_description = $srcprd[0]['product_sku'];
                        }

                        if ( $item->item_description == 'DIVERS' && ( $item->item_id == NULL || $item->item_id == '' ) )
                        {
                            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('DIVERS - TEST', now() )");
                            $flg = 1;
                            $flg_prc = $item->item_price;
                            $item->item_price = 1;
                        }
                        // Check if an item has either a quantity + price or name or description
                        if ($item->item_quantity != 0 && $item->item_price != 0
                            || $item->item_name != 0
                            || $item->item_description != 0
                        ) {
                            if( $flg == 1 )
                            {
                                $item->item_price = $flg_prc;
                                $flg = 0;
                            }
                        	//$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('IF QTT != 0 " . $srcprd[0]['product_sku'] . "', now() )");
                            if($item->item_id == NULL || $item->item_id == '')
                            {
                                $item->item_quantity = standardize_amount($item->item_quantity);
                                $item->item_price = standardize_amount($item->item_price);
                                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM LOGO " . $item->item_logo . "', now() )");
                                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM COLOR " . $item->item_color_num . "', now() )");
                                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM BAT NUM " . $item->item_bat_num . "', now() )");
                                
                                $this->db->query("INSERT INTO ip_invoice_items (invoice_id, item_tax_rate_id, item_date_added, item_name, item_description, item_quantity, item_price, item_discount_amount, item_logo, item_color_num, item_bat_num, item_order) VALUES (".$invoice_id.", 0, '2018-12-27', '".$item->item_name."', '".$item->item_description."', ".$item->item_quantity.", ".$item->item_price.", ".$item->item_discount_amount.", '".$item->item_logo."', '".$item->item_color_num."', '".$item->item_bat_num."', ".$ord.")");
                                
                                //$item_id = ($item->item_id) ?: NULL;
                                $itmid = $this->db->query("SELECT MAX(item_id) AS item_id FROM ip_invoice_items")->result_array();
                                $item_id = $itmid[0]['item_id'];
                                unset($item->item_id, $item->save_item_as_lookup);

                                $this->db->query("INSERT INTO ip_invoice_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) VALUES (".$item_id.", '".($item->item_price * $item->item_quantity)."', '0.00', '0.00', '".($item->item_price * $item->item_quantity)."')");

                                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM ID " . $item_id . "', now() )");
                                //$this->mdl_items->save($invoice_id, $item_id, $item);
                                $ord++;
                            }
                            else
                            {
                                $item->item_quantity = standardize_amount($item->item_quantity);
                                $item->item_price = standardize_amount($item->item_price);
                                $item->item_discount_amount = standardize_amount($item->item_discount_amount);
                                $item_id = ($item->item_id) ?: NULL;
                                unset($item->item_id, $item->save_item_as_lookup);
                                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM ID " . $item_id . "', now() )");
                                $this->mdl_items->save($invoice_id, $item_id, $item);
                            }
                        } else {
                        	//$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ELSE QTT != 0 " . $srcprd[0]['product_sku'] . "', now() )");
                            // Throw an error message and use the form validation for that
                            /*$this->load->library('form_validation');
                            $this->form_validation->set_rules('item_name', lang('item'), 'required');
                            $this->form_validation->set_rules('item_description', lang('description'), 'required');
                            $this->form_validation->set_rules('item_quantity', lang('quantity'), 'required');
                            $this->form_validation->set_rules('item_price', lang('price'), 'required');
                            $this->form_validation->run();

                            $response = array(
                                'success' => 0,
                                'validation_errors' => array(
                                    'item_name' => form_error('item_name', '', ''),
                                    'item_description' => form_error('item_description', '', ''),
                                    'item_quantity' => form_error('item_quantity', '', ''),
                                    'item_price' => form_error('item_price', '', ''),
                                )
                            );
                            echo json_encode($response);
                            exit;*/
                        }
                    }
                }

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER ITEMS', now() )");

                $invoice_status = $this->input->post('invoice_status_id');

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER STATUS', now() )");

                if($this->input->post('invoice_date_due') == '' || $this->input->post('invoice_date_due') == NULL)
                {
                    $date_due = $this->input->post('invoice_date_created');
                }
                else
                {
                    $date_due = $this->input->post('invoice_date_due');
                }

                $db_array = array(
                    'invoice_number' => $this->input->post('invoice_number'),
                    'invoice_terms' => $this->input->post('invoice_terms'),
                    'invoice_date_created' => date_to_mysql($this->input->post('invoice_date_created')),
                    'invoice_date_due' => date_to_mysql($date_due),
                    'invoice_password' => $this->input->post('invoice_password'),
                    'invoice_status_id' => $invoice_status,
                    'payment_method' => $this->input->post('payment_method'),
                    'invoice_discount_amount' => $this->input->post('invoice_discount_amount'),
                    'invoice_discount_percent' => $this->input->post('invoice_discount_percent'),
                );

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER DB_ARRAY', now() )");

                // check if status changed to sent, the feature is enabled and settings is set to sent
                if ($invoice_status == 2 && $this->config->item('disable_read_only') == FALSE && $this->mdl_settings->setting('read_only_toggle') == 'sent') {
                    $db_array['is_read_only'] = 1;
                }

                // check if status changed to viewed, the feature is enabled and settings is set to viewed
                if ($invoice_status == 3 && $this->config->item('disable_read_only') == FALSE && $this->mdl_settings->setting('read_only_toggle') == 'viewed') {
                    $db_array['is_read_only'] = 1;
                }

                // check if status changed to paid and the feature is enabled
                if ($invoice_status == 4 && $this->config->item('disable_read_only') == FALSE && $this->mdl_settings->setting('read_only_toggle') == 'paid') {
                    $db_array['is_read_only'] = 1;
                }

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER IS READ ONLY VALIDATION', now() )");

                $this->mdl_invoices->save($invoice_id, $db_array);

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER SAVE', now() )");

                // Recalculate for discounts
                $this->load->model('invoices/mdl_invoice_amounts');
                $this->mdl_invoice_amounts->calculate($invoice_id);

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('AFTER MODAL AMOUNTS', now() )");

                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('INVOICE STATUS PRV ".$i_prv_stt[0]['invoice_status_id']."', now() )");

                //if($i_prv_stt[0]['invoice_status_id'] != 2 && $i_prv_stt[0]['invoice_status_id'] != 4 && $i_prv_stt[0]['invoice_status_id'] != 6)
                //{
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('INVOICE STATUS AFTR ".$invoice_status."', now() )");

                    //if($invoice_status == 2 || $invoice_status == 4 || $invoice_status == 6)
                    //{
                        $c_res = $this->db->query("SELECT * FROM ip_clients WHERE client_id = ".$i_prv_stt[0]['client_id'])->result_array();

                        $c_res[0]['client_name'] = str_replace("'", "´", $c_res[0]['client_name']);
                        $c_res[0]['client_name_p1'] = str_replace("'", "´", $c_res[0]['client_name_p1']);
                        $c_res[0]['client_address_1'] = str_replace("'", "´", $c_res[0]['client_address_1']);
                        $c_res[0]['client_address_2'] = str_replace("'", "´", $c_res[0]['client_address_2']);
                        $c_res[0]['client_zip'] = str_replace("'", "´", $c_res[0]['client_zip']);
                        $c_res[0]['client_city'] = str_replace("'", "´", $c_res[0]['client_city']);
                        $c_res[0]['client_country'] = str_replace("'", "´", $c_res[0]['client_country']);
                        $c_res[0]['client_vat_id'] = str_replace("'", "´", $c_res[0]['client_vat_id']);
                        $c_res[0]['client_phone'] = str_replace("'", "´", $c_res[0]['client_phone']);
                        $c_res[0]['client_email'] = str_replace("'", "´", $c_res[0]['client_email']);
                        $c_res[0]['client_address_delivery_1'] = str_replace("'", "´", $c_res[0]['client_address_delivery_1']);
                        $c_res[0]['client_address_delivery_2'] = str_replace("'", "´", $c_res[0]['client_address_delivery_2']);
                        $c_res[0]['client_delivery_zip'] = str_replace("'", "´", $c_res[0]['client_delivery_zip']);
                        $c_res[0]['client_delivery_city'] = str_replace("'", "´", $c_res[0]['client_delivery_city']);
                        $c_res[0]['client_delivery_country'] = str_replace("'", "´", $c_res[0]['client_delivery_country']);
                        $c_res[0]['client_delivery_company'] = str_replace("'", "´", $c_res[0]['client_delivery_company']);
                        $c_res[0]['client_delivery_contact'] = str_replace("'", "´", $c_res[0]['client_delivery_contact']);
                        $c_res[0]['client_delivery_phone'] = str_replace("'", "´", $c_res[0]['client_delivery_phone']);
                        
                        $updt_oquo_cstmr = $this->db->query("UPDATE ip_invoices SET
                                                    invoice_client_name = '".$c_res[0]['client_name']."',
                                                    invoice_client_name_p1 = '".$c_res[0]['client_name_p1']."',
                                                    invoice_client_address_1 = '".$c_res[0]['client_address_1']."',
                                                    invoice_client_address_2 = '".$c_res[0]['client_address_2']."',
                                                    invoice_client_zip = '".$c_res[0]['client_zip']."',
                                                    invoice_client_city = '".$c_res[0]['client_city']."',
                                                    invoice_client_country = '".$c_res[0]['client_country']."',
                                                    invoice_client_vat_id = '".$c_res[0]['client_vat_id']."',
                                                    invoice_client_phone = '".$c_res[0]['client_phone']."',
                                                    invoice_client_email = '".$c_res[0]['client_email']."',
                                                    invoice_client_delivery_address = '".$c_res[0]['client_address_delivery_1']." ".$c_res[0]['client_address_delivery_2']."',
                                                    invoice_client_delivery_local = '".$c_res[0]['client_delivery_zip']." ".$c_res[0]['client_delivery_city']." ".$c_res[0]['client_delivery_country']."',
                                                    invoice_client_delivery_company = '".$c_res[0]['client_delivery_company']."',
                                                    invoice_client_delivery_contact = '".$c_res[0]['client_delivery_contact']."',
                                                    invoice_client_delivery_phone = '".$c_res[0]['client_delivery_phone']."'
                                                WHERE invoice_id = ".$this->input->post('invoice_id'));
                    //}
                //}

                $response = array(
                    'success' => 1
                );
            } else {
                $this->load->helper('json_error');
                $response = array(
                    'success' => 0,
                    'validation_errors' => json_errors()
                );
            }

            if ($this->input->post('custom')) {
                $db_array = array();

                foreach ($this->input->post('custom') as $custom) {
                    // I hate myself for this...
                    $db_array[str_replace(']', '', str_replace('custom[', '', $custom['name']))] = $custom['value'];
                }

                $this->load->model('custom_fields/mdl_invoice_custom');
                $this->mdl_invoice_custom->save_custom($invoice_id, $db_array);
            }
        //}

        echo json_encode($response);
    }

    public function save_invoice_tax_rate()
    {
        $this->load->model('invoices/mdl_invoice_tax_rates');

        if ($this->mdl_invoice_tax_rates->run_validation()) {
            $this->mdl_invoice_tax_rates->save($this->input->post('invoice_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_invoice_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function undo_invoice()
    {
        $invoice_id = $this->input->post('invoice_id');

        $this->db->query("UPDATE ip_invoices SET invoice_status_id = 2, is_read_only = 0 WHERE invoice_id = " . $invoice_id );

        $response = array(
            'success' => 1
        );

        echo json_encode($response);
    }

    public function create()
    {
        $this->load->model('invoices/mdl_invoices');

        if ($this->mdl_invoices->run_validation()) {
            $invoice_id = $this->mdl_invoices->create();

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        if($this->input->post('client_id') != "" &&  $this->input->post('client_id') != NULL && $this->input->post('client_id') > 0)
        {
            $this->db->query("UPDATE ip_invoices SET client_id = " . $this->input->post('client_id') . " WHERE invoice_id = " . $invoice_id);
        }

        echo json_encode($response);
    }

    public function create_recurring()
    {
        $this->load->model('invoices/mdl_invoices_recurring');

        if ($this->mdl_invoices_recurring->run_validation()) {
            $this->mdl_invoices_recurring->save();

            $response = array(
                'success' => 1,
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('invoices/mdl_items');

        $item = $this->mdl_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_invoice()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('clients/mdl_clients');

        if($this->input->post('client_id') != "" && $this->input->post('client_id') != NULL && $this->input->post('client_id') > 0)
        {
            $data = array(
                'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
                'client_name' => $this->input->post('client_name'),
                'client_id' => $this->input->post('client_id'),
                //'clients' => $this->mdl_clients->get()->result(),
                //'clients' => $this->mdl_clients->where('client_active', 1)->get()->result(),
                'clients' => $this->mdl_clients->where('is_valid', 1)->limit(1550)->get()->result(),
            );
        }
        else
        {
            $data = array(
                'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
                'client_name' => $this->input->post('client_name'),
                //'clients' => $this->mdl_clients->get()->result(),
                //'clients' => $this->mdl_clients->where('client_active', 1)->get()->result(),
                'clients' => $this->mdl_clients->where('is_valid', 1)->limit(1550)->get()->result(),
            );
        }

        $this->layout->load_view('invoices/modal_create_invoice', $data);
    }

    public function modal_create_recurring()
    {
        $this->load->module('layout');

        $this->load->model('mdl_invoices_recurring');

        $data = array(
            'invoice_id' => $this->input->post('invoice_id'),
            'recur_frequencies' => $this->mdl_invoices_recurring->recur_frequencies
        );

        $this->layout->load_view('invoices/modal_create_recurring', $data);
    }

    public function get_recur_start_date()
    {
        $invoice_date = $this->input->post('invoice_date');
        $recur_frequency = $this->input->post('recur_frequency');

        echo increment_user_date($invoice_date, $recur_frequency);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'invoice_id' => $this->input->post('invoice_id'),
            //'clients' => $this->mdl_clients->get()->result(),
            'clients' => $this->mdl_clients->where('is_valid', 1)->get()->result(),
        );

        $this->layout->load_view('invoices/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('invoices/mdl_invoices');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $invoice_id = $this->input->post('invoice_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('invoice_id', $invoice_id);
            $this->db->update('ip_invoices', $db_array);

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_copy_invoice()
    {
        $this->load->module('layout');

        $this->load->model('invoices/mdl_invoices');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'invoice_id' => $this->input->post('invoice_id'),
            'invoice' => $this->mdl_invoices->where('ip_invoices.invoice_id', $this->input->post('invoice_id'))->get()->row()
        );

        $this->layout->load_view('invoices/modal_copy_invoice', $data);
    }

    public function copy_invoice()
    {
        $this->load->model('invoices/mdl_invoices');
        $this->load->model('invoices/mdl_items');
        $this->load->model('invoices/mdl_invoice_tax_rates');

        if ($this->mdl_invoices->run_validation()) {
            $target_id = $this->mdl_invoices->save();
            $source_id = $this->input->post('invoice_id');

            $this->mdl_invoices->copy_invoice($source_id, $target_id);

            $response = array(
                'success' => 1,
                'invoice_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_create_credit()
    {
        $this->load->module('layout');

        $this->load->model('invoices/mdl_invoices');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'invoice_id' => $this->input->post('invoice_id'),
            'invoice' => $this->mdl_invoices->where('ip_invoices.invoice_id', $this->input->post('invoice_id'))->get()->row()
        );

        $this->layout->load_view('invoices/modal_create_credit', $data);
    }

    public function create_credit()
    {
        $this->load->model('invoices/mdl_invoices');
        $this->load->model('invoices/mdl_items');
        $this->load->model('invoices/mdl_invoice_tax_rates');

        if ($this->mdl_invoices->run_validation()) {
            $target_id = $this->mdl_invoices->save();
            $source_id = $this->input->post('invoice_id');

            $this->mdl_invoices->copy_credit_invoice($source_id, $target_id);

            // Set source invoice to read-only
            if ($this->config->item('disable_read_only') == FALSE) {
                $this->mdl_invoices->where('invoice_id', $source_id);
                $this->mdl_invoices->update('ip_invoices', array('is_read_only' => '1'));
            }

            // Set target invoice to credit invoice
            $this->mdl_invoices->where('invoice_id', $target_id);
            $this->mdl_invoices->update('ip_invoices', array('creditinvoice_parent_id' => $source_id));

            $this->mdl_invoices->where('invoice_id', $target_id);
            $this->mdl_invoices->update('ip_invoice_amounts', array('invoice_sign' => '-1'));

            $oq_res = $this->db->query("SELECT invoice_number as fn FROM ip_invoices WHERE invoice_number like 'AV%' ORDER BY invoice_id DESC LIMIT 1")->result_array();
            $dtp = substr($oq_res[0]['fn'],0,2);
            $dnm = substr($oq_res[0]['fn'],2);
            $dnm = intval($dnm)+1;
            $cnote_nm = $dtp.$dnm;

            $this->mdl_invoices->where('invoice_id', $target_id);
            $this->mdl_invoices->update('ip_invoices', array('invoice_number' => $cnote_nm));

            $response = array(
                'success' => 1,
                'invoice_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

}
