<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function filter_products()
    {
        if ( is_array( $data ) )
            $output = "<script>console.log( 'Debug Objects: " . implode( ',', $data) . "' );</script>";
        else
            $output = "<script>console.log( 'Debug Objects: " . $data . "' );</script>";

        echo $output;



        $this->load->model('products/mdl_products');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_products->like("CONCAT_WS('^',product_sku)", $keyword);
                $kw = $keyword;
            }
        }

        $results = $this->db->query("SELECT * FROM ip_products WHERE product_sku like '%$kw%'")->result_array();

        $data = array(
            //'products' => $this->mdl_products->get()->result()
            'products' => $this->db->query("SELECT * FROM ip_products WHERE product_sku like '%$kw%'")->result_array()
        );

        $this->layout->load_view('products/partial_product_table', $data);
    }

    public function filter_invoices()
    {
        $this->load->model('invoices/mdl_invoices');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_invoices->like("CONCAT_WS('^',LOWER(invoice_number),invoice_date_created,invoice_date_due,LOWER(client_name),invoice_total,invoice_balance,client_zip,client_city,client_country)", $keyword);
            }
        }

        $data = array(
            'invoices' => $this->mdl_invoices->limit(100)->get()->result(),
            'invoice_statuses' => $this->mdl_invoices->statuses()
        );

        $this->layout->load_view('invoices/partial_invoice_table', $data);
    }

    public function filter_quotes()
    {
        $this->load->model('quotes/mdl_quotes');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        $this->mdl_quotes->like("CONCAT_WS('^',LOWER(quote_number),quote_date_created,quote_date_expires,LOWER(client_name),quote_total,client_zip,client_city,client_country,user_name)", $query);

        /*foreach ($keywords as $keyword) {
            if ($keyword) {
                $output = "<script>console.log( 'Debug keyword: " . $keyword . "' );</script>";
                echo $output;
                $keyword = strtolower($keyword);
                //$this->mdl_quotes->like("CONCAT_WS('^',LOWER(quote_number),quote_date_created,quote_date_expires,LOWER(client_name),quote_total,client_zip,client_city,client_country)", $keyword);
                $this->mdl_quotes->like("CONCAT_WS('^',LOWER(quote_number),quote_date_created,quote_date_expires,LOWER(client_name),quote_total,client_zip,client_city,client_country,user_name)", $keyword);
                //$this->mdl_quotes->like("CONCAT_WS('^',LOWER(quote_number),quote_date_created,quote_date_expires,LOWER(client_name),LOWER(client_name_p1),quote_total,client_zip,client_city,client_country,user_name)", $keyword);
            }
        }*/

        //$this->mdl_quotes->limit(20)->get()->result()
        $data = array(
            //'quotes' => $this->mdl_quotes->get()->result(),
            'quotes' => $this->mdl_quotes->limit(100)->get()->result(),
            'quote_statuses' => $this->mdl_quotes->statuses()
        );

        /*if (is_array($data))
        {
            $output = "<script>console.log( 'Debug Objects: " . implode(',', $data) . "' );</script>";
            foreach ($data['quotes'] as $key => $val) {
                $output = "<script>console.log( 'Debug Objects key: " . implode(',', $key) . "' );</script>";
                echo $output;
                $output = "<script>console.log( 'Debug Objects val: " . implode(',', $val) . "' );</script>";
                echo $output;
            }
        }
        else
            $output = "<script>console.log( 'Debug Objects: " . $data . "' );</script>";

        echo $output;*/

        $this->layout->load_view('quotes/partial_quote_table', $data);
    }

    public function filter_clients()
    {
        $this->load->model('clients/mdl_clients');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_clients->like("CONCAT_WS('^',LOWER(client_name),LOWER(client_name_p1),LOWER(client_email),client_phone,client_active,client_zip,client_country,client_city)", $keyword);
                //$this->mdl_clients->like("CONCAT_WS('^',LOWER(client_name),LOWER(client_email),client_phone,client_active)", $keyword);
            }
        }

        //'quotes' => $this->mdl_quotes->limit(900)->get()->result(),

        $data = array(
            'records' => $this->mdl_clients->limit(100)->with_total_balance()->get()->result()
            //'records' => $this->mdl_clients->with_total_balance()->get()->result()
        );

        $this->layout->load_view('clients/partial_client_table', $data);
    }

    public function filter_payments()
    {
        $this->load->model('payments/mdl_payments');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_payments->like("CONCAT_WS('^',payment_date,LOWER(invoice_number),LOWER(client_name),payment_amount,LOWER(payment_method_name),LOWER(payment_note))", $keyword);
            }
        }

        $data = array(
            'payments' => $this->mdl_payments->limit(100)->get()->result()
        );

        $this->layout->load_view('payments/partial_payment_table', $data);
    }

    public function filter_online_quotes()
    {
        $this->load->model('online_quotes/mdl_quotes');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        /*foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                //$this->mdl_quotes->like("CONCAT_WS('^',LOWER(online_quote_number),online_quote_date_created,online_quote_date_expires,LOWER(client_name),online_quote_total,client_zip)", $keyword);
                $kw = $keyword;
            }
        }

        $results = $this->db->query("SELECT * FROM ip_online_quotes oq JOIN ip_clients c ON oq.client_id = c.client_id JOIN ip_online_quote_amounts oqa ON oqa.online_quote_id = oq.online_quote_id
                                      WHERE online_quote_number like '%".$kw."%'
                                      OR online_quote_date_created like '%".$kw."%'
                                      OR online_quote_date_expires like '%".$kw."%'
                                      OR LOWER(client_name) like '%".$kw."%'
                                      OR online_quote_total like '%".$kw."%'
                                      OR client_zip like '%".$kw."%'")->result_array();*/

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_quotes->like("CONCAT_WS('^',LOWER(online_quote_number),online_quote_date_created,online_quote_date_expires,LOWER(client_name),online_quote_total,client_zip,client_city,client_country)", $keyword);
            }
        }

        /*if (is_array($results))
        {
            //$output = "<script>console.log( 'Debug Objects: " . implode(',', $results) . "' );</script>";
            foreach ($results as $result) {
                $output = "<script>console.log( 'Debug Objects 1: " . implode(',', $result) . "' );</script>";
                echo $output;
            }
        }
        else
            $output = "<script>console.log( 'Debug Objects 2: " . $results . "' );</script>";

        echo $output;*/

        //print_r($this->mdl_quotes->get()->result());

        $data = array(
            'online_quotes' => $this->mdl_quotes->limit(100)->get()->result(),
            'online_quote_statuses' => $this->mdl_quotes->statuses()
        );

        $this->layout->load_view('online_quotes/partial_quote_table', $data);
    }

    public function filter_production()
    {
        $this->load->model('production/mdl_quotes');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_quotes->like("CONCAT_WS('^',LOWER(production_number),production_date_created,production_date_expires,LOWER(client_name),LOWER(client_name_p1),week,production_total,client_zip,client_city,client_country)", $keyword);
            }
        }

        $data = array(
            'production' => $this->mdl_quotes->get()->result(),
            //'online_quotes' => $results,
            'production_statuses' => $this->mdl_quotes->statuses()
        );

        $this->layout->load_view('production/partial_quote_table', $data);
    }

    public function filter_supplier()
    {
        $this->load->model('supplier/mdl_quotes');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_quotes->like("CONCAT_WS('^',LOWER(supplier_order_number),supplier_order_date_created,supplier_order_date_expires,LOWER(supplier_name),supplier_order_total)", $keyword);
            }
        }

        $data = array(
            'supplier_order' => $this->mdl_quotes->get()->result(),
            //'online_quotes' => $results,
            'supplier_order_statuses' => $this->mdl_quotes->statuses()
        );

        $this->layout->load_view('supplier/partial_quote_table', $data);
    }

    public function filter_transport()
    {
        $this->load->model('bon_livraison/mdl_quotes');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_quotes->like("CONCAT_WS('^',LOWER(transport_number),transport_date_created,transport_date_expires,LOWER(client_name),LOWER(client_name_p1),client_phone,transport_total,client_zip,client_city,client_country,origin_quote)", $keyword);
            }
        }

        $data = array(
            'transport' => $this->mdl_quotes->limit(100)->get()->result(),
            //'online_quotes' => $results,
            'transport_statuses' => $this->mdl_quotes->statuses()
        );

        $this->layout->load_view('bon_livraison/partial_quote_table', $data);
    }

    public function filter_products2()
    {
        $this->load->model('products/mdl_quotes');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_products->like("CONCAT_WS('^',product_sku)", $keyword);
            }
        }

        $data = array(
            'products' => $this->mdl_products->get()->result(),
            //'online_quotes' => $results,
            //'product_statuses' => $this->mdl_products->statuses()
        );

        $this->layout->load_view('products/partial_product_table', $data);
    }
	
	public function filter_invoices_proform()
    {
        $this->load->model('invoices_proform/mdl_invoices');

        $query = $this->input->post('filter_query');

        $keywords = explode(' ', $query);
        $params = array();

        foreach ($keywords as $keyword) {
            if ($keyword) {
                $keyword = strtolower($keyword);
                $this->mdl_invoices->like("CONCAT_WS('^',LOWER(invoice_proform_number),invoice_proform_date_created,invoice_proform_date_due,LOWER(client_name),invoice_proform_total,invoice_proform_balance,client_zip,client_city,client_country)", $keyword);
            }
        }

        $data = array(
            'invoices_proform' => $this->mdl_invoices->get()->result(),
            'invoice_proform_statuses' => $this->mdl_invoices->statuses()
        );

        $this->layout->load_view('invoices_proform/partial_invoice_table', $data);
    }

}
