<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Dashboard extends Admin_Controller
{
    public function index()
    {
        $this->load->model('invoices/mdl_invoice_amounts');
        $this->load->model('quotes/mdl_quote_amounts');
        $this->load->model('online_quotes/mdl_online_dashboard');
        $this->load->model('invoices/mdl_invoices');
        $this->load->model('quotes/mdl_quotes');
        $this->load->model('dashboard/data_load');

        $quote_overview_period = $this->mdl_settings->setting('quote_overview_period');
        $invoice_overview_period = $this->mdl_settings->setting('invoice_overview_period');

        $this->layout->set(
            array(
                'invoice_status_totals' => $this->mdl_invoice_amounts->get_status_totals($invoice_overview_period),
                'quote_status_totals' => $this->mdl_quote_amounts->get_status_totals($quote_overview_period),
                'online_quote_status_totals' => $this->mdl_online_dashboard->get_online_status_totals($quote_overview_period),
                'invoice_status_period' => str_replace('-', '_', $invoice_overview_period),
                'quote_status_period' => str_replace('-', '_', $quote_overview_period),
                'invoices' => $this->mdl_invoices->limit(10)->get()->result(),
                'quotes' => $this->mdl_quotes->limit(10)->get()->result(),
                'online_quotes' => $this->mdl_online_dashboard->get_last_online(10),
                'invoice_statuses' => $this->mdl_invoices->statuses(),
                'quote_statuses' => $this->mdl_quotes->statuses(),
                'online_quote_statuses' => $this->mdl_online_dashboard->online_statuses(),
                'overdue_invoices' => $this->mdl_invoices->is_overdue()->limit(10)->get()->result(),
                'quote_messages' => $this->data_load->get_total_quote_messages($quote_overview_period),
                'invoice_messages' => $this->data_load->get_total_invoice_messages($quote_overview_period),
                'quote_month' => $this->data_load->get_quote_number($quote_overview_period),
                'quote_month_value' => $this->data_load->get_quote_value($quote_overview_period),
                'online_quote_month_value' => $this->data_load->get_online_quote_value($quote_overview_period),
                'invoice_month' => $this->data_load->get_invoice_number($quote_overview_period),
                'invoice_month_value' => $this->data_load->get_invoice_value($quote_overview_period)
            )
        );

        $this->layout->buffer('content', 'dashboard/index');
        $this->layout->render();
    }

}
