<script type="text/javascript">
    $(function () {
        $('#save_client_note').click(function () {
            $.post("<?php echo site_url('clients/ajax/save_client_note'); ?>",
                {
                    client_id: $('#client_id').val(),
                    client_note: $('#client_note').val()
                }, function (data) {
                    var response = JSON.parse(data);
                    if (response.success == '1') {
                        // The validation was successful
                        $('.control-group').removeClass('error');
                        $('#client_note').val('');

                        $('#notes_list').load("<?php echo site_url('clients/ajax/load_client_notes'); ?>",
                            {
                                client_id: <?php echo $client->client_id; ?>
                            });
                    }
                    else {
                        // The validation was not successful
                        $('.control-group').removeClass('error');
                        for (var key in response.validation_errors) {
                            $('#' + key).parent().parent().addClass('error');
                        }
                    }
                });
        });

    });
</script>

<?php $prd_quo = $this->db->query("SELECT qi.item_description AS Ref, SUM(qi.item_quantity) AS Qtt
                                      FROM ip_quote_items qi
                                      JOIN ip_quotes q ON q.quote_id = qi.quote_id
                                      WHERE q.client_id = ".$client->client_id."
                                      GROUP BY qi.item_description
                                      ORDER BY Qtt DESC;")->result_array();?>

<?php $prd_inv = $this->db->query("SELECT ii.item_description AS Ref, SUM(ii.item_quantity) AS Qtt
                                      FROM ip_invoice_items ii
                                      JOIN ip_invoices i ON i.invoice_id = ii.invoice_id
                                      WHERE i.client_id = ".$client->client_id."
                                      GROUP BY ii.item_description
                                      ORDER BY Qtt DESC;")->result_array(); ?>

<?php $oq_lst = $this->db->query("SELECT oq.online_quote_number, oq.online_quote_date_created, oq.online_quote_status_id, oq.online_quote_date_modified, oqa.online_quote_item_subtotal, oq.online_client_name, CONCAT(oq.online_client_zip, ' - ', oq.online_client_city, ' - ', oq.online_client_country ) AS place
                                      FROM ip_online_quotes oq
                                      JOIN ip_online_quote_amounts oqa ON oq.online_quote_id = oqa.online_quote_id
                                      WHERE oq.client_id = ".$client->client_id."
                                      ORDER BY oq.online_quote_id DESC;")->result_array(); ?>

<div id="headerbar">
    <div class="pull-left">
        <h1><?php echo $client->client_name; ?></h1>
    </div>
    <div class="pull-right btn-group">
        <a href="#" class="btn btn-sm btn-default client-create-quote"
           data-client-name="<?php echo $client->client_name; ?>" data-client-id="<?php echo $client->client_id; ?>">
            <i class="fa fa-file"></i> <?php echo lang('create_quote'); ?>
        </a>
        <a href="#" class="btn btn-sm btn-default client-create-invoice"
           data-client-name="<?php echo $client->client_name; ?>" data-client-id="<?php echo $client->client_id; ?>">
            <i class="fa fa-file-text""></i> <?php echo lang('create_invoice'); ?></a>
        <a href="<?php echo site_url('clients/form/' . $client->client_id); ?>"
           class="btn btn-sm btn-default">
            <i class="fa fa-edit"></i> <?php echo lang('edit'); ?>
        </a>

        <!--<a class="btn btn-sm btn-danger"
           href="<?php echo site_url('clients/delete/' . $client->client_id); ?>"
           onclick="return confirm('<?php echo lang('delete_client_warning'); ?>');">
            <i class="fa fa-trash-o"></i> <?php echo lang('delete'); ?>
        </a>-->
    </div>

</div>

<ul id="settings-tabs" class="nav nav-tabs nav-tabs-noborder">
    <li class="active"><a data-toggle="tab" href="#clientDetails"><?php echo lang('details'); ?></a></li>
    <li><a data-toggle="tab" href="#clientQuotes"><?php echo lang('hst_quotes'); ?></a></li>
    <li><a data-toggle="tab" href="#clientInvoices"><?php echo lang('hst_invoices'); ?></a></li>
    <li><a data-toggle="tab" href="#clientPayments"><?php echo lang('hst_payments'); ?></a></li>
    <li><a data-toggle="tab" href="#clientNC"><?php echo lang('hst_nc'); ?></a></li>
    <li><a data-toggle="tab" href="#clientProducts"><?php echo lang('hst_products'); ?></a></li>
    <li><a data-toggle="tab" href="#clientOnlineQuotes"><?php echo lang('hst_online_quotes'); ?></a></li>
    <li><a data-toggle="tab" href="#clientProforma"><?php echo lang('hst_proforma'); ?></a></li>
    <li><a data-toggle="tab" href="#clientProduction"><?php echo lang('hst_production'); ?></a></li>
    <li><a data-toggle="tab" href="#clientTransport"><?php echo lang('hst_transport'); ?></a></li>
</ul>

<div class="tabbable tabs-below">

    <div class="tab-content">

        <div id="clientDetails" class="tab-pane tab-info active">

            <?php $this->layout->load_view('layout/alerts'); ?>

            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-6 col-lg-8">
                    <h3><?php echo $client->client_name; ?></h3>

                    <p>
                        <?php echo ($client->client_address_1) ? $client->client_address_1 . '<br>' : ''; ?>
                        <?php echo ($client->client_address_2) ? $client->client_address_2 . '<br>' : ''; ?>
                        <?php echo ($client->client_zip) ? $client->client_zip : ''; ?>
                        <?php echo ($client->client_city) ? $client->client_city : ''; ?>
                        <?php echo ($client->client_state) ? $client->client_state : ''; ?>
                        <?php echo ($client->client_country) ? '<br>' . $client->client_country : ''; ?>
                    </p>
                </div>
                <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4">
                    <table class="table table-condensed table-bordered">
                        <tr>
                            <td>
                                <b><?php echo lang('total_billed'); ?></b>
                            </td>
                            <td class="td-amount">
                                <?php echo format_currency($client->client_invoice_total); ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <b><?php echo lang('total_paid'); ?></b>
                            </td>
                            <td class="td-amount">
                                <?php echo format_currency($client->client_invoice_paid); ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <b><?php echo lang('total_balance'); ?></b>
                            </td>
                            <td class="td-amount">
                                <?php echo format_currency($client->client_invoice_balance); ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <hr/>

            <div class="row">
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('contact_information'); ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if (isset($client->client_gender) && $client->client_gender == 0) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('mr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->client_gender) && $client->client_gender == 1) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('ms'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->client_gender) && $client->client_gender == 2) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('msr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_name_p1) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo auto_link($client->client_name_p1, 'name'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_email) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo auto_link($client->client_email, 'email'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_phone) { ?>
                            <tr>
                                <td><?php echo lang('phone'); ?></td>
                                <td><?php echo $client->client_phone; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_mobile) { ?>
                            <tr>
                                <td><?php echo lang('mobile'); ?></td>
                                <td><?php echo $client->client_mobile; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_fax) { ?>
                            <tr>
                                <td><?php echo lang('fax'); ?></td>
                                <td><?php echo $client->client_fax; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_web) { ?>
                            <tr>
                                <td><?php echo lang('web'); ?></td>
                                <td><?php echo auto_link($client->client_web, 'url', TRUE); ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td><?php echo lang('segment_lbl'); ?></td>
                            <td>
                                <?php if ($client->client_segm == 0) echo lang('other_segment'); ?>
                                <?php if ($client->client_segm == 1) echo lang('com_segment'); ?>
                                <?php if ($client->client_segm == 2) echo lang('event_segment'); ?>
                                <?php if ($client->client_segm == 3) echo lang('rest_segment'); ?>
                                <?php if ($client->client_segm == 4) echo lang('bev_segment'); ?>
                                <?php if ($client->client_segm == 5) echo lang('collective_segment'); ?>
                                <?php if ($client->client_segm == 6) echo lang('reseller_segment'); ?>
                                <?php if ($client->client_segm == 7) echo lang('supplier_segment'); ?>
                                <?php if ($client->client_segm == 8) echo lang('camp_segment'); ?>
                                <?php if ($client->client_segm == 9) echo lang('treat_segment'); ?>
                                <?php if ($client->client_segm == 10) echo lang('assoc_segment'); ?>
                                <?php if ($client->client_segm == 11) echo lang('private_segment'); ?>

                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('tax_information'); ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->client_vat_id) { ?>
                            <tr>
                                <td><?php echo lang('vat_id'); ?></td>
                                <td><?php echo $client->client_vat_id; ?></td>
                            </tr>
                        <?php } ?>
                        <?php /*if ($client->client_tax_code) { ?>
                            <tr>
                                <td><?php echo lang('tax_code'); ?></td>
                                <td><?php echo $client->client_tax_code; ?></td>
                            </tr>
                        <?php }*/ ?>
                    </table>
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('contact_information')." 2"; ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if (isset($client->client_gender_2) && $client->client_gender_2 == 0) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('mr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->client_gender_2) && $client->client_gender_2 == 1) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('ms'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if (isset($client->client_gender_2) && $client->client_gender_2 == 2) { ?>
                            <tr>
                                <td><?php echo lang('gender'); ?></td>
                                <td><?php echo lang('msr'); ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_name_p2) { ?>
                            <tr>
                                <td><?php echo lang('name')." 2"; ?></td>
                                <td><?php echo $client->client_name_p2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_email2) { ?>
                            <tr>
                                <td><?php echo lang('email')." 2"; ?></td>
                                <td><?php echo $client->client_email2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_phone2) { ?>
                            <tr>
                                <td><?php echo lang('phone')." 2"; ?></td>
                                <td><?php echo $client->client_phone2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_mobile_p2) { ?>
                            <tr>
                                <td><?php echo lang('mobile')." 2"; ?></td>
                                <td><?php echo $client->client_mobile_p2; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>

                <?php if ($client->client_address_delivery_1) { ?>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('delivery_address'); ?></h4>
                    <?php //print_r($client);?>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->client_delivery_company) { ?>
                            <tr>
                                <td><?php echo lang('personal_information'); ?></td>
                                <td><?php echo $client->client_delivery_company; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_contact) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo $client->client_delivery_contact; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_address_delivery_1) { ?>
                            <tr>
                                <td><?php echo lang('street_address'); ?></td>
                                <td><?php echo $client->client_address_delivery_1;
                                    if ($client->client_address_delivery_2) {
                                        echo '<br />';
                                        echo $client->client_address_delivery_2;
                                    }?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_zip) { ?>
                            <tr>
                                <td><?php echo lang('zip_code'); ?></td>
                                <td><?php echo $client->client_delivery_zip; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_city) { ?>
                            <tr>
                                <td><?php echo lang('city'); ?></td>
                                <td><?php echo $client->client_delivery_city; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_country) { ?>
                            <tr>
                                <td><?php echo lang('country'); ?></td>
                                <td><?php echo $client->client_delivery_country; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_phone) { ?>
                            <tr>
                                <td><?php echo lang('phone_number'); ?></td>
                                <td><?php echo $client->client_delivery_phone; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_email) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo $client->client_delivery_email; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <?php } ?>

            </div>

            <div class="row">
            	<?php if ($client->client_address_delivery_1_2) { ?>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('delivery_address') . ' 2'; ?></h4>
                    <?php //print_r($client);?>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->client_delivery_company2) { ?>
                            <tr>
                                <td><?php echo lang('personal_information'); ?></td>
                                <td><?php echo $client->client_delivery_company2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_contact2) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo $client->client_delivery_contact2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_address_delivery_1_2) { ?>
                            <tr>
                                <td><?php echo lang('street_address'); ?></td>
                                <td><?php echo $client->client_address_delivery_1_2;
                                    if ($client->client_address_delivery_2_2) {
                                        echo '<br />';
                                        echo $client->client_address_delivery_2_2;
                                    }?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_zip2) { ?>
                            <tr>
                                <td><?php echo lang('zip_code'); ?></td>
                                <td><?php echo $client->client_delivery_zip2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_city2) { ?>
                            <tr>
                                <td><?php echo lang('city'); ?></td>
                                <td><?php echo $client->client_delivery_city2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_country2) { ?>
                            <tr>
                                <td><?php echo lang('country'); ?></td>
                                <td><?php echo $client->client_delivery_country2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_phone2) { ?>
                            <tr>
                                <td><?php echo lang('phone_number'); ?></td>
                                <td><?php echo $client->client_delivery_phone2; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_email2) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo $client->client_delivery_email2; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <?php } ?>

                <?php if ($client->client_address_delivery_1_3) { ?>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('delivery_address') . ' 3'; ?></h4>
                    <?php //print_r($client);?>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->client_delivery_company3) { ?>
                            <tr>
                                <td><?php echo lang('personal_information'); ?></td>
                                <td><?php echo $client->client_delivery_company3; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_contact3) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo $client->client_delivery_contact3; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_address_delivery_1_3) { ?>
                            <tr>
                                <td><?php echo lang('street_address'); ?></td>
                                <td><?php echo $client->client_address_delivery_1_3;
                                    if ($client->client_address_delivery_2_3) {
                                        echo '<br />';
                                        echo $client->client_address_delivery_2_3;
                                    }?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_zip3) { ?>
                            <tr>
                                <td><?php echo lang('zip_code'); ?></td>
                                <td><?php echo $client->client_delivery_zip3; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_city3) { ?>
                            <tr>
                                <td><?php echo lang('city'); ?></td>
                                <td><?php echo $client->client_delivery_city3; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_country3) { ?>
                            <tr>
                                <td><?php echo lang('country'); ?></td>
                                <td><?php echo $client->client_delivery_country3; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_phone3) { ?>
                            <tr>
                                <td><?php echo lang('phone_number'); ?></td>
                                <td><?php echo $client->client_delivery_phone3; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_email3) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo $client->client_delivery_email3; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <?php } ?>

            </div>

            <div class="row">
                <?php if ($client->client_address_delivery_1_4) { ?>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('delivery_address') . ' 4'; ?></h4>
                    <?php //print_r($client);?>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->client_delivery_company4) { ?>
                            <tr>
                                <td><?php echo lang('personal_information'); ?></td>
                                <td><?php echo $client->client_delivery_company4; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_contact4) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo $client->client_delivery_contact4; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_address_delivery_1_4) { ?>
                            <tr>
                                <td><?php echo lang('street_address'); ?></td>
                                <td><?php echo $client->client_address_delivery_1_4;
                                    if ($client->client_address_delivery_2_4) {
                                        echo '<br />';
                                        echo $client->client_address_delivery_2_4;
                                    }?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_zip4) { ?>
                            <tr>
                                <td><?php echo lang('zip_code'); ?></td>
                                <td><?php echo $client->client_delivery_zip4; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_city4) { ?>
                            <tr>
                                <td><?php echo lang('city'); ?></td>
                                <td><?php echo $client->client_delivery_city4; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_country4) { ?>
                            <tr>
                                <td><?php echo lang('country'); ?></td>
                                <td><?php echo $client->client_delivery_country4; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_phone4) { ?>
                            <tr>
                                <td><?php echo lang('phone_number'); ?></td>
                                <td><?php echo $client->client_delivery_phone4; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_email4) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo $client->client_delivery_email4; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <?php } ?>

                <?php if ($client->client_address_delivery_1_5) { ?>
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('delivery_address') . ' 5'; ?></h4>
                    <?php //print_r($client);?>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php if ($client->client_delivery_company5) { ?>
                            <tr>
                                <td><?php echo lang('personal_information'); ?></td>
                                <td><?php echo $client->client_delivery_company5; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_contact5) { ?>
                            <tr>
                                <td><?php echo lang('name'); ?></td>
                                <td><?php echo $client->client_delivery_contact5; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_address_delivery_1_5) { ?>
                            <tr>
                                <td><?php echo lang('street_address'); ?></td>
                                <td><?php echo $client->client_address_delivery_1_5;
                                    if ($client->client_address_delivery_2_5) {
                                        echo '<br />';
                                        echo $client->client_address_delivery_2_5;
                                    }?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_zip5) { ?>
                            <tr>
                                <td><?php echo lang('zip_code'); ?></td>
                                <td><?php echo $client->client_delivery_zip5; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_city5) { ?>
                            <tr>
                                <td><?php echo lang('city'); ?></td>
                                <td><?php echo $client->client_delivery_city5; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_country5) { ?>
                            <tr>
                                <td><?php echo lang('country'); ?></td>
                                <td><?php echo $client->client_delivery_country5; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_phone5) { ?>
                            <tr>
                                <td><?php echo lang('phone_number'); ?></td>
                                <td><?php echo $client->client_delivery_phone5; ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($client->client_delivery_email5) { ?>
                            <tr>
                                <td><?php echo lang('email'); ?></td>
                                <td><?php echo $client->client_delivery_email5; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <?php } ?>

            </div>

            <div class="row">
                <div class="col-xs-12 col-md-6">
                    <h4><?php echo lang('custom_fields'); ?></h4>
                    <br/>
                    <table class="table table-condensed table-striped">
                        <?php foreach ($custom_fields as $custom_field) { ?>
                            <tr>
                                <td><?php echo $custom_field->custom_field_label ?></td>
                                <td><?php echo $client->{$custom_field->custom_field_column}; ?></td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
            </div>

            <hr/>

            <div>
                <h4><?php echo lang('notes'); ?></h4>
                <br/>
                    <?php echo nl2br($client->client_notes); ?>
                <!--<div id="notes_list">
                    <?php echo $partial_notes; ?>
                </div>
                <div class="panel panel-default panel-body">
                    <form class="row">
                        <div class="col-xs-12 col-md-10">
                            <input type="hidden" name="client_id" id="client_id"
                                   value="<?php echo $client->client_id; ?>">
                            <textarea id="client_note" class="form-control" rows="1"></textarea>
                        </div>
                        <div class="col-xs-12 col-md-2 text-center">
                            <input type="button" id="save_client_note" class="btn btn-default btn-block"
                                   value="<?php echo lang('add_notes'); ?>">
                        </div>
                    </form>
                </div>-->
            </div>

        </div>

        <div id="clientQuotes" class="tab-pane table-content">
            <?php echo $quote_table; ?>
        </div>

        <div id="clientInvoices" class="tab-pane table-content">
            <?php echo $invoice_table; ?>
        </div>

        <div id="clientPayments" class="tab-pane table-content">
            <?php echo $payment_table; ?>
        </div>

        <div id="clientNC" class="tab-pane table-content">
            <?php echo $nc_table; ?>
        </div>

        <div id="clientProducts" class="tab-pane table-content">
            <div style="width: 49%; float: left; display: inline-block">
                <div class="table-responsive">
                    <table class="table table-striped">

                        <thead>
                        <tr style="background-color: #ededed;" >
                            <th style="text-align: center;" colspan="2"><?php echo strtoupper(lang('quote')); ?></th>
                        </tr>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('product_sku'); ?></th>
                            <th><?php echo lang('quantity'); ?></th>
                        </tr>
                        </thead>
                        <?php
                        foreach($prd_quo AS $row)
                        {
                            echo '<tr>';
                            echo '<td>'.$row['Ref'].'</td>';
                            echo '<td>'.$row['Qtt'].'</td>';
                            echo '</tr>';
                        }
                        ?>
                    </table>
                </div>
            </div>
            <div style="width: 50%; float: right; display: inline-block">
                <div class="table-responsive">
                    <table class="table table-striped">

                        <thead>
                        <tr style="background-color: #ededed;" >
                            <th style="text-align: center;" colspan="2"><?php echo strtoupper(lang('invoices')); ?></th>
                        </tr>
                        <tr style="background-color: #ededed;">
                            <th><?php echo lang('product_sku'); ?></th>
                            <th><?php echo lang('quantity'); ?></th>
                        </tr>
                        </thead>
                        <?php
                        foreach($prd_inv AS $row)
                        {
                            echo '<tr>';
                            echo '<td>'.$row['Ref'].'</td>';
                            echo '<td>'.$row['Qtt'].'</td>';
                            echo '</tr>';
                        }
                        ?>
                    </table>
                </div>
            </div>
        </div>

        <div id="clientOnlineQuotes" class="tab-pane table-content">
            <?php echo $online_quote_table; ?>
        </div>

        <div id="clientProforma" class="tab-pane table-content">
            <?php echo $proform_table; ?>
        </div>

        <div id="clientProduction" class="tab-pane table-content">
            <?php echo $production_table; ?>
        </div>

        <div id="clientTransport" class="tab-pane table-content">
            <?php echo $transport_table; ?>
        </div>
    </div>

</div>