<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

class Clients extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_clients');
    }

    public function index()
    {
        // Display active clients by default
        redirect('clients/status/active');
    }

    public function status($status = 'active', $page = 0)
    {
        if (is_numeric(array_search($status, array('active', 'inactive')))) {
            $function = 'is_' . $status;
            $this->mdl_clients->$function();
        }

        $this->mdl_clients->with_total_balance()->paginate(site_url('clients/status/' . $status), $page);
        $clients = $this->mdl_clients->result();

        $this->layout->set(
            array(
                'records' => $clients,
                'filter_display' => TRUE,
                'filter_placeholder' => lang('filter_clients'),
                'filter_method' => 'filter_clients'
            )
        );

        $this->layout->buffer('content', 'clients/index');
        $this->layout->render();
    }

    public function calculate_transports($page = 0)
    {
        //$this->layout->set('products', $products);
        $this->load->helper('country');
        $this->layout->set('countries', get_country_list(lang('cldr')));
        //$this->layout->set('selected_country', $this->mdl_clients->form_value('client_country') ?: $this->mdl_settings->setting('default_country'));
        $this->layout->buffer('content', 'clients/calculator');
        $this->layout->render();
    }

    public function form($id = NULL)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('clients');
        }

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('FORM INSERT-UPDATE CLIENT - IS UPDATE ".$this->input->post('is_update')."', now() )");

        if ($this->mdl_clients->run_validation()) {

            $_POST['client_name'] = str_replace("'", "´", $_POST['client_name']);
            $_POST['client_name_p1'] = str_replace("'", "´", $_POST['client_name_p1']);
            $_POST['client_name_p2'] = str_replace("'", "´", $_POST['client_name_p2']);
            $_POST['client_name_p3'] = str_replace("'", "´", $_POST['client_name_p3']);
            $_POST['client_address_1'] = str_replace("'", "´", $_POST['client_address_1']);
            $_POST['client_address_2'] = str_replace("'", "´", $_POST['client_address_2']);
            $_POST['client_city'] = str_replace("'", "´", $_POST['client_city']);
            $_POST['client_name'] = str_replace('"', "´´", $_POST['client_name']);
            $_POST['client_name_p1'] = str_replace('"', "´´", $_POST['client_name_p1']);
            $_POST['client_name_p2'] = str_replace('"', "´´", $_POST['client_name_p2']);
            $_POST['client_name_p3'] = str_replace('"', "´´", $_POST['client_name_p3']);
            $_POST['client_address_1'] = str_replace('"', "´´", $_POST['client_address_1']);
            $_POST['client_address_2'] = str_replace('"', "´´", $_POST['client_address_2']);
            $_POST['client_city'] = str_replace('"', "´´", $_POST['client_city']);
            /* Delivery 1 */
            $_POST['client_address_delivery_1'] = str_replace("'", "´", $_POST['client_address_delivery_1']);
            $_POST['client_address_delivery_2'] = str_replace("'", "´", $_POST['client_address_delivery_2']);
            $_POST['client_delivery_zip'] = str_replace("'", "´", $_POST['client_delivery_zip']);
            $_POST['client_delivery_city'] = str_replace("'", "´", $_POST['client_delivery_city']);
            $_POST['client_delivery_country'] = str_replace("'", "´", $_POST['client_delivery_country']);
            $_POST['client_delivery_company'] = str_replace("'", "´", $_POST['client_delivery_company']);
            $_POST['client_delivery_email'] = str_replace("'", "´", $_POST['client_delivery_email']);
            $_POST['client_delivery_contact'] = str_replace("'", "´", $_POST['client_delivery_contact']);
            $_POST['client_delivery_phone'] = str_replace("'", "´", $_POST['client_delivery_phone']);
            $_POST['client_address_delivery_1'] = str_replace('"', "´´", $_POST['client_address_delivery_1']);
            $_POST['client_address_delivery_2'] = str_replace('"', "´´", $_POST['client_address_delivery_2']);
            $_POST['client_delivery_zip'] = str_replace('"', "´´", $_POST['client_delivery_zip']);
            $_POST['client_delivery_city'] = str_replace('"', "´´", $_POST['client_delivery_city']);
            $_POST['client_delivery_country'] = str_replace('"', "´´", $_POST['client_delivery_country']);
            $_POST['client_delivery_company'] = str_replace('"', "´´", $_POST['client_delivery_company']);
            $_POST['client_delivery_email'] = str_replace('"', "´´", $_POST['client_delivery_email']);
            $_POST['client_delivery_contact'] = str_replace('"', "´´", $_POST['client_delivery_contact']);
            $_POST['client_delivery_phone'] = str_replace('"', "´´", $_POST['client_delivery_phone']);
            /* Delivery 2 */
            $_POST['client_address_delivery_1_2'] = str_replace("'", "´", $_POST['client_address_delivery_1_2']);
            $_POST['client_address_delivery_2_2'] = str_replace("'", "´", $_POST['client_address_delivery_2_2']);
            $_POST['client_delivery_zip2'] = str_replace("'", "´", $_POST['client_delivery_zip2']);
            $_POST['client_delivery_city2'] = str_replace("'", "´", $_POST['client_delivery_city2']);
            $_POST['client_delivery_country2'] = str_replace("'", "´", $_POST['client_delivery_country2']);
            $_POST['client_delivery_company2'] = str_replace("'", "´", $_POST['client_delivery_company2']);
            $_POST['client_delivery_email2'] = str_replace("'", "´", $_POST['client_delivery_email2']);
            $_POST['client_delivery_contact2'] = str_replace("'", "´", $_POST['client_delivery_contact2']);
            $_POST['client_delivery_phone2'] = str_replace("'", "´", $_POST['client_delivery_phone2']);
            $_POST['client_address_delivery_1_2'] = str_replace('"', "´´", $_POST['client_address_delivery_1_2']);
            $_POST['client_address_delivery_2_2'] = str_replace('"', "´´", $_POST['client_address_delivery_2_2']);
            $_POST['client_delivery_zip2'] = str_replace('"', "´´", $_POST['client_delivery_zip2']);
            $_POST['client_delivery_city2'] = str_replace('"', "´´", $_POST['client_delivery_city2']);
            $_POST['client_delivery_country2'] = str_replace('"', "´´", $_POST['client_delivery_country2']);
            $_POST['client_delivery_company2'] = str_replace('"', "´´", $_POST['client_delivery_company2']);
            $_POST['client_delivery_email2'] = str_replace('"', "´´", $_POST['client_delivery_email2']);
            $_POST['client_delivery_contact2'] = str_replace('"', "´´", $_POST['client_delivery_contact2']);
            $_POST['client_delivery_phone2'] = str_replace('"', "´´", $_POST['client_delivery_phone2']);
            /* Delivery 3 */
            $_POST['client_address_delivery_1_3'] = str_replace("'", "´", $_POST['client_address_delivery_1_3']);
            $_POST['client_address_delivery_2_3'] = str_replace("'", "´", $_POST['client_address_delivery_2_3']);
            $_POST['client_delivery_zip3'] = str_replace("'", "´", $_POST['client_delivery_zip3']);
            $_POST['client_delivery_city3'] = str_replace("'", "´", $_POST['client_delivery_city3']);
            $_POST['client_delivery_country3'] = str_replace("'", "´", $_POST['client_delivery_country3']);
            $_POST['client_delivery_company3'] = str_replace("'", "´", $_POST['client_delivery_company3']);
            $_POST['client_delivery_email3'] = str_replace("'", "´", $_POST['client_delivery_email3']);
            $_POST['client_delivery_contact3'] = str_replace("'", "´", $_POST['client_delivery_contact3']);
            $_POST['client_delivery_phone3'] = str_replace("'", "´", $_POST['client_delivery_phone3']);
            $_POST['client_address_delivery_1_3'] = str_replace('"', "´´", $_POST['client_address_delivery_1_3']);
            $_POST['client_address_delivery_2_3'] = str_replace('"', "´´", $_POST['client_address_delivery_2_3']);
            $_POST['client_delivery_zip3'] = str_replace('"', "´´", $_POST['client_delivery_zip3']);
            $_POST['client_delivery_city3'] = str_replace('"', "´´", $_POST['client_delivery_city3']);
            $_POST['client_delivery_country3'] = str_replace('"', "´´", $_POST['client_delivery_country3']);
            $_POST['client_delivery_company3'] = str_replace('"', "´´", $_POST['client_delivery_company3']);
            $_POST['client_delivery_email3'] = str_replace('"', "´´", $_POST['client_delivery_email3']);
            $_POST['client_delivery_contact3'] = str_replace('"', "´´", $_POST['client_delivery_contact3']);
            $_POST['client_delivery_phone3'] = str_replace('"', "´´", $_POST['client_delivery_phone3']);
            /* Delivery 4 */
            $_POST['client_address_delivery_1_4'] = str_replace("'", "´", $_POST['client_address_delivery_1_4']);
            $_POST['client_address_delivery_2_4'] = str_replace("'", "´", $_POST['client_address_delivery_2_4']);
            $_POST['client_delivery_zip4'] = str_replace("'", "´", $_POST['client_delivery_zip4']);
            $_POST['client_delivery_city4'] = str_replace("'", "´", $_POST['client_delivery_city4']);
            $_POST['client_delivery_country4'] = str_replace("'", "´", $_POST['client_delivery_country4']);
            $_POST['client_delivery_company4'] = str_replace("'", "´", $_POST['client_delivery_company4']);
            $_POST['client_delivery_email4'] = str_replace("'", "´", $_POST['client_delivery_email4']);
            $_POST['client_delivery_contact4'] = str_replace("'", "´", $_POST['client_delivery_contact4']);
            $_POST['client_delivery_phone4'] = str_replace("'", "´", $_POST['client_delivery_phone4']);
            $_POST['client_address_delivery_1_4'] = str_replace('"', "´´", $_POST['client_address_delivery_1_4']);
            $_POST['client_address_delivery_2_4'] = str_replace('"', "´´", $_POST['client_address_delivery_2_4']);
            $_POST['client_delivery_zip4'] = str_replace('"', "´´", $_POST['client_delivery_zip4']);
            $_POST['client_delivery_city4'] = str_replace('"', "´´", $_POST['client_delivery_city4']);
            $_POST['client_delivery_country4'] = str_replace('"', "´´", $_POST['client_delivery_country4']);
            $_POST['client_delivery_company4'] = str_replace('"', "´´", $_POST['client_delivery_company4']);
            $_POST['client_delivery_email4'] = str_replace('"', "´´", $_POST['client_delivery_email4']);
            $_POST['client_delivery_contact4'] = str_replace('"', "´´", $_POST['client_delivery_contact4']);
            $_POST['client_delivery_phone4'] = str_replace('"', "´´", $_POST['client_delivery_phone4']);
            /* Delivery 5 */
            $_POST['client_address_delivery_1_5'] = str_replace("'", "´", $_POST['client_address_delivery_1_5']);
            $_POST['client_address_delivery_2_5'] = str_replace("'", "´", $_POST['client_address_delivery_2_5']);
            $_POST['client_delivery_zip5'] = str_replace("'", "´", $_POST['client_delivery_zip5']);
            $_POST['client_delivery_city5'] = str_replace("'", "´", $_POST['client_delivery_city5']);
            $_POST['client_delivery_country5'] = str_replace("'", "´", $_POST['client_delivery_country5']);
            $_POST['client_delivery_company5'] = str_replace("'", "´", $_POST['client_delivery_company5']);
            $_POST['client_delivery_email5'] = str_replace("'", "´", $_POST['client_delivery_email5']);
            $_POST['client_delivery_contact5'] = str_replace("'", "´", $_POST['client_delivery_contact5']);
            $_POST['client_delivery_phone5'] = str_replace("'", "´", $_POST['client_delivery_phone5']);
            $_POST['client_address_delivery_1_5'] = str_replace('"', "´´", $_POST['client_address_delivery_1_5']);
            $_POST['client_address_delivery_2_5'] = str_replace('"', "´´", $_POST['client_address_delivery_2_5']);
            $_POST['client_delivery_zip5'] = str_replace('"', "´´", $_POST['client_delivery_zip5']);
            $_POST['client_delivery_city5'] = str_replace('"', "´´", $_POST['client_delivery_city5']);
            $_POST['client_delivery_country5'] = str_replace('"', "´´", $_POST['client_delivery_country5']);
            $_POST['client_delivery_company5'] = str_replace('"', "´´", $_POST['client_delivery_company5']);
            $_POST['client_delivery_email5'] = str_replace('"', "´´", $_POST['client_delivery_email5']);
            $_POST['client_delivery_contact5'] = str_replace('"', "´´", $_POST['client_delivery_contact5']);
            $_POST['client_delivery_phone5'] = str_replace('"', "´´", $_POST['client_delivery_phone5']);

            if($_POST['client_active'] == 1)
            {
                if($_POST['client_name'] == '' || $_POST['client_email'] == '' || $_POST['client_phone'] == '' || $_POST['client_country'] == '' || $_POST['client_address_1'] == '' || $_POST['client_city'] == '' || $_POST['client_zip'] == '' || $_POST['client_name'] == NULL || $_POST['client_email'] == NULL || $_POST['client_phone'] == NULL || $_POST['client_country'] == NULL || $_POST['client_address_1'] == NULL || $_POST['client_city'] == NULL || $_POST['client_zip'] == NULL )
                {
                    $nm=$eml=$phn=$cntr=$adr=$cty=$zip=0;

                    if($_POST['client_name'] == '' || $_POST['client_name'] == NULL)
                    {
                        $nm = 1;
                    }
                    if($_POST['client_email'] == '' || $_POST['client_email'] == NULL)
                    {
                        $eml = 1;
                    }
                    if($_POST['client_phone'] == '' || $_POST['client_phone'] == NULL)
                    {
                        $phn = 1;
                    }
                    if($_POST['client_country'] == '' || $_POST['client_country'] == NULL)
                    {
                        $cntr = 1;
                    }
                    if($_POST['client_address_1'] == '' || $_POST['client_address_1'] == NULL)
                    {
                        $adr = 1;
                    }
                    if($_POST['client_city'] == '' || $_POST['client_city'] == NULL)
                    {
                        $cty = 1;
                    }
                    if($_POST['client_zip'] == '' || $_POST['client_zip'] == NULL)
                    {
                        $zip = 1;
                    }

                    $error = lang('mandatory_fields').($nm == 1 ? lang('personal_information').', ' : '').($eml == 1 ? lang('email_address').', ' : '').($phn == 1 ? lang('phone_abbr').', ' : '').($cntr == 1 ? lang('country').', ' : '').($adr == 1 ? lang('street_address').', ' : '').($cty == 1 ? lang('city').', ' : '').($zip == 1 ? lang('zip_code') : '').'.';

                    $this->session->set_flashdata('alert_error', $error);
                }
                else
                {
                    $id = $this->mdl_clients->save($id);

                    $this->load->model('custom_fields/mdl_client_custom');

                    $this->mdl_client_custom->save_custom($id, $this->input->post('custom'));

                    /* SPECIAL CUSTOMER FIELDS MANUALLY INSERT HERE */
                    //[client_name_p1] => Nome1 [client_name_p2] => Nome2 [client_email2] => Email2 [client_phone2] => Phone2 [client_mobile_p2] => Movel2
                    if($_POST['no_cee'] == '' || $_POST['no_cee'] == NULL)
                    {
                        $_POST['no_cee'] = 0;
                    }

                    /*if($_POST['client_notes'] != '' && $_POST['client_notes'] == NULL)
                    {
                        $_POST['client_notes'] = str_replace("'", "\'", $_POST['client_notes']);
                    }*/

                    if($_POST['client_closed'] == '' || $_POST['client_closed'] == NULL)
                    {
                        $_POST['client_closed'] = 0;
                    }

                    $isrt_cstm_spcl = $this->db->query("UPDATE ip_clients SET
                                                                client_name_p1 = '".addslashes($_POST['client_name_p1'])."',
                                                                client_name_p2 = '".addslashes($_POST['client_name_p2'])."',
                                                                client_name_p3 = '".addslashes($_POST['client_name_p3'])."',
                                                                client_email2 = '".$_POST['client_email2']."',
                                                                client_email3 = '".$_POST['client_email3']."',
                                                                client_phone2 = '".$_POST['client_phone2']."',
                                                                client_phone3 = '".$_POST['client_phone3']."',
                                                                client_mobile_p2 = '".$_POST['client_mobile_p2']."',
                                                                client_mobile_p3 = '".$_POST['client_mobile_p3']."',
                                                                /* Delivery 1 */
                                                                client_address_delivery_1 = '".$_POST['client_address_delivery_1']."',
                                                                client_address_delivery_2 = '".$_POST['client_address_delivery_2']."',
                                                                client_delivery_zip = '".$_POST['client_delivery_zip']."',
                                                                client_delivery_city = '".$_POST['client_delivery_city']."',
                                                                client_delivery_country = '".$_POST['client_delivery_country']."',
                                                                client_delivery_company = '".$_POST['client_delivery_company']."',
                                                                client_delivery_email = '".$_POST['client_delivery_email']."',
                                                                client_delivery_contact = '".$_POST['client_delivery_contact']."',
                                                                client_delivery_phone = '".$_POST['client_delivery_phone']."',
                                                                /* Delivery 2 */
                                                                client_address_delivery_1_2 = '".$_POST['client_address_delivery_1_2']."',
                                                                client_address_delivery_2_2 = '".$_POST['client_address_delivery_2_2']."',
                                                                client_delivery_zip2 = '".$_POST['client_delivery_zip2']."',
                                                                client_delivery_city2 = '".$_POST['client_delivery_city2']."',
                                                                client_delivery_country2 = '".$_POST['client_delivery_country2']."',
                                                                client_delivery_company2 = '".$_POST['client_delivery_company2']."',
                                                                client_delivery_email2 = '".$_POST['client_delivery_email2']."',
                                                                client_delivery_contact2 = '".$_POST['client_delivery_contact2']."',
                                                                client_delivery_phone2 = '".$_POST['client_delivery_phone2']."',
                                                                /* Delivery 3 */
                                                                client_address_delivery_1_3 = '".$_POST['client_address_delivery_1_3']."',
                                                                client_address_delivery_2_3 = '".$_POST['client_address_delivery_2_3']."',
                                                                client_delivery_zip3 = '".$_POST['client_delivery_zip3']."',
                                                                client_delivery_city3 = '".$_POST['client_delivery_city3']."',
                                                                client_delivery_country3 = '".$_POST['client_delivery_country3']."',
                                                                client_delivery_company3 = '".$_POST['client_delivery_company3']."',
                                                                client_delivery_email3 = '".$_POST['client_delivery_email3']."',
                                                                client_delivery_contact3 = '".$_POST['client_delivery_contact3']."',
                                                                client_delivery_phone3 = '".$_POST['client_delivery_phone3']."',
                                                                /* Delivery 4 */
                                                                client_address_delivery_1_4 = '".$_POST['client_address_delivery_1_4']."',
                                                                client_address_delivery_2_4 = '".$_POST['client_address_delivery_2_4']."',
                                                                client_delivery_zip4 = '".$_POST['client_delivery_zip4']."',
                                                                client_delivery_city4 = '".$_POST['client_delivery_city4']."',
                                                                client_delivery_country4 = '".$_POST['client_delivery_country4']."',
                                                                client_delivery_company4 = '".$_POST['client_delivery_company4']."',
                                                                client_delivery_email4 = '".$_POST['client_delivery_email4']."',
                                                                client_delivery_contact4 = '".$_POST['client_delivery_contact4']."',
                                                                client_delivery_phone4 = '".$_POST['client_delivery_phone4']."',
                                                                /* Delivery 5 */
                                                                client_address_delivery_1_5 = '".$_POST['client_address_delivery_1_5']."',
                                                                client_address_delivery_2_5 = '".$_POST['client_address_delivery_2_5']."',
                                                                client_delivery_zip5 = '".$_POST['client_delivery_zip5']."',
                                                                client_delivery_city5 = '".$_POST['client_delivery_city5']."',
                                                                client_delivery_country5 = '".$_POST['client_delivery_country5']."',
                                                                client_delivery_company5 = '".$_POST['client_delivery_company5']."',
                                                                client_delivery_email5 = '".$_POST['client_delivery_email5']."',
                                                                client_delivery_contact5 = '".$_POST['client_delivery_contact5']."',
                                                                client_delivery_phone5 = '".$_POST['client_delivery_phone5']."',
                                                                client_gender = '".$_POST['client_gender']."',
                                                                client_gender_2 = '".$_POST['client_gender_2']."',
                                                                client_gender_3 = '".$_POST['client_gender_3']."',
                                                                tax_rate_id = '".$_POST['tax_rate_id']."',
                                                                client_job_p1 = '".$_POST['job_id']."',
                                                                client_job_p2 = '".$_POST['job_id2']."',
                                                                client_job_p3 = '".$_POST['job_id3']."',
                                                                client_closed = ".$_POST['client_closed'].",
                                                                client_discount = '".$_POST['client_discount']."',
                                                                client_segm = '".$_POST['segm_id']."',
                                                                client_commercial = '".$_POST['client_commercial']."',
                                                                client_notes = '".addslashes($_POST['client_notes'])."',
                                                                is_valid = 1,
                                                                no_cee = '".$_POST['no_cee']."'
                                                          WHERE client_id = ".$id);

                    redirect('clients/view/' . $id);
                }
            }
            else
            {
                $id = $this->mdl_clients->save($id);

                $this->load->model('custom_fields/mdl_client_custom');

                $this->mdl_client_custom->save_custom($id, $this->input->post('custom'));

                /* SPECIAL CUSTOMER FIELDS MANUALLY INSERT HERE */
                //[client_name_p1] => Nome1 [client_name_p2] => Nome2 [client_email2] => Email2 [client_phone2] => Phone2 [client_mobile_p2] => Movel2
                if($_POST['no_cee'] == '' || $_POST['no_cee'] == NULL)
                {
                    $_POST['no_cee'] = 0;
                }

                /*if($_POST['client_notes'] != '' && $_POST['client_notes'] == NULL)
                {
                    $_POST['client_notes'] = str_replace("'", "\'", $_POST['client_notes']);
                }*/
                if($_POST['client_closed'] == '' || $_POST['client_closed'] == NULL)
                {
                    $_POST['client_closed'] = 0;
                }

                $isrt_cstm_spcl = $this->db->query("UPDATE ip_clients SET
                                                                client_name_p1 = '".addslashes($_POST['client_name_p1'])."',
                                                                client_name_p2 = '".addslashes($_POST['client_name_p2'])."',
                                                                client_name_p3 = '".addslashes($_POST['client_name_p3'])."',
                                                                client_email2 = '".$_POST['client_email2']."',
                                                                client_email3 = '".$_POST['client_email3']."',
                                                                client_phone2 = '".$_POST['client_phone2']."',
                                                                client_phone3 = '".$_POST['client_phone3']."',
                                                                client_mobile_p2 = '".$_POST['client_mobile_p2']."',
                                                                client_mobile_p3 = '".$_POST['client_mobile_p3']."',
                                                                /* Delivery 1 */
                                                                client_address_delivery_1 = '".$_POST['client_address_delivery_1']."',
                                                                client_address_delivery_2 = '".$_POST['client_address_delivery_2']."',
                                                                client_delivery_zip = '".$_POST['client_delivery_zip']."',
                                                                client_delivery_city = '".$_POST['client_delivery_city']."',
                                                                client_delivery_country = '".$_POST['client_delivery_country']."',
                                                                client_delivery_company = '".$_POST['client_delivery_company']."',
                                                                client_delivery_email = '".$_POST['client_delivery_email']."',
                                                                client_delivery_contact = '".$_POST['client_delivery_contact']."',
                                                                client_delivery_phone = '".$_POST['client_delivery_phone']."',
                                                                /* Delivery 2 */
                                                                client_address_delivery_1_2 = '".$_POST['client_address_delivery_1_2']."',
                                                                client_address_delivery_2_2 = '".$_POST['client_address_delivery_2_2']."',
                                                                client_delivery_zip2 = '".$_POST['client_delivery_zip2']."',
                                                                client_delivery_city2 = '".$_POST['client_delivery_city2']."',
                                                                client_delivery_country2 = '".$_POST['client_delivery_country2']."',
                                                                client_delivery_company2 = '".$_POST['client_delivery_company2']."',
                                                                client_delivery_email2 = '".$_POST['client_delivery_email2']."',
                                                                client_delivery_contact2 = '".$_POST['client_delivery_contact2']."',
                                                                client_delivery_phone2 = '".$_POST['client_delivery_phone2']."',
                                                                /* Delivery 3 */
                                                                client_address_delivery_1_3 = '".$_POST['client_address_delivery_1_3']."',
                                                                client_address_delivery_2_3 = '".$_POST['client_address_delivery_2_3']."',
                                                                client_delivery_zip3 = '".$_POST['client_delivery_zip3']."',
                                                                client_delivery_city3 = '".$_POST['client_delivery_city3']."',
                                                                client_delivery_country3 = '".$_POST['client_delivery_country3']."',
                                                                client_delivery_company3 = '".$_POST['client_delivery_company3']."',
                                                                client_delivery_email3 = '".$_POST['client_delivery_email3']."',
                                                                client_delivery_contact3 = '".$_POST['client_delivery_contact3']."',
                                                                client_delivery_phone3 = '".$_POST['client_delivery_phone3']."',
                                                                /* Delivery 4 */
                                                                client_address_delivery_1_4 = '".$_POST['client_address_delivery_1_4']."',
                                                                client_address_delivery_2_4 = '".$_POST['client_address_delivery_2_4']."',
                                                                client_delivery_zip4 = '".$_POST['client_delivery_zip4']."',
                                                                client_delivery_city4 = '".$_POST['client_delivery_city4']."',
                                                                client_delivery_country4 = '".$_POST['client_delivery_country4']."',
                                                                client_delivery_company4 = '".$_POST['client_delivery_company4']."',
                                                                client_delivery_email4 = '".$_POST['client_delivery_email4']."',
                                                                client_delivery_contact4 = '".$_POST['client_delivery_contact4']."',
                                                                client_delivery_phone4 = '".$_POST['client_delivery_phone4']."',
                                                                /* Delivery 5 */
                                                                client_address_delivery_1_5 = '".$_POST['client_address_delivery_1_5']."',
                                                                client_address_delivery_2_5 = '".$_POST['client_address_delivery_2_5']."',
                                                                client_delivery_zip5 = '".$_POST['client_delivery_zip5']."',
                                                                client_delivery_city5 = '".$_POST['client_delivery_city5']."',
                                                                client_delivery_country5 = '".$_POST['client_delivery_country5']."',
                                                                client_delivery_company5 = '".$_POST['client_delivery_company5']."',
                                                                client_delivery_email5 = '".$_POST['client_delivery_email5']."',
                                                                client_delivery_contact5 = '".$_POST['client_delivery_contact5']."',
                                                                client_delivery_phone5 = '".$_POST['client_delivery_phone5']."',
                                                                client_gender = '".$_POST['client_gender']."',
                                                                client_gender_2 = '".$_POST['client_gender_2']."',
                                                                client_gender_3 = '".$_POST['client_gender_3']."',
                                                                tax_rate_id = '".$_POST['tax_rate_id']."',
                                                                client_job_p1 = '".$_POST['job_id']."',
                                                                client_job_p2 = '".$_POST['job_id2']."',
                                                                client_job_p3 = '".$_POST['job_id3']."',
                                                                client_closed = ".$_POST['client_closed'].",
                                                                client_discount = '".$_POST['client_discount']."',
                                                                client_segm = '".$_POST['segm_id']."',
                                                                client_commercial = '".$_POST['client_commercial']."',
                                                                client_notes = '".addslashes($_POST['client_notes'])."',
                                                                is_valid = 1,
                                                                no_cee = '".$_POST['no_cee']."'
                                                          WHERE client_id = ".$id);

                redirect('clients/view/' . $id);
            }
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_clients->prep_form($id)) {
                show_404();
            }

            $this->load->model('custom_fields/mdl_client_custom');
            $this->mdl_clients->set_form_value('is_update', true);

            $client_custom = $this->mdl_client_custom->where('client_id', $id)->get();

            if ($client_custom->num_rows()) {
                $client_custom = $client_custom->row();

                unset($client_custom->client_id, $client_custom->client_custom_id);

                foreach ($client_custom as $key => $val) {
                    $this->mdl_clients->set_form_value('custom[' . $key . ']', $val);
                }
            }
        } elseif ($this->input->post('btn_submit')) {
            if ($this->input->post('custom')) {
                foreach ($this->input->post('custom') as $key => $val) {
                    $this->mdl_clients->set_form_value('custom[' . $key . ']', $val);
                }
            }
        }

        $this->load->model('custom_fields/mdl_custom_fields');
        $this->load->helper('country');

        $this->layout->set('custom_fields', $this->mdl_custom_fields->by_table('ip_client_custom')->get()->result());
        $this->layout->set('countries', get_country_list(lang('cldr')));
        $this->layout->set('selected_country', $this->mdl_clients->form_value('client_country') ?:
            $this->mdl_settings->setting('default_country'));

        // Set validation rule based on is_update
        if ($this->input->post('is_update') == 0 && $this->input->post('client_name') != '') {
            $check = $this->db->get_where('ip_clients', array('client_name' => $this->input->post('client_name')))->result();
            if (!empty($check)) {
                $this->session->set_flashdata('alert_error', lang('client_already_exists'));
                redirect('clients/form');
            }

            $q_max_id[] = $this->db->query("SELECT max(client_id) as id FROM ip_clients ")->result_array();

            if($_POST['no_cee'] == '' || $_POST['no_cee'] == NULL)
            {
                $_POST['no_cee'] = 0;
            }

            /*if($_POST['client_notes'] != '' && $_POST['client_notes'] == NULL)
            {
                $_POST['client_notes'] = str_replace("'", "\'", $_POST['client_notes']);
            }*/

            /*$isrt_cstm_spcl = $this->db->query("UPDATE ip_clients SET
                                                                client_name_p1 = '".addslashes($_POST['client_name_p1'])."',
                                                                client_name_p2 = '".addslashes($_POST['client_name_p2'])."',
                                                                client_name_p3 = '".addslashes($_POST['client_name_p3'])."',
                                                                client_email2 = '".$_POST['client_email2']."',
                                                                client_email3 = '".$_POST['client_email3']."',
                                                                client_phone2 = '".$_POST['client_phone2']."',
                                                                client_phone3 = '".$_POST['client_phone3']."',
                                                                client_mobile_p2 = '".$_POST['client_mobile_p2']."',
                                                                client_mobile_p3 = '".$_POST['client_mobile_p3']."',
                                                                client_address_delivery_1 = '".addslashes($_POST['client_address_delivery_1'])."',
                                                                client_address_delivery_2 = '".addslashes($_POST['client_address_delivery_2'])."',
                                                                client_delivery_zip = '".$_POST['client_delivery_zip']."',
                                                                client_delivery_city = '".addslashes($_POST['client_delivery_city'])."',
                                                                client_delivery_country = '".addslashes($_POST['client_delivery_country'])."',
                                                                client_delivery_company = '".addslashes($_POST['client_delivery_company'])."',
                                                                client_delivery_contact = '".addslashes($_POST['client_delivery_contact'])."',
                                                                client_delivery_phone = '".$_POST['client_delivery_phone']."',
                                                                client_gender = '".$_POST['client_gender']."',
                                                                client_gender_2 = '".$_POST['client_gender_2']."',
                                                                client_gender_3 = '".$_POST['client_gender_3']."',
                                                                tax_rate_id = '".$_POST['tax_rate_id']."',
                                                                client_job_p1 = '".$_POST['job_id']."',
                                                                client_job_p2 = '".$_POST['job_id2']."',
                                                                client_job_p3 = '".$_POST['job_id3']."',
                                                                client_closed = '".$_POST['client_closed']."',
                                                                client_discount = '".$_POST['client_discount']."',
                                                                client_segm = '".$_POST['segm_id']."',
                                                                client_commercial = '".$_POST['client_commercial']."',
                                                                client_notes = '".addslashes($_POST['client_notes'])."',
                                                                is_valid = 1,
                                                                no_cee = ".$_POST['no_cee']."
                                                          WHERE client_id = ".$q_max_id[0][0]['id']);*/
          if($_POST['client_closed'] == '' || $_POST['client_closed'] == NULL)
            {
                $_POST['client_closed'] = 0;
            }
          $isrt_cstm_spcl = $this->db->query("UPDATE ip_clients SET
                                                client_name_p2 = '".addslashes($_POST['client_name_p2'])."',
                                                client_name_p3 = '".addslashes($_POST['client_name_p3'])."',
                                                client_email2 = '".$_POST['client_email2']."',
                                                client_email3 = '".$_POST['client_email3']."',
                                                client_phone2 = '".$_POST['client_phone2']."',
                                                client_phone3 = '".$_POST['client_phone3']."',
                                                client_mobile_p2 = '".$_POST['client_mobile_p2']."',
                                                client_mobile_p3 = '".$_POST['client_mobile_p3']."',
                                                /* Delivery 1 */
                                                client_address_delivery_1 = '".$_POST['client_address_delivery_1']."',
                                                client_address_delivery_2 = '".$_POST['client_address_delivery_2']."',
                                                client_delivery_zip = '".$_POST['client_delivery_zip']."',
                                                client_delivery_city = '".$_POST['client_delivery_city']."',
                                                client_delivery_country = '".$_POST['client_delivery_country']."',
                                                client_delivery_company = '".$_POST['client_delivery_company']."',
                                                client_delivery_email = '".$_POST['client_delivery_email']."',
                                                client_delivery_contact = '".$_POST['client_delivery_contact']."',
                                                client_delivery_phone = '".$_POST['client_delivery_phone']."',
                                                /* Delivery 2 */
                                                client_address_delivery_1_2 = '".$_POST['client_address_delivery_1_2']."',
                                                client_address_delivery_2_2 = '".$_POST['client_address_delivery_2_2']."',
                                                client_delivery_zip2 = '".$_POST['client_delivery_zip2']."',
                                                client_delivery_city2 = '".$_POST['client_delivery_city2']."',
                                                client_delivery_country2 = '".$_POST['client_delivery_country2']."',
                                                client_delivery_company2 = '".$_POST['client_delivery_company2']."',
                                                client_delivery_email2 = '".$_POST['client_delivery_email2']."',
                                                client_delivery_contact2 = '".$_POST['client_delivery_contact2']."',
                                                client_delivery_phone2 = '".$_POST['client_delivery_phone2']."',
                                                /* Delivery 3 */
                                                client_address_delivery_1_3 = '".$_POST['client_address_delivery_1_3']."',
                                                client_address_delivery_2_3 = '".$_POST['client_address_delivery_2_3']."',
                                                client_delivery_zip3 = '".$_POST['client_delivery_zip3']."',
                                                client_delivery_city3 = '".$_POST['client_delivery_city3']."',
                                                client_delivery_country3 = '".$_POST['client_delivery_country3']."',
                                                client_delivery_company3 = '".$_POST['client_delivery_company3']."',
                                                client_delivery_email3 = '".$_POST['client_delivery_email3']."',
                                                client_delivery_contact3 = '".$_POST['client_delivery_contact3']."',
                                                client_delivery_phone3 = '".$_POST['client_delivery_phone3']."',
                                                /* Delivery 4 */
                                                client_address_delivery_1_4 = '".$_POST['client_address_delivery_1_4']."',
                                                client_address_delivery_2_4 = '".$_POST['client_address_delivery_2_4']."',
                                                client_delivery_zip4 = '".$_POST['client_delivery_zip4']."',
                                                client_delivery_city4 = '".$_POST['client_delivery_city4']."',
                                                client_delivery_country4 = '".$_POST['client_delivery_country4']."',
                                                client_delivery_company4 = '".$_POST['client_delivery_company4']."',
                                                client_delivery_email4 = '".$_POST['client_delivery_email4']."',
                                                client_delivery_contact4 = '".$_POST['client_delivery_contact4']."',
                                                client_delivery_phone4 = '".$_POST['client_delivery_phone4']."',
                                                /* Delivery 5 */
                                                client_address_delivery_1_5 = '".$_POST['client_address_delivery_1_5']."',
                                                client_address_delivery_2_5 = '".$_POST['client_address_delivery_2_5']."',
                                                client_delivery_zip5 = '".$_POST['client_delivery_zip5']."',
                                                client_delivery_city5 = '".$_POST['client_delivery_city5']."',
                                                client_delivery_country5 = '".$_POST['client_delivery_country5']."',
                                                client_delivery_company5 = '".$_POST['client_delivery_company5']."',
                                                client_delivery_email5 = '".$_POST['client_delivery_email5']."',
                                                client_delivery_contact5 = '".$_POST['client_delivery_contact5']."',
                                                client_delivery_phone5 = '".$_POST['client_delivery_phone5']."',
                                                client_gender = '".$_POST['client_gender']."',
                                                client_gender_2 = '".$_POST['client_gender_2']."',
                                                client_gender_3 = '".$_POST['client_gender_3']."',
                                                tax_rate_id = '".$_POST['tax_rate_id']."',
                                                client_job_p1 = '".$_POST['job_id']."',
                                                client_job_p2 = '".$_POST['job_id2']."',
                                                client_job_p3 = '".$_POST['job_id3']."',
                                                client_closed = ".$_POST['client_closed'].",
                                                client_discount = '".$_POST['client_discount']."',
                                                client_segm = '".$_POST['segm_id']."',
                                                client_commercial = '".$_POST['client_commercial']."',
                                                client_notes = '".addslashes($_POST['client_notes'])."',
                                                is_valid = 1,
                                                no_cee = ".$_POST['no_cee']."
                                          WHERE client_id = ".$q_max_id[0][0]['id']);
}

        $this->layout->buffer('content', 'clients/form');
        $this->layout->render();
    }

    public function view($client_id)
    {
        $this->load->model('clients/mdl_client_notes');
        $this->load->model('invoices/mdl_invoices');
        $this->load->model('quotes/mdl_quotes');
        $this->load->model('online_quotes/mdl_online_quotes');
        $this->load->model('invoices_proform/mdl_invoices_proform');
        $this->load->model('production/mdl_production');
        $this->load->model('bon_livraison/mdl_transport');
        $this->load->model('payments/mdl_payments');
        $this->load->model('custom_fields/mdl_custom_fields');

        $client = $this->mdl_clients->with_total()->with_total_balance()->with_total_paid()->where('ip_clients.client_id', $client_id)->get()->row();

        if (!$client) {
            show_404();
        }

        $this->layout->set(
            array(
                'client' => $client,
                'client_notes' => $this->mdl_client_notes->where('client_id', $client_id)->get()->result(),
                'invoices' => $this->mdl_invoices->by_client($client_id)->limit(500)->get()->result(),
                'quotes' => $this->mdl_quotes->by_client($client_id)->limit(500)->get()->result(),
                'online_quotes' => $this->mdl_online_quotes->by_client($client_id)->limit(500)->get()->result(),
                'proform' => $this->mdl_invoices_proform->by_client($client_id)->limit(500)->get()->result(),
                'production' => $this->mdl_production->by_client($client_id)->limit(500)->get()->result(),
                'transport' => $this->mdl_transport->by_client($client_id)->limit(500)->get()->result(),
                'payments' => $this->mdl_payments->by_client($client_id)->limit(500)->get()->result(),
                'custom_fields' => $this->mdl_custom_fields->by_table('ip_client_custom')->get()->result(),
                'quote_statuses' => $this->mdl_quotes->statuses(),
                'invoice_statuses' => $this->mdl_invoices->statuses(),
            )
        );

        $this->layout->buffer(
            array(
                array('online_quote_table', 'online_quotes/partial_quote_table'),
                array('invoice_table', 'invoices/partial_invoice_table'),
                array('nc_table', 'invoices/partial_invoice_table_nc'),
                array('quote_table', 'quotes/partial_quote_table'),
                array('production_table', 'production/partial_quote_table'),
                array('transport_table', 'bon_livraison/partial_quote_table'),
                array('payment_table', 'payments/partial_payment_table'),
                array('proform_table', 'invoices_proform/partial_invoice_table'),
                array('partial_notes', 'clients/partial_notes'),
                array('content', 'clients/view')
            )
        );

        $this->layout->render();
    }

    public function delete($client_id)
    {
        $this->mdl_clients->delete($client_id);
        redirect('clients');
    }

}
