<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

class Bon_livraison extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('mdl_quotes');
    }

    public function index()
    {
        // Display all quotes by default
        redirect('bon_livraison/status/all');
    }

    public function status($status = 'all', $page = 0)
    {
        // Determine which group of quotes to load
        switch ($status) {
            case 'draft':
                $this->mdl_quotes->is_draft();
                break;
            /*case 'sent':
                $this->mdl_quotes->is_sent();
                break;
            case 'viewed':
                $this->mdl_quotes->is_viewed();
                break;*/
            case 'approved':
                $this->mdl_quotes->is_approved();
                break;
            /*case 'rejected':
                $this->mdl_quotes->is_rejected();
                break;*/
            case 'canceled':
                $this->mdl_quotes->is_canceled();
                break;
        }

        $this->mdl_quotes->paginate(site_url('bon_livraison/status/' . $status), $page);
        $quotes = $this->mdl_quotes->result();

        $this->layout->set(
            array(
                'transport' => $quotes,
                'status' => $status,
                'filter_display' => TRUE,
                'filter_placeholder' => lang('filter_transport'),
                'filter_method' => 'filter_transport',
                'transport_statuses' => $this->mdl_quotes->statuses()
            )
        );

        $this->layout->buffer('content', 'bon_livraison/index');
        $this->layout->render();
    }

    public function view($quote_id)
    {
        $this->load->model('mdl_quote_items');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('mdl_quote_tax_rates');
        $this->load->model('custom_fields/mdl_custom_fields');
        $this->load->model('custom_fields/mdl_quote_custom');
        $this->load->library('encrypt');

        //$quote_custom = $this->mdl_quote_custom->where('quote_id', $quote_id)->get();
        /*$quote_custom = $this->mdl_quote_custom->where('transport_id', $quote_id)->get();

        if ($quote_custom->num_rows()) {
            $quote_custom = $quote_custom->row();

            unset($quote_custom->transport_id, $quote_custom->transport_custom_id);

            foreach ($quote_custom as $key => $val) {
                $this->mdl_quotes->set_form_value('custom[' . $key . ']', $val);
            }
        }*/

        $quote = $this->mdl_quotes->get_by_id($quote_id);

        if (!$quote) {
            show_404();
        }

        $this->layout->set(
            array(
                'transport' => $quote,
                'items' => $this->mdl_quote_items->where('transport_id', $quote_id)->get()->result(),
                'transport_id' => $quote_id,
                'tax_rates' => $this->mdl_tax_rates->get()->result(),
                'transport_tax_rates' => $this->mdl_quote_tax_rates->where('transport_id', $quote_id)->get()->result(),
                'custom_fields' => $this->mdl_custom_fields->by_table('ip_transport_custom')->get()->result(),
                'custom_js_vars' => array(
                    'currency_symbol' => $this->mdl_settings->setting('currency_symbol'),
                    'currency_symbol_placement' => $this->mdl_settings->setting('currency_symbol_placement'),
                    'decimal_point' => $this->mdl_settings->setting('decimal_point')
                ),
                'transport_statuses' => $this->mdl_quotes->statuses()
            )
        );

        $this->layout->buffer(
            array(
                array('modal_delete_quote', 'bon_livraison/modal_delete_quote'),
                array('modal_add_quote_tax', 'bon_livraison/modal_add_quote_tax'),
                array('content', 'bon_livraison/view')
            )
        );

        $this->layout->render();
    }

    public function delete($quote_id)
    {
        // Delete the transport
        $this->mdl_quotes->delete($quote_id);

        // Redirect to transport index
        redirect('bon_livraison/index');
    }

    public function delete_item($quote_id, $item_id)
    {
        // Delete transport item
        $this->load->model('mdl_quote_items');
        $this->mdl_quote_items->delete($item_id);

        // Redirect to transport view
        redirect('bon_livraison/view/' . $quote_id);
    }

    public function generate_pdf($quote_id, $stream = TRUE, $transport_template = NULL)
    {
        $this->load->helper('pdf');

        if ($this->mdl_settings->setting('mark_quotes_sent_pdf') == 1) {
            $this->mdl_quotes->mark_sent($quote_id);
        }

        //generate_quote_pdf($quote_id, $stream, $transport_template);
        generate_transport_pdf($quote_id, $stream, $transport_template);
    }

    public function btn_generate_label_pdf($quote_id, $stream = TRUE, $transport_template = NULL)
    {
        $this->load->helper('pdf');

        if ($this->mdl_settings->setting('mark_quotes_sent_pdf') == 1) {
            $this->mdl_quotes->mark_sent($quote_id);
        }

        //generate_quote_pdf($quote_id, $stream, $transport_template);
        generate_label_transport_pdf($quote_id, $stream, $transport_template);
    }

    public function delete_quote_tax($quote_id, $quote_tax_rate_id)
    {
        $this->load->model('mdl_quote_tax_rates');
        $this->mdl_quote_tax_rates->delete($quote_tax_rate_id);

        $this->load->model('mdl_quote_amounts');
        $this->mdl_quote_amounts->calculate($quote_id);

        redirect('bon_livraison/view/' . $quote_id);
    }

    public function recalculate_all_quotes()
    {
        $this->db->select('transport_id');
        $quote_ids = $this->db->get('ip_transport')->result();

        $this->load->model('mdl_quote_amounts');

        foreach ($quote_ids as $quote_id) {
            $this->mdl_quote_amounts->calculate($quote_id->transport_id);
        }
    }

}
