<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

class Ajax extends Admin_Controller
{
    public $ajax_controller = TRUE;

    public function save()
    {
        $this->load->model('bon_livraison/mdl_quote_items');
        $this->load->model('bon_livraison/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');

        $quote_id = $this->input->post('transport_id');

        $q_prv_stt = $this->db->query("SELECT transport_status_id, client_id FROM ip_transport WHERE transport_id = '".$this->input->post('transport_id')."'")->result_array();

        $is_slash_create = substr($this->input->post('transport_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $day_create = substr($this->input->post('transport_date_created'), 0, 2);
            $month_create = substr($this->input->post('transport_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('transport_date_created');
        }

        $items = json_decode($this->input->post('items'));

        $plist = $this->db->query("SELECT * FROM ip_products WHERE inactive = 0 ORDER BY product_order")->result_array();

        $error = 0;

        foreach ($items as $item) {
            $exists = 0;
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_name." -- ".$item->item_description."', now() )");

            foreach($plist as $pl)
            {
                if($pl['product_sku'] == $item->item_description)
                {
                    $exists = 1;
                }

                //$this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$pl['product_sku']." ".$item->item_description."', now() )");
            }

            if($exists == 0)
            {
                //ERRO
                $this->load->helper('json_error');
                $response = array(
                    'success' => 0,
                    'validation_errors' => 'SKU_ERROR'
                );

                $error = 1;
            }

        }

        foreach ($items as $item) {
            //$note_k = " || ".$note_k.$item." ==>";
            $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[] ".$item->item_id." ".$item->item_description."', now() )");
            if($item->item_id == NULL)
            {
                foreach($item as $it)
                {
                    $string= "?? ".$string.$it;
                }
                $string = ' ' . $string;
                $ini = strpos($string, $quote_id);
                $ini += strlen($quote_id);
                $len = strpos($string, $item->item_quantity, $ini) - $ini;
                $note_k = substr($string, $ini, $len);

                $prod_info[] = $this->db->query("SELECT product_id FROM ip_products WHERE product_sku like '%".$note_k."%' limit 1;")->result_array();

                $pid = $prod_info[0][0]['product_id'];

                if($pid == NULL || $pdi == "")
                {
                    $pid = 0;
                }

                //$note_k = $note_k." ".$pid ;

                $date_add = date('Y-m-d');

                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                if($item->item_description != "" && $item->item_description != NULL)
                {
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM LOGO " . $item->item_logo . "', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM COLOR " . $item->item_color_num . "', now() )");
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM BAT " . $item->item_bat_num . "', now() )");

                    $updt_bl = $this->db->query( "INSERT INTO ip_transport_items (item_id, transport_id, item_tax_rate_id, item_date_added, item_name,
                                                                              item_description, item_quantity, item_price, item_discount_amount, item_order,
                                                                              item_bat_num, item_color_num, item_logo)  
                                              VALUES
                                                                              (".$pid.", ".$this->input->post('transport_id').", 0, '".$date_add."', '".$item->item_name."',
                                                                              '".$item->item_description."', ".$item->item_quantity.", ".$item->item_price.", '".$item->item_discount_amount."', ".$item->item_order.",
                                                                              '".$item->item_bat_num."', '".$item->item_color_num."', '".$item->item_logo."')" );
                }
            }
            else
            {
                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                if( is_numeric($item->item_pid) )
                {
                    $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[2] ".$item->item_pid." ".$item->item_description."', now() )");
                    $prod_info[] = $this->db->query("SELECT * FROM ip_products WHERE product_id = ".$item->item_pid." AND online = 1 AND inactive = 0 limit 1;")->result_array();
                    $item->item_description = $prod_info[0][0]['product_sku'];
                }
                
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM LOGO " . $item->item_logo . "', now() )");
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM COLOR " . $item->item_color_num . "', now() )");
                $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('ITEM BAT " . $item->item_bat_num . "', now() )");

                $updt_bl = $this->db->query( "UPDATE ip_transport_items SET 
                        item_name = '".$item->item_name."',
                        item_description = '".$item->item_description."',
                        item_order = ".$item->item_order.",
                        item_quantity = ".$item->item_quantity.",
                        item_logo = '".$item->item_logo."',
                        item_color_num = '".$item->item_color_num."',
                        item_bat_num = '".$item->item_bat_num."'  
                     WHERE transport_id = ".$this->input->post('transport_id')."
                     AND item_id = ".$item->item_id );
            }
        }

        $this->db->query("INSERT INTO idm_log (log, ts) VALUES ('[S] ".$q_prv_stt[0]['transport_status_id']."', now() )");

        if($q_prv_stt[0]['transport_status_id'] != 4 && $q_prv_stt[0]['transport_status_id'] != 6)
        {
            if($this->input->post('transport_status_id') == 4 || $this->input->post('transport_status_id') == 6)
            {
                $c_res = $this->db->query("SELECT * FROM ip_clients WHERE client_id = ".$q_prv_stt[0]['client_id'])->result_array();

                if($this->input->post('delivery') == 1 || $this->input->post('delivery') == TRUE)
                {
                    if($this->input->post('delivery_address') == 1)
                    {
                        $quote_client_delivery_address = $c_res[0]['client_address_delivery_1'] . " " . $c_res[0]['client_address_delivery_2'];
                        $quote_client_delivery_local = $c_res[0]['client_delivery_zip'] . " " . $c_res[0]['client_delivery_city'] . " " . $c_res[0]['client_delivery_country'];
                        $quote_client_delivery_company = $c_res[0]['client_delivery_company'];
                        $quote_client_delivery_contact = $c_res[0]['client_delivery_contact'];
                        $quote_client_delivery_phone = $c_res[0]['client_delivery_phone'];
                    }
                    elseif($this->input->post('delivery_address') == 2)
                    {
                        $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_2'] . " " . $c_res[0]['client_address_delivery_2_2'];
                        $quote_client_delivery_local = $c_res[0]['client_delivery_zip2'] . " " . $c_res[0]['client_delivery_city2'] . " " . $c_res[0]['client_delivery_country2'];
                        $quote_client_delivery_company = $c_res[0]['client_delivery_company2'];
                        $quote_client_delivery_contact = $c_res[0]['client_delivery_contact2'];
                        $quote_client_delivery_phone = $c_res[0]['client_delivery_phone2'];
                    }
                    elseif($this->input->post('delivery_address') == 3)
                    {
                        $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_3'] . " " . $c_res[0]['client_address_delivery_2_3'];
                        $quote_client_delivery_local = $c_res[0]['client_delivery_zip3'] . " " . $c_res[0]['client_delivery_city3'] . " " . $c_res[0]['client_delivery_country3'];
                        $quote_client_delivery_company = $c_res[0]['client_delivery_company3'];
                        $quote_client_delivery_contact = $c_res[0]['client_delivery_contact3'];
                        $quote_client_delivery_phone = $c_res[0]['client_delivery_phone3'];
                    }
                    elseif($this->input->post('delivery_address') == 4)
                    {
                        $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_4'] . " " . $c_res[0]['client_address_delivery_2_4'];
                        $quote_client_delivery_local = $c_res[0]['client_delivery_zip4'] . " " . $c_res[0]['client_delivery_city4'] . " " . $c_res[0]['client_delivery_country4'];
                        $quote_client_delivery_company = $c_res[0]['client_delivery_company4'];
                        $quote_client_delivery_contact = $c_res[0]['client_delivery_contact4'];
                        $quote_client_delivery_phone = $c_res[0]['client_delivery_phone4'];
                    }
                    elseif($this->input->post('delivery_address') == 5)
                    {
                        $quote_client_delivery_address = $c_res[0]['client_address_delivery_1_5'] . " " . $c_res[0]['client_address_delivery_2_5'];
                        $quote_client_delivery_local = $c_res[0]['client_delivery_zip5'] . " " . $c_res[0]['client_delivery_city5'] . " " . $c_res[0]['client_delivery_country5'];
                        $quote_client_delivery_company = $c_res[0]['client_delivery_company5'];
                        $quote_client_delivery_contact = $c_res[0]['client_delivery_contact5'];
                        $quote_client_delivery_phone = $c_res[0]['client_delivery_phone5'];
                    }
                    else
                    {
                        $quote_client_delivery_address = "";
                        $quote_client_delivery_local = "";
                        $quote_client_delivery_company = "";
                        $quote_client_delivery_contact = "";
                        $quote_client_delivery_phone = "";
                    }
                }
                else
                {
                    $quote_client_delivery_address = "";
                    $quote_client_delivery_local = "";
                    $quote_client_delivery_company = "";
                    $quote_client_delivery_contact = "";
                    $quote_client_delivery_phone = "";
                }

                $c_res[0]['client_name'] = str_replace("'", "´", $c_res[0]['client_name']);
                $c_res[0]['client_name_p1'] = str_replace("'", "´", $c_res[0]['client_name_p1']);
                $c_res[0]['client_address_1'] = str_replace("'", "´", $c_res[0]['client_address_1']);
                $c_res[0]['client_address_2'] = str_replace("'", "´", $c_res[0]['client_address_2']);
                $c_res[0]['client_zip'] = str_replace("'", "´", $c_res[0]['client_zip']);
                $c_res[0]['client_city'] = str_replace("'", "´", $c_res[0]['client_city']);
                $c_res[0]['client_country'] = str_replace("'", "´", $c_res[0]['client_country']);
                $c_res[0]['client_vat_id'] = str_replace("'", "´", $c_res[0]['client_vat_id']);
                $c_res[0]['client_phone'] = str_replace("'", "´", $c_res[0]['client_phone']);
                $c_res[0]['client_email'] = str_replace("'", "´", $c_res[0]['client_email']);
                $quote_client_delivery_address = str_replace("'", "´", $quote_client_delivery_address);
                $quote_client_delivery_local = str_replace("'", "´", $quote_client_delivery_local);
                $quote_client_delivery_company = str_replace("'", "´", $quote_client_delivery_company);
                $quote_client_delivery_contact = str_replace("'", "´", $quote_client_delivery_contact);
                $quote_client_delivery_phone = str_replace("'", "´", $quote_client_delivery_phone);

                $updt_oquo_cstmr = $this->db->query("UPDATE ip_transport SET
                                                    transport_client_name = '".$c_res[0]['client_name']."',
                                                    transport_client_name_p1 = '".$c_res[0]['client_name_p1']."',
                                                    transport_client_address_1 = '".$c_res[0]['client_address_1']."',
                                                    transport_client_address_2 = '".$c_res[0]['client_address_2']."',
                                                    transport_client_zip = '".$c_res[0]['client_zip']."',
                                                    transport_client_city = '".$c_res[0]['client_city']."',
                                                    transport_client_country = '".$c_res[0]['client_country']."',
                                                    transport_client_vat_id = '".$c_res[0]['client_vat_id']."',
                                                    transport_client_phone = '".$c_res[0]['client_phone']."',
                                                    transport_client_email = '".$c_res[0]['client_email']."',
                                                    transport_client_delivery_address = '" . $quote_client_delivery_address . "',
                                                    transport_client_delivery_local = '" . $quote_client_delivery_local . "',
                                                    transport_client_delivery_company = '" . $quote_client_delivery_company . "',
                                                    transport_client_delivery_contact = '" . $quote_client_delivery_contact . "',
                                                    transport_client_delivery_phone = '" . $quote_client_delivery_phone . "'
                                                WHERE transport_id = ".$this->input->post('transport_id'));
            }
        }

        /*$updt_bl = $this->db->query( "UPDATE ip_transport SET
                        transport_date_created = '".$date_create."',
                        transport_status_id = ".$this->input->post('transport_status_id').",
                        notes = '".$this->input->post('notes')."'
                     WHERE transport_id = ".$this->input->post('transport_id') );*/
        $checked2 = 0;
        if ($this->input->post('tracking_not_send') == 'true') {
            $checked2 = 1;
        }
        
        $checked3 = 0;
        if ($this->input->post('use_notes_delivery_address') == 'true') {
            $checked3 = 1;
        }

        $notes_logistic = str_replace("'", "´", $this->input->post('notes_logistic'));
        $notes = str_replace("'", "´", $this->input->post('notes'));

        $updt_bl = $this->db->query( "UPDATE ip_transport SET
                        transport_status_id = ".$this->input->post('transport_status_id').",
                        weight = '".$this->input->post('weight')."',
                        pack = ".$this->input->post('pack').",
                        box = ".$this->input->post('box').",
                        transporter = ".$this->input->post('transporter').",
                        other_transporter = '".$this->input->post('other_transporter')."',
                        license_plate = '".$this->input->post('license_plate')."',
                        tracking_code = '".$this->input->post('tracking_code')."',
                        tracking_inner_price = '".$this->input->post('tracking_inner_price')."', 
                        tracking_not_send = ".$checked2.",
                        use_notes_delivery_address = ".$checked3.",
                        notes = '".$notes."',
                        notes_logistic = '".$notes_logistic."'
                     WHERE transport_id = ".$this->input->post('transport_id') );

        $checked = 0;
        if($this->input->post('delivery') == 'true')
        {
            $checked = 1;
            $this->db->query("UPDATE ip_transport SET quote_delivery_id = '".$this->input->post('delivery_address')."' WHERE transport_id = " . $this->input->post('transport_id'));
        }
        else
        {
            $this->db->query("UPDATE ip_transport SET quote_delivery_id = 0 WHERE quote_id = " . $this->input->post('transport_id'));
        }

        //Delivery address
        //quote_delivery_id

        $this->db->query("UPDATE ip_transport SET delivery = ".$checked." WHERE transport_id = " . $this->input->post('transport_id'));

        $response = array(
            'success' => 1,
            'transport_id' => 168
        );

        echo json_encode($response);
    }

    public function save2()
    {
        $this->load->model('bon_livraison/mdl_quote_items');
        $this->load->model('bon_livraison/mdl_quotes');
        $this->load->model('item_lookups/mdl_item_lookups');
        $this->load->library('encrypt');

        $quote_id = $this->input->post('transport_id');

        $this->mdl_quotes->set_id($quote_id);
        //if ($this->mdl_quotes->run_validation('validation_rules_save_online_quote')) {
        $this->load->helper('json_error');
        $response = array(
            'success' => 0,
            'validation_errors' => json_errors()
        );
        $items = json_decode($this->input->post('items'));

        foreach ($items as $item) {
            if ($item->item_name) {
                $item->item_quantity = standardize_amount($item->item_quantity);
                $item->item_price = standardize_amount($item->item_price);
                $item->item_discount_amount = standardize_amount($item->item_discount_amount);

                $item_id = ($item->item_id) ?: NULL;

                $save_item_as_lookup = (isset($item->save_item_as_lookup)) ? $item->save_item_as_lookup : 0;

                unset($item->item_id, $item->save_item_as_lookup);

                $this->mdl_quote_items->save($quote_id, $item_id, $item);

                if ($save_item_as_lookup) {
                    $db_array = array(
                        'item_name' => $item->item_name,
                        'item_description' => $item->item_description,
                        'item_price' => $item->item_price
                    );

                    $this->mdl_item_lookups->save(NULL, $db_array);
                }
            }
        }

        //print "before db_array <br />";
        $is_slash_create = substr($this->input->post('transport_date_created'), 2, 1);
        if($is_slash_create == "/")
        {//24-02-2016
            /*$year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $month_create = substr($this->input->post('transport_date_created'), 0, 2);
            $day_create = substr($this->input->post('transport_date_created'), 3, 4);
            $day_create = substr($day_create, 0, 2);*/
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $day_create = substr($this->input->post('transport_date_created'), 0, 2);
            $month_create = substr($this->input->post('transport_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('transport_date_created');
        }
        $is_slash_expire = substr($this->input->post('transport_date_expires'), 2, 1);
        if($is_slash_expire == "/")
        {
            $year_expire = substr($this->input->post('transport_date_expires'), 6, 9);
            $month_expire = substr($this->input->post('transport_date_expires'), 0, 2);
            $day_expire = substr($this->input->post('transport_date_expires'), 3, 4);
            $day_expire = substr($day_expire, 0, 2);
            $date_expire = $year_expire."-".$month_expire."-".$day_expire;
        }
        elseif($is_slash_expire == "-")
        {
            $year_expire = substr($this->input->post('transport_date_expires'), 6, 9);
            $day_expire = substr($this->input->post('transport_date_expires'), 0, 2);
            $month_expire = substr($this->input->post('transport_date_expires'), 3, 2);
            $day_expire = substr($day_expire, 0, 2);
            $date_expire = $year_expire."-".$month_expire."-".$day_expire;
        }
        else
        {
            $date_expire = $this->input->post('transport_date_expires');
        }

        // @TODO Add checks / formatting for discounts!
        $db_array = array(
            'transport_number' => $this->input->post('transport_number'),
            //'transport_date_created' => $this->input->post('transport_date_created'),
            //'transport_date_expires' => $this->input->post('transport_date_expires'),
            //'transport_date_created' => date_to_mysql($this->input->post('transport_date_created')),
            //'transport_date_expires' => date_to_mysql($this->input->post('transport_date_expires')),
            'transport_date_created' => $date_create,
            'transport_date_expires' => $date_expire,
            'transport_status_id' => $this->input->post('transport_status_id'),
            'transport_password' => $this->input->post('transport_password'),
            'notes' => $this->input->post('notes'),
            'transport_discount_amount' => $this->input->post('transport_discount_amount'),
            'transport_discount_percent' => $this->input->post('transport_discount_percent')
        );

        //print "after db_array <br />";

        $this->mdl_quotes->save($quote_id, $db_array);

        //print "after mdl_quotes_save <br />";
        // Recalculate for discounts
        $this->load->model('bon_livraison/mdl_quote_amounts');
        //print "after load model <br />";

        $this->mdl_quote_amounts->calculate($quote_id);

        //print "after mdl_quote_amounts calculate <br />";

        $response = array(
            'success' => 1,
            'transport_id' => 168
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        if ($this->input->post('custom')) {
            $db_array = array();

            foreach ($this->input->post('custom') as $custom) {
                // I hate myself for this...
                $db_array[str_replace(']', '', str_replace('custom[', '', $custom['name']))] = $custom['value'];
            }

            $this->load->model('custom_fields/mdl_quote_custom');
            $this->mdl_quote_custom->save_custom($quote_id, $db_array);
        }

        //print "<br />";
        //print_r($response);


        echo json_encode($response);
    }

    public function save_quote_tax_rate()
    {
        $this->load->model('bon_livraison/mdl_quote_tax_rates');

        if ($this->mdl_quote_tax_rates->run_validation()) {
            $this->mdl_quote_tax_rates->save($this->input->post('transport_id'));

            $response = array(
                'success' => 1
            );
        } else {
            $response = array(
                'success' => 0,
                'validation_errors' => $this->mdl_quote_tax_rates->validation_errors
            );
        }

        echo json_encode($response);
    }

    public function create()
    {
        $this->load->model('bon_livraison/mdl_quotes');

        /*$response = array(
            'success' => 2,
            'transport_id' => 0
        );

        echo json_encode($response);*/

        $t_max_id_num[] = $this->db->query("SELECT max(transport_number) as transport_number FROM ip_transport")->result_array();
        $num = $t_max_id_num[0][0]['transport_number'];
        $num = substr($num, 2);
        $num = (int)$num;
        $num++;

        $cst_id[] = $this->db->query("SELECT client_id FROM ip_clients WHERE client_name = '".$this->input->post('client_name')."' limit 1 ")->result_array();
        $nm_cst_id = $cst_id[0][0]['client_id'];

        $is_slash_create = substr($this->input->post('transport_date_created'), 2, 1);
        if($is_slash_create == "/")
        {
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        elseif($is_slash_create == "-")
        {
            $year_create = substr($this->input->post('transport_date_created'), 6, 9);
            $day_create = substr($this->input->post('transport_date_created'), 0, 2);
            $month_create = substr($this->input->post('transport_date_created'), 3, 2);
            $day_create = substr($day_create, 0, 2);
            $date_create = $year_create."-".$month_create."-".$day_create;
        }
        else
        {
            $date_create = $this->input->post('transport_date_created');
        }

        //doc_id
        //transport_date_created user_id
        $updt_bl = $this->db->query( "INSERT INTO ip_transport (user_id, client_id, invoice_group_id, transport_status_id, 
                                                                transport_date_created, transport_date_expires, 
                                                                transport_number, pack, box, transporter,
                                                                license_plate, tracking_code, weight, owner,
                                                                origin_quote) 
                                              VALUES
                                                  (".$this->input->post('user_id').", ".$nm_cst_id.", 0, 1, 
                                                  '".$date_create."', '".$date_create."', 
                                                  'BL".$num."', ".$this->input->post('pack').", ".$this->input->post('box').", ".$this->input->post('transporter').",
                                                  '".$this->input->post('license_plate')."', '".$this->input->post('tracking_code')."', '".$this->input->post('weight')."', ".$this->input->post('user_id').",
                                                  '".$this->input->post('doc_id')."' )" );

        //if ($this->mdl_quotes->run_validation()) {
        //$quote_id = $this->mdl_quotes->create();
        //$t_max_id_num[] = $this->db->query("SELECT max(transport_id) as id FROM ip_transport")->result_array();

        $q_max_id[] = $this->db->query("SELECT max(transport_id) as id FROM ip_transport ")->result_array();
        //$quote_id = $t_max_id_num[0][0]['transport_id'];

        if($this->input->post('doc_id') != "" && $this->input->post('doc_id') != NULL)
        {
            $quo_slct[] = $this->db->query("SELECT quote_id, notes, client_id, quote_transporter FROM ip_quotes WHERE quote_number = '".$this->input->post('doc_id')."' limit 1 ")->result_array();
            $quo_id = $quo_slct[0][0]['quote_id'];
            $trnsp_id = $quo_slct[0][0]['quote_transporter'];

            $prd_lst = $this->db->query("SELECT * FROM ip_quote_items WHERE quote_id = ".$quo_id." ")->result_array();

            $date_add = date('Y-m-d');
            $tot_wgt = 0;
            $cntr = 0;

            foreach ($prd_lst as $item)
            {
                unset($wgt_sku);
                $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('QTT BL ".$cntr.": ".$item['item_quantity']."', now() )" );

                $isrt_bl_prd = $this->db->query( "INSERT INTO ip_transport_items (transport_id, item_tax_rate_id, 
                                                  item_date_added, item_name, item_description, 
                                                  item_quantity, item_price, item_discount_amount, item_order) 
                                              VALUES
                                                  (".$q_max_id[0][0]['id'].", 0, 
                                                  '".$date_add."', '".$item['item_name']."', '".$item['item_description']."',
                                                  ".$item['item_quantity'].", '0.00', '0.00', ".$item['item_order']." )" );

                $wgt_sku[] = $this->db->query("SELECT wgt FROM ip_products WHERE product_sku = '".$item['item_description']."' limit 1 ")->result_array();

                $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts) 
                                              VALUES ('WGT1 [0][0] BL ".$cntr.": ".$wgt_sku[0][0]['wgt']."', now() )" );

                //$wgt_rpc = substr($wgt_sku[0][0]['wgt'], 0, strpos($wgt_sku[0][0]['wgt'], ' '));

                /*$isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts)
                                              VALUES ('WGT2 BL: ".$wgt_rpc."', now() )" );*/

                //$tot_wgt = $tot_wgt + ( $wgt_rpc * $item['item_quantity'] );
                if($wgt_sku[0][0]['wgt'] != '0.00' && $wgt_sku[0][0]['wgt'] != 0 && $wgt_sku[0][0]['wgt'] != NULL && $wgt_sku[0][0]['wgt'] != "")
                {
                    $tot_wgt = $tot_wgt + ( $wgt_sku[0][0]['wgt'] * $item['item_quantity'] );
                }
                $isrt_log = $this->db->query( "INSERT INTO idm_log (log, ts)
                                              VALUES ('TOTWGT BL ".$cntr.": ".$tot_wgt."', now() )" );
                $cntr++;
            }

            $tot_wgt = $tot_wgt / 1000;

            $quo_slct[0][0]['notes'] = str_replace("'", "´", $quo_slct[0][0]['notes']);

            $updt_bl = $this->db->query( "UPDATE ip_transport SET client_id = ".$quo_slct[0][0]['client_id'].", weight = ".$tot_wgt.", notes = '".$quo_slct[0][0]['notes']."', transporter = ".$trnsp_id." WHERE transport_id = ".$q_max_id[0][0]['id'] );
        }

        $response = array(
            'success' => 1,
            'transport_id' => $q_max_id[0][0]['id']
        );
        /*} else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }*/

        echo json_encode($response);
    }

    public function modal_change_client()
    {
        $this->load->module('layout');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'client_name' => $this->input->post('client_name'),
            'transport_id' => $this->input->post('transport_id'),
            'clients' => $this->mdl_clients->get()->result(),
        );

        $this->layout->load_view('bon_livraison/modal_change_client', $data);
    }

    public function change_client()
    {
        $this->load->model('bon_livraison/mdl_quotes');
        $this->load->model('clients/mdl_clients');

        // Get the client ID
        $client_name = $this->input->post('client_name');
        $client = $this->mdl_clients->where('client_name', $this->db->escape_str($client_name))
            ->get()->row();

        if (!empty($client)) {
            $client_id = $client->client_id;
            $quote_id = $this->input->post('transport_id');

            $db_array = array(
                'client_id' => $client_id,
            );
            $this->db->where('transport_id', $quote_id);
            $this->db->update('ip_transport', $db_array);

            $response = array(
                'success' => 1,
                'transport_id' => $quote_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function get_item()
    {
        $this->load->model('bon_livraison/mdl_quote_items');

        $item = $this->mdl_quote_items->get_by_id($this->input->post('item_id'));

        echo json_encode($item);
    }

    public function modal_create_quote()
    {
        $this->load->module('layout');

        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');
        $this->load->model('clients/mdl_clients');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'client_name' => $this->input->post('client_name'),
            //'clients' => $this->mdl_clients->get()->result(),
            //'clients' => $this->mdl_clients->where('client_active', 1)->get()->result(),
            'clients' => $this->mdl_clients->where('is_valid', 1)->limit(1750)->get()->result(),
        );

        $this->layout->load_view('bon_livraison/modal_create_quote', $data);
    }

    public function modal_copy_quote()
    {
        $this->load->module('layout');

        $this->load->model('bon_livraison/mdl_quotes');
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('tax_rates/mdl_tax_rates');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'tax_rates' => $this->mdl_tax_rates->get()->result(),
            'transport_id' => $this->input->post('transport_id'),
            'transport' => $this->mdl_quotes->where('ip_transport.transport_id', $this->input->post('transport_id'))->get()->row()
        );

        $this->layout->load_view('bon_livraison/modal_copy_quote', $data);
    }

    public function copy_quote()
    {
        $this->load->model('bon_livraison/mdl_quotes');
        $this->load->model('bon_livraison/mdl_quote_items');
        $this->load->model('bon_livraison/mdl_quote_tax_rates');

        if ($this->mdl_quotes->run_validation()) {
            $target_id = $this->mdl_quotes->save();
            $source_id = $this->input->post('transport_id');

            $this->mdl_quotes->copy_quote($source_id, $target_id);

            $response = array(
                'success' => 1,
                'transport_id' => $target_id
            );
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

    public function modal_quote_to_invoice($quote_id)
    {
        $this->load->model('invoice_groups/mdl_invoice_groups');
        $this->load->model('bon_livraison/mdl_quotes');

        $data = array(
            'invoice_groups' => $this->mdl_invoice_groups->get()->result(),
            'transport_id' => $quote_id,
            'transport' => $this->mdl_quotes->where('ip_transport.transport_id', $quote_id)->get()->row()
        );

        $this->load->view('bon_livraison/modal_quote_to_invoice', $data);
    }

    public function quote_to_invoice()
    {
        $this->load->model(
            array(
                'invoices/mdl_invoices',
                'invoices/mdl_items',
                'bon_livraison/mdl_quotes',
                'bon_livraison/mdl_quote_items',
                'invoices/mdl_invoice_tax_rates',
                'bon_livraison/mdl_quote_tax_rates'
            )
        );
        /*$this->load->model(
            array(
                'quotes/mdl_quotes',
                'quotes/mdl_items',
                'bon_livraison/mdl_quotes',
                'bon_livraison/mdl_quote_items',
                'quotes/mdl_quote_tax_rates',
                'bon_livraison/mdl_quote_tax_rates'
            )
        );*/

        if ($this->mdl_invoices->run_validation()) {
            // DO OWN CODE TO CONVERT EOL -> QUOTE
            $oq_res = $this->db->query("SELECT * FROM ip_transport ioq
                LEFT JOIN ip_transport_amounts ioqa ON ioqa.transport_id = ioq.transport_id
                LEFT JOIN ip_transport_custom ioqc ON ioqc.transport_id = ioq.transport_id
                WHERE ioq.transport_id = ".$this->input->post('transport_id'))->result_array();

            $oqtax_res = $this->db->query("SELECT * FROM ip_transport_tax_rates WHERE transport_id = ".$this->input->post('transport_id'))->result_array();

            $oqitems_res = $this->db->query("SELECT * FROM ip_transport_items WHERE transport_id = ".$this->input->post('transport_id'))->result_array();

            foreach ($oqitems_res as $item) {
                $oqitems_qtt_res[] = $this->db->query("SELECT * FROM ip_transport_item_amounts WHERE item_id = ".$item['item_id'] )->result_array();
            }

            $quo_exp_days = $this->db->query("SELECT * FROM ip_settings WHERE setting_key = 'quotes_expire_after'")->result_array();

            $q_max_id_num[] = $this->db->query("SELECT quote_number FROM ip_quotes order by quote_date_created desc limit 1 ")->result_array();
            $num = $q_max_id_num[0][0]['quote_number'];
            $num = substr($num, 1);
            $num = (int)$num;
            $num++;

            //GET EXPIRE QUOTE DATE TO CALCULATE NOW+EXPIRE TIMER
            /*$isrt_quo = $this->db->query("INSERT INTO ip_quotes (invoice_id, user_id, client_id, invoice_group_id, quote_status_id, quote_date_created,
            quote_date_modified, quote_date_expires, quote_number, quote_discount_amount, quote_discount_percent, quote_url_key,
            quote_password, notes) VALUES
             (0, ".$oq_res[0]['user_id'].", ".$oq_res[0]['client_id'].", ".$this->input->post('invoice_group_id').", 1, now(),
                now(), NOW() + INTERVAL ".$quo_exp_days[0]['setting_value']." DAY, 'D".$num."', ".$oq_res[0]['online_quote_discount_amount'].", ".$oq_res[0]['online_quote_discount_percent'].", '".$oq_res[0]['online_quote_url_key']."',
            '".$this->input->post('invoice_password')."', '".$oq_res[0]['notes']."' )");

            $q_max_id[] = $this->db->query("SELECT max(quote_id) as id FROM ip_quotes ")->result_array();

            if( !is_null($oq_res[0]['quote_custom_id']) && $oq_res[0]['quote_custom_id'] != "")
            {
                $isrt_quo_cstm = $this->db->query("INSERT INTO ip_quote_custom (quote_custom_id, quote_id) VALUES ( ".$oq_res[0]['online_quote_custom_id'].", ".$q_max_id[0][0]['id'].")");
            }
            if( !is_null($oq_res[0]['online_quote_amount_id']) && $oq_res[0]['online_quote_amount_id'] != "")
            {
                $isrt_quo_amnt = $this->db->query("INSERT INTO ip_quote_amounts (quote_id, quote_item_subtotal, quote_item_tax_total, quote_total) VALUES
                    ( ".$q_max_id[0][0]['id'].", '".$oq_res[0]['online_quote_item_subtotal']."', '".$oq_res[0]['online_quote_item_tax_total']."', '".$oq_res[0]['online_quote_total']."')");
            }

            foreach ($oqtax_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_tax_rates (quote_id, tax_rate_id, include_item_tax, quote_tax_rate_amount) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['tax_rate_id'].", ".$item['include_item_tax'].", ".$item['online_quote_tax_rate_amount']." )");
            }

            foreach ($oqitems_res as $item) {
                $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_items (quote_id, item_tax_rate_id, item_date_added, item_name, item_description,
                        item_quantity, item_price, item_discount_amount, item_order) VALUES
                        (".$q_max_id[0][0]['id'].", ".$item['item_tax_rate_id'].", '".$item['item_date_added']."', '".$item['item_name']."', '".$item['item_description']."',
                        '".$item['item_quantity']."', '".$item['item_price']."', '".$item['item_discount_amount']."', ".$item['item_order']." )");

                $q_itm_max_id[] = $this->db->query("SELECT max(item_id) as id FROM ip_quote_items ")->result_array();

                foreach ($oqitems_qtt_res as $itm) {
                    if($itm[0]['item_id'] == $item['item_id'])
                    {
                        $isrt_quo_txr = $this->db->query("INSERT INTO ip_quote_item_amounts (item_id, item_subtotal, item_tax_total, item_discount, item_total) VALUES
                        (".$itm[0]['item_id'].", ".$itm[0]['item_subtotal'].", '".$itm[0]['item_tax_total']."', '".$itm[0]['item_discount']."', '".$itm[0]['item_total']."')");
                    }
                }
            }*/

            $response = array(
                'success' => 1,
                'quote_id' => $q_max_id[0][0]['id']
            );

            echo json_encode($response);
            break;
            /*//$invoice_id = $this->mdl_invoices->create(NULL, FALSE);
            $invoice_id = $this->mdl_quotes->create(NULL);

            $this->db->where('online_quote_id', $this->input->post('online_quote_id'));
            $this->db->set('quote_id', $invoice_id);
            $this->db->update('ip_online_quotes');

            $quote_items = $this->mdl_quote_items->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_items as $quote_item) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'item_tax_rate_id' => $quote_item->item_tax_rate_id,
                    'item_name' => $quote_item->item_name,
                    'item_description' => $quote_item->item_description,
                    'item_quantity' => $quote_item->item_quantity,
                    'item_price' => $quote_item->item_price,
                    'item_order' => $quote_item->item_order
                );

                $this->mdl_items->save($invoice_id, NULL, $db_array);
            }

            $quote_tax_rates = $this->mdl_quote_tax_rates->where('online_quote_id', $this->input->post('online_quote_id'))->get()->result();

            foreach ($quote_tax_rates as $quote_tax_rate) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'tax_rate_id' => $quote_tax_rate->tax_rate_id,
                    'include_item_tax' => $quote_tax_rate->include_item_tax,
                    'invoice_tax_rate_amount' => $quote_tax_rate->quote_tax_rate_amount
                );

                $this->mdl_invoice_tax_rates->save($invoice_id, NULL, $db_array);
            }

            $response = array(
                'success' => 1,
                'invoice_id' => $invoice_id
            );*/
        } else {
            $this->load->helper('json_error');
            $response = array(
                'success' => 0,
                'validation_errors' => json_errors()
            );
        }

        echo json_encode($response);
    }

}
