<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 * 
 */

function generate_invoice_pdf($invoice_id, $stream = TRUE, $invoice_template = NULL,$isGuest = NULL)
{
    $CI = &get_instance();

    $CI->load->model('invoices/mdl_invoices');
    $CI->load->model('invoices/mdl_items');
    $CI->load->model('invoices/mdl_invoice_tax_rates');
    $CI->load->model('payment_methods/mdl_payment_methods');
    $CI->load->library('encrypt');

    $invoice = $CI->mdl_invoices->get_by_id($invoice_id);
    if (!$invoice_template) {
        $CI->load->helper('template');
        $invoice_template = select_pdf_invoice_template($invoice);
    }

    $payment_method = $CI->mdl_payment_methods->where('payment_method_id', $invoice->payment_method)->get()->row();
    if ($invoice->payment_method == 0) $payment_method = NULL;

    $data = array(
        'invoice' => $invoice,
        'invoice_tax_rates' => $CI->mdl_invoice_tax_rates->where('invoice_id', $invoice_id)->get()->result(),
        'items' => $CI->mdl_items->where('invoice_id', $invoice_id)->get()->result(),
        'payment_method' => $payment_method,
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('invoice_templates/pdf/' . $invoice_template, $data, TRUE);

    $CI->load->helper('mpdf');
    return pdf_create($html, lang('invoice') . '_' . str_replace(array('\\', '/'), '_', $invoice->invoice_number), $stream, $invoice->invoice_password,1,$isGuest);
}

function generate_invoice_proform_pdf($invoice_id, $stream = TRUE, $invoice_template = NULL,$isGuest = NULL)
{
    $CI = &get_instance();

    $CI->load->model('invoices_proform/mdl_invoices');
    $CI->load->model('invoices_proform/mdl_items');
    $CI->load->model('invoices_proform/mdl_invoice_tax_rates');
    $CI->load->model('payment_methods/mdl_payment_methods');
    $CI->load->library('encrypt');

    $invoice = $CI->mdl_invoices->get_by_id($invoice_id);
    if (!$invoice_template) {
        $CI->load->helper('template');
        $invoice_template = select_pdf_invoice_template($invoice);
    }

    $payment_method = $CI->mdl_payment_methods->where('payment_method_id', $invoice->payment_method)->get()->row();
    if ($invoice->payment_method == 0) $payment_method = NULL;

    $data = array(
        'invoice_proform' => $invoice,
        'invoice_proform_tax_rates' => $CI->mdl_invoice_tax_rates->where('invoice_proform_id', $invoice_id)->get()->result(),
        'items' => $CI->mdl_items->where('invoice_proform_id', $invoice_id)->get()->result(),
        'payment_method' => $payment_method,
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('invoice_proform_templates/pdf/' . $invoice_template, $data, TRUE);

    $CI->load->helper('mpdf');
    
    $pdf_num = substr($invoice->invoice_proform_number, 3);
    //return pdf_create($html, lang('invoice') . '_' . str_replace(array('\\', '/'), '_', $invoice->invoice_number), $stream, $invoice->invoice_password,1,$isGuest);
    return pdf_create($html, 'Proforma_' . str_replace(array('\\', '/'), '_', $pdf_num), $stream, $invoice->invoice_password,1,$isGuest);
}

function generate_quote_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('quotes/mdl_quotes');
    $CI->load->model('quotes/mdl_quote_items');
    $CI->load->model('quotes/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    if (!$quote_template) {
        $quote_template = $CI->mdl_settings->setting('pdf_quote_template');
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('quote_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('quote_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('quote_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    $pdf_num = substr($quote->quote_number, 6);
    $pdf_date = date("dmY", strtotime($quote->quote_date_created) );
    //return pdf_create($html, lang('quote') . '_' . str_replace(array('\\', '/'), '_', $quote->quote_number), $stream,$quote->quote_password);
    if( $quote->quote_status_id == 4 || $quote->quote_status_id == 5 || $quote->quote_status_id == 6 )
    {
        return pdf_create($html, lang('quote') . ' Nº' . str_replace(array('\\', '/'), '_', $pdf_num . ' ' . $quote->quote_client_name . ' ' . $pdf_date ), $stream,$quote->quote_password);
    }
    else
    {
        return pdf_create($html, lang('quote') . ' Nº' . str_replace(array('\\', '/'), '_', $pdf_num . ' ' . $quote->client_name . ' ' . $pdf_date ), $stream,$quote->quote_password);
    }
}

function generate_online_quote_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('online_quotes/mdl_quotes');
    $CI->load->model('online_quotes/mdl_quote_items');
    $CI->load->model('online_quotes/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    //print_r($quote);
    //print $quote_template;

    if (!$quote_template) {
        $quote_template = $CI->mdl_settings->setting('pdf_quote_template');
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('online_quote_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('online_quote_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('online_quote_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    return pdf_create($html, lang('online_quote_prt') . '_' . str_replace(array('\\', '/'), '_', $quote->online_quote_number), $stream,$quote->online_quote_password);
}

function generate_transport_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('bon_livraison/mdl_quotes');
    $CI->load->model('bon_livraison/mdl_quote_items');
    $CI->load->model('bon_livraison/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    if (!$quote_template) {
        //$quote_template = $CI->mdl_settings->setting('pdf_quote_template');
        $quote_template = 'default';
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('transport_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('transport_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('bon_livraison_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    //return pdf_create($html, lang('quote') . '_' . str_replace(array('\\', '/'), '_', $quote->transport_number), $stream,$quote->transport_password);
    return pdf_create($html, str_replace(array('\\', '/'), '_', $quote->transport_number), $stream,$quote->transport_password);
}

function generate_label_transport_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('bon_livraison/mdl_quotes');
    $CI->load->model('bon_livraison/mdl_quote_items');
    $CI->load->model('bon_livraison/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    if (!$quote_template) {
        //$quote_template = $CI->mdl_settings->setting('pdf_quote_template');
        $quote_template = 'label';
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('transport_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('transport_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('bon_livraison_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    return pdf_create($html, 'LBL_' . str_replace(array('\\', '/'), '_', $quote->transport_number), $stream,$quote->transport_password);
}

function generate_production_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('production/mdl_quotes');
    $CI->load->model('production/mdl_quote_items');
    $CI->load->model('production/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    if (!$quote_template) {
        //$quote_template = $CI->mdl_settings->setting('pdf_quote_template');
        $quote_template = 'default';
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('production_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('production_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('production_order_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    //return pdf_create($html, lang('quote') . '_' . str_replace(array('\\', '/'), '_', $quote->production_number), $stream,$quote->production_password);
    return pdf_create($html, lang('production_prt') . '_' . str_replace(array('\\', '/'), '_', $quote->production_number), $stream,$quote->production_password);
}

function generate_production_pdf_services($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('production/mdl_quotes');
    $CI->load->model('production/mdl_quote_items');
    $CI->load->model('production/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    if (!$quote_template) {
        //$quote_template = $CI->mdl_settings->setting('pdf_quote_template');
        $quote_template = 'default';
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('production_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('production_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('production_order_templates/pdf/default_services', $data, TRUE);

    $CI->load->helper('mpdf');

    //return pdf_create($html, lang('quote') . '_' . str_replace(array('\\', '/'), '_', $quote->production_number), $stream,$quote->production_password);
    return pdf_create($html, lang('production_prt') . '_' . str_replace(array('\\', '/'), '_', $quote->production_number), $stream,$quote->production_password);
}

function generate_supplier_order_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('supplier/mdl_quotes');
    $CI->load->model('supplier/mdl_quote_items');
    $CI->load->model('supplier/mdl_quote_tax_rates');

    $quote = $CI->mdl_quotes->get_by_id($quote_id);

    if (!$quote_template) {
        //$quote_template = $CI->mdl_settings->setting('pdf_quote_template');
        $quote_template = 'default';
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('supplier_order_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('supplier_order_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('supplier_order_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    //return pdf_create($html, lang('quote') . '_' . str_replace(array('\\', '/'), '_', $quote->supplier_order_number), $stream,$quote->supplier_order_password);
    return pdf_create($html, lang('supplier_prt') . '_' . str_replace(array('\\', '/'), '_', $quote->supplier_order_number), $stream,$quote->supplier_order_password);
}

function generate_purchase_pdf($quote_id, $stream = TRUE, $quote_template = NULL)
{
    $CI = &get_instance();

    $CI->load->model('purchases/mdl_purchases');
    $CI->load->model('purchases/mdl_quote_items');
    $CI->load->model('purchases/mdl_quote_tax_rates');

    $quote = $CI->mdl_purchases->get_by_id($quote_id);

    if (!$quote_template) {
        //$quote_template = $CI->mdl_settings->setting('pdf_quote_template');
        $quote_template = 'default';
    }

    $data = array(
        'quote' => $quote,
        'quote_tax_rates' => $CI->mdl_quote_tax_rates->where('purchase_order_id', $quote_id)->get()->result(),
        'items' => $CI->mdl_quote_items->where('purchase_order_id', $quote_id)->get()->result(),
        'output_type' => 'pdf'
    );

    $html = $CI->load->view('purchase_order_templates/pdf/' . $quote_template, $data, TRUE);

    $CI->load->helper('mpdf');

    //return pdf_create($html, lang('quote') . '_' . str_replace(array('\\', '/'), '_', $quote->production_number), $stream,$quote->production_password);
    return pdf_create($html, 'PO' . '_' . str_replace(array('\\', '/'), '_', $quote->purchase_order_number) . '_' . $quote->purchase_company , $stream,$quote->purchase_order_password);
}