<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 * 
 * A free and open source web based invoicing system
 *
 * @package     InvoicePlane
 * @author      Kovah (www.kovah.de)
 * @copyright   Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license     https://invoiceplane.com/license.txt
 * @link        https://invoiceplane.com
 * 
 */

function pdf_create($html, $filename, $stream = TRUE, $password = NULL,$isInvoice = NULL,$isGuest = NULL)
{
    require_once(APPPATH . 'helpers/mpdf/mpdf.php');

    //$mpdf = new mPDF();
    // $mode, $format, $default_font_size, $default_font, $left, $right, $top, $bottom, $margin_header, $margin_footer, $orientation
    if(substr($filename, 0, 2) == lang('production_prt') || substr($filename, 0, 2) == lang('supplier_prt') || substr($filename, 0, 2) == 'PO')
    {
        $mpdf=new mPDF('utf-8', 'A4-L', 0, '', 17, 10, 10, 32, 10, 7);
    }
    elseif(substr($filename, 0, 3) == 'LBL')
    {
        $mpdf=new mPDF('utf-8', 'A4', 0, '', 5, 5, 5, 5, 10, 7);
    }
    else
    {
        $mpdf=new mPDF('utf-8', 'A4', 0, '', 17, 10, 10, 32, 10, 7);
    }

    $mpdf->useAdobeCJK = true;
    $mpdf->SetAutoFont();
    $mpdf->SetProtection(array('copy','print'), $password, $password);
    if(!(is_dir('./uploads/archive/') OR is_link('./uploads/archive/') ))
        mkdir ('./uploads/archive/','0777');

    //if (strpos($filename, lang('invoice')) !== false) {
        $CI = &get_instance();
        //$mpdf->setAutoBottomMargin = 'stretch';
        //$mpdf->SetHTMLFooter('<div id="footer">' . $CI->mdl_settings->settings['pdf_invoice_footer'] . '</div>');
        if(substr($filename, 0, 3) == lang('online_quote_prt') || substr($filename, 0, 3) == 'LBL')
        {

        }
        elseif (substr($filename, 0, 2) == lang('supplier_prt') || substr($filename, 0, 2) == lang('production_prt') || substr($filename, 0, 2) == 'PO')
        {
        	if(substr($filename, 0, 2) == 'PO')
        	{
        		$cmpny_id = substr($filename, -1);
        		if( $cmpny_id == 1 )
        		{
        			$mpdf->SetHTMLFooter('<div id="footer">
		            <div id="footer_seller_info" style="width: 100%">
		                <span style="font-family: Arial; color: #000000; font-size: 8pt;"><b>RB</b>LOGISTIC&reg;</span><br/>
		                <span style="font-size: 6pt; font-weight: normal;">Zona Industrial das Flores Letra E - 2400-016 Barosa - Leiria - NIF: 514563540</span>
		            </div>
		            <div style="text-align:right; width:100%; display:block; font-size: 6pt;">
		            {PAGENO} / {nb}
		            </div>
		            <div style="clear: both;"></div>
		            </div>');
        		}
        		elseif ( $cmpny_id == 2 ) 
        		{
        			$mpdf->SetHTMLFooter('<div id="footer">
		            <div id="footer_seller_info" style="width: 100%">
		                <span style="font-family: Arial; color: #000000; font-size: 8pt;"><b>RB</b>PRINTT&reg;</span><br/>
		                <span style="font-size: 6pt; font-weight: normal;">Zona Industrial das Flores Letra E - 2400-016 Barosa - Leiria - NIF: 514877650</span>
		            </div>
		            <div style="text-align:right; width:100%; display:block; font-size: 6pt;">
		            {PAGENO} / {nb}
		            </div>
		            <div style="clear: both;"></div>
		            </div>');
        		}
        		elseif ( $cmpny_id == 3 ) 
        		{
        			$mpdf->SetHTMLFooter('<div id="footer">
		            <div id="footer_seller_info" style="width: 100%">
		                <span style="font-family: Arial; color: #000000; font-size: 8pt;"><b>RB</b>PRINTT&reg;</span><br/>
		                <span style="font-size: 6pt; font-weight: normal;">Zona Industrial das Flores Letra F - 2400-016 Barosa - Leiria - NIF: 515151220</span>
		            </div>
		            <div style="text-align:right; width:100%; display:block; font-size: 6pt;">
		            {PAGENO} / {nb}
		            </div>
		            <div style="clear: both;"></div>
		            </div>');
        		}
        	}
        	else
        	{
        		$mpdf->SetHTMLFooter('<div id="footer">
	            <div id="footer_seller_info" style="width: 100%">
	                <span style="font-family: Arial; color: #000000; font-size: 8pt;"><b>RB</b>DRINKS&reg;</span><br/>
	                <span style="font-size: 6pt; font-weight: normal;">' . $CI->mdl_settings->settings['pdf_supplier_footer_seller_quote'] . '</span>
	                <span style="font-size: 5pt; font-weight: normal;">' . $CI->mdl_settings->settings['pdf_supplier_footer_seller_quote_2'] . '</span>
	            </div>
	            <div style="text-align:right; width:100%; display:block; font-size: 6pt;">
	            {PAGENO} / {nb}
	            </div>
	            <div style="clear: both;"></div>
	            </div>');
        	}
        }
        else
        {
            if (strpos($filename, lang('quote')) !== false) {
                $mpdf->SetHTMLFooter('<div id="footer">
            <div id="footer_seller_info">
                <span style="font-family: Arial; color: #000000; font-size: 7pt;"><b>RB</b>DRINKS&reg;</span><br/>
                ' . $CI->mdl_settings->settings['pdf_invoice_footer_seller_quote'] . '
            </div>
            <div id="footer_side_info">
                <img src="./uploads/cgv.png" width="100%" height="auto">
                <!--' . $CI->mdl_settings->settings['pdf_invoice_footer'] . '-->
            </div>
            <div style="text-align:right; width:100%; display:block; font-size: 6pt;">
            {PAGENO} / {nb}
            </div>
            <div style="clear: both;"></div>
            </div>');
            }
            else{
                $mpdf->SetHTMLFooter('<div id="footer">
            <div id="footer_seller_info">
                <span style="font-family: Arial; color: #000000; font-size: 7pt;"><b>RB</b>DRINKS&reg;</span><br/>
                ' . $CI->mdl_settings->settings['pdf_invoice_footer_seller'] . '
            </div>
            <div id="footer_side_info">
                <img src="./uploads/cgv.png" width="100%" height="auto">
                <!--' . $CI->mdl_settings->settings['pdf_invoice_footer'] . '-->
            </div>
            <div style="text-align:right; width:100%; display:block; font-size: 6pt;">
            {PAGENO} / {nb}
            </div>
            <div style="clear: both;"></div>
            </div>');
            }
        }
    //}
    $invoice_array = array();
    $mpdf->WriteHTML($html);

    if ($stream) {
        if (!$isInvoice) {
            return $mpdf->Output($filename . '.pdf', 'I');
        }

        foreach (glob('./uploads/archive/*' . $filename . '.pdf') as $file) {
            array_push($invoice_array, $file);
        }

        if (!empty($invoice_array) AND $isGuest) {
            rsort($invoice_array);
            header('Content-type: application/pdf');
            return readfile($invoice_array[0]);
        } else
            if ($isGuest){
            //todo flashdata is deleted between requests
            //$CI->session->flashdata('alert_error', 'sorry no Invoice found!');
            redirect('guest/view/invoice/' . end($CI->uri->segment_array()));
        }
        $mpdf->Output('./uploads/archive/' . date('Y-m-d') . '_' . $filename . '.pdf', 'F');
        return $mpdf->Output( $filename . '.pdf', 'I');
    }

    else {

        if($isInvoice) {

            foreach (glob('./uploads/archive/*' .  $filename . '.pdf') as $file) {
                array_push($invoice_array, $file);
            }
            if (!empty($invoice_array) && !is_null($isGuest)) {
                rsort($invoice_array);
                return $invoice_array[0];
            }
            $mpdf->Output('./uploads/archive/' . date('Y-m-d') .'_'. $filename . '.pdf', 'F');
            return './uploads/archive/'.date('Y-m-d').'_'. $filename . '.pdf';
        }
        $mpdf->Output('./uploads/temp/' . $filename . '.pdf', 'F');

        // DELETE OLD TEMP FILES - Housekeeping
        // Delete any files in temp/ directory that are >1 hrs old
        $interval = 3600;
        if ($handle = @opendir(preg_replace('/\/$/','','./uploads/temp/'))) {
            while (false !== ($file = readdir($handle))) {
                if (($file != "..") && ($file != ".") && !is_dir($file) && ((filemtime('./uploads/temp/'.$file)+$interval) < time()) && (substr($file, 0, 1) !== '.') && ($file !='remove.txt')) { // mPDF 5.7.3
                    unlink('./uploads/temp/'.$file);
                }
            }
            closedir($handle);
        }
        //==============================================================================================================
        return './uploads/temp/' . $filename . '.pdf';
    }
}
