<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * InvoicePlane
 *
 * A free and open source web based invoicing system
 *
 * @package		InvoicePlane
 * @author		Kovah (www.kovah.de)
 * @copyright	Copyright (c) 2012 - 2015 InvoicePlane.com
 * @license		https://invoiceplane.com/license.txt
 * @link		https://invoiceplane.com
 *
 */

function mailer_configured()
{
    $CI = &get_instance();

    return (($CI->mdl_settings->setting('email_send_method') == 'phpmail') OR
        ($CI->mdl_settings->setting('email_send_method') == 'sendmail') OR
        (($CI->mdl_settings->setting('email_send_method') == 'smtp') AND ($CI->mdl_settings->setting('smtp_server_address')))
    );
}

function email_invoice($invoice_id, $invoice_template, $from, $to, $subject, $body, $cc = NULL, $bcc = NULL,$attachments = NULL)
{
    $CI = &get_instance();

    $CI->load->helper('mailer/phpmailer');
    $CI->load->helper('template');
    $CI->load->helper('invoice');
    $CI->load->helper('pdf');

    $invoice = generate_invoice_pdf($invoice_id, FALSE, $invoice_template);

    $db_invoice = $CI->mdl_invoices->where('ip_invoices.invoice_id', $invoice_id)->get()->row();

    $message = parse_template($db_invoice, $body);
    $subject = parse_template($db_invoice, $subject);
    $cc = parse_template($db_invoice, $cc);
    $bcc = parse_template($db_invoice, $bcc);
    $from = array(parse_template($db_invoice, $from[0]), parse_template($db_invoice, $from[1]));

    return phpmail_send($from, $to, $subject, $message, $invoice, $cc, $bcc,$attachments);
}

function email_quote($quote_id, $quote_template, $from, $to, $subject, $body, $cc = NULL, $bcc = NULL,$attachments = NULL)
{
    $CI = &get_instance();

    $CI->load->helper('mailer/phpmailer');
    $CI->load->helper('template');
    $CI->load->helper('pdf');

    $quote = generate_quote_pdf($quote_id, FALSE, $quote_template);

    $db_quote = $CI->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row();
    /*print_r($db_quote);
    break;*/

    $message = parse_template($db_quote, $body);
    $subject = parse_template($db_quote, $subject);
    $cc = parse_template($db_quote, $cc);
    $bcc = parse_template($db_quote, $bcc);
    $from = array(parse_template($db_quote, $from[0]), parse_template($db_quote, $from[1]));

    return phpmail_send($from, $to, $subject, $message, $quote, $cc, $bcc,$attachments);
}

function email_online_quote($quote_id, $quote_template, $from, $to, $subject, $body, $cc = NULL, $bcc = NULL,$attachments = NULL)
{
    $CI = &get_instance();

    $CI->load->helper('mailer/phpmailer');
    $CI->load->helper('template');
    $CI->load->helper('pdf');

    $quote = generate_quote_pdf($quote_id, FALSE, $quote_template);

    $db_quote = $CI->db->query("
					SELECT SQL_CALC_FOUND_ROWS ip_online_quote_custom.*, ip_client_custom.*, ip_user_custom.*, ip_users.user_name, ip_users.user_company, ip_users.user_address_1, ip_users.user_address_2, ip_users.user_city,
ip_users.user_state, ip_users.user_zip, ip_users.user_country, ip_users.user_phone, ip_users.user_fax, ip_users.user_mobile, ip_users.user_email, ip_users.user_web, ip_users.user_vat_id,
ip_users.user_tax_code, ip_clients.*, ip_online_quote_amounts.online_quote_amount_id,
IFNULL(ip_online_quote_amounts.online_quote_item_subtotal, '0.00') AS quote_item_subtotal,
IFNULL(ip_online_quote_amounts.online_quote_item_tax_total, '0.00') AS quote_item_tax_total,
IFNULL(ip_online_quote_amounts.online_quote_tax_total, '0.00') AS quote_tax_total,
IFNULL(ip_online_quote_amounts.online_quote_total, '0.00') AS quote_total, ip_invoices.invoice_number,
ip_online_quotes.online_quote_date_created as quote_date_created, ip_online_quotes.online_quote_date_expires as quote_date_expires,
ip_online_quotes.online_quote_number as quote_number, ip_online_quotes.online_quote_url_key as quote_guest_url,
ip_online_quotes.*
FROM (`ip_online_quotes`)
JOIN `ip_clients` ON `ip_clients`.`client_id` = `ip_online_quotes`.`client_id`
JOIN `ip_users` ON `ip_users`.`user_id` = `ip_online_quotes`.`user_id`
LEFT JOIN `ip_online_quote_amounts` ON `ip_online_quote_amounts`.`online_quote_id` = `ip_online_quotes`.`online_quote_id`
LEFT JOIN `ip_invoices` ON `ip_invoices`.`invoice_id` = `ip_online_quotes`.`invoice_id`
LEFT JOIN `ip_client_custom` ON `ip_client_custom`.`client_id` = `ip_clients`.`client_id`
LEFT JOIN `ip_user_custom` ON `ip_user_custom`.`user_id` = `ip_users`.`user_id`
LEFT JOIN `ip_online_quote_custom` ON `ip_online_quote_custom`.`online_quote_id` = `ip_online_quotes`.`online_quote_id`
WHERE `ip_online_quotes`.`online_quote_id` = '9'
ORDER BY `ip_online_quotes`.`online_quote_id` DESC")->result_array();
    //print_r($db_quote[0]);
    $tempArray = $db_quote[0];
    unset($db_quote);
    $db_quote = new stdClass();
    foreach ($tempArray as $key => $value)
    {
        $db_quote->$key = $value;
    }
    /*print_r($db_quote);
    //break;
    //$db_quote = $CI->mdl_quotes->where('ip_online_quotes.online_quote_id', $quote_id)->get()->row();
    //print "here";
    print "<br />".$body;
    print "<br />".$subject;
    print "<br />".$cc;
    print "<br />".$bcc."<br />";
    print_r($from);
    break;*/
    $message = parse_template($db_quote, $body);
    $subject = parse_template($db_quote, $subject);
    $cc = parse_template($db_quote, $cc);
    $bcc = parse_template($db_quote, $bcc);
    $from = array(parse_template($db_quote, $from[0]), parse_template($db_quote, $from[1]));

    return phpmail_send($from, $to, $subject, $message, $quote, $cc, $bcc,$attachments);
}

/**
 * @param $quote_id
 * @param $status string "accepted" or "rejected"
 * @return bool if the email was sent
 */
function email_quote_status($quote_id, $status)
{
    ini_set("display_errors", "on");
    error_reporting(E_ALL);

    if (!mailer_configured()) return false;

    $CI = &get_instance();
    $CI->load->helper('mailer/phpmailer');

    $quote = $CI->mdl_quotes->where('ip_quotes.quote_id', $quote_id)->get()->row();
    $base_url = base_url('/quotes/view/' . $quote_id);

    $user_email = $quote->user_email;
    $subject = sprintf(lang('quote_status_email_subject'),
        $quote->client_name,
        strtolower(lang($status)),
        $quote->quote_number
    );
    $body = sprintf(nl2br(lang('quote_status_email_body')),
        $quote->client_name,
        strtolower(lang($status)),
        $quote->quote_number,
        '<a href="' . $base_url . '">' . $base_url . '</a>'
    );

    return phpmail_send($user_email, $user_email, $subject, $body);
}
